// components/download/public/common/download_stream.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/download/public/common/download_stream.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/download/public/common/download_stream.mojom-params-data.h"
#include "components/download/public/common/download_stream.mojom-shared-message-ids.h"

#include "components/download/public/common/download_stream.mojom-import-headers.h"


#ifndef COMPONENTS_DOWNLOAD_PUBLIC_COMMON_DOWNLOAD_STREAM_MOJOM_JUMBO_H_
#define COMPONENTS_DOWNLOAD_PUBLIC_COMMON_DOWNLOAD_STREAM_MOJOM_JUMBO_H_
#endif
namespace download {
namespace mojom {
DownloadStreamHandle::DownloadStreamHandle()
    : stream(),
      client_receiver() {}

DownloadStreamHandle::DownloadStreamHandle(
    ::mojo::ScopedDataPipeConsumerHandle stream_in,
    ::mojo::PendingReceiver<DownloadStreamClient> client_receiver_in)
    : stream(std::move(stream_in)),
      client_receiver(std::move(client_receiver_in)) {}

DownloadStreamHandle::~DownloadStreamHandle() = default;

void DownloadStreamHandle::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream"), this->stream, 
      "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver, 
      "<value of type ::mojo::PendingReceiver<DownloadStreamClient>>");
}

bool DownloadStreamHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char DownloadStreamClient::Name_[] = "download.mojom.DownloadStreamClient";

DownloadStreamClientProxy::DownloadStreamClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DownloadStreamClientProxy::OnStreamCompleted(
    NetworkRequestStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "download::mojom::DownloadStreamClient::OnStreamCompleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type NetworkRequestStatus>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDownloadStreamClient_OnStreamCompleted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::download::mojom::internal::DownloadStreamClient_OnStreamCompleted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::download::mojom::NetworkRequestStatus>(
      in_status, &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadStreamClient::Name_);
  message.set_method_name("OnStreamCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DownloadStreamClientStubDispatch::Accept(
    DownloadStreamClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDownloadStreamClient_OnStreamCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)download::mojom::DownloadStreamClient::OnStreamCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)download::mojom::DownloadStreamClient::OnStreamCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DownloadStreamClient_OnStreamCompleted_Params_Data* params =
          reinterpret_cast<internal::DownloadStreamClient_OnStreamCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NetworkRequestStatus p_status{};
      DownloadStreamClient_OnStreamCompleted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DownloadStreamClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStreamCompleted(
std::move(p_status));
      return true;
    }
  }
  return false;
}

// static
bool DownloadStreamClientStubDispatch::AcceptWithResponder(
    DownloadStreamClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDownloadStreamClient_OnStreamCompleted_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDownloadStreamClientValidationInfo[] = {
    {internal::kDownloadStreamClient_OnStreamCompleted_Name,
     {&internal::DownloadStreamClient_OnStreamCompleted_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DownloadStreamClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::download::mojom::DownloadStreamClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDownloadStreamClientValidationInfo);
}

}  // namespace mojom
}  // namespace download

namespace mojo {


// static
bool StructTraits<::download::mojom::DownloadStreamHandle::DataView, ::download::mojom::DownloadStreamHandlePtr>::Read(
    ::download::mojom::DownloadStreamHandle::DataView input,
    ::download::mojom::DownloadStreamHandlePtr* output) {
  bool success = true;
  ::download::mojom::DownloadStreamHandlePtr result(::download::mojom::DownloadStreamHandle::New());
  
      if (success)
        result->stream = input.TakeStream();
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif