// components/network_hints/common/network_hints.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/network_hints/common/network_hints.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/network_hints/common/network_hints.mojom-params-data.h"
#include "components/network_hints/common/network_hints.mojom-shared-message-ids.h"

#include "components/network_hints/common/network_hints.mojom-import-headers.h"


#ifndef COMPONENTS_NETWORK_HINTS_COMMON_NETWORK_HINTS_MOJOM_JUMBO_H_
#define COMPONENTS_NETWORK_HINTS_COMMON_NETWORK_HINTS_MOJOM_JUMBO_H_
#endif
namespace network_hints {
namespace mojom {
const char NetworkHintsHandler::Name_[] = "network_hints.mojom.NetworkHintsHandler";

NetworkHintsHandlerProxy::NetworkHintsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkHintsHandlerProxy::PrefetchDNS(
    const std::vector<std::string>& in_hostname_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network_hints::mojom::NetworkHintsHandler::PrefetchDNS", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hostname_list"), in_hostname_list, 
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkHintsHandler_PrefetchDNS_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network_hints::mojom::internal::NetworkHintsHandler_PrefetchDNS_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hostname_list)::BaseType>
      hostname_list_fragment(params.message());
  const mojo::internal::ContainerValidateParams hostname_list_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_hostname_list, hostname_list_fragment, &hostname_list_validate_params);
  params->hostname_list.Set(
      hostname_list_fragment.is_null() ? nullptr : hostname_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->hostname_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hostname_list in NetworkHintsHandler.PrefetchDNS request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkHintsHandler::Name_);
  message.set_method_name("PrefetchDNS");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkHintsHandlerProxy::Preconnect(
    const ::GURL& in_url, bool in_allow_credentials) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network_hints::mojom::NetworkHintsHandler::Preconnect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_credentials"), in_allow_credentials, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkHintsHandler_Preconnect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network_hints::mojom::internal::NetworkHintsHandler_Preconnect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkHintsHandler.Preconnect request");
  params->allow_credentials = in_allow_credentials;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkHintsHandler::Name_);
  message.set_method_name("Preconnect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NetworkHintsHandlerStubDispatch::Accept(
    NetworkHintsHandler* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNetworkHintsHandler_PrefetchDNS_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network_hints::mojom::NetworkHintsHandler::PrefetchDNS",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network_hints::mojom::NetworkHintsHandler::PrefetchDNS");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkHintsHandler_PrefetchDNS_Params_Data* params =
          reinterpret_cast<internal::NetworkHintsHandler_PrefetchDNS_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<std::string> p_hostname_list{};
      NetworkHintsHandler_PrefetchDNS_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHostnameList(&p_hostname_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkHintsHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrefetchDNS(
std::move(p_hostname_list));
      return true;
    }
    case internal::kNetworkHintsHandler_Preconnect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network_hints::mojom::NetworkHintsHandler::Preconnect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network_hints::mojom::NetworkHintsHandler::Preconnect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkHintsHandler_Preconnect_Params_Data* params =
          reinterpret_cast<internal::NetworkHintsHandler_Preconnect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      bool p_allow_credentials{};
      NetworkHintsHandler_Preconnect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_allow_credentials = input_data_view.allow_credentials();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkHintsHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Preconnect(
std::move(p_url), 
std::move(p_allow_credentials));
      return true;
    }
  }
  return false;
}

// static
bool NetworkHintsHandlerStubDispatch::AcceptWithResponder(
    NetworkHintsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetworkHintsHandler_PrefetchDNS_Name: {
      break;
    }
    case internal::kNetworkHintsHandler_Preconnect_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkHintsHandlerValidationInfo[] = {
    {internal::kNetworkHintsHandler_PrefetchDNS_Name,
     {&internal::NetworkHintsHandler_PrefetchDNS_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkHintsHandler_Preconnect_Name,
     {&internal::NetworkHintsHandler_Preconnect_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetworkHintsHandlerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network_hints::mojom::NetworkHintsHandler::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetworkHintsHandlerValidationInfo);
}

}  // namespace mojom
}  // namespace network_hints

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif