// components/paint_preview/common/mojom/paint_preview_types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/paint_preview/common/mojom/paint_preview_types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/paint_preview/common/mojom/paint_preview_types.mojom-params-data.h"
#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared-message-ids.h"

#include "components/paint_preview/common/mojom/paint_preview_types.mojom-import-headers.h"


#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_JUMBO_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_JUMBO_H_
#endif
namespace paint_preview {
namespace mojom {
SerializedRecording::SerializedRecording() : tag_(Tag::FILE) {
  data_.file = new ::base::File;
}

SerializedRecording::~SerializedRecording() {
  DestroyActive();
}


void SerializedRecording::set_file(
    ::base::File file) {
  if (tag_ == Tag::FILE) {
    *(data_.file) = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::FILE;
    data_.file = new ::base::File(
        std::move(file));
  }
}
void SerializedRecording::set_buffer(
    ::mojo_base::BigBuffer buffer) {
  if (tag_ == Tag::BUFFER) {
    *(data_.buffer) = std::move(buffer);
  } else {
    DestroyActive();
    tag_ = Tag::BUFFER;
    data_.buffer = new ::mojo_base::BigBuffer(
        std::move(buffer));
  }
}

void SerializedRecording::DestroyActive() {
  switch (tag_) {

    case Tag::FILE:

      delete data_.file;
      break;
    case Tag::BUFFER:

      delete data_.buffer;
      break;
  }
}

bool SerializedRecording::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace mojom
}  // namespace paint_preview

namespace mojo {

// static
bool UnionTraits<::paint_preview::mojom::SerializedRecording::DataView, ::paint_preview::mojom::SerializedRecordingPtr>::Read(
    ::paint_preview::mojom::SerializedRecording::DataView input,
    ::paint_preview::mojom::SerializedRecordingPtr* output) {
  using UnionType = ::paint_preview::mojom::SerializedRecording;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::FILE: {
      ::base::File result_file;
      if (!input.ReadFile(&result_file))
        return false;

      *output = UnionType::NewFile(
          std::move(result_file));
      break;
    }
    case Tag::BUFFER: {
      ::mojo_base::BigBuffer result_buffer;
      if (!input.ReadBuffer(&result_buffer))
        return false;

      *output = UnionType::NewBuffer(
          std::move(result_buffer));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif