// components/performance_manager/public/mojom/coordination_unit.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/performance_manager/public/mojom/coordination_unit.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/performance_manager/public/mojom/coordination_unit.mojom-params-data.h"
namespace performance_manager {
namespace mojom {

std::string CoordinationUnitTypeToString(CoordinationUnitType value) {
  switch(value) {
    case CoordinationUnitType::kFrame:
      return "CoordinationUnitType::kFrame";
    case CoordinationUnitType::kPage:
      return "CoordinationUnitType::kPage";
    case CoordinationUnitType::kProcess:
      return "CoordinationUnitType::kProcess";
    case CoordinationUnitType::kSystem:
      return "CoordinationUnitType::kSystem";
    default:
      return base::StringPrintf("Unknown CoordinationUnitType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CoordinationUnitType value) {
  return os << CoordinationUnitTypeToString(value);
}

namespace internal {


// static
bool DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data* object = static_cast<const DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_SetLifecycleState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DocumentCoordinationUnit_SetLifecycleState_Params_Data* object = static_cast<const DocumentCoordinationUnit_SetLifecycleState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::performance_manager::mojom::internal::LifecycleState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

DocumentCoordinationUnit_SetLifecycleState_Params_Data::DocumentCoordinationUnit_SetLifecycleState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data* object = static_cast<const DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_SetHadFormInteraction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DocumentCoordinationUnit_SetHadFormInteraction_Params_Data* object = static_cast<const DocumentCoordinationUnit_SetHadFormInteraction_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DocumentCoordinationUnit_SetHadFormInteraction_Params_Data::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_SetIsAdFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DocumentCoordinationUnit_SetIsAdFrame_Params_Data* object = static_cast<const DocumentCoordinationUnit_SetIsAdFrame_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DocumentCoordinationUnit_SetIsAdFrame_Params_Data::DocumentCoordinationUnit_SetIsAdFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_SetViewportIntersection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DocumentCoordinationUnit_SetViewportIntersection_Params_Data* object = static_cast<const DocumentCoordinationUnit_SetViewportIntersection_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewport_intersection, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->viewport_intersection, validation_context))
    return false;

  return true;
}

DocumentCoordinationUnit_SetViewportIntersection_Params_Data::DocumentCoordinationUnit_SetViewportIntersection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data* object = static_cast<const DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data* object = static_cast<const DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_since_navigation_start, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_since_navigation_start, validation_context))
    return false;

  return true;
}

DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data* object = static_cast<const DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::performance_manager::mojom::internal::WebMemoryMeasurement_Mode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data* object = static_cast<const DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->measurement, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->measurement, validation_context))
    return false;

  return true;
}

DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data* object = static_cast<const ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessCoordinationUnit_OnV8ContextCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessCoordinationUnit_OnV8ContextCreated_Params_Data* object = static_cast<const ProcessCoordinationUnit_OnV8ContextCreated_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->iframe_attribution_data, validation_context))
    return false;

  return true;
}

ProcessCoordinationUnit_OnV8ContextCreated_Params_Data::ProcessCoordinationUnit_OnV8ContextCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessCoordinationUnit_OnV8ContextDetached_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessCoordinationUnit_OnV8ContextDetached_Params_Data* object = static_cast<const ProcessCoordinationUnit_OnV8ContextDetached_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->v8_context_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->v8_context_token, validation_context))
    return false;

  return true;
}

ProcessCoordinationUnit_OnV8ContextDetached_Params_Data::ProcessCoordinationUnit_OnV8ContextDetached_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data* object = static_cast<const ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->v8_context_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->v8_context_token, validation_context))
    return false;

  return true;
}

ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data::ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data* object = static_cast<const ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_frame_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->iframe_attribution_data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->iframe_attribution_data, validation_context))
    return false;

  return true;
}

ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data::ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data* object = static_cast<const ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_frame_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_frame_token, validation_context))
    return false;

  return true;
}

ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data::ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace performance_manager

namespace perfetto {

// static
void TraceFormatTraits<::performance_manager::mojom::CoordinationUnitType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::performance_manager::mojom::CoordinationUnitType value) {
  return std::move(context).WriteString(::performance_manager::mojom::CoordinationUnitTypeToString(value));
}

} // namespace perfetto
