// components/performance_manager/public/mojom/web_memory.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/performance_manager/public/mojom/web_memory.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/performance_manager/public/mojom/web_memory.mojom-params-data.h"
namespace performance_manager {
namespace mojom {

std::string WebMemoryAttribution_ScopeToString(WebMemoryAttribution_Scope value) {
  switch(value) {
    case WebMemoryAttribution_Scope::kCrossOriginAggregated:
      return "WebMemoryAttribution_Scope::kCrossOriginAggregated";
    case WebMemoryAttribution_Scope::kDedicatedWorker:
      return "WebMemoryAttribution_Scope::kDedicatedWorker";
    case WebMemoryAttribution_Scope::kWindow:
      return "WebMemoryAttribution_Scope::kWindow";
    default:
      return base::StringPrintf("Unknown WebMemoryAttribution_Scope value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, WebMemoryAttribution_Scope value) {
  return os << WebMemoryAttribution_ScopeToString(value);
}

std::string WebMemoryMeasurement_ModeToString(WebMemoryMeasurement_Mode value) {
  switch(value) {
    case WebMemoryMeasurement_Mode::kDefault:
      return "WebMemoryMeasurement_Mode::kDefault";
    case WebMemoryMeasurement_Mode::kEager:
      return "WebMemoryMeasurement_Mode::kEager";
    default:
      return base::StringPrintf("Unknown WebMemoryMeasurement_Mode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, WebMemoryMeasurement_Mode value) {
  return os << WebMemoryMeasurement_ModeToString(value);
}

namespace internal {


// static
bool WebMemoryAttribution_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebMemoryAttribution_Data* object = static_cast<const WebMemoryAttribution_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::performance_manager::mojom::internal::WebMemoryAttribution_Scope_Data
        ::Validate(object->scope, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams src_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->src, validation_context,
                                         &src_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

WebMemoryAttribution_Data::WebMemoryAttribution_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebMemoryUsage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebMemoryUsage_Data* object = static_cast<const WebMemoryUsage_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

WebMemoryUsage_Data::WebMemoryUsage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebMemoryBreakdownEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebMemoryBreakdownEntry_Data* object = static_cast<const WebMemoryBreakdownEntry_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->memory, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribution, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams attribution_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->attribution, validation_context,
                                         &attribution_validate_params)) {
    return false;
  }

  return true;
}

WebMemoryBreakdownEntry_Data::WebMemoryBreakdownEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebMemoryMeasurement_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebMemoryMeasurement_Data* object = static_cast<const WebMemoryMeasurement_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->breakdown, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams breakdown_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->breakdown, validation_context,
                                         &breakdown_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->detached_memory, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->shared_memory, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->blink_memory, validation_context))
    return false;

  return true;
}

WebMemoryMeasurement_Data::WebMemoryMeasurement_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace performance_manager

namespace perfetto {

// static
void TraceFormatTraits<::performance_manager::mojom::WebMemoryAttribution_Scope>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::performance_manager::mojom::WebMemoryAttribution_Scope value) {
  return std::move(context).WriteString(::performance_manager::mojom::WebMemoryAttribution_ScopeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::performance_manager::mojom::WebMemoryMeasurement_Mode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::performance_manager::mojom::WebMemoryMeasurement_Mode value) {
  return std::move(context).WriteString(::performance_manager::mojom::WebMemoryMeasurement_ModeToString(value));
}

} // namespace perfetto
