// components/schema_org/common/metadata.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/schema_org/common/metadata.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/schema_org/common/metadata.mojom-params-data.h"
namespace schema_org {
namespace mojom {

namespace internal {
// static
bool Values_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const Values_Data* object = static_cast<const Values_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case Values_Tag::BOOL_VALUES: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_bool_values, 1, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams bool_values_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_bool_values, validation_context,
                                             &bool_values_validate_params)) {
        return false;
      }
      return true;
    }
    case Values_Tag::LONG_VALUES: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_long_values, 2, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams long_values_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_long_values, validation_context,
                                             &long_values_validate_params)) {
        return false;
      }
      return true;
    }
    case Values_Tag::STRING_VALUES: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_string_values, 3, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams string_values_validate_params(
          0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
      if (!mojo::internal::ValidateContainer(object->data.f_string_values, validation_context,
                                             &string_values_validate_params)) {
        return false;
      }
      return true;
    }
    case Values_Tag::ENTITY_VALUES: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_entity_values, 4, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams entity_values_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_entity_values, validation_context,
                                             &entity_values_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in Values");
      return false;
    }
  }
}


// static
bool Property_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Property_Data* object = static_cast<const Property_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->values, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->values, validation_context))
    return false;

  return true;
}

Property_Data::Property_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Entity_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Entity_Data* object = static_cast<const Entity_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams properties_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->properties, validation_context,
                                         &properties_validate_params)) {
    return false;
  }

  return true;
}

Entity_Data::Entity_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace schema_org
