// components/services/app_service/public/mojom/app_service.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/services/app_service/public/mojom/app_service.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "components/services/app_service/public/mojom/types.mojom.h"


#ifndef COMPONENTS_SERVICES_APP_SERVICE_PUBLIC_MOJOM_APP_SERVICE_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_APP_SERVICE_PUBLIC_MOJOM_APP_SERVICE_MOJOM_JUMBO_H_
#endif


namespace apps {
namespace mojom {


void AppServiceInterceptorForTesting::RegisterPublisher(::mojo::PendingRemote<Publisher> publisher, ::apps::mojom::AppType app_type) {
  GetForwardingInterface()->RegisterPublisher(std::move(publisher), std::move(app_type));
}
void AppServiceInterceptorForTesting::RegisterSubscriber(::mojo::PendingRemote<Subscriber> subscriber, ConnectOptionsPtr opts) {
  GetForwardingInterface()->RegisterSubscriber(std::move(subscriber), std::move(opts));
}
void AppServiceInterceptorForTesting::LoadIcon(::apps::mojom::AppType app_type, const std::string& app_id, ::apps::mojom::IconKeyPtr icon_key, ::apps::mojom::IconType icon_type, int32_t size_hint_in_dip, bool allow_placeholder_icon, LoadIconCallback callback) {
  GetForwardingInterface()->LoadIcon(std::move(app_type), std::move(app_id), std::move(icon_key), std::move(icon_type), std::move(size_hint_in_dip), std::move(allow_placeholder_icon), std::move(callback));
}
void AppServiceInterceptorForTesting::Launch(::apps::mojom::AppType app_type, const std::string& app_id, int32_t event_flags, ::apps::mojom::LaunchSource launch_source, ::apps::mojom::WindowInfoPtr window_info) {
  GetForwardingInterface()->Launch(std::move(app_type), std::move(app_id), std::move(event_flags), std::move(launch_source), std::move(window_info));
}
void AppServiceInterceptorForTesting::LaunchAppWithFiles(::apps::mojom::AppType app_type, const std::string& app_id, ::apps::mojom::LaunchContainer container, int32_t event_flags, ::apps::mojom::LaunchSource launch_source, ::apps::mojom::FilePathsPtr file_paths) {
  GetForwardingInterface()->LaunchAppWithFiles(std::move(app_type), std::move(app_id), std::move(container), std::move(event_flags), std::move(launch_source), std::move(file_paths));
}
void AppServiceInterceptorForTesting::LaunchAppWithIntent(::apps::mojom::AppType app_type, const std::string& app_id, int32_t event_flags, ::apps::mojom::IntentPtr intent, ::apps::mojom::LaunchSource launch_source, ::apps::mojom::WindowInfoPtr window_info) {
  GetForwardingInterface()->LaunchAppWithIntent(std::move(app_type), std::move(app_id), std::move(event_flags), std::move(intent), std::move(launch_source), std::move(window_info));
}
void AppServiceInterceptorForTesting::SetPermission(::apps::mojom::AppType app_type, const std::string& app_id, ::apps::mojom::PermissionPtr permission) {
  GetForwardingInterface()->SetPermission(std::move(app_type), std::move(app_id), std::move(permission));
}
void AppServiceInterceptorForTesting::Uninstall(::apps::mojom::AppType app_type, const std::string& app_id, ::apps::mojom::UninstallSource uninstall_source, bool clear_site_data, bool report_abuse) {
  GetForwardingInterface()->Uninstall(std::move(app_type), std::move(app_id), std::move(uninstall_source), std::move(clear_site_data), std::move(report_abuse));
}
void AppServiceInterceptorForTesting::PauseApp(::apps::mojom::AppType app_type, const std::string& app_id) {
  GetForwardingInterface()->PauseApp(std::move(app_type), std::move(app_id));
}
void AppServiceInterceptorForTesting::UnpauseApps(::apps::mojom::AppType app_type, const std::string& app_id) {
  GetForwardingInterface()->UnpauseApps(std::move(app_type), std::move(app_id));
}
void AppServiceInterceptorForTesting::StopApp(::apps::mojom::AppType app_type, const std::string& app_id) {
  GetForwardingInterface()->StopApp(std::move(app_type), std::move(app_id));
}
void AppServiceInterceptorForTesting::GetMenuModel(::apps::mojom::AppType app_type, const std::string& app_id, ::apps::mojom::MenuType menu_type, int64_t display_id, GetMenuModelCallback callback) {
  GetForwardingInterface()->GetMenuModel(std::move(app_type), std::move(app_id), std::move(menu_type), std::move(display_id), std::move(callback));
}
void AppServiceInterceptorForTesting::ExecuteContextMenuCommand(::apps::mojom::AppType app_type, const std::string& app_id, int32_t command_id, const std::string& shortcut_id, int64_t display_id) {
  GetForwardingInterface()->ExecuteContextMenuCommand(std::move(app_type), std::move(app_id), std::move(command_id), std::move(shortcut_id), std::move(display_id));
}
void AppServiceInterceptorForTesting::OpenNativeSettings(::apps::mojom::AppType app_type, const std::string& app_id) {
  GetForwardingInterface()->OpenNativeSettings(std::move(app_type), std::move(app_id));
}
void AppServiceInterceptorForTesting::AddPreferredApp(::apps::mojom::AppType app_type, const std::string& app_id, ::apps::mojom::IntentFilterPtr intent_filter, ::apps::mojom::IntentPtr intent, bool from_publisher) {
  GetForwardingInterface()->AddPreferredApp(std::move(app_type), std::move(app_id), std::move(intent_filter), std::move(intent), std::move(from_publisher));
}
void AppServiceInterceptorForTesting::RemovePreferredApp(::apps::mojom::AppType app_type, const std::string& app_id) {
  GetForwardingInterface()->RemovePreferredApp(std::move(app_type), std::move(app_id));
}
void AppServiceInterceptorForTesting::RemovePreferredAppForFilter(::apps::mojom::AppType app_type, const std::string& app_id, ::apps::mojom::IntentFilterPtr intent_filter) {
  GetForwardingInterface()->RemovePreferredAppForFilter(std::move(app_type), std::move(app_id), std::move(intent_filter));
}
AppServiceAsyncWaiter::AppServiceAsyncWaiter(
    AppService* proxy) : proxy_(proxy) {}

AppServiceAsyncWaiter::~AppServiceAsyncWaiter() = default;

void AppServiceAsyncWaiter::LoadIcon(
    ::apps::mojom::AppType app_type, const std::string& app_id, ::apps::mojom::IconKeyPtr icon_key, ::apps::mojom::IconType icon_type, int32_t size_hint_in_dip, bool allow_placeholder_icon, ::apps::mojom::IconValuePtr* out_icon_value) {
  base::RunLoop loop;
  proxy_->LoadIcon(std::move(app_type),std::move(app_id),std::move(icon_key),std::move(icon_type),std::move(size_hint_in_dip),std::move(allow_placeholder_icon),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::apps::mojom::IconValuePtr* out_icon_value
,
             ::apps::mojom::IconValuePtr icon_value) {*out_icon_value = std::move(icon_value);
            loop->Quit();
          },
          &loop,
          out_icon_value));
  loop.Run();
}
void AppServiceAsyncWaiter::GetMenuModel(
    ::apps::mojom::AppType app_type, const std::string& app_id, ::apps::mojom::MenuType menu_type, int64_t display_id, ::apps::mojom::MenuItemsPtr* out_menu_items) {
  base::RunLoop loop;
  proxy_->GetMenuModel(std::move(app_type),std::move(app_id),std::move(menu_type),std::move(display_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::apps::mojom::MenuItemsPtr* out_menu_items
,
             ::apps::mojom::MenuItemsPtr menu_items) {*out_menu_items = std::move(menu_items);
            loop->Quit();
          },
          &loop,
          out_menu_items));
  loop.Run();
}



void PublisherInterceptorForTesting::Connect(::mojo::PendingRemote<Subscriber> subscriber, ConnectOptionsPtr opts) {
  GetForwardingInterface()->Connect(std::move(subscriber), std::move(opts));
}
void PublisherInterceptorForTesting::LoadIcon(const std::string& app_id, ::apps::mojom::IconKeyPtr icon_key, ::apps::mojom::IconType icon_type, int32_t size_hint_in_dip, bool allow_placeholder_icon, LoadIconCallback callback) {
  GetForwardingInterface()->LoadIcon(std::move(app_id), std::move(icon_key), std::move(icon_type), std::move(size_hint_in_dip), std::move(allow_placeholder_icon), std::move(callback));
}
void PublisherInterceptorForTesting::Launch(const std::string& app_id, int32_t event_flags, ::apps::mojom::LaunchSource launch_source, ::apps::mojom::WindowInfoPtr window_info) {
  GetForwardingInterface()->Launch(std::move(app_id), std::move(event_flags), std::move(launch_source), std::move(window_info));
}
void PublisherInterceptorForTesting::LaunchAppWithFiles(const std::string& app_id, ::apps::mojom::LaunchContainer container, int32_t event_flags, ::apps::mojom::LaunchSource launch_source, ::apps::mojom::FilePathsPtr file_paths) {
  GetForwardingInterface()->LaunchAppWithFiles(std::move(app_id), std::move(container), std::move(event_flags), std::move(launch_source), std::move(file_paths));
}
void PublisherInterceptorForTesting::LaunchAppWithIntent(const std::string& app_id, int32_t event_flags, ::apps::mojom::IntentPtr intent, ::apps::mojom::LaunchSource launch_source, ::apps::mojom::WindowInfoPtr window_info) {
  GetForwardingInterface()->LaunchAppWithIntent(std::move(app_id), std::move(event_flags), std::move(intent), std::move(launch_source), std::move(window_info));
}
void PublisherInterceptorForTesting::SetPermission(const std::string& app_id, ::apps::mojom::PermissionPtr permission) {
  GetForwardingInterface()->SetPermission(std::move(app_id), std::move(permission));
}
void PublisherInterceptorForTesting::Uninstall(const std::string& app_id, ::apps::mojom::UninstallSource uninstall_source, bool clear_site_data, bool report_abuse) {
  GetForwardingInterface()->Uninstall(std::move(app_id), std::move(uninstall_source), std::move(clear_site_data), std::move(report_abuse));
}
void PublisherInterceptorForTesting::PauseApp(const std::string& app_id) {
  GetForwardingInterface()->PauseApp(std::move(app_id));
}
void PublisherInterceptorForTesting::UnpauseApps(const std::string& app_id) {
  GetForwardingInterface()->UnpauseApps(std::move(app_id));
}
void PublisherInterceptorForTesting::StopApp(const std::string& app_id) {
  GetForwardingInterface()->StopApp(std::move(app_id));
}
void PublisherInterceptorForTesting::GetMenuModel(const std::string& app_id, ::apps::mojom::MenuType menu_type, int64_t display_id, GetMenuModelCallback callback) {
  GetForwardingInterface()->GetMenuModel(std::move(app_id), std::move(menu_type), std::move(display_id), std::move(callback));
}
void PublisherInterceptorForTesting::ExecuteContextMenuCommand(const std::string& app_id, int32_t command_id, const std::string& shortcut_id, int64_t display_id) {
  GetForwardingInterface()->ExecuteContextMenuCommand(std::move(app_id), std::move(command_id), std::move(shortcut_id), std::move(display_id));
}
void PublisherInterceptorForTesting::OpenNativeSettings(const std::string& app_id) {
  GetForwardingInterface()->OpenNativeSettings(std::move(app_id));
}
void PublisherInterceptorForTesting::OnPreferredAppSet(const std::string& app_id, ::apps::mojom::IntentFilterPtr intent_filter, ::apps::mojom::IntentPtr intent, ::apps::mojom::ReplacedAppPreferencesPtr replaced_app_preferences) {
  GetForwardingInterface()->OnPreferredAppSet(std::move(app_id), std::move(intent_filter), std::move(intent), std::move(replaced_app_preferences));
}
PublisherAsyncWaiter::PublisherAsyncWaiter(
    Publisher* proxy) : proxy_(proxy) {}

PublisherAsyncWaiter::~PublisherAsyncWaiter() = default;

void PublisherAsyncWaiter::LoadIcon(
    const std::string& app_id, ::apps::mojom::IconKeyPtr icon_key, ::apps::mojom::IconType icon_type, int32_t size_hint_in_dip, bool allow_placeholder_icon, ::apps::mojom::IconValuePtr* out_icon_value) {
  base::RunLoop loop;
  proxy_->LoadIcon(std::move(app_id),std::move(icon_key),std::move(icon_type),std::move(size_hint_in_dip),std::move(allow_placeholder_icon),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::apps::mojom::IconValuePtr* out_icon_value
,
             ::apps::mojom::IconValuePtr icon_value) {*out_icon_value = std::move(icon_value);
            loop->Quit();
          },
          &loop,
          out_icon_value));
  loop.Run();
}
void PublisherAsyncWaiter::GetMenuModel(
    const std::string& app_id, ::apps::mojom::MenuType menu_type, int64_t display_id, ::apps::mojom::MenuItemsPtr* out_menu_items) {
  base::RunLoop loop;
  proxy_->GetMenuModel(std::move(app_id),std::move(menu_type),std::move(display_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::apps::mojom::MenuItemsPtr* out_menu_items
,
             ::apps::mojom::MenuItemsPtr menu_items) {*out_menu_items = std::move(menu_items);
            loop->Quit();
          },
          &loop,
          out_menu_items));
  loop.Run();
}



void SubscriberInterceptorForTesting::OnApps(std::vector<::apps::mojom::AppPtr> deltas, ::apps::mojom::AppType app_type, bool should_notify_initialized) {
  GetForwardingInterface()->OnApps(std::move(deltas), std::move(app_type), std::move(should_notify_initialized));
}
void SubscriberInterceptorForTesting::OnCapabilityAccesses(std::vector<::apps::mojom::CapabilityAccessPtr> deltas) {
  GetForwardingInterface()->OnCapabilityAccesses(std::move(deltas));
}
void SubscriberInterceptorForTesting::Clone(::mojo::PendingReceiver<Subscriber> receiver) {
  GetForwardingInterface()->Clone(std::move(receiver));
}
void SubscriberInterceptorForTesting::OnPreferredAppSet(const std::string& app_id, ::apps::mojom::IntentFilterPtr intent_filter) {
  GetForwardingInterface()->OnPreferredAppSet(std::move(app_id), std::move(intent_filter));
}
void SubscriberInterceptorForTesting::OnPreferredAppRemoved(const std::string& app_id, ::apps::mojom::IntentFilterPtr intent_filter) {
  GetForwardingInterface()->OnPreferredAppRemoved(std::move(app_id), std::move(intent_filter));
}
void SubscriberInterceptorForTesting::InitializePreferredApps(std::vector<::apps::mojom::PreferredAppPtr> preferred_apps) {
  GetForwardingInterface()->InitializePreferredApps(std::move(preferred_apps));
}
SubscriberAsyncWaiter::SubscriberAsyncWaiter(
    Subscriber* proxy) : proxy_(proxy) {}

SubscriberAsyncWaiter::~SubscriberAsyncWaiter() = default;






}  // namespace mojom
}  // namespace apps

#if defined(__clang__)
#pragma clang diagnostic pop
#endif