// components/services/app_service/public/mojom/types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/app_service/public/mojom/types.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/app_service/public/mojom/types.mojom-params-data.h"
namespace apps {
namespace mojom {

std::string AppTypeToString(AppType value) {
  switch(value) {
    case AppType::kUnknown:
      return "AppType::kUnknown";
    case AppType::kArc:
      return "AppType::kArc";
    case AppType::kBuiltIn:
      return "AppType::kBuiltIn";
    case AppType::kCrostini:
      return "AppType::kCrostini";
    case AppType::kExtension:
      return "AppType::kExtension";
    case AppType::kWeb:
      return "AppType::kWeb";
    case AppType::kMacOs:
      return "AppType::kMacOs";
    case AppType::kPluginVm:
      return "AppType::kPluginVm";
    case AppType::kLacros:
      return "AppType::kLacros";
    case AppType::kRemote:
      return "AppType::kRemote";
    case AppType::kBorealis:
      return "AppType::kBorealis";
    default:
      return base::StringPrintf("Unknown AppType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, AppType value) {
  return os << AppTypeToString(value);
}

std::string ReadinessToString(Readiness value) {
  switch(value) {
    case Readiness::kUnknown:
      return "Readiness::kUnknown";
    case Readiness::kReady:
      return "Readiness::kReady";
    case Readiness::kDisabledByBlocklist:
      return "Readiness::kDisabledByBlocklist";
    case Readiness::kDisabledByPolicy:
      return "Readiness::kDisabledByPolicy";
    case Readiness::kDisabledByUser:
      return "Readiness::kDisabledByUser";
    case Readiness::kTerminated:
      return "Readiness::kTerminated";
    case Readiness::kUninstalledByUser:
      return "Readiness::kUninstalledByUser";
    case Readiness::kRemoved:
      return "Readiness::kRemoved";
    default:
      return base::StringPrintf("Unknown Readiness value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Readiness value) {
  return os << ReadinessToString(value);
}

std::string InstallSourceToString(InstallSource value) {
  switch(value) {
    case InstallSource::kUnknown:
      return "InstallSource::kUnknown";
    case InstallSource::kSystem:
      return "InstallSource::kSystem";
    case InstallSource::kPolicy:
      return "InstallSource::kPolicy";
    case InstallSource::kOem:
      return "InstallSource::kOem";
    case InstallSource::kDefault:
      return "InstallSource::kDefault";
    case InstallSource::kSync:
      return "InstallSource::kSync";
    case InstallSource::kUser:
      return "InstallSource::kUser";
    default:
      return base::StringPrintf("Unknown InstallSource value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, InstallSource value) {
  return os << InstallSourceToString(value);
}

std::string UninstallSourceToString(UninstallSource value) {
  switch(value) {
    case UninstallSource::kUnknown:
      return "UninstallSource::kUnknown";
    case UninstallSource::kUser:
      return "UninstallSource::kUser";
    case UninstallSource::kMigration:
      return "UninstallSource::kMigration";
    default:
      return base::StringPrintf("Unknown UninstallSource value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, UninstallSource value) {
  return os << UninstallSourceToString(value);
}

std::string OptionalBoolToString(OptionalBool value) {
  switch(value) {
    case OptionalBool::kUnknown:
      return "OptionalBool::kUnknown";
    case OptionalBool::kFalse:
      return "OptionalBool::kFalse";
    case OptionalBool::kTrue:
      return "OptionalBool::kTrue";
    default:
      return base::StringPrintf("Unknown OptionalBool value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, OptionalBool value) {
  return os << OptionalBoolToString(value);
}

std::string IconTypeToString(IconType value) {
  switch(value) {
    case IconType::kUnknown:
      return "IconType::kUnknown";
    case IconType::kUncompressed:
      return "IconType::kUncompressed";
    case IconType::kCompressed:
      return "IconType::kCompressed";
    case IconType::kStandard:
      return "IconType::kStandard";
    default:
      return base::StringPrintf("Unknown IconType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, IconType value) {
  return os << IconTypeToString(value);
}

std::string LaunchSourceToString(LaunchSource value) {
  switch(value) {
    case LaunchSource::kUnknown:
      return "LaunchSource::kUnknown";
    case LaunchSource::kFromAppListGrid:
      return "LaunchSource::kFromAppListGrid";
    case LaunchSource::kFromAppListGridContextMenu:
      return "LaunchSource::kFromAppListGridContextMenu";
    case LaunchSource::kFromAppListQuery:
      return "LaunchSource::kFromAppListQuery";
    case LaunchSource::kFromAppListQueryContextMenu:
      return "LaunchSource::kFromAppListQueryContextMenu";
    case LaunchSource::kFromAppListRecommendation:
      return "LaunchSource::kFromAppListRecommendation";
    case LaunchSource::kFromParentalControls:
      return "LaunchSource::kFromParentalControls";
    case LaunchSource::kFromShelf:
      return "LaunchSource::kFromShelf";
    case LaunchSource::kFromFileManager:
      return "LaunchSource::kFromFileManager";
    case LaunchSource::kFromLink:
      return "LaunchSource::kFromLink";
    case LaunchSource::kFromOmnibox:
      return "LaunchSource::kFromOmnibox";
    case LaunchSource::kFromChromeInternal:
      return "LaunchSource::kFromChromeInternal";
    case LaunchSource::kFromKeyboard:
      return "LaunchSource::kFromKeyboard";
    case LaunchSource::kFromOtherApp:
      return "LaunchSource::kFromOtherApp";
    case LaunchSource::kFromMenu:
      return "LaunchSource::kFromMenu";
    case LaunchSource::kFromInstalledNotification:
      return "LaunchSource::kFromInstalledNotification";
    case LaunchSource::kFromTest:
      return "LaunchSource::kFromTest";
    case LaunchSource::kFromArc:
      return "LaunchSource::kFromArc";
    case LaunchSource::kFromSharesheet:
      return "LaunchSource::kFromSharesheet";
    case LaunchSource::kFromReleaseNotesNotification:
      return "LaunchSource::kFromReleaseNotesNotification";
    case LaunchSource::kFromFullRestore:
      return "LaunchSource::kFromFullRestore";
    default:
      return base::StringPrintf("Unknown LaunchSource value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, LaunchSource value) {
  return os << LaunchSourceToString(value);
}

std::string TriStateToString(TriState value) {
  switch(value) {
    case TriState::kAllow:
      return "TriState::kAllow";
    case TriState::kBlock:
      return "TriState::kBlock";
    case TriState::kAsk:
      return "TriState::kAsk";
    default:
      return base::StringPrintf("Unknown TriState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TriState value) {
  return os << TriStateToString(value);
}

std::string PermissionValueTypeToString(PermissionValueType value) {
  switch(value) {
    case PermissionValueType::kBool:
      return "PermissionValueType::kBool";
    case PermissionValueType::kTriState:
      return "PermissionValueType::kTriState";
    default:
      return base::StringPrintf("Unknown PermissionValueType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PermissionValueType value) {
  return os << PermissionValueTypeToString(value);
}

std::string MenuItemTypeToString(MenuItemType value) {
  switch(value) {
    case MenuItemType::kCommand:
      return "MenuItemType::kCommand";
    case MenuItemType::kRadio:
      return "MenuItemType::kRadio";
    case MenuItemType::kSeparator:
      return "MenuItemType::kSeparator";
    case MenuItemType::kSubmenu:
      return "MenuItemType::kSubmenu";
    case MenuItemType::kPublisherCommand:
      return "MenuItemType::kPublisherCommand";
    default:
      return base::StringPrintf("Unknown MenuItemType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MenuItemType value) {
  return os << MenuItemTypeToString(value);
}

std::string MenuTypeToString(MenuType value) {
  switch(value) {
    case MenuType::kAppList:
      return "MenuType::kAppList";
    case MenuType::kShelf:
      return "MenuType::kShelf";
    default:
      return base::StringPrintf("Unknown MenuType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MenuType value) {
  return os << MenuTypeToString(value);
}

std::string ConditionTypeToString(ConditionType value) {
  switch(value) {
    case ConditionType::kScheme:
      return "ConditionType::kScheme";
    case ConditionType::kHost:
      return "ConditionType::kHost";
    case ConditionType::kPattern:
      return "ConditionType::kPattern";
    case ConditionType::kAction:
      return "ConditionType::kAction";
    case ConditionType::kMimeType:
      return "ConditionType::kMimeType";
    default:
      return base::StringPrintf("Unknown ConditionType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ConditionType value) {
  return os << ConditionTypeToString(value);
}

std::string PatternMatchTypeToString(PatternMatchType value) {
  switch(value) {
    case PatternMatchType::kNone:
      return "PatternMatchType::kNone";
    case PatternMatchType::kLiteral:
      return "PatternMatchType::kLiteral";
    case PatternMatchType::kPrefix:
      return "PatternMatchType::kPrefix";
    case PatternMatchType::kGlob:
      return "PatternMatchType::kGlob";
    case PatternMatchType::kMimeType:
      return "PatternMatchType::kMimeType";
    default:
      return base::StringPrintf("Unknown PatternMatchType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PatternMatchType value) {
  return os << PatternMatchTypeToString(value);
}

std::string AppLaunchSourceToString(AppLaunchSource value) {
  switch(value) {
    case AppLaunchSource::kSourceNone:
      return "AppLaunchSource::kSourceNone";
    case AppLaunchSource::kSourceUntracked:
      return "AppLaunchSource::kSourceUntracked";
    case AppLaunchSource::kSourceAppLauncher:
      return "AppLaunchSource::kSourceAppLauncher";
    case AppLaunchSource::kSourceNewTabPage:
      return "AppLaunchSource::kSourceNewTabPage";
    case AppLaunchSource::kSourceReload:
      return "AppLaunchSource::kSourceReload";
    case AppLaunchSource::kSourceRestart:
      return "AppLaunchSource::kSourceRestart";
    case AppLaunchSource::kSourceLoadAndLaunch:
      return "AppLaunchSource::kSourceLoadAndLaunch";
    case AppLaunchSource::kSourceCommandLine:
      return "AppLaunchSource::kSourceCommandLine";
    case AppLaunchSource::kSourceFileHandler:
      return "AppLaunchSource::kSourceFileHandler";
    case AppLaunchSource::kSourceUrlHandler:
      return "AppLaunchSource::kSourceUrlHandler";
    case AppLaunchSource::kSourceSystemTray:
      return "AppLaunchSource::kSourceSystemTray";
    case AppLaunchSource::kSourceAboutPage:
      return "AppLaunchSource::kSourceAboutPage";
    case AppLaunchSource::kSourceKeyboard:
      return "AppLaunchSource::kSourceKeyboard";
    case AppLaunchSource::kSourceExtensionsPage:
      return "AppLaunchSource::kSourceExtensionsPage";
    case AppLaunchSource::kSourceManagementApi:
      return "AppLaunchSource::kSourceManagementApi";
    case AppLaunchSource::kSourceEphemeralAppDeprecated:
      return "AppLaunchSource::kSourceEphemeralAppDeprecated";
    case AppLaunchSource::kSourceBackground:
      return "AppLaunchSource::kSourceBackground";
    case AppLaunchSource::kSourceKiosk:
      return "AppLaunchSource::kSourceKiosk";
    case AppLaunchSource::kSourceChromeInternal:
      return "AppLaunchSource::kSourceChromeInternal";
    case AppLaunchSource::kSourceTest:
      return "AppLaunchSource::kSourceTest";
    case AppLaunchSource::kSourceInstalledNotification:
      return "AppLaunchSource::kSourceInstalledNotification";
    case AppLaunchSource::kSourceContextMenu:
      return "AppLaunchSource::kSourceContextMenu";
    case AppLaunchSource::kSourceArc:
      return "AppLaunchSource::kSourceArc";
    case AppLaunchSource::kSourceIntentUrl:
      return "AppLaunchSource::kSourceIntentUrl";
    default:
      return base::StringPrintf("Unknown AppLaunchSource value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, AppLaunchSource value) {
  return os << AppLaunchSourceToString(value);
}

std::string LaunchContainerToString(LaunchContainer value) {
  switch(value) {
    case LaunchContainer::kLaunchContainerWindow:
      return "LaunchContainer::kLaunchContainerWindow";
    case LaunchContainer::kLaunchContainerPanelDeprecated:
      return "LaunchContainer::kLaunchContainerPanelDeprecated";
    case LaunchContainer::kLaunchContainerTab:
      return "LaunchContainer::kLaunchContainerTab";
    case LaunchContainer::kLaunchContainerNone:
      return "LaunchContainer::kLaunchContainerNone";
    default:
      return base::StringPrintf("Unknown LaunchContainer value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, LaunchContainer value) {
  return os << LaunchContainerToString(value);
}

namespace internal {


// static
bool App_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 152, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const App_Data* object = static_cast<const App_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::Readiness_Data
        ::Validate(object->readiness, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams short_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->short_name, validation_context,
                                         &short_name_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams publisher_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->publisher_id, validation_context,
                                         &publisher_id_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams description_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams version_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->version, validation_context,
                                         &version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_search_terms, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams additional_search_terms_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->additional_search_terms, validation_context,
                                         &additional_search_terms_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->icon_key, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->last_launch_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->install_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permissions, 13, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams permissions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->permissions, validation_context,
                                         &permissions_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::InstallSource_Data
        ::Validate(object->install_source, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->is_platform_app, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->recommendable, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->searchable, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->show_in_launcher, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->show_in_shelf, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->show_in_search, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->show_in_management, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->has_badge, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->paused, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intent_filters, 24, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams intent_filters_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->intent_filters, validation_context,
                                         &intent_filters_validate_params)) {
    return false;
  }

  return true;
}

App_Data::App_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Permission_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Permission_Data* object = static_cast<const Permission_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::PermissionValueType_Data
        ::Validate(object->value_type, validation_context))
    return false;

  return true;
}

Permission_Data::Permission_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IconKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IconKey_Data* object = static_cast<const IconKey_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IconKey_Data::IconKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IconValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IconValue_Data* object = static_cast<const IconValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::IconType_Data
        ::Validate(object->icon_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->uncompressed, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams compressed_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->compressed, validation_context,
                                         &compressed_validate_params)) {
    return false;
  }

  return true;
}

IconValue_Data::IconValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MenuItems_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MenuItems_Data* object = static_cast<const MenuItems_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams items_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  return true;
}

MenuItems_Data::MenuItems_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MenuItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MenuItem_Data* object = static_cast<const MenuItem_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::MenuItemType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->submenu, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams submenu_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->submenu, validation_context,
                                         &submenu_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shortcut_id, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams shortcut_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->shortcut_id, validation_context,
                                         &shortcut_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams label_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

MenuItem_Data::MenuItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConditionValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConditionValue_Data* object = static_cast<const ConditionValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::PatternMatchType_Data
        ::Validate(object->match_type, validation_context))
    return false;

  return true;
}

ConditionValue_Data::ConditionValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Condition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Condition_Data* object = static_cast<const Condition_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::ConditionType_Data
        ::Validate(object->condition_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->condition_values, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams condition_values_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->condition_values, validation_context,
                                         &condition_values_validate_params)) {
    return false;
  }

  return true;
}

Condition_Data::Condition_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IntentFilter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IntentFilter_Data* object = static_cast<const IntentFilter_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conditions, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams conditions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->conditions, validation_context,
                                         &conditions_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams activity_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->activity_name, validation_context,
                                         &activity_name_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams activity_label_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->activity_label, validation_context,
                                         &activity_label_validate_params)) {
    return false;
  }

  return true;
}

IntentFilter_Data::IntentFilter_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Intent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Intent_Data* object = static_cast<const Intent_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams action_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->action, validation_context,
                                         &action_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams mime_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams file_urls_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->file_urls, validation_context,
                                         &file_urls_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams activity_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->activity_name, validation_context,
                                         &activity_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->drive_share_url, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams share_text_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->share_text, validation_context,
                                         &share_text_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams share_title_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->share_title, validation_context,
                                         &share_title_validate_params)) {
    return false;
  }

  return true;
}

Intent_Data::Intent_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReplacedAppPreferences_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ReplacedAppPreferences_Data* object = static_cast<const ReplacedAppPreferences_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replaced_preference, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams replaced_preference_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->replaced_preference, validation_context,
                                         &replaced_preference_validate_params)) {
    return false;
  }

  return true;
}

ReplacedAppPreferences_Data::ReplacedAppPreferences_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PreferredApp_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PreferredApp_Data* object = static_cast<const PreferredApp_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intent_filter, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->intent_filter, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PreferredApp_Data::PreferredApp_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FilePaths_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FilePaths_Data* object = static_cast<const FilePaths_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_paths, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams file_paths_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->file_paths, validation_context,
                                         &file_paths_validate_params)) {
    return false;
  }

  return true;
}

FilePaths_Data::FilePaths_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CapabilityAccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CapabilityAccess_Data* object = static_cast<const CapabilityAccess_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->camera, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->microphone, validation_context))
    return false;

  return true;
}

CapabilityAccess_Data::CapabilityAccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Rect_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Rect_Data* object = static_cast<const Rect_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Rect_Data::Rect_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WindowInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WindowInfo_Data* object = static_cast<const WindowInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

WindowInfo_Data::WindowInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace apps

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::AppType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::AppType value) {
  return std::move(context).WriteString(::apps::mojom::AppTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::Readiness>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::Readiness value) {
  return std::move(context).WriteString(::apps::mojom::ReadinessToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::InstallSource>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::InstallSource value) {
  return std::move(context).WriteString(::apps::mojom::InstallSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::UninstallSource>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::UninstallSource value) {
  return std::move(context).WriteString(::apps::mojom::UninstallSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::OptionalBool>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::OptionalBool value) {
  return std::move(context).WriteString(::apps::mojom::OptionalBoolToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::IconType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::IconType value) {
  return std::move(context).WriteString(::apps::mojom::IconTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::LaunchSource>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::LaunchSource value) {
  return std::move(context).WriteString(::apps::mojom::LaunchSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::TriState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::TriState value) {
  return std::move(context).WriteString(::apps::mojom::TriStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::PermissionValueType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::PermissionValueType value) {
  return std::move(context).WriteString(::apps::mojom::PermissionValueTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::MenuItemType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::MenuItemType value) {
  return std::move(context).WriteString(::apps::mojom::MenuItemTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::MenuType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::MenuType value) {
  return std::move(context).WriteString(::apps::mojom::MenuTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::ConditionType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::ConditionType value) {
  return std::move(context).WriteString(::apps::mojom::ConditionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::PatternMatchType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::PatternMatchType value) {
  return std::move(context).WriteString(::apps::mojom::PatternMatchTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::AppLaunchSource>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::AppLaunchSource value) {
  return std::move(context).WriteString(::apps::mojom::AppLaunchSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::LaunchContainer>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::apps::mojom::LaunchContainer value) {
  return std::move(context).WriteString(::apps::mojom::LaunchContainerToString(value));
}

} // namespace perfetto
