// components/services/filesystem/public/mojom/file.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/filesystem/public/mojom/file.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/filesystem/public/mojom/file.mojom-params-data.h"
namespace filesystem {
namespace mojom {

namespace internal {


// static
bool File_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Close_Params_Data* object = static_cast<const File_Close_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

File_Close_Params_Data::File_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Close_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Close_ResponseParams_Data* object = static_cast<const File_Close_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->err, validation_context))
    return false;

  return true;
}

File_Close_ResponseParams_Data::File_Close_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Read_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Read_Params_Data* object = static_cast<const File_Read_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::filesystem::mojom::internal::Whence_Data
        ::Validate(object->whence, validation_context))
    return false;

  return true;
}

File_Read_Params_Data::File_Read_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Read_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Read_ResponseParams_Data* object = static_cast<const File_Read_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams bytes_read_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->bytes_read, validation_context,
                                         &bytes_read_validate_params)) {
    return false;
  }

  return true;
}

File_Read_ResponseParams_Data::File_Read_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Write_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Write_Params_Data* object = static_cast<const File_Write_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bytes_to_write, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams bytes_to_write_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->bytes_to_write, validation_context,
                                         &bytes_to_write_validate_params)) {
    return false;
  }


  if (!::filesystem::mojom::internal::Whence_Data
        ::Validate(object->whence, validation_context))
    return false;

  return true;
}

File_Write_Params_Data::File_Write_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Write_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Write_ResponseParams_Data* object = static_cast<const File_Write_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

File_Write_ResponseParams_Data::File_Write_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Tell_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Tell_Params_Data* object = static_cast<const File_Tell_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

File_Tell_Params_Data::File_Tell_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Tell_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Tell_ResponseParams_Data* object = static_cast<const File_Tell_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

File_Tell_ResponseParams_Data::File_Tell_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Seek_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Seek_Params_Data* object = static_cast<const File_Seek_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::filesystem::mojom::internal::Whence_Data
        ::Validate(object->whence, validation_context))
    return false;

  return true;
}

File_Seek_Params_Data::File_Seek_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Seek_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Seek_ResponseParams_Data* object = static_cast<const File_Seek_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

File_Seek_ResponseParams_Data::File_Seek_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Stat_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Stat_Params_Data* object = static_cast<const File_Stat_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

File_Stat_Params_Data::File_Stat_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Stat_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Stat_ResponseParams_Data* object = static_cast<const File_Stat_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->file_information, validation_context))
    return false;

  return true;
}

File_Stat_ResponseParams_Data::File_Stat_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Truncate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Truncate_Params_Data* object = static_cast<const File_Truncate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

File_Truncate_Params_Data::File_Truncate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Truncate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Truncate_ResponseParams_Data* object = static_cast<const File_Truncate_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

File_Truncate_ResponseParams_Data::File_Truncate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Touch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Touch_Params_Data* object = static_cast<const File_Touch_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->atime, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mtime, validation_context))
    return false;

  return true;
}

File_Touch_Params_Data::File_Touch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Touch_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Touch_ResponseParams_Data* object = static_cast<const File_Touch_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

File_Touch_ResponseParams_Data::File_Touch_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Dup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Dup_Params_Data* object = static_cast<const File_Dup_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->file,
                                                 validation_context)) {
    return false;
  }

  return true;
}

File_Dup_Params_Data::File_Dup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Dup_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Dup_ResponseParams_Data* object = static_cast<const File_Dup_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

File_Dup_ResponseParams_Data::File_Dup_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Flush_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Flush_Params_Data* object = static_cast<const File_Flush_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

File_Flush_Params_Data::File_Flush_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Flush_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Flush_ResponseParams_Data* object = static_cast<const File_Flush_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

File_Flush_ResponseParams_Data::File_Flush_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Lock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Lock_Params_Data* object = static_cast<const File_Lock_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

File_Lock_Params_Data::File_Lock_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Lock_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Lock_ResponseParams_Data* object = static_cast<const File_Lock_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

File_Lock_ResponseParams_Data::File_Lock_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Unlock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Unlock_Params_Data* object = static_cast<const File_Unlock_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

File_Unlock_Params_Data::File_Unlock_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Unlock_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_Unlock_ResponseParams_Data* object = static_cast<const File_Unlock_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

File_Unlock_ResponseParams_Data::File_Unlock_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_AsHandle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_AsHandle_Params_Data* object = static_cast<const File_AsHandle_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

File_AsHandle_Params_Data::File_AsHandle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_AsHandle_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const File_AsHandle_ResponseParams_Data* object = static_cast<const File_AsHandle_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->file_handle, validation_context))
    return false;

  return true;
}

File_AsHandle_ResponseParams_Data::File_AsHandle_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace filesystem
