// components/services/filesystem/public/mojom/types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/filesystem/public/mojom/types.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/filesystem/public/mojom/types.mojom-params-data.h"
namespace filesystem {
namespace mojom {

std::string WhenceToString(Whence value) {
  switch(value) {
    case Whence::FROM_BEGIN:
      return "Whence::FROM_BEGIN";
    case Whence::FROM_CURRENT:
      return "Whence::FROM_CURRENT";
    case Whence::FROM_END:
      return "Whence::FROM_END";
    default:
      return base::StringPrintf("Unknown Whence value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Whence value) {
  return os << WhenceToString(value);
}

std::string FsFileTypeToString(FsFileType value) {
  switch(value) {
    case FsFileType::UNKNOWN:
      return "FsFileType::UNKNOWN";
    case FsFileType::REGULAR_FILE:
      return "FsFileType::REGULAR_FILE";
    case FsFileType::DIRECTORY:
      return "FsFileType::DIRECTORY";
    default:
      return base::StringPrintf("Unknown FsFileType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FsFileType value) {
  return os << FsFileTypeToString(value);
}

namespace internal {


// static
bool TimespecOrNow_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TimespecOrNow_Data* object = static_cast<const TimespecOrNow_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TimespecOrNow_Data::TimespecOrNow_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileInformation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileInformation_Data* object = static_cast<const FileInformation_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::filesystem::mojom::internal::FsFileType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

FileInformation_Data::FileInformation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectoryEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DirectoryEntry_Data* object = static_cast<const DirectoryEntry_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;


  if (!::filesystem::mojom::internal::FsFileType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

DirectoryEntry_Data::DirectoryEntry_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace filesystem

namespace perfetto {

// static
void TraceFormatTraits<::filesystem::mojom::Whence>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::filesystem::mojom::Whence value) {
  return std::move(context).WriteString(::filesystem::mojom::WhenceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::filesystem::mojom::FsFileType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::filesystem::mojom::FsFileType value) {
  return std::move(context).WriteString(::filesystem::mojom::FsFileTypeToString(value));
}

} // namespace perfetto
