// components/services/font/public/mojom/font_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/font/public/mojom/font_service.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/font/public/mojom/font_service.mojom-params-data.h"
namespace font_service {
namespace mojom {

std::string TypefaceSlantToString(TypefaceSlant value) {
  switch(value) {
    case TypefaceSlant::ROMAN:
      return "TypefaceSlant::ROMAN";
    case TypefaceSlant::ITALIC:
      return "TypefaceSlant::ITALIC";
    case TypefaceSlant::OBLIQUE:
      return "TypefaceSlant::OBLIQUE";
    default:
      return base::StringPrintf("Unknown TypefaceSlant value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TypefaceSlant value) {
  return os << TypefaceSlantToString(value);
}

std::string RenderStyleSwitchToString(RenderStyleSwitch value) {
  switch(value) {
    case RenderStyleSwitch::OFF:
      return "RenderStyleSwitch::OFF";
    case RenderStyleSwitch::ON:
      return "RenderStyleSwitch::ON";
    case RenderStyleSwitch::NO_PREFERENCE:
      return "RenderStyleSwitch::NO_PREFERENCE";
    default:
      return base::StringPrintf("Unknown RenderStyleSwitch value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, RenderStyleSwitch value) {
  return os << RenderStyleSwitchToString(value);
}

namespace internal {


// static
bool TypefaceStyle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TypefaceStyle_Data* object = static_cast<const TypefaceStyle_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::font_service::mojom::internal::TypefaceSlant_Data
        ::Validate(object->slant, validation_context))
    return false;

  return true;
}

TypefaceStyle_Data::TypefaceStyle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontIdentity_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontIdentity_Data* object = static_cast<const FontIdentity_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filepath, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filepath, validation_context))
    return false;

  return true;
}

FontIdentity_Data::FontIdentity_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontRenderStyle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontRenderStyle_Data* object = static_cast<const FontRenderStyle_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::font_service::mojom::internal::RenderStyleSwitch_Data
        ::Validate(object->use_bitmaps, validation_context))
    return false;


  if (!::font_service::mojom::internal::RenderStyleSwitch_Data
        ::Validate(object->use_autohint, validation_context))
    return false;


  if (!::font_service::mojom::internal::RenderStyleSwitch_Data
        ::Validate(object->use_hinting, validation_context))
    return false;


  if (!::font_service::mojom::internal::RenderStyleSwitch_Data
        ::Validate(object->use_antialias, validation_context))
    return false;


  if (!::font_service::mojom::internal::RenderStyleSwitch_Data
        ::Validate(object->use_subpixel_rendering, validation_context))
    return false;


  if (!::font_service::mojom::internal::RenderStyleSwitch_Data
        ::Validate(object->use_subpixel_positioning, validation_context))
    return false;

  return true;
}

FontRenderStyle_Data::FontRenderStyle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontService_MatchFamilyName_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontService_MatchFamilyName_Params_Data* object = static_cast<const FontService_MatchFamilyName_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->family_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams family_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->family_name, validation_context,
                                         &family_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->style, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->style, validation_context))
    return false;

  return true;
}

FontService_MatchFamilyName_Params_Data::FontService_MatchFamilyName_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontService_MatchFamilyName_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontService_MatchFamilyName_ResponseParams_Data* object = static_cast<const FontService_MatchFamilyName_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->identity, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->family_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams family_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->family_name, validation_context,
                                         &family_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->style, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->style, validation_context))
    return false;

  return true;
}

FontService_MatchFamilyName_ResponseParams_Data::FontService_MatchFamilyName_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontService_OpenStream_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontService_OpenStream_Params_Data* object = static_cast<const FontService_OpenStream_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FontService_OpenStream_Params_Data::FontService_OpenStream_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontService_OpenStream_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontService_OpenStream_ResponseParams_Data* object = static_cast<const FontService_OpenStream_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->font_handle, validation_context))
    return false;

  return true;
}

FontService_OpenStream_ResponseParams_Data::FontService_OpenStream_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontService_FallbackFontForCharacter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontService_FallbackFontForCharacter_Params_Data* object = static_cast<const FontService_FallbackFontForCharacter_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->locale, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams locale_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->locale, validation_context,
                                         &locale_validate_params)) {
    return false;
  }

  return true;
}

FontService_FallbackFontForCharacter_Params_Data::FontService_FallbackFontForCharacter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontService_FallbackFontForCharacter_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontService_FallbackFontForCharacter_ResponseParams_Data* object = static_cast<const FontService_FallbackFontForCharacter_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->identity, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->family_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams family_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->family_name, validation_context,
                                         &family_name_validate_params)) {
    return false;
  }

  return true;
}

FontService_FallbackFontForCharacter_ResponseParams_Data::FontService_FallbackFontForCharacter_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontService_FontRenderStyleForStrike_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontService_FontRenderStyleForStrike_Params_Data* object = static_cast<const FontService_FontRenderStyleForStrike_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->family, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams family_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->family, validation_context,
                                         &family_validate_params)) {
    return false;
  }

  return true;
}

FontService_FontRenderStyleForStrike_Params_Data::FontService_FontRenderStyleForStrike_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontService_FontRenderStyleForStrike_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontService_FontRenderStyleForStrike_ResponseParams_Data* object = static_cast<const FontService_FontRenderStyleForStrike_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->font_render_style, validation_context))
    return false;

  return true;
}

FontService_FontRenderStyleForStrike_ResponseParams_Data::FontService_FontRenderStyleForStrike_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontService_MatchFontByPostscriptNameOrFullFontName_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontService_MatchFontByPostscriptNameOrFullFontName_Params_Data* object = static_cast<const FontService_MatchFontByPostscriptNameOrFullFontName_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->postscript_name_or_full_font_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams postscript_name_or_full_font_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->postscript_name_or_full_font_name, validation_context,
                                         &postscript_name_or_full_font_name_validate_params)) {
    return false;
  }

  return true;
}

FontService_MatchFontByPostscriptNameOrFullFontName_Params_Data::FontService_MatchFontByPostscriptNameOrFullFontName_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontService_MatchFontByPostscriptNameOrFullFontName_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontService_MatchFontByPostscriptNameOrFullFontName_ResponseParams_Data* object = static_cast<const FontService_MatchFontByPostscriptNameOrFullFontName_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->identity, validation_context))
    return false;

  return true;
}

FontService_MatchFontByPostscriptNameOrFullFontName_ResponseParams_Data::FontService_MatchFontByPostscriptNameOrFullFontName_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontService_MatchFontWithFallback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontService_MatchFontWithFallback_Params_Data* object = static_cast<const FontService_MatchFontWithFallback_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->family, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams family_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->family, validation_context,
                                         &family_validate_params)) {
    return false;
  }

  return true;
}

FontService_MatchFontWithFallback_Params_Data::FontService_MatchFontWithFallback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontService_MatchFontWithFallback_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontService_MatchFontWithFallback_ResponseParams_Data* object = static_cast<const FontService_MatchFontWithFallback_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->font_file_handle, validation_context))
    return false;

  return true;
}

FontService_MatchFontWithFallback_ResponseParams_Data::FontService_MatchFontWithFallback_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace font_service

namespace perfetto {

// static
void TraceFormatTraits<::font_service::mojom::TypefaceSlant>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::font_service::mojom::TypefaceSlant value) {
  return std::move(context).WriteString(::font_service::mojom::TypefaceSlantToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::font_service::mojom::RenderStyleSwitch>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::font_service::mojom::RenderStyleSwitch value) {
  return std::move(context).WriteString(::font_service::mojom::RenderStyleSwitchToString(value));
}

} // namespace perfetto
