// components/services/print_compositor/public/mojom/print_compositor.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/services/print_compositor/public/mojom/print_compositor.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "url/mojom/url.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"


#ifndef COMPONENTS_SERVICES_PRINT_COMPOSITOR_PUBLIC_MOJOM_PRINT_COMPOSITOR_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_PRINT_COMPOSITOR_PUBLIC_MOJOM_PRINT_COMPOSITOR_MOJOM_JUMBO_H_
#endif


namespace printing {
namespace mojom {


void PrintCompositorInterceptorForTesting::SetDiscardableSharedMemoryManager(::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> manager) {
  GetForwardingInterface()->SetDiscardableSharedMemoryManager(std::move(manager));
}
void PrintCompositorInterceptorForTesting::NotifyUnavailableSubframe(uint64_t frame_guid) {
  GetForwardingInterface()->NotifyUnavailableSubframe(std::move(frame_guid));
}
void PrintCompositorInterceptorForTesting::AddSubframeContent(uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion serialized_content, const base::flat_map<uint32_t, uint64_t>& subframe_content_info) {
  GetForwardingInterface()->AddSubframeContent(std::move(frame_guid), std::move(serialized_content), std::move(subframe_content_info));
}
void PrintCompositorInterceptorForTesting::SetAccessibilityTree(const ::ui::AXTreeUpdate& accessibility_tree) {
  GetForwardingInterface()->SetAccessibilityTree(std::move(accessibility_tree));
}
void PrintCompositorInterceptorForTesting::CompositePageToPdf(uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion sk_region, const base::flat_map<uint32_t, uint64_t>& subframe_content_info, CompositePageToPdfCallback callback) {
  GetForwardingInterface()->CompositePageToPdf(std::move(frame_guid), std::move(sk_region), std::move(subframe_content_info), std::move(callback));
}
void PrintCompositorInterceptorForTesting::CompositeDocumentToPdf(uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion sk_region, const base::flat_map<uint32_t, uint64_t>& subframe_content_info, CompositeDocumentToPdfCallback callback) {
  GetForwardingInterface()->CompositeDocumentToPdf(std::move(frame_guid), std::move(sk_region), std::move(subframe_content_info), std::move(callback));
}
void PrintCompositorInterceptorForTesting::PrepareForDocumentToPdf(PrepareForDocumentToPdfCallback callback) {
  GetForwardingInterface()->PrepareForDocumentToPdf(std::move(callback));
}
void PrintCompositorInterceptorForTesting::CompleteDocumentToPdf(uint32_t pages_count, CompleteDocumentToPdfCallback callback) {
  GetForwardingInterface()->CompleteDocumentToPdf(std::move(pages_count), std::move(callback));
}
void PrintCompositorInterceptorForTesting::SetWebContentsURL(const ::GURL& url) {
  GetForwardingInterface()->SetWebContentsURL(std::move(url));
}
void PrintCompositorInterceptorForTesting::SetUserAgent(const std::string& user_agent) {
  GetForwardingInterface()->SetUserAgent(std::move(user_agent));
}
PrintCompositorAsyncWaiter::PrintCompositorAsyncWaiter(
    PrintCompositor* proxy) : proxy_(proxy) {}

PrintCompositorAsyncWaiter::~PrintCompositorAsyncWaiter() = default;

void PrintCompositorAsyncWaiter::CompositePageToPdf(
    uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion sk_region, const base::flat_map<uint32_t, uint64_t>& subframe_content_info, PrintCompositor::Status* out_status, ::base::ReadOnlySharedMemoryRegion* out_pdf_region) {
  base::RunLoop loop;
  proxy_->CompositePageToPdf(std::move(frame_guid),std::move(sk_region),std::move(subframe_content_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintCompositor::Status* out_status
,
             ::base::ReadOnlySharedMemoryRegion* out_pdf_region
,
             PrintCompositor::Status status,
             ::base::ReadOnlySharedMemoryRegion pdf_region) {*out_status = std::move(status);*out_pdf_region = std::move(pdf_region);
            loop->Quit();
          },
          &loop,
          out_status,
          out_pdf_region));
  loop.Run();
}
void PrintCompositorAsyncWaiter::CompositeDocumentToPdf(
    uint64_t frame_guid, ::base::ReadOnlySharedMemoryRegion sk_region, const base::flat_map<uint32_t, uint64_t>& subframe_content_info, PrintCompositor::Status* out_status, ::base::ReadOnlySharedMemoryRegion* out_pdf_region) {
  base::RunLoop loop;
  proxy_->CompositeDocumentToPdf(std::move(frame_guid),std::move(sk_region),std::move(subframe_content_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintCompositor::Status* out_status
,
             ::base::ReadOnlySharedMemoryRegion* out_pdf_region
,
             PrintCompositor::Status status,
             ::base::ReadOnlySharedMemoryRegion pdf_region) {*out_status = std::move(status);*out_pdf_region = std::move(pdf_region);
            loop->Quit();
          },
          &loop,
          out_status,
          out_pdf_region));
  loop.Run();
}
void PrintCompositorAsyncWaiter::PrepareForDocumentToPdf(
    PrintCompositor::Status* out_status) {
  base::RunLoop loop;
  proxy_->PrepareForDocumentToPdf(
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintCompositor::Status* out_status
,
             PrintCompositor::Status status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void PrintCompositorAsyncWaiter::CompleteDocumentToPdf(
    uint32_t pages_count, PrintCompositor::Status* out_status, ::base::ReadOnlySharedMemoryRegion* out_pdf_region) {
  base::RunLoop loop;
  proxy_->CompleteDocumentToPdf(std::move(pages_count),
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintCompositor::Status* out_status
,
             ::base::ReadOnlySharedMemoryRegion* out_pdf_region
,
             PrintCompositor::Status status,
             ::base::ReadOnlySharedMemoryRegion pdf_region) {*out_status = std::move(status);*out_pdf_region = std::move(pdf_region);
            loop->Quit();
          },
          &loop,
          out_status,
          out_pdf_region));
  loop.Run();
}





}  // namespace mojom
}  // namespace printing

#if defined(__clang__)
#pragma clang diagnostic pop
#endif