// components/services/print_compositor/public/mojom/print_compositor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/print_compositor/public/mojom/print_compositor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/services/print_compositor/public/mojom/print_compositor.mojom-params-data.h"
#include "components/services/print_compositor/public/mojom/print_compositor.mojom-shared-message-ids.h"

#include "components/services/print_compositor/public/mojom/print_compositor.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_PRINT_COMPOSITOR_PUBLIC_MOJOM_PRINT_COMPOSITOR_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_PRINT_COMPOSITOR_PUBLIC_MOJOM_PRINT_COMPOSITOR_MOJOM_JUMBO_H_
#endif
namespace printing {
namespace mojom {
const char PrintCompositor::Name_[] = "printing.mojom.PrintCompositor";

class PrintCompositor_CompositePageToPdf_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintCompositor_CompositePageToPdf_ForwardToCallback(
      PrintCompositor::CompositePageToPdfCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PrintCompositor::CompositePageToPdfCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PrintCompositor_CompositePageToPdf_ForwardToCallback);
};

class PrintCompositor_CompositeDocumentToPdf_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintCompositor_CompositeDocumentToPdf_ForwardToCallback(
      PrintCompositor::CompositeDocumentToPdfCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PrintCompositor::CompositeDocumentToPdfCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PrintCompositor_CompositeDocumentToPdf_ForwardToCallback);
};

class PrintCompositor_PrepareForDocumentToPdf_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintCompositor_PrepareForDocumentToPdf_ForwardToCallback(
      PrintCompositor::PrepareForDocumentToPdfCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PrintCompositor::PrepareForDocumentToPdfCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PrintCompositor_PrepareForDocumentToPdf_ForwardToCallback);
};

class PrintCompositor_CompleteDocumentToPdf_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintCompositor_CompleteDocumentToPdf_ForwardToCallback(
      PrintCompositor::CompleteDocumentToPdfCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PrintCompositor::CompleteDocumentToPdfCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PrintCompositor_CompleteDocumentToPdf_ForwardToCallback);
};

PrintCompositorProxy::PrintCompositorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrintCompositorProxy::SetDiscardableSharedMemoryManager(
    ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> in_manager) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintCompositor::SetDiscardableSharedMemoryManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("manager"), in_manager, 
                        "<value of type ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_SetDiscardableSharedMemoryManager_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_SetDiscardableSharedMemoryManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::discardable_memory::mojom::DiscardableSharedMemoryManagerInterfaceBase>>(
      in_manager, &params->manager, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->manager),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid manager in PrintCompositor.SetDiscardableSharedMemoryManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("SetDiscardableSharedMemoryManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintCompositorProxy::NotifyUnavailableSubframe(
    uint64_t in_frame_guid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintCompositor::NotifyUnavailableSubframe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_guid"), in_frame_guid, 
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_NotifyUnavailableSubframe_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_NotifyUnavailableSubframe_Params_Data> params(
          message);
  params.Allocate();
  params->frame_guid = in_frame_guid;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("NotifyUnavailableSubframe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintCompositorProxy::AddSubframeContent(
    uint64_t in_frame_guid, ::base::ReadOnlySharedMemoryRegion in_serialized_content, const base::flat_map<uint32_t, uint64_t>& in_subframe_content_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintCompositor::AddSubframeContent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_guid"), in_frame_guid, 
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serialized_content"), in_serialized_content, 
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subframe_content_info"), in_subframe_content_info, 
                        "<value of type const base::flat_map<uint32_t, uint64_t>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_AddSubframeContent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_AddSubframeContent_Params_Data> params(
          message);
  params.Allocate();
  params->frame_guid = in_frame_guid;
  mojo::internal::MessageFragment<
      typename decltype(params->serialized_content)::BaseType> serialized_content_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_serialized_content, serialized_content_fragment);
  params->serialized_content.Set(
      serialized_content_fragment.is_null() ? nullptr : serialized_content_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->serialized_content.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null serialized_content in PrintCompositor.AddSubframeContent request");
  mojo::internal::MessageFragment<
      typename decltype(params->subframe_content_info)::BaseType>
      subframe_content_info_fragment(params.message());
  const mojo::internal::ContainerValidateParams subframe_content_info_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<uint32_t, uint64_t>>(
      in_subframe_content_info, subframe_content_info_fragment, &subframe_content_info_validate_params);
  params->subframe_content_info.Set(
      subframe_content_info_fragment.is_null() ? nullptr : subframe_content_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->subframe_content_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subframe_content_info in PrintCompositor.AddSubframeContent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("AddSubframeContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintCompositorProxy::SetAccessibilityTree(
    const ::ui::AXTreeUpdate& in_accessibility_tree) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintCompositor::SetAccessibilityTree", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("accessibility_tree"), in_accessibility_tree, 
                        "<value of type const ::ui::AXTreeUpdate&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_SetAccessibilityTree_Name, kFlags, 0, 0,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_SetAccessibilityTree_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->accessibility_tree)::BaseType> accessibility_tree_fragment(
          params.message());
  mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView>(
      in_accessibility_tree, accessibility_tree_fragment);
  params->accessibility_tree.Set(
      accessibility_tree_fragment.is_null() ? nullptr : accessibility_tree_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->accessibility_tree.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accessibility_tree in PrintCompositor.SetAccessibilityTree request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("SetAccessibilityTree");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintCompositorProxy::CompositePageToPdf(
    uint64_t in_frame_guid, ::base::ReadOnlySharedMemoryRegion in_sk_region, const base::flat_map<uint32_t, uint64_t>& in_subframe_content_info, CompositePageToPdfCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintCompositor::CompositePageToPdf", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_guid"), in_frame_guid, 
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sk_region"), in_sk_region, 
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subframe_content_info"), in_subframe_content_info, 
                        "<value of type const base::flat_map<uint32_t, uint64_t>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_CompositePageToPdf_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_CompositePageToPdf_Params_Data> params(
          message);
  params.Allocate();
  params->frame_guid = in_frame_guid;
  mojo::internal::MessageFragment<
      typename decltype(params->sk_region)::BaseType> sk_region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_sk_region, sk_region_fragment);
  params->sk_region.Set(
      sk_region_fragment.is_null() ? nullptr : sk_region_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sk_region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sk_region in PrintCompositor.CompositePageToPdf request");
  mojo::internal::MessageFragment<
      typename decltype(params->subframe_content_info)::BaseType>
      subframe_content_info_fragment(params.message());
  const mojo::internal::ContainerValidateParams subframe_content_info_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<uint32_t, uint64_t>>(
      in_subframe_content_info, subframe_content_info_fragment, &subframe_content_info_validate_params);
  params->subframe_content_info.Set(
      subframe_content_info_fragment.is_null() ? nullptr : subframe_content_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->subframe_content_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subframe_content_info in PrintCompositor.CompositePageToPdf request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("CompositePageToPdf");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintCompositor_CompositePageToPdf_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PrintCompositorProxy::CompositeDocumentToPdf(
    uint64_t in_frame_guid, ::base::ReadOnlySharedMemoryRegion in_sk_region, const base::flat_map<uint32_t, uint64_t>& in_subframe_content_info, CompositeDocumentToPdfCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintCompositor::CompositeDocumentToPdf", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_guid"), in_frame_guid, 
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sk_region"), in_sk_region, 
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subframe_content_info"), in_subframe_content_info, 
                        "<value of type const base::flat_map<uint32_t, uint64_t>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_CompositeDocumentToPdf_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_CompositeDocumentToPdf_Params_Data> params(
          message);
  params.Allocate();
  params->frame_guid = in_frame_guid;
  mojo::internal::MessageFragment<
      typename decltype(params->sk_region)::BaseType> sk_region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_sk_region, sk_region_fragment);
  params->sk_region.Set(
      sk_region_fragment.is_null() ? nullptr : sk_region_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sk_region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sk_region in PrintCompositor.CompositeDocumentToPdf request");
  mojo::internal::MessageFragment<
      typename decltype(params->subframe_content_info)::BaseType>
      subframe_content_info_fragment(params.message());
  const mojo::internal::ContainerValidateParams subframe_content_info_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<uint32_t, uint64_t>>(
      in_subframe_content_info, subframe_content_info_fragment, &subframe_content_info_validate_params);
  params->subframe_content_info.Set(
      subframe_content_info_fragment.is_null() ? nullptr : subframe_content_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->subframe_content_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subframe_content_info in PrintCompositor.CompositeDocumentToPdf request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("CompositeDocumentToPdf");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintCompositor_CompositeDocumentToPdf_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PrintCompositorProxy::PrepareForDocumentToPdf(
    PrepareForDocumentToPdfCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "printing::mojom::PrintCompositor::PrepareForDocumentToPdf");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_PrepareForDocumentToPdf_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_PrepareForDocumentToPdf_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("PrepareForDocumentToPdf");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintCompositor_PrepareForDocumentToPdf_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PrintCompositorProxy::CompleteDocumentToPdf(
    uint32_t in_pages_count, CompleteDocumentToPdfCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintCompositor::CompleteDocumentToPdf", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pages_count"), in_pages_count, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_CompleteDocumentToPdf_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_CompleteDocumentToPdf_Params_Data> params(
          message);
  params.Allocate();
  params->pages_count = in_pages_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("CompleteDocumentToPdf");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintCompositor_CompleteDocumentToPdf_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PrintCompositorProxy::SetWebContentsURL(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintCompositor::SetWebContentsURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_SetWebContentsURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_SetWebContentsURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PrintCompositor.SetWebContentsURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("SetWebContentsURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrintCompositorProxy::SetUserAgent(
    const std::string& in_user_agent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "printing::mojom::PrintCompositor::SetUserAgent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_agent"), in_user_agent, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_SetUserAgent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_SetUserAgent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->user_agent)::BaseType> user_agent_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_user_agent, user_agent_fragment);
  params->user_agent.Set(
      user_agent_fragment.is_null() ? nullptr : user_agent_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->user_agent.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_agent in PrintCompositor.SetUserAgent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("SetUserAgent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class PrintCompositor_CompositePageToPdf_ProxyToResponder {
 public:
  static PrintCompositor::CompositePageToPdfCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PrintCompositor_CompositePageToPdf_ProxyToResponder> proxy(
        new PrintCompositor_CompositePageToPdf_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PrintCompositor_CompositePageToPdf_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintCompositor_CompositePageToPdf_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PrintCompositor_CompositePageToPdf_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintCompositor::CompositePageToPdfCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintCompositor::Status in_status, ::base::ReadOnlySharedMemoryRegion in_pdf_region);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PrintCompositor_CompositePageToPdf_ProxyToResponder);
};

bool PrintCompositor_CompositePageToPdf_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "printing::mojom::PrintCompositor::CompositePageToPdfCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PrintCompositor_CompositePageToPdf_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintCompositor_CompositePageToPdf_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PrintCompositor::Status p_status{};
  ::base::ReadOnlySharedMemoryRegion p_pdf_region{};
  PrintCompositor_CompositePageToPdf_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadPdfRegion(&p_pdf_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintCompositor::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_pdf_region));
  return true;
}

void PrintCompositor_CompositePageToPdf_ProxyToResponder::Run(
    PrintCompositor::Status in_status, ::base::ReadOnlySharedMemoryRegion in_pdf_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)printing::mojom::PrintCompositor::CompositePageToPdfCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type PrintCompositor::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pdf_region"), in_pdf_region, 
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_CompositePageToPdf_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_CompositePageToPdf_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::printing::mojom::PrintCompositor_Status>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->pdf_region)::BaseType> pdf_region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_pdf_region, pdf_region_fragment);
  params->pdf_region.Set(
      pdf_region_fragment.is_null() ? nullptr : pdf_region_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)printing::mojom::PrintCompositor::CompositePageToPdfCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("CompositePageToPdf");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintCompositor_CompositeDocumentToPdf_ProxyToResponder {
 public:
  static PrintCompositor::CompositeDocumentToPdfCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PrintCompositor_CompositeDocumentToPdf_ProxyToResponder> proxy(
        new PrintCompositor_CompositeDocumentToPdf_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PrintCompositor_CompositeDocumentToPdf_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintCompositor_CompositeDocumentToPdf_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PrintCompositor_CompositeDocumentToPdf_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintCompositor::CompositeDocumentToPdfCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintCompositor::Status in_status, ::base::ReadOnlySharedMemoryRegion in_pdf_region);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PrintCompositor_CompositeDocumentToPdf_ProxyToResponder);
};

bool PrintCompositor_CompositeDocumentToPdf_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "printing::mojom::PrintCompositor::CompositeDocumentToPdfCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PrintCompositor_CompositeDocumentToPdf_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintCompositor_CompositeDocumentToPdf_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PrintCompositor::Status p_status{};
  ::base::ReadOnlySharedMemoryRegion p_pdf_region{};
  PrintCompositor_CompositeDocumentToPdf_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadPdfRegion(&p_pdf_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintCompositor::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_pdf_region));
  return true;
}

void PrintCompositor_CompositeDocumentToPdf_ProxyToResponder::Run(
    PrintCompositor::Status in_status, ::base::ReadOnlySharedMemoryRegion in_pdf_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)printing::mojom::PrintCompositor::CompositeDocumentToPdfCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type PrintCompositor::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pdf_region"), in_pdf_region, 
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_CompositeDocumentToPdf_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_CompositeDocumentToPdf_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::printing::mojom::PrintCompositor_Status>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->pdf_region)::BaseType> pdf_region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_pdf_region, pdf_region_fragment);
  params->pdf_region.Set(
      pdf_region_fragment.is_null() ? nullptr : pdf_region_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)printing::mojom::PrintCompositor::CompositeDocumentToPdfCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("CompositeDocumentToPdf");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintCompositor_PrepareForDocumentToPdf_ProxyToResponder {
 public:
  static PrintCompositor::PrepareForDocumentToPdfCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PrintCompositor_PrepareForDocumentToPdf_ProxyToResponder> proxy(
        new PrintCompositor_PrepareForDocumentToPdf_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PrintCompositor_PrepareForDocumentToPdf_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintCompositor_PrepareForDocumentToPdf_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PrintCompositor_PrepareForDocumentToPdf_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintCompositor::PrepareForDocumentToPdfCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintCompositor::Status in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PrintCompositor_PrepareForDocumentToPdf_ProxyToResponder);
};

bool PrintCompositor_PrepareForDocumentToPdf_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "printing::mojom::PrintCompositor::PrepareForDocumentToPdfCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PrintCompositor_PrepareForDocumentToPdf_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintCompositor_PrepareForDocumentToPdf_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PrintCompositor::Status p_status{};
  PrintCompositor_PrepareForDocumentToPdf_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintCompositor::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void PrintCompositor_PrepareForDocumentToPdf_ProxyToResponder::Run(
    PrintCompositor::Status in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)printing::mojom::PrintCompositor::PrepareForDocumentToPdfCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type PrintCompositor::Status>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_PrepareForDocumentToPdf_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_PrepareForDocumentToPdf_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::printing::mojom::PrintCompositor_Status>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)printing::mojom::PrintCompositor::PrepareForDocumentToPdfCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("PrepareForDocumentToPdf");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintCompositor_CompleteDocumentToPdf_ProxyToResponder {
 public:
  static PrintCompositor::CompleteDocumentToPdfCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PrintCompositor_CompleteDocumentToPdf_ProxyToResponder> proxy(
        new PrintCompositor_CompleteDocumentToPdf_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PrintCompositor_CompleteDocumentToPdf_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintCompositor_CompleteDocumentToPdf_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PrintCompositor_CompleteDocumentToPdf_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintCompositor::CompleteDocumentToPdfCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintCompositor::Status in_status, ::base::ReadOnlySharedMemoryRegion in_pdf_region);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PrintCompositor_CompleteDocumentToPdf_ProxyToResponder);
};

bool PrintCompositor_CompleteDocumentToPdf_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "printing::mojom::PrintCompositor::CompleteDocumentToPdfCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PrintCompositor_CompleteDocumentToPdf_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintCompositor_CompleteDocumentToPdf_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PrintCompositor::Status p_status{};
  ::base::ReadOnlySharedMemoryRegion p_pdf_region{};
  PrintCompositor_CompleteDocumentToPdf_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadPdfRegion(&p_pdf_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintCompositor::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_pdf_region));
  return true;
}

void PrintCompositor_CompleteDocumentToPdf_ProxyToResponder::Run(
    PrintCompositor::Status in_status, ::base::ReadOnlySharedMemoryRegion in_pdf_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)printing::mojom::PrintCompositor::CompleteDocumentToPdfCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type PrintCompositor::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pdf_region"), in_pdf_region, 
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrintCompositor_CompleteDocumentToPdf_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintCompositor_CompleteDocumentToPdf_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::printing::mojom::PrintCompositor_Status>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->pdf_region)::BaseType> pdf_region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_pdf_region, pdf_region_fragment);
  params->pdf_region.Set(
      pdf_region_fragment.is_null() ? nullptr : pdf_region_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)printing::mojom::PrintCompositor::CompleteDocumentToPdfCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintCompositor::Name_);
  message.set_method_name("CompleteDocumentToPdf");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PrintCompositorStubDispatch::Accept(
    PrintCompositor* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPrintCompositor_SetDiscardableSharedMemoryManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintCompositor::SetDiscardableSharedMemoryManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintCompositor::SetDiscardableSharedMemoryManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintCompositor_SetDiscardableSharedMemoryManager_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_SetDiscardableSharedMemoryManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> p_manager{};
      PrintCompositor_SetDiscardableSharedMemoryManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_manager =
            input_data_view.TakeManager<decltype(p_manager)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDiscardableSharedMemoryManager(
std::move(p_manager));
      return true;
    }
    case internal::kPrintCompositor_NotifyUnavailableSubframe_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintCompositor::NotifyUnavailableSubframe",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintCompositor::NotifyUnavailableSubframe");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintCompositor_NotifyUnavailableSubframe_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_NotifyUnavailableSubframe_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_frame_guid{};
      PrintCompositor_NotifyUnavailableSubframe_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_guid = input_data_view.frame_guid();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyUnavailableSubframe(
std::move(p_frame_guid));
      return true;
    }
    case internal::kPrintCompositor_AddSubframeContent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintCompositor::AddSubframeContent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintCompositor::AddSubframeContent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintCompositor_AddSubframeContent_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_AddSubframeContent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_frame_guid{};
      ::base::ReadOnlySharedMemoryRegion p_serialized_content{};
      base::flat_map<uint32_t, uint64_t> p_subframe_content_info{};
      PrintCompositor_AddSubframeContent_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_guid = input_data_view.frame_guid();
      if (success && !input_data_view.ReadSerializedContent(&p_serialized_content))
        success = false;
      if (success && !input_data_view.ReadSubframeContentInfo(&p_subframe_content_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddSubframeContent(
std::move(p_frame_guid), 
std::move(p_serialized_content), 
std::move(p_subframe_content_info));
      return true;
    }
    case internal::kPrintCompositor_SetAccessibilityTree_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintCompositor::SetAccessibilityTree",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintCompositor::SetAccessibilityTree");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintCompositor_SetAccessibilityTree_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_SetAccessibilityTree_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::ui::AXTreeUpdate p_accessibility_tree{};
      PrintCompositor_SetAccessibilityTree_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAccessibilityTree(&p_accessibility_tree))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAccessibilityTree(
std::move(p_accessibility_tree));
      return true;
    }
    case internal::kPrintCompositor_CompositePageToPdf_Name: {
      break;
    }
    case internal::kPrintCompositor_CompositeDocumentToPdf_Name: {
      break;
    }
    case internal::kPrintCompositor_PrepareForDocumentToPdf_Name: {
      break;
    }
    case internal::kPrintCompositor_CompleteDocumentToPdf_Name: {
      break;
    }
    case internal::kPrintCompositor_SetWebContentsURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintCompositor::SetWebContentsURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintCompositor::SetWebContentsURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintCompositor_SetWebContentsURL_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_SetWebContentsURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      PrintCompositor_SetWebContentsURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWebContentsURL(
std::move(p_url));
      return true;
    }
    case internal::kPrintCompositor_SetUserAgent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintCompositor::SetUserAgent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintCompositor::SetUserAgent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrintCompositor_SetUserAgent_Params_Data* params =
          reinterpret_cast<internal::PrintCompositor_SetUserAgent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_user_agent{};
      PrintCompositor_SetUserAgent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUserAgent(&p_user_agent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserAgent(
std::move(p_user_agent));
      return true;
    }
  }
  return false;
}

// static
bool PrintCompositorStubDispatch::AcceptWithResponder(
    PrintCompositor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPrintCompositor_SetDiscardableSharedMemoryManager_Name: {
      break;
    }
    case internal::kPrintCompositor_NotifyUnavailableSubframe_Name: {
      break;
    }
    case internal::kPrintCompositor_AddSubframeContent_Name: {
      break;
    }
    case internal::kPrintCompositor_SetAccessibilityTree_Name: {
      break;
    }
    case internal::kPrintCompositor_CompositePageToPdf_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintCompositor::CompositePageToPdf",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintCompositor::CompositePageToPdf");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PrintCompositor_CompositePageToPdf_Params_Data* params =
          reinterpret_cast<
              internal::PrintCompositor_CompositePageToPdf_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_frame_guid{};
      ::base::ReadOnlySharedMemoryRegion p_sk_region{};
      base::flat_map<uint32_t, uint64_t> p_subframe_content_info{};
      PrintCompositor_CompositePageToPdf_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_guid = input_data_view.frame_guid();
      if (success && !input_data_view.ReadSkRegion(&p_sk_region))
        success = false;
      if (success && !input_data_view.ReadSubframeContentInfo(&p_subframe_content_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 4, false);
        return false;
      }
      PrintCompositor::CompositePageToPdfCallback callback =
          PrintCompositor_CompositePageToPdf_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CompositePageToPdf(
std::move(p_frame_guid), 
std::move(p_sk_region), 
std::move(p_subframe_content_info), std::move(callback));
      return true;
    }
    case internal::kPrintCompositor_CompositeDocumentToPdf_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintCompositor::CompositeDocumentToPdf",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintCompositor::CompositeDocumentToPdf");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PrintCompositor_CompositeDocumentToPdf_Params_Data* params =
          reinterpret_cast<
              internal::PrintCompositor_CompositeDocumentToPdf_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_frame_guid{};
      ::base::ReadOnlySharedMemoryRegion p_sk_region{};
      base::flat_map<uint32_t, uint64_t> p_subframe_content_info{};
      PrintCompositor_CompositeDocumentToPdf_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_guid = input_data_view.frame_guid();
      if (success && !input_data_view.ReadSkRegion(&p_sk_region))
        success = false;
      if (success && !input_data_view.ReadSubframeContentInfo(&p_subframe_content_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 5, false);
        return false;
      }
      PrintCompositor::CompositeDocumentToPdfCallback callback =
          PrintCompositor_CompositeDocumentToPdf_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CompositeDocumentToPdf(
std::move(p_frame_guid), 
std::move(p_sk_region), 
std::move(p_subframe_content_info), std::move(callback));
      return true;
    }
    case internal::kPrintCompositor_PrepareForDocumentToPdf_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintCompositor::PrepareForDocumentToPdf",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintCompositor::PrepareForDocumentToPdf");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PrintCompositor_PrepareForDocumentToPdf_Params_Data* params =
          reinterpret_cast<
              internal::PrintCompositor_PrepareForDocumentToPdf_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PrintCompositor_PrepareForDocumentToPdf_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 6, false);
        return false;
      }
      PrintCompositor::PrepareForDocumentToPdfCallback callback =
          PrintCompositor_PrepareForDocumentToPdf_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrepareForDocumentToPdf(std::move(callback));
      return true;
    }
    case internal::kPrintCompositor_CompleteDocumentToPdf_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)printing::mojom::PrintCompositor::CompleteDocumentToPdf",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)printing::mojom::PrintCompositor::CompleteDocumentToPdf");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PrintCompositor_CompleteDocumentToPdf_Params_Data* params =
          reinterpret_cast<
              internal::PrintCompositor_CompleteDocumentToPdf_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_pages_count{};
      PrintCompositor_CompleteDocumentToPdf_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pages_count = input_data_view.pages_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintCompositor::Name_, 7, false);
        return false;
      }
      PrintCompositor::CompleteDocumentToPdfCallback callback =
          PrintCompositor_CompleteDocumentToPdf_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CompleteDocumentToPdf(
std::move(p_pages_count), std::move(callback));
      return true;
    }
    case internal::kPrintCompositor_SetWebContentsURL_Name: {
      break;
    }
    case internal::kPrintCompositor_SetUserAgent_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPrintCompositorValidationInfo[] = {
    {internal::kPrintCompositor_SetDiscardableSharedMemoryManager_Name,
     {&internal::PrintCompositor_SetDiscardableSharedMemoryManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintCompositor_NotifyUnavailableSubframe_Name,
     {&internal::PrintCompositor_NotifyUnavailableSubframe_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintCompositor_AddSubframeContent_Name,
     {&internal::PrintCompositor_AddSubframeContent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintCompositor_SetAccessibilityTree_Name,
     {&internal::PrintCompositor_SetAccessibilityTree_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintCompositor_CompositePageToPdf_Name,
     {&internal::PrintCompositor_CompositePageToPdf_Params_Data::Validate,
      &internal::PrintCompositor_CompositePageToPdf_ResponseParams_Data::Validate}},
    {internal::kPrintCompositor_CompositeDocumentToPdf_Name,
     {&internal::PrintCompositor_CompositeDocumentToPdf_Params_Data::Validate,
      &internal::PrintCompositor_CompositeDocumentToPdf_ResponseParams_Data::Validate}},
    {internal::kPrintCompositor_PrepareForDocumentToPdf_Name,
     {&internal::PrintCompositor_PrepareForDocumentToPdf_Params_Data::Validate,
      &internal::PrintCompositor_PrepareForDocumentToPdf_ResponseParams_Data::Validate}},
    {internal::kPrintCompositor_CompleteDocumentToPdf_Name,
     {&internal::PrintCompositor_CompleteDocumentToPdf_Params_Data::Validate,
      &internal::PrintCompositor_CompleteDocumentToPdf_ResponseParams_Data::Validate}},
    {internal::kPrintCompositor_SetWebContentsURL_Name,
     {&internal::PrintCompositor_SetWebContentsURL_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPrintCompositor_SetUserAgent_Name,
     {&internal::PrintCompositor_SetUserAgent_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PrintCompositorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintCompositor::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPrintCompositorValidationInfo);
}

bool PrintCompositorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintCompositor::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPrintCompositorValidationInfo);

}
}  // namespace mojom
}  // namespace printing

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif