// components/services/storage/public/mojom/blob_storage_context.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/services/storage/public/mojom/blob_storage_context.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/blob/blob.mojom.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_JUMBO_H_
#endif


namespace storage {
namespace mojom {


void BlobDataItemReaderInterceptorForTesting::Read(uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, ReadCallback callback) {
  GetForwardingInterface()->Read(std::move(offset), std::move(length), std::move(pipe), std::move(callback));
}
void BlobDataItemReaderInterceptorForTesting::ReadSideData(ReadSideDataCallback callback) {
  GetForwardingInterface()->ReadSideData(std::move(callback));
}
BlobDataItemReaderAsyncWaiter::BlobDataItemReaderAsyncWaiter(
    BlobDataItemReader* proxy) : proxy_(proxy) {}

BlobDataItemReaderAsyncWaiter::~BlobDataItemReaderAsyncWaiter() = default;

void BlobDataItemReaderAsyncWaiter::Read(
    uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, int32_t* out_success) {
  base::RunLoop loop;
  proxy_->Read(std::move(offset),std::move(length),std::move(pipe),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_success
,
             int32_t success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void BlobDataItemReaderAsyncWaiter::ReadSideData(
    int32_t* out_success, ::mojo_base::BigBuffer* out_data) {
  base::RunLoop loop;
  proxy_->ReadSideData(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_success
,
             ::mojo_base::BigBuffer* out_data
,
             int32_t success,
             ::mojo_base::BigBuffer data) {*out_success = std::move(success);*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_success,
          out_data));
  loop.Run();
}



void BlobStorageContextInterceptorForTesting::RegisterFromDataItem(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, BlobDataItemPtr item) {
  GetForwardingInterface()->RegisterFromDataItem(std::move(blob), std::move(uuid), std::move(item));
}
void BlobStorageContextInterceptorForTesting::RegisterFromMemory(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, ::mojo_base::BigBuffer data) {
  GetForwardingInterface()->RegisterFromMemory(std::move(blob), std::move(uuid), std::move(data));
}
void BlobStorageContextInterceptorForTesting::WriteBlobToFile(::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::base::FilePath& path, bool flush_on_write, base::Optional<::base::Time> last_modified, WriteBlobToFileCallback callback) {
  GetForwardingInterface()->WriteBlobToFile(std::move(blob), std::move(path), std::move(flush_on_write), std::move(last_modified), std::move(callback));
}
BlobStorageContextAsyncWaiter::BlobStorageContextAsyncWaiter(
    BlobStorageContext* proxy) : proxy_(proxy) {}

BlobStorageContextAsyncWaiter::~BlobStorageContextAsyncWaiter() = default;

void BlobStorageContextAsyncWaiter::WriteBlobToFile(
    ::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::base::FilePath& path, bool flush_on_write, base::Optional<::base::Time> last_modified, WriteBlobToFileResult* out_result) {
  base::RunLoop loop;
  proxy_->WriteBlobToFile(std::move(blob),std::move(path),std::move(flush_on_write),std::move(last_modified),
      base::BindOnce(
          [](base::RunLoop* loop,
             WriteBlobToFileResult* out_result
,
             WriteBlobToFileResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}





}  // namespace mojom
}  // namespace storage

#if defined(__clang__)
#pragma clang diagnostic pop
#endif