// components/services/storage/public/mojom/cache_storage_control.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/storage/public/mojom/cache_storage_control.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/cache_storage_control.mojom-params-data.h"
namespace storage {
namespace mojom {

std::string CacheStorageOwnerToString(CacheStorageOwner value) {
  switch(value) {
    case CacheStorageOwner::kCacheAPI:
      return "CacheStorageOwner::kCacheAPI";
    case CacheStorageOwner::kBackgroundFetch:
      return "CacheStorageOwner::kBackgroundFetch";
    default:
      return base::StringPrintf("Unknown CacheStorageOwner value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CacheStorageOwner value) {
  return os << CacheStorageOwnerToString(value);
}

namespace internal {


// static
bool CacheStorageObserver_OnCacheListChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageObserver_OnCacheListChanged_Params_Data* object = static_cast<const CacheStorageObserver_OnCacheListChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

CacheStorageObserver_OnCacheListChanged_Params_Data::CacheStorageObserver_OnCacheListChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageObserver_OnCacheContentChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageObserver_OnCacheContentChanged_Params_Data* object = static_cast<const CacheStorageObserver_OnCacheContentChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cache_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cache_name, validation_context,
                                         &cache_name_validate_params)) {
    return false;
  }

  return true;
}

CacheStorageObserver_OnCacheContentChanged_Params_Data::CacheStorageObserver_OnCacheContentChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageControl_AddReceiver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageControl_AddReceiver_Params_Data* object = static_cast<const CacheStorageControl_AddReceiver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->policy, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->coep_reporter,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;


  if (!::storage::mojom::internal::CacheStorageOwner_Data
        ::Validate(object->owner, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CacheStorageControl_AddReceiver_Params_Data::CacheStorageControl_AddReceiver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageControl_DeleteForOrigin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageControl_DeleteForOrigin_Params_Data* object = static_cast<const CacheStorageControl_DeleteForOrigin_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

CacheStorageControl_DeleteForOrigin_Params_Data::CacheStorageControl_DeleteForOrigin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageControl_GetAllOriginsInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageControl_GetAllOriginsInfo_Params_Data* object = static_cast<const CacheStorageControl_GetAllOriginsInfo_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CacheStorageControl_GetAllOriginsInfo_Params_Data::CacheStorageControl_GetAllOriginsInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageControl_GetAllOriginsInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageControl_GetAllOriginsInfo_ResponseParams_Data* object = static_cast<const CacheStorageControl_GetAllOriginsInfo_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->usage_info, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams usage_info_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->usage_info, validation_context,
                                         &usage_info_validate_params)) {
    return false;
  }

  return true;
}

CacheStorageControl_GetAllOriginsInfo_ResponseParams_Data::CacheStorageControl_GetAllOriginsInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageControl_AddObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageControl_AddObserver_Params_Data* object = static_cast<const CacheStorageControl_AddObserver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CacheStorageControl_AddObserver_Params_Data::CacheStorageControl_AddObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageControl_ApplyPolicyUpdates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageControl_ApplyPolicyUpdates_Params_Data* object = static_cast<const CacheStorageControl_ApplyPolicyUpdates_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_updates, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams policy_updates_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->policy_updates, validation_context,
                                         &policy_updates_validate_params)) {
    return false;
  }

  return true;
}

CacheStorageControl_ApplyPolicyUpdates_Params_Data::CacheStorageControl_ApplyPolicyUpdates_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace storage

namespace perfetto {

// static
void TraceFormatTraits<::storage::mojom::CacheStorageOwner>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::storage::mojom::CacheStorageOwner value) {
  return std::move(context).WriteString(::storage::mojom::CacheStorageOwnerToString(value));
}

} // namespace perfetto
