// components/services/storage/public/mojom/cache_storage_control.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/services/storage/public/mojom/cache_storage_control.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "components/services/storage/public/mojom/storage_policy_update.mojom.h"
#include "components/services/storage/public/mojom/storage_usage_info.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom.h"
#include "url/mojom/origin.mojom.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_CACHE_STORAGE_CONTROL_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_CACHE_STORAGE_CONTROL_MOJOM_JUMBO_H_
#endif


namespace storage {
namespace mojom {


void CacheStorageObserverInterceptorForTesting::OnCacheListChanged(const ::url::Origin& origin) {
  GetForwardingInterface()->OnCacheListChanged(std::move(origin));
}
void CacheStorageObserverInterceptorForTesting::OnCacheContentChanged(const ::url::Origin& origin, const std::string& cache_name) {
  GetForwardingInterface()->OnCacheContentChanged(std::move(origin), std::move(cache_name));
}
CacheStorageObserverAsyncWaiter::CacheStorageObserverAsyncWaiter(
    CacheStorageObserver* proxy) : proxy_(proxy) {}

CacheStorageObserverAsyncWaiter::~CacheStorageObserverAsyncWaiter() = default;




void CacheStorageControlInterceptorForTesting::AddReceiver(const ::network::CrossOriginEmbedderPolicy& policy, ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter, const ::url::Origin& origin, CacheStorageOwner owner, ::mojo::PendingReceiver<::blink::mojom::CacheStorage> receiver) {
  GetForwardingInterface()->AddReceiver(std::move(policy), std::move(coep_reporter), std::move(origin), std::move(owner), std::move(receiver));
}
void CacheStorageControlInterceptorForTesting::DeleteForOrigin(const ::url::Origin& origin) {
  GetForwardingInterface()->DeleteForOrigin(std::move(origin));
}
void CacheStorageControlInterceptorForTesting::GetAllOriginsInfo(GetAllOriginsInfoCallback callback) {
  GetForwardingInterface()->GetAllOriginsInfo(std::move(callback));
}
void CacheStorageControlInterceptorForTesting::AddObserver(::mojo::PendingRemote<CacheStorageObserver> observer) {
  GetForwardingInterface()->AddObserver(std::move(observer));
}
void CacheStorageControlInterceptorForTesting::ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates) {
  GetForwardingInterface()->ApplyPolicyUpdates(std::move(policy_updates));
}
CacheStorageControlAsyncWaiter::CacheStorageControlAsyncWaiter(
    CacheStorageControl* proxy) : proxy_(proxy) {}

CacheStorageControlAsyncWaiter::~CacheStorageControlAsyncWaiter() = default;

void CacheStorageControlAsyncWaiter::GetAllOriginsInfo(
    std::vector<::storage::mojom::StorageUsageInfoPtr>* out_usage_info) {
  base::RunLoop loop;
  proxy_->GetAllOriginsInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::storage::mojom::StorageUsageInfoPtr>* out_usage_info
,
             std::vector<::storage::mojom::StorageUsageInfoPtr> usage_info) {*out_usage_info = std::move(usage_info);
            loop->Quit();
          },
          &loop,
          out_usage_info));
  loop.Run();
}





}  // namespace mojom
}  // namespace storage

#if defined(__clang__)
#pragma clang diagnostic pop
#endif