// components/services/storage/public/mojom/indexed_db_control.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/storage/public/mojom/indexed_db_control.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/indexed_db_control.mojom-params-data.h"
namespace storage {
namespace mojom {

std::string ForceCloseReasonToString(ForceCloseReason value) {
  switch(value) {
    case ForceCloseReason::FORCE_CLOSE_DELETE_ORIGIN:
      return "ForceCloseReason::FORCE_CLOSE_DELETE_ORIGIN";
    case ForceCloseReason::FORCE_CLOSE_BACKING_STORE_FAILURE:
      return "ForceCloseReason::FORCE_CLOSE_BACKING_STORE_FAILURE";
    case ForceCloseReason::FORCE_CLOSE_INTERNALS_PAGE:
      return "ForceCloseReason::FORCE_CLOSE_INTERNALS_PAGE";
    case ForceCloseReason::FORCE_CLOSE_COPY_ORIGIN:
      return "ForceCloseReason::FORCE_CLOSE_COPY_ORIGIN";
    case ForceCloseReason::FORCE_SCHEMA_DOWNGRADE_INTERNALS_PAGE:
      return "ForceCloseReason::FORCE_SCHEMA_DOWNGRADE_INTERNALS_PAGE";
    default:
      return base::StringPrintf("Unknown ForceCloseReason value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ForceCloseReason value) {
  return os << ForceCloseReasonToString(value);
}

namespace internal {


// static
bool IndexedDBObserver_OnIndexedDBListChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBObserver_OnIndexedDBListChanged_Params_Data* object = static_cast<const IndexedDBObserver_OnIndexedDBListChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

IndexedDBObserver_OnIndexedDBListChanged_Params_Data::IndexedDBObserver_OnIndexedDBListChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBObserver_OnIndexedDBContentChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBObserver_OnIndexedDBContentChanged_Params_Data* object = static_cast<const IndexedDBObserver_OnIndexedDBContentChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->database_name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->database_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->object_store_name, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->object_store_name, validation_context))
    return false;

  return true;
}

IndexedDBObserver_OnIndexedDBContentChanged_Params_Data::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_BindIndexedDB_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_BindIndexedDB_Params_Data* object = static_cast<const IndexedDBControl_BindIndexedDB_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IndexedDBControl_BindIndexedDB_Params_Data::IndexedDBControl_BindIndexedDB_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_GetUsage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_GetUsage_Params_Data* object = static_cast<const IndexedDBControl_GetUsage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControl_GetUsage_Params_Data::IndexedDBControl_GetUsage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_GetUsage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_GetUsage_ResponseParams_Data* object = static_cast<const IndexedDBControl_GetUsage_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams info_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->info, validation_context,
                                         &info_validate_params)) {
    return false;
  }

  return true;
}

IndexedDBControl_GetUsage_ResponseParams_Data::IndexedDBControl_GetUsage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_DeleteForOrigin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_DeleteForOrigin_Params_Data* object = static_cast<const IndexedDBControl_DeleteForOrigin_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

IndexedDBControl_DeleteForOrigin_Params_Data::IndexedDBControl_DeleteForOrigin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_DeleteForOrigin_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_DeleteForOrigin_ResponseParams_Data* object = static_cast<const IndexedDBControl_DeleteForOrigin_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControl_DeleteForOrigin_ResponseParams_Data::IndexedDBControl_DeleteForOrigin_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_ForceClose_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_ForceClose_Params_Data* object = static_cast<const IndexedDBControl_ForceClose_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;


  if (!::storage::mojom::internal::ForceCloseReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

IndexedDBControl_ForceClose_Params_Data::IndexedDBControl_ForceClose_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_ForceClose_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_ForceClose_ResponseParams_Data* object = static_cast<const IndexedDBControl_ForceClose_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControl_ForceClose_ResponseParams_Data::IndexedDBControl_ForceClose_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_GetConnectionCount_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_GetConnectionCount_Params_Data* object = static_cast<const IndexedDBControl_GetConnectionCount_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

IndexedDBControl_GetConnectionCount_Params_Data::IndexedDBControl_GetConnectionCount_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_GetConnectionCount_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_GetConnectionCount_ResponseParams_Data* object = static_cast<const IndexedDBControl_GetConnectionCount_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControl_GetConnectionCount_ResponseParams_Data::IndexedDBControl_GetConnectionCount_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_DownloadOriginData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_DownloadOriginData_Params_Data* object = static_cast<const IndexedDBControl_DownloadOriginData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

IndexedDBControl_DownloadOriginData_Params_Data::IndexedDBControl_DownloadOriginData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_DownloadOriginData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_DownloadOriginData_ResponseParams_Data* object = static_cast<const IndexedDBControl_DownloadOriginData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->temp_path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->temp_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->zip_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->zip_path, validation_context))
    return false;

  return true;
}

IndexedDBControl_DownloadOriginData_ResponseParams_Data::IndexedDBControl_DownloadOriginData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_GetAllOriginsDetails_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_GetAllOriginsDetails_Params_Data* object = static_cast<const IndexedDBControl_GetAllOriginsDetails_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControl_GetAllOriginsDetails_Params_Data::IndexedDBControl_GetAllOriginsDetails_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_GetAllOriginsDetails_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_GetAllOriginsDetails_ResponseParams_Data* object = static_cast<const IndexedDBControl_GetAllOriginsDetails_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  return true;
}

IndexedDBControl_GetAllOriginsDetails_ResponseParams_Data::IndexedDBControl_GetAllOriginsDetails_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_SetForceKeepSessionState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_SetForceKeepSessionState_Params_Data* object = static_cast<const IndexedDBControl_SetForceKeepSessionState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControl_SetForceKeepSessionState_Params_Data::IndexedDBControl_SetForceKeepSessionState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_AddObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_AddObserver_Params_Data* object = static_cast<const IndexedDBControl_AddObserver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IndexedDBControl_AddObserver_Params_Data::IndexedDBControl_AddObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_ApplyPolicyUpdates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_ApplyPolicyUpdates_Params_Data* object = static_cast<const IndexedDBControl_ApplyPolicyUpdates_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_updates, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams policy_updates_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->policy_updates, validation_context,
                                         &policy_updates_validate_params)) {
    return false;
  }

  return true;
}

IndexedDBControl_ApplyPolicyUpdates_Params_Data::IndexedDBControl_ApplyPolicyUpdates_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControl_BindTestInterface_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControl_BindTestInterface_Params_Data* object = static_cast<const IndexedDBControl_BindTestInterface_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IndexedDBControl_BindTestInterface_Params_Data::IndexedDBControl_BindTestInterface_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace storage

namespace perfetto {

// static
void TraceFormatTraits<::storage::mojom::ForceCloseReason>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::storage::mojom::ForceCloseReason value) {
  return std::move(context).WriteString(::storage::mojom::ForceCloseReasonToString(value));
}

} // namespace perfetto
