// components/services/storage/public/mojom/indexed_db_control_test.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/storage/public/mojom/indexed_db_control_test.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/indexed_db_control_test.mojom-params-data.h"
namespace storage {
namespace mojom {

std::string V2SchemaCorruptionStatusToString(V2SchemaCorruptionStatus value) {
  switch(value) {
    case V2SchemaCorruptionStatus::CORRUPTION_UNKNOWN:
      return "V2SchemaCorruptionStatus::CORRUPTION_UNKNOWN";
    case V2SchemaCorruptionStatus::CORRUPTION_NO:
      return "V2SchemaCorruptionStatus::CORRUPTION_NO";
    case V2SchemaCorruptionStatus::CORRUPTION_YES:
      return "V2SchemaCorruptionStatus::CORRUPTION_YES";
    default:
      return base::StringPrintf("Unknown V2SchemaCorruptionStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, V2SchemaCorruptionStatus value) {
  return os << V2SchemaCorruptionStatusToString(value);
}

std::string FailClassToString(FailClass value) {
  switch(value) {
    case FailClass::NOTHING:
      return "FailClass::NOTHING";
    case FailClass::LEVELDB_ITERATOR:
      return "FailClass::LEVELDB_ITERATOR";
    case FailClass::LEVELDB_DIRECT_TRANSACTION:
      return "FailClass::LEVELDB_DIRECT_TRANSACTION";
    case FailClass::LEVELDB_TRANSACTION:
      return "FailClass::LEVELDB_TRANSACTION";
    case FailClass::LEVELDB_DATABASE:
      return "FailClass::LEVELDB_DATABASE";
    default:
      return base::StringPrintf("Unknown FailClass value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FailClass value) {
  return os << FailClassToString(value);
}

std::string FailMethodToString(FailMethod value) {
  switch(value) {
    case FailMethod::NOTHING:
      return "FailMethod::NOTHING";
    case FailMethod::COMMIT:
      return "FailMethod::COMMIT";
    case FailMethod::COMMIT_DISK_FULL:
      return "FailMethod::COMMIT_DISK_FULL";
    case FailMethod::GET:
      return "FailMethod::GET";
    case FailMethod::SEEK:
      return "FailMethod::SEEK";
    case FailMethod::WRITE:
      return "FailMethod::WRITE";
    default:
      return base::StringPrintf("Unknown FailMethod value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FailMethod value) {
  return os << FailMethodToString(value);
}

namespace internal {


// static
bool MockFailureInjector_FailOperation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MockFailureInjector_FailOperation_Params_Data* object = static_cast<const MockFailureInjector_FailOperation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::FailClass_Data
        ::Validate(object->failure_class, validation_context))
    return false;


  if (!::storage::mojom::internal::FailMethod_Data
        ::Validate(object->failure_method, validation_context))
    return false;

  return true;
}

MockFailureInjector_FailOperation_Params_Data::MockFailureInjector_FailOperation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MockFailureInjector_FailOperation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MockFailureInjector_FailOperation_ResponseParams_Data* object = static_cast<const MockFailureInjector_FailOperation_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MockFailureInjector_FailOperation_ResponseParams_Data::MockFailureInjector_FailOperation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data* object = static_cast<const IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data::IndexedDBControlTest_GetBaseDataPathForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data* object = static_cast<const IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data::IndexedDBControlTest_GetBaseDataPathForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_GetFilePathForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_GetFilePathForTesting_Params_Data* object = static_cast<const IndexedDBControlTest_GetFilePathForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

IndexedDBControlTest_GetFilePathForTesting_Params_Data::IndexedDBControlTest_GetFilePathForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data* object = static_cast<const IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data::IndexedDBControlTest_GetFilePathForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_ResetCachesForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_ResetCachesForTesting_Params_Data* object = static_cast<const IndexedDBControlTest_ResetCachesForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControlTest_ResetCachesForTesting_Params_Data::IndexedDBControlTest_ResetCachesForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data* object = static_cast<const IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data::IndexedDBControlTest_ResetCachesForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_ForceSchemaDowngradeForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_ForceSchemaDowngradeForTesting_Params_Data* object = static_cast<const IndexedDBControlTest_ForceSchemaDowngradeForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

IndexedDBControlTest_ForceSchemaDowngradeForTesting_Params_Data::IndexedDBControlTest_ForceSchemaDowngradeForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_ForceSchemaDowngradeForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_ForceSchemaDowngradeForTesting_ResponseParams_Data* object = static_cast<const IndexedDBControlTest_ForceSchemaDowngradeForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControlTest_ForceSchemaDowngradeForTesting_ResponseParams_Data::IndexedDBControlTest_ForceSchemaDowngradeForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_HasV2SchemaCorruptionForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_HasV2SchemaCorruptionForTesting_Params_Data* object = static_cast<const IndexedDBControlTest_HasV2SchemaCorruptionForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

IndexedDBControlTest_HasV2SchemaCorruptionForTesting_Params_Data::IndexedDBControlTest_HasV2SchemaCorruptionForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ResponseParams_Data* object = static_cast<const IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::storage::mojom::internal::V2SchemaCorruptionStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ResponseParams_Data::IndexedDBControlTest_HasV2SchemaCorruptionForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_WriteToIndexedDBForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_WriteToIndexedDBForTesting_Params_Data* object = static_cast<const IndexedDBControlTest_WriteToIndexedDBForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams key_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

IndexedDBControlTest_WriteToIndexedDBForTesting_Params_Data::IndexedDBControlTest_WriteToIndexedDBForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_WriteToIndexedDBForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_WriteToIndexedDBForTesting_ResponseParams_Data* object = static_cast<const IndexedDBControlTest_WriteToIndexedDBForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControlTest_WriteToIndexedDBForTesting_ResponseParams_Data::IndexedDBControlTest_WriteToIndexedDBForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_GetBlobCountForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_GetBlobCountForTesting_Params_Data* object = static_cast<const IndexedDBControlTest_GetBlobCountForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

IndexedDBControlTest_GetBlobCountForTesting_Params_Data::IndexedDBControlTest_GetBlobCountForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_GetBlobCountForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_GetBlobCountForTesting_ResponseParams_Data* object = static_cast<const IndexedDBControlTest_GetBlobCountForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControlTest_GetBlobCountForTesting_ResponseParams_Data::IndexedDBControlTest_GetBlobCountForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_GetNextBlobNumberForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_GetNextBlobNumberForTesting_Params_Data* object = static_cast<const IndexedDBControlTest_GetNextBlobNumberForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

IndexedDBControlTest_GetNextBlobNumberForTesting_Params_Data::IndexedDBControlTest_GetNextBlobNumberForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_GetNextBlobNumberForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_GetNextBlobNumberForTesting_ResponseParams_Data* object = static_cast<const IndexedDBControlTest_GetNextBlobNumberForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControlTest_GetNextBlobNumberForTesting_ResponseParams_Data::IndexedDBControlTest_GetNextBlobNumberForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_GetPathForBlobForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_GetPathForBlobForTesting_Params_Data* object = static_cast<const IndexedDBControlTest_GetPathForBlobForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

IndexedDBControlTest_GetPathForBlobForTesting_Params_Data::IndexedDBControlTest_GetPathForBlobForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data* object = static_cast<const IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data::IndexedDBControlTest_GetPathForBlobForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_CompactBackingStoreForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_CompactBackingStoreForTesting_Params_Data* object = static_cast<const IndexedDBControlTest_CompactBackingStoreForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

IndexedDBControlTest_CompactBackingStoreForTesting_Params_Data::IndexedDBControlTest_CompactBackingStoreForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_CompactBackingStoreForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_CompactBackingStoreForTesting_ResponseParams_Data* object = static_cast<const IndexedDBControlTest_CompactBackingStoreForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControlTest_CompactBackingStoreForTesting_ResponseParams_Data::IndexedDBControlTest_CompactBackingStoreForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data* object = static_cast<const IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data::IndexedDBControlTest_BindMockFailureSingletonForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_GetDatabaseKeysForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_GetDatabaseKeysForTesting_Params_Data* object = static_cast<const IndexedDBControlTest_GetDatabaseKeysForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IndexedDBControlTest_GetDatabaseKeysForTesting_Params_Data::IndexedDBControlTest_GetDatabaseKeysForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IndexedDBControlTest_GetDatabaseKeysForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IndexedDBControlTest_GetDatabaseKeysForTesting_ResponseParams_Data* object = static_cast<const IndexedDBControlTest_GetDatabaseKeysForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->schema_version_key, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams schema_version_key_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->schema_version_key, validation_context,
                                         &schema_version_key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_version_key, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_version_key_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data_version_key, validation_context,
                                         &data_version_key_validate_params)) {
    return false;
  }

  return true;
}

IndexedDBControlTest_GetDatabaseKeysForTesting_ResponseParams_Data::IndexedDBControlTest_GetDatabaseKeysForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace storage

namespace perfetto {

// static
void TraceFormatTraits<::storage::mojom::V2SchemaCorruptionStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::storage::mojom::V2SchemaCorruptionStatus value) {
  return std::move(context).WriteString(::storage::mojom::V2SchemaCorruptionStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::storage::mojom::FailClass>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::storage::mojom::FailClass value) {
  return std::move(context).WriteString(::storage::mojom::FailClassToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::storage::mojom::FailMethod>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::storage::mojom::FailMethod value) {
  return std::move(context).WriteString(::storage::mojom::FailMethodToString(value));
}

} // namespace perfetto
