// components/services/storage/public/mojom/local_storage_control.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/local_storage_control.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/services/storage/public/mojom/local_storage_control.mojom-params-data.h"
#include "components/services/storage/public/mojom/local_storage_control.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/local_storage_control.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_LOCAL_STORAGE_CONTROL_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_LOCAL_STORAGE_CONTROL_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
const char LocalStorageControl::Name_[] = "storage.mojom.LocalStorageControl";

class LocalStorageControl_GetUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalStorageControl_GetUsage_ForwardToCallback(
      LocalStorageControl::GetUsageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalStorageControl::GetUsageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalStorageControl_GetUsage_ForwardToCallback);
};

class LocalStorageControl_DeleteStorage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalStorageControl_DeleteStorage_ForwardToCallback(
      LocalStorageControl::DeleteStorageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalStorageControl::DeleteStorageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalStorageControl_DeleteStorage_ForwardToCallback);
};

class LocalStorageControl_CleanUpStorage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalStorageControl_CleanUpStorage_ForwardToCallback(
      LocalStorageControl::CleanUpStorageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalStorageControl::CleanUpStorageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalStorageControl_CleanUpStorage_ForwardToCallback);
};

class LocalStorageControl_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalStorageControl_Flush_ForwardToCallback(
      LocalStorageControl::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalStorageControl::FlushCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalStorageControl_Flush_ForwardToCallback);
};

LocalStorageControlProxy::LocalStorageControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalStorageControlProxy::BindStorageArea(
    const ::url::Origin& in_origin, ::mojo::PendingReceiver<::blink::mojom::StorageArea> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::LocalStorageControl::BindStorageArea", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::StorageArea>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalStorageControl_BindStorageArea_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_BindStorageArea_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in LocalStorageControl.BindStorageArea request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::StorageAreaInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in LocalStorageControl.BindStorageArea request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("BindStorageArea");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalStorageControlProxy::GetUsage(
    GetUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::LocalStorageControl::GetUsage");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalStorageControl_GetUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_GetUsage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("GetUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalStorageControl_GetUsage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalStorageControlProxy::DeleteStorage(
    const ::url::Origin& in_origin, DeleteStorageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::LocalStorageControl::DeleteStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::url::Origin&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalStorageControl_DeleteStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_DeleteStorage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in LocalStorageControl.DeleteStorage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("DeleteStorage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalStorageControl_DeleteStorage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalStorageControlProxy::CleanUpStorage(
    CleanUpStorageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::LocalStorageControl::CleanUpStorage");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalStorageControl_CleanUpStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_CleanUpStorage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("CleanUpStorage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalStorageControl_CleanUpStorage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalStorageControlProxy::Flush(
    FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::LocalStorageControl::Flush");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalStorageControl_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalStorageControl_Flush_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalStorageControlProxy::PurgeMemory(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::LocalStorageControl::PurgeMemory");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalStorageControl_PurgeMemory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_PurgeMemory_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("PurgeMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalStorageControlProxy::ApplyPolicyUpdates(
    std::vector<::storage::mojom::StoragePolicyUpdatePtr> in_policy_updates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::LocalStorageControl::ApplyPolicyUpdates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_updates"), in_policy_updates, 
                        "<value of type std::vector<::storage::mojom::StoragePolicyUpdatePtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalStorageControl_ApplyPolicyUpdates_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_ApplyPolicyUpdates_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->policy_updates)::BaseType>
      policy_updates_fragment(params.message());
  const mojo::internal::ContainerValidateParams policy_updates_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::StoragePolicyUpdateDataView>>(
      in_policy_updates, policy_updates_fragment, &policy_updates_validate_params);
  params->policy_updates.Set(
      policy_updates_fragment.is_null() ? nullptr : policy_updates_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_updates.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_updates in LocalStorageControl.ApplyPolicyUpdates request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("ApplyPolicyUpdates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalStorageControlProxy::ForceKeepSessionState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::LocalStorageControl::ForceKeepSessionState");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalStorageControl_ForceKeepSessionState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_ForceKeepSessionState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("ForceKeepSessionState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class LocalStorageControl_GetUsage_ProxyToResponder {
 public:
  static LocalStorageControl::GetUsageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalStorageControl_GetUsage_ProxyToResponder> proxy(
        new LocalStorageControl_GetUsage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalStorageControl_GetUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalStorageControl_GetUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalStorageControl_GetUsage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalStorageControl::GetUsageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::storage::mojom::StorageUsageInfoPtr> in_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalStorageControl_GetUsage_ProxyToResponder);
};

bool LocalStorageControl_GetUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::LocalStorageControl::GetUsageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalStorageControl_GetUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalStorageControl_GetUsage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::storage::mojom::StorageUsageInfoPtr> p_info{};
  LocalStorageControl_GetUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalStorageControl::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void LocalStorageControl_GetUsage_ProxyToResponder::Run(
    std::vector<::storage::mojom::StorageUsageInfoPtr> in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::LocalStorageControl::GetUsageCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info, 
                        "<value of type std::vector<::storage::mojom::StorageUsageInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalStorageControl_GetUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_GetUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType>
      info_fragment(params.message());
  const mojo::internal::ContainerValidateParams info_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::StorageUsageInfoDataView>>(
      in_info, info_fragment, &info_validate_params);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::LocalStorageControl::GetUsageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("GetUsage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalStorageControl_DeleteStorage_ProxyToResponder {
 public:
  static LocalStorageControl::DeleteStorageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalStorageControl_DeleteStorage_ProxyToResponder> proxy(
        new LocalStorageControl_DeleteStorage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalStorageControl_DeleteStorage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalStorageControl_DeleteStorage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalStorageControl_DeleteStorage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalStorageControl::DeleteStorageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalStorageControl_DeleteStorage_ProxyToResponder);
};

bool LocalStorageControl_DeleteStorage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::LocalStorageControl::DeleteStorageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalStorageControl_DeleteStorage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalStorageControl_DeleteStorage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  LocalStorageControl_DeleteStorage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalStorageControl::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LocalStorageControl_DeleteStorage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::LocalStorageControl::DeleteStorageCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalStorageControl_DeleteStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_DeleteStorage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::LocalStorageControl::DeleteStorageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("DeleteStorage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalStorageControl_CleanUpStorage_ProxyToResponder {
 public:
  static LocalStorageControl::CleanUpStorageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalStorageControl_CleanUpStorage_ProxyToResponder> proxy(
        new LocalStorageControl_CleanUpStorage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalStorageControl_CleanUpStorage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalStorageControl_CleanUpStorage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalStorageControl_CleanUpStorage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalStorageControl::CleanUpStorageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalStorageControl_CleanUpStorage_ProxyToResponder);
};

bool LocalStorageControl_CleanUpStorage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::LocalStorageControl::CleanUpStorageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalStorageControl_CleanUpStorage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalStorageControl_CleanUpStorage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  LocalStorageControl_CleanUpStorage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalStorageControl::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LocalStorageControl_CleanUpStorage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::LocalStorageControl::CleanUpStorageCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalStorageControl_CleanUpStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_CleanUpStorage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::LocalStorageControl::CleanUpStorageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("CleanUpStorage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalStorageControl_Flush_ProxyToResponder {
 public:
  static LocalStorageControl::FlushCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalStorageControl_Flush_ProxyToResponder> proxy(
        new LocalStorageControl_Flush_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalStorageControl_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalStorageControl_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalStorageControl_Flush_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalStorageControl::FlushCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalStorageControl_Flush_ProxyToResponder);
};

bool LocalStorageControl_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::LocalStorageControl::FlushCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalStorageControl_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalStorageControl_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  LocalStorageControl_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalStorageControl::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LocalStorageControl_Flush_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::LocalStorageControl::FlushCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalStorageControl_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::LocalStorageControl_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::LocalStorageControl::FlushCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalStorageControl::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalStorageControlStubDispatch::Accept(
    LocalStorageControl* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLocalStorageControl_BindStorageArea_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::LocalStorageControl::BindStorageArea",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::LocalStorageControl::BindStorageArea");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalStorageControl_BindStorageArea_Params_Data* params =
          reinterpret_cast<internal::LocalStorageControl_BindStorageArea_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      ::mojo::PendingReceiver<::blink::mojom::StorageArea> p_receiver{};
      LocalStorageControl_BindStorageArea_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindStorageArea(
std::move(p_origin), 
std::move(p_receiver));
      return true;
    }
    case internal::kLocalStorageControl_GetUsage_Name: {
      break;
    }
    case internal::kLocalStorageControl_DeleteStorage_Name: {
      break;
    }
    case internal::kLocalStorageControl_CleanUpStorage_Name: {
      break;
    }
    case internal::kLocalStorageControl_Flush_Name: {
      break;
    }
    case internal::kLocalStorageControl_PurgeMemory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::LocalStorageControl::PurgeMemory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::LocalStorageControl::PurgeMemory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalStorageControl_PurgeMemory_Params_Data* params =
          reinterpret_cast<internal::LocalStorageControl_PurgeMemory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalStorageControl_PurgeMemory_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PurgeMemory();
      return true;
    }
    case internal::kLocalStorageControl_ApplyPolicyUpdates_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::LocalStorageControl::ApplyPolicyUpdates",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::LocalStorageControl::ApplyPolicyUpdates");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalStorageControl_ApplyPolicyUpdates_Params_Data* params =
          reinterpret_cast<internal::LocalStorageControl_ApplyPolicyUpdates_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::storage::mojom::StoragePolicyUpdatePtr> p_policy_updates{};
      LocalStorageControl_ApplyPolicyUpdates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicyUpdates(&p_policy_updates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyPolicyUpdates(
std::move(p_policy_updates));
      return true;
    }
    case internal::kLocalStorageControl_ForceKeepSessionState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::LocalStorageControl::ForceKeepSessionState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::LocalStorageControl::ForceKeepSessionState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalStorageControl_ForceKeepSessionState_Params_Data* params =
          reinterpret_cast<internal::LocalStorageControl_ForceKeepSessionState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalStorageControl_ForceKeepSessionState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceKeepSessionState();
      return true;
    }
  }
  return false;
}

// static
bool LocalStorageControlStubDispatch::AcceptWithResponder(
    LocalStorageControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalStorageControl_BindStorageArea_Name: {
      break;
    }
    case internal::kLocalStorageControl_GetUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::LocalStorageControl::GetUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::LocalStorageControl::GetUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalStorageControl_GetUsage_Params_Data* params =
          reinterpret_cast<
              internal::LocalStorageControl_GetUsage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      LocalStorageControl_GetUsage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 1, false);
        return false;
      }
      LocalStorageControl::GetUsageCallback callback =
          LocalStorageControl_GetUsage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUsage(std::move(callback));
      return true;
    }
    case internal::kLocalStorageControl_DeleteStorage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::LocalStorageControl::DeleteStorage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::LocalStorageControl::DeleteStorage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalStorageControl_DeleteStorage_Params_Data* params =
          reinterpret_cast<
              internal::LocalStorageControl_DeleteStorage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      LocalStorageControl_DeleteStorage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 2, false);
        return false;
      }
      LocalStorageControl::DeleteStorageCallback callback =
          LocalStorageControl_DeleteStorage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteStorage(
std::move(p_origin), std::move(callback));
      return true;
    }
    case internal::kLocalStorageControl_CleanUpStorage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::LocalStorageControl::CleanUpStorage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::LocalStorageControl::CleanUpStorage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalStorageControl_CleanUpStorage_Params_Data* params =
          reinterpret_cast<
              internal::LocalStorageControl_CleanUpStorage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      LocalStorageControl_CleanUpStorage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 3, false);
        return false;
      }
      LocalStorageControl::CleanUpStorageCallback callback =
          LocalStorageControl_CleanUpStorage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CleanUpStorage(std::move(callback));
      return true;
    }
    case internal::kLocalStorageControl_Flush_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::LocalStorageControl::Flush",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::LocalStorageControl::Flush");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalStorageControl_Flush_Params_Data* params =
          reinterpret_cast<
              internal::LocalStorageControl_Flush_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      LocalStorageControl_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalStorageControl::Name_, 4, false);
        return false;
      }
      LocalStorageControl::FlushCallback callback =
          LocalStorageControl_Flush_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(std::move(callback));
      return true;
    }
    case internal::kLocalStorageControl_PurgeMemory_Name: {
      break;
    }
    case internal::kLocalStorageControl_ApplyPolicyUpdates_Name: {
      break;
    }
    case internal::kLocalStorageControl_ForceKeepSessionState_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalStorageControlValidationInfo[] = {
    {internal::kLocalStorageControl_BindStorageArea_Name,
     {&internal::LocalStorageControl_BindStorageArea_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalStorageControl_GetUsage_Name,
     {&internal::LocalStorageControl_GetUsage_Params_Data::Validate,
      &internal::LocalStorageControl_GetUsage_ResponseParams_Data::Validate}},
    {internal::kLocalStorageControl_DeleteStorage_Name,
     {&internal::LocalStorageControl_DeleteStorage_Params_Data::Validate,
      &internal::LocalStorageControl_DeleteStorage_ResponseParams_Data::Validate}},
    {internal::kLocalStorageControl_CleanUpStorage_Name,
     {&internal::LocalStorageControl_CleanUpStorage_Params_Data::Validate,
      &internal::LocalStorageControl_CleanUpStorage_ResponseParams_Data::Validate}},
    {internal::kLocalStorageControl_Flush_Name,
     {&internal::LocalStorageControl_Flush_Params_Data::Validate,
      &internal::LocalStorageControl_Flush_ResponseParams_Data::Validate}},
    {internal::kLocalStorageControl_PurgeMemory_Name,
     {&internal::LocalStorageControl_PurgeMemory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalStorageControl_ApplyPolicyUpdates_Name,
     {&internal::LocalStorageControl_ApplyPolicyUpdates_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalStorageControl_ForceKeepSessionState_Name,
     {&internal::LocalStorageControl_ForceKeepSessionState_Params_Data::Validate,
      nullptr /* no response */}},
};

bool LocalStorageControlRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::LocalStorageControl::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalStorageControlValidationInfo);
}

bool LocalStorageControlResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::LocalStorageControl::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLocalStorageControlValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif