// components/services/storage/public/mojom/quota_client.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/storage/public/mojom/quota_client.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/quota_client.mojom-params-data.h"
namespace storage {
namespace mojom {

namespace internal {


// static
bool QuotaClient_GetOriginUsage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuotaClient_GetOriginUsage_Params_Data* object = static_cast<const QuotaClient_GetOriginUsage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;


  if (!::blink::mojom::internal::StorageType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

QuotaClient_GetOriginUsage_Params_Data::QuotaClient_GetOriginUsage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaClient_GetOriginUsage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuotaClient_GetOriginUsage_ResponseParams_Data* object = static_cast<const QuotaClient_GetOriginUsage_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

QuotaClient_GetOriginUsage_ResponseParams_Data::QuotaClient_GetOriginUsage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaClient_GetOriginsForType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuotaClient_GetOriginsForType_Params_Data* object = static_cast<const QuotaClient_GetOriginsForType_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::StorageType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

QuotaClient_GetOriginsForType_Params_Data::QuotaClient_GetOriginsForType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaClient_GetOriginsForType_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuotaClient_GetOriginsForType_ResponseParams_Data* object = static_cast<const QuotaClient_GetOriginsForType_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origins, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams origins_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->origins, validation_context,
                                         &origins_validate_params)) {
    return false;
  }

  return true;
}

QuotaClient_GetOriginsForType_ResponseParams_Data::QuotaClient_GetOriginsForType_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaClient_GetOriginsForHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuotaClient_GetOriginsForHost_Params_Data* object = static_cast<const QuotaClient_GetOriginsForHost_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::StorageType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  return true;
}

QuotaClient_GetOriginsForHost_Params_Data::QuotaClient_GetOriginsForHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaClient_GetOriginsForHost_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuotaClient_GetOriginsForHost_ResponseParams_Data* object = static_cast<const QuotaClient_GetOriginsForHost_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origins, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams origins_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->origins, validation_context,
                                         &origins_validate_params)) {
    return false;
  }

  return true;
}

QuotaClient_GetOriginsForHost_ResponseParams_Data::QuotaClient_GetOriginsForHost_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaClient_DeleteOriginData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuotaClient_DeleteOriginData_Params_Data* object = static_cast<const QuotaClient_DeleteOriginData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;


  if (!::blink::mojom::internal::StorageType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

QuotaClient_DeleteOriginData_Params_Data::QuotaClient_DeleteOriginData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaClient_DeleteOriginData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuotaClient_DeleteOriginData_ResponseParams_Data* object = static_cast<const QuotaClient_DeleteOriginData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::QuotaStatusCode_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

QuotaClient_DeleteOriginData_ResponseParams_Data::QuotaClient_DeleteOriginData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaClient_PerformStorageCleanup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuotaClient_PerformStorageCleanup_Params_Data* object = static_cast<const QuotaClient_PerformStorageCleanup_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::StorageType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

QuotaClient_PerformStorageCleanup_Params_Data::QuotaClient_PerformStorageCleanup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaClient_PerformStorageCleanup_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuotaClient_PerformStorageCleanup_ResponseParams_Data* object = static_cast<const QuotaClient_PerformStorageCleanup_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

QuotaClient_PerformStorageCleanup_ResponseParams_Data::QuotaClient_PerformStorageCleanup_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace storage
