// components/services/storage/public/mojom/quota_client.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/services/storage/public/mojom/quota_client.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "third_party/blink/public/mojom/quota/quota_types.mojom.h"
#include "url/mojom/origin.mojom.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_QUOTA_CLIENT_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_QUOTA_CLIENT_MOJOM_JUMBO_H_
#endif


namespace storage {
namespace mojom {


void QuotaClientInterceptorForTesting::GetOriginUsage(const ::url::Origin& origin, ::blink::mojom::StorageType type, GetOriginUsageCallback callback) {
  GetForwardingInterface()->GetOriginUsage(std::move(origin), std::move(type), std::move(callback));
}
void QuotaClientInterceptorForTesting::GetOriginsForType(::blink::mojom::StorageType type, GetOriginsForTypeCallback callback) {
  GetForwardingInterface()->GetOriginsForType(std::move(type), std::move(callback));
}
void QuotaClientInterceptorForTesting::GetOriginsForHost(::blink::mojom::StorageType type, const std::string& host, GetOriginsForHostCallback callback) {
  GetForwardingInterface()->GetOriginsForHost(std::move(type), std::move(host), std::move(callback));
}
void QuotaClientInterceptorForTesting::DeleteOriginData(const ::url::Origin& origin, ::blink::mojom::StorageType type, DeleteOriginDataCallback callback) {
  GetForwardingInterface()->DeleteOriginData(std::move(origin), std::move(type), std::move(callback));
}
void QuotaClientInterceptorForTesting::PerformStorageCleanup(::blink::mojom::StorageType type, PerformStorageCleanupCallback callback) {
  GetForwardingInterface()->PerformStorageCleanup(std::move(type), std::move(callback));
}
QuotaClientAsyncWaiter::QuotaClientAsyncWaiter(
    QuotaClient* proxy) : proxy_(proxy) {}

QuotaClientAsyncWaiter::~QuotaClientAsyncWaiter() = default;

void QuotaClientAsyncWaiter::GetOriginUsage(
    const ::url::Origin& origin, ::blink::mojom::StorageType type, int64_t* out_usage) {
  base::RunLoop loop;
  proxy_->GetOriginUsage(std::move(origin),std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_usage
,
             int64_t usage) {*out_usage = std::move(usage);
            loop->Quit();
          },
          &loop,
          out_usage));
  loop.Run();
}
void QuotaClientAsyncWaiter::GetOriginsForType(
    ::blink::mojom::StorageType type, std::vector<::url::Origin>* out_origins) {
  base::RunLoop loop;
  proxy_->GetOriginsForType(std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::url::Origin>* out_origins
,
             const std::vector<::url::Origin>& origins) {*out_origins = std::move(origins);
            loop->Quit();
          },
          &loop,
          out_origins));
  loop.Run();
}
void QuotaClientAsyncWaiter::GetOriginsForHost(
    ::blink::mojom::StorageType type, const std::string& host, std::vector<::url::Origin>* out_origins) {
  base::RunLoop loop;
  proxy_->GetOriginsForHost(std::move(type),std::move(host),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::url::Origin>* out_origins
,
             const std::vector<::url::Origin>& origins) {*out_origins = std::move(origins);
            loop->Quit();
          },
          &loop,
          out_origins));
  loop.Run();
}
void QuotaClientAsyncWaiter::DeleteOriginData(
    const ::url::Origin& origin, ::blink::mojom::StorageType type, ::blink::mojom::QuotaStatusCode* out_status) {
  base::RunLoop loop;
  proxy_->DeleteOriginData(std::move(origin),std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::QuotaStatusCode* out_status
,
             ::blink::mojom::QuotaStatusCode status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void QuotaClientAsyncWaiter::PerformStorageCleanup(
    ::blink::mojom::StorageType type) {
  base::RunLoop loop;
  proxy_->PerformStorageCleanup(std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace mojom
}  // namespace storage

#if defined(__clang__)
#pragma clang diagnostic pop
#endif