// components/services/storage/public/mojom/quota_client.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/quota_client.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/services/storage/public/mojom/quota_client.mojom-params-data.h"
#include "components/services/storage/public/mojom/quota_client.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/quota_client.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_QUOTA_CLIENT_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_QUOTA_CLIENT_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
const char QuotaClient::Name_[] = "storage.mojom.QuotaClient";

class QuotaClient_GetOriginUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_GetOriginUsage_ForwardToCallback(
      QuotaClient::GetOriginUsageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::GetOriginUsageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaClient_GetOriginUsage_ForwardToCallback);
};

class QuotaClient_GetOriginsForType_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_GetOriginsForType_ForwardToCallback(
      QuotaClient::GetOriginsForTypeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::GetOriginsForTypeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaClient_GetOriginsForType_ForwardToCallback);
};

class QuotaClient_GetOriginsForHost_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_GetOriginsForHost_ForwardToCallback(
      QuotaClient::GetOriginsForHostCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::GetOriginsForHostCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaClient_GetOriginsForHost_ForwardToCallback);
};

class QuotaClient_DeleteOriginData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_DeleteOriginData_ForwardToCallback(
      QuotaClient::DeleteOriginDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::DeleteOriginDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaClient_DeleteOriginData_ForwardToCallback);
};

class QuotaClient_PerformStorageCleanup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_PerformStorageCleanup_ForwardToCallback(
      QuotaClient::PerformStorageCleanupCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::PerformStorageCleanupCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuotaClient_PerformStorageCleanup_ForwardToCallback);
};

QuotaClientProxy::QuotaClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuotaClientProxy::GetOriginUsage(
    const ::url::Origin& in_origin, ::blink::mojom::StorageType in_type, GetOriginUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::QuotaClient::GetOriginUsage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ::blink::mojom::StorageType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaClient_GetOriginUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetOriginUsage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in QuotaClient.GetOriginUsage request");
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetOriginUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_GetOriginUsage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuotaClientProxy::GetOriginsForType(
    ::blink::mojom::StorageType in_type, GetOriginsForTypeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::QuotaClient::GetOriginsForType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ::blink::mojom::StorageType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaClient_GetOriginsForType_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetOriginsForType_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetOriginsForType");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_GetOriginsForType_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuotaClientProxy::GetOriginsForHost(
    ::blink::mojom::StorageType in_type, const std::string& in_host, GetOriginsForHostCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::QuotaClient::GetOriginsForHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ::blink::mojom::StorageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaClient_GetOriginsForHost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetOriginsForHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_type, &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host, host_fragment);
  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in QuotaClient.GetOriginsForHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetOriginsForHost");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_GetOriginsForHost_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuotaClientProxy::DeleteOriginData(
    const ::url::Origin& in_origin, ::blink::mojom::StorageType in_type, DeleteOriginDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::QuotaClient::DeleteOriginData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ::blink::mojom::StorageType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaClient_DeleteOriginData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_DeleteOriginData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in QuotaClient.DeleteOriginData request");
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("DeleteOriginData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_DeleteOriginData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuotaClientProxy::PerformStorageCleanup(
    ::blink::mojom::StorageType in_type, PerformStorageCleanupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::QuotaClient::PerformStorageCleanup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ::blink::mojom::StorageType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaClient_PerformStorageCleanup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_PerformStorageCleanup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("PerformStorageCleanup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_PerformStorageCleanup_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class QuotaClient_GetOriginUsage_ProxyToResponder {
 public:
  static QuotaClient::GetOriginUsageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaClient_GetOriginUsage_ProxyToResponder> proxy(
        new QuotaClient_GetOriginUsage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaClient_GetOriginUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_GetOriginUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaClient_GetOriginUsage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::GetOriginUsageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_usage);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaClient_GetOriginUsage_ProxyToResponder);
};

bool QuotaClient_GetOriginUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::QuotaClient::GetOriginUsageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaClient_GetOriginUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_GetOriginUsage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_usage{};
  QuotaClient_GetOriginUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_usage = input_data_view.usage();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_usage));
  return true;
}

void QuotaClient_GetOriginUsage_ProxyToResponder::Run(
    int64_t in_usage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::QuotaClient::GetOriginUsageCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage"), in_usage, 
                        "<value of type int64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaClient_GetOriginUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetOriginUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->usage = in_usage;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::QuotaClient::GetOriginUsageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetOriginUsage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaClient_GetOriginsForType_ProxyToResponder {
 public:
  static QuotaClient::GetOriginsForTypeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaClient_GetOriginsForType_ProxyToResponder> proxy(
        new QuotaClient_GetOriginsForType_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaClient_GetOriginsForType_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_GetOriginsForType_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaClient_GetOriginsForType_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::GetOriginsForTypeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::url::Origin>& in_origins);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaClient_GetOriginsForType_ProxyToResponder);
};

bool QuotaClient_GetOriginsForType_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::QuotaClient::GetOriginsForTypeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaClient_GetOriginsForType_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_GetOriginsForType_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::url::Origin> p_origins{};
  QuotaClient_GetOriginsForType_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOrigins(&p_origins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_origins));
  return true;
}

void QuotaClient_GetOriginsForType_ProxyToResponder::Run(
    const std::vector<::url::Origin>& in_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::QuotaClient::GetOriginsForTypeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origins"), in_origins, 
                        "<value of type const std::vector<::url::Origin>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaClient_GetOriginsForType_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetOriginsForType_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origins)::BaseType>
      origins_fragment(params.message());
  const mojo::internal::ContainerValidateParams origins_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
      in_origins, origins_fragment, &origins_validate_params);
  params->origins.Set(
      origins_fragment.is_null() ? nullptr : origins_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origins.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origins in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::QuotaClient::GetOriginsForTypeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetOriginsForType");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaClient_GetOriginsForHost_ProxyToResponder {
 public:
  static QuotaClient::GetOriginsForHostCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaClient_GetOriginsForHost_ProxyToResponder> proxy(
        new QuotaClient_GetOriginsForHost_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaClient_GetOriginsForHost_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_GetOriginsForHost_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaClient_GetOriginsForHost_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::GetOriginsForHostCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::url::Origin>& in_origins);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaClient_GetOriginsForHost_ProxyToResponder);
};

bool QuotaClient_GetOriginsForHost_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::QuotaClient::GetOriginsForHostCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaClient_GetOriginsForHost_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_GetOriginsForHost_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::url::Origin> p_origins{};
  QuotaClient_GetOriginsForHost_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOrigins(&p_origins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_origins));
  return true;
}

void QuotaClient_GetOriginsForHost_ProxyToResponder::Run(
    const std::vector<::url::Origin>& in_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::QuotaClient::GetOriginsForHostCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origins"), in_origins, 
                        "<value of type const std::vector<::url::Origin>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaClient_GetOriginsForHost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetOriginsForHost_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origins)::BaseType>
      origins_fragment(params.message());
  const mojo::internal::ContainerValidateParams origins_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
      in_origins, origins_fragment, &origins_validate_params);
  params->origins.Set(
      origins_fragment.is_null() ? nullptr : origins_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origins.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origins in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::QuotaClient::GetOriginsForHostCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetOriginsForHost");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaClient_DeleteOriginData_ProxyToResponder {
 public:
  static QuotaClient::DeleteOriginDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaClient_DeleteOriginData_ProxyToResponder> proxy(
        new QuotaClient_DeleteOriginData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaClient_DeleteOriginData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_DeleteOriginData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaClient_DeleteOriginData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::DeleteOriginDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::QuotaStatusCode in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaClient_DeleteOriginData_ProxyToResponder);
};

bool QuotaClient_DeleteOriginData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::QuotaClient::DeleteOriginDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaClient_DeleteOriginData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_DeleteOriginData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::QuotaStatusCode p_status{};
  QuotaClient_DeleteOriginData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void QuotaClient_DeleteOriginData_ProxyToResponder::Run(
    ::blink::mojom::QuotaStatusCode in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::QuotaClient::DeleteOriginDataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::blink::mojom::QuotaStatusCode>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaClient_DeleteOriginData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_DeleteOriginData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::QuotaStatusCode>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::QuotaClient::DeleteOriginDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("DeleteOriginData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaClient_PerformStorageCleanup_ProxyToResponder {
 public:
  static QuotaClient::PerformStorageCleanupCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuotaClient_PerformStorageCleanup_ProxyToResponder> proxy(
        new QuotaClient_PerformStorageCleanup_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuotaClient_PerformStorageCleanup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_PerformStorageCleanup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuotaClient_PerformStorageCleanup_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::PerformStorageCleanupCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuotaClient_PerformStorageCleanup_ProxyToResponder);
};

bool QuotaClient_PerformStorageCleanup_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::QuotaClient::PerformStorageCleanupCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuotaClient_PerformStorageCleanup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_PerformStorageCleanup_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  QuotaClient_PerformStorageCleanup_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void QuotaClient_PerformStorageCleanup_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::QuotaClient::PerformStorageCleanupCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuotaClient_PerformStorageCleanup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_PerformStorageCleanup_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::QuotaClient::PerformStorageCleanupCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("PerformStorageCleanup");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool QuotaClientStubDispatch::Accept(
    QuotaClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kQuotaClient_GetOriginUsage_Name: {
      break;
    }
    case internal::kQuotaClient_GetOriginsForType_Name: {
      break;
    }
    case internal::kQuotaClient_GetOriginsForHost_Name: {
      break;
    }
    case internal::kQuotaClient_DeleteOriginData_Name: {
      break;
    }
    case internal::kQuotaClient_PerformStorageCleanup_Name: {
      break;
    }
  }
  return false;
}

// static
bool QuotaClientStubDispatch::AcceptWithResponder(
    QuotaClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kQuotaClient_GetOriginUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::QuotaClient::GetOriginUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::QuotaClient::GetOriginUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaClient_GetOriginUsage_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_GetOriginUsage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      ::blink::mojom::StorageType p_type{};
      QuotaClient_GetOriginUsage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 0, false);
        return false;
      }
      QuotaClient::GetOriginUsageCallback callback =
          QuotaClient_GetOriginUsage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetOriginUsage(
std::move(p_origin), 
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kQuotaClient_GetOriginsForType_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::QuotaClient::GetOriginsForType",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::QuotaClient::GetOriginsForType");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaClient_GetOriginsForType_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_GetOriginsForType_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::StorageType p_type{};
      QuotaClient_GetOriginsForType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 1, false);
        return false;
      }
      QuotaClient::GetOriginsForTypeCallback callback =
          QuotaClient_GetOriginsForType_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetOriginsForType(
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kQuotaClient_GetOriginsForHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::QuotaClient::GetOriginsForHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::QuotaClient::GetOriginsForHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaClient_GetOriginsForHost_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_GetOriginsForHost_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::StorageType p_type{};
      std::string p_host{};
      QuotaClient_GetOriginsForHost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 2, false);
        return false;
      }
      QuotaClient::GetOriginsForHostCallback callback =
          QuotaClient_GetOriginsForHost_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetOriginsForHost(
std::move(p_type), 
std::move(p_host), std::move(callback));
      return true;
    }
    case internal::kQuotaClient_DeleteOriginData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::QuotaClient::DeleteOriginData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::QuotaClient::DeleteOriginData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaClient_DeleteOriginData_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_DeleteOriginData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      ::blink::mojom::StorageType p_type{};
      QuotaClient_DeleteOriginData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 3, false);
        return false;
      }
      QuotaClient::DeleteOriginDataCallback callback =
          QuotaClient_DeleteOriginData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteOriginData(
std::move(p_origin), 
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kQuotaClient_PerformStorageCleanup_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::QuotaClient::PerformStorageCleanup",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::QuotaClient::PerformStorageCleanup");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuotaClient_PerformStorageCleanup_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_PerformStorageCleanup_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::StorageType p_type{};
      QuotaClient_PerformStorageCleanup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 4, false);
        return false;
      }
      QuotaClient::PerformStorageCleanupCallback callback =
          QuotaClient_PerformStorageCleanup_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformStorageCleanup(
std::move(p_type), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kQuotaClientValidationInfo[] = {
    {internal::kQuotaClient_GetOriginUsage_Name,
     {&internal::QuotaClient_GetOriginUsage_Params_Data::Validate,
      &internal::QuotaClient_GetOriginUsage_ResponseParams_Data::Validate}},
    {internal::kQuotaClient_GetOriginsForType_Name,
     {&internal::QuotaClient_GetOriginsForType_Params_Data::Validate,
      &internal::QuotaClient_GetOriginsForType_ResponseParams_Data::Validate}},
    {internal::kQuotaClient_GetOriginsForHost_Name,
     {&internal::QuotaClient_GetOriginsForHost_Params_Data::Validate,
      &internal::QuotaClient_GetOriginsForHost_ResponseParams_Data::Validate}},
    {internal::kQuotaClient_DeleteOriginData_Name,
     {&internal::QuotaClient_DeleteOriginData_Params_Data::Validate,
      &internal::QuotaClient_DeleteOriginData_ResponseParams_Data::Validate}},
    {internal::kQuotaClient_PerformStorageCleanup_Name,
     {&internal::QuotaClient_PerformStorageCleanup_Params_Data::Validate,
      &internal::QuotaClient_PerformStorageCleanup_ResponseParams_Data::Validate}},
};

bool QuotaClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::QuotaClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kQuotaClientValidationInfo);
}

bool QuotaClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::QuotaClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kQuotaClientValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif