// components/services/storage/public/mojom/service_worker_database.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/service_worker_database.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/services/storage/public/mojom/service_worker_database.mojom-params-data.h"
#include "components/services/storage/public/mojom/service_worker_database.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/service_worker_database.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
ServiceWorkerRegistrationData::ServiceWorkerRegistrationData()
    : registration_id(::blink::mojom::kInvalidServiceWorkerRegistrationId),
      scope(),
      script(),
      script_type(::blink::mojom::ScriptType::kClassic),
      update_via_cache(::blink::mojom::ServiceWorkerUpdateViaCache::kImports),
      version_id(::blink::mojom::kInvalidServiceWorkerVersionId),
      is_active(false),
      has_fetch_handler(false),
      last_update_check(),
      script_response_time(),
      origin_trial_tokens(),
      navigation_preload_state(),
      used_features(),
      resources_total_size_bytes(0),
      cross_origin_embedder_policy() {}

ServiceWorkerRegistrationData::ServiceWorkerRegistrationData(
    int64_t registration_id_in,
    const ::GURL& scope_in,
    const ::GURL& script_in,
    ::blink::mojom::ScriptType script_type_in,
    ::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache_in,
    int64_t version_id_in,
    bool is_active_in,
    bool has_fetch_handler_in,
    ::base::Time last_update_check_in,
    ::base::Time script_response_time_in,
    const base::Optional<base::flat_map<std::string, std::vector<std::string>>>& origin_trial_tokens_in,
    ::blink::mojom::NavigationPreloadStatePtr navigation_preload_state_in,
    std::vector<::blink::mojom::WebFeature> used_features_in,
    int64_t resources_total_size_bytes_in,
    const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy_in)
    : registration_id(std::move(registration_id_in)),
      scope(std::move(scope_in)),
      script(std::move(script_in)),
      script_type(std::move(script_type_in)),
      update_via_cache(std::move(update_via_cache_in)),
      version_id(std::move(version_id_in)),
      is_active(std::move(is_active_in)),
      has_fetch_handler(std::move(has_fetch_handler_in)),
      last_update_check(std::move(last_update_check_in)),
      script_response_time(std::move(script_response_time_in)),
      origin_trial_tokens(std::move(origin_trial_tokens_in)),
      navigation_preload_state(std::move(navigation_preload_state_in)),
      used_features(std::move(used_features_in)),
      resources_total_size_bytes(std::move(resources_total_size_bytes_in)),
      cross_origin_embedder_policy(std::move(cross_origin_embedder_policy_in)) {}

ServiceWorkerRegistrationData::~ServiceWorkerRegistrationData() = default;

void ServiceWorkerRegistrationData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration_id"), this->registration_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope"), this->scope, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script"), this->script, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_type"), this->script_type, 
      "<value of type ::blink::mojom::ScriptType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_via_cache"), this->update_via_cache, 
      "<value of type ::blink::mojom::ServiceWorkerUpdateViaCache>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_id"), this->version_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_active"), this->is_active, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_fetch_handler"), this->has_fetch_handler, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_update_check"), this->last_update_check, 
      "<value of type ::base::Time>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_response_time"), this->script_response_time, 
      "<value of type ::base::Time>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin_trial_tokens"), this->origin_trial_tokens, 
      "<value of type const base::Optional<base::flat_map<std::string, std::vector<std::string>>>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_preload_state"), this->navigation_preload_state, 
      "<value of type ::blink::mojom::NavigationPreloadStatePtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "used_features"), this->used_features, 
      "<value of type const std::vector<::blink::mojom::WebFeature>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resources_total_size_bytes"), this->resources_total_size_bytes, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin_embedder_policy"), this->cross_origin_embedder_policy, 
      "<value of type const ::network::CrossOriginEmbedderPolicy&>");
}

bool ServiceWorkerRegistrationData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerResourceRecord::ServiceWorkerResourceRecord()
    : resource_id(::blink::mojom::kInvalidServiceWorkerResourceId),
      url(),
      size_bytes(0) {}

ServiceWorkerResourceRecord::ServiceWorkerResourceRecord(
    int64_t resource_id_in,
    const ::GURL& url_in,
    int64_t size_bytes_in)
    : resource_id(std::move(resource_id_in)),
      url(std::move(url_in)),
      size_bytes(std::move(size_bytes_in)) {}

ServiceWorkerResourceRecord::~ServiceWorkerResourceRecord() = default;

void ServiceWorkerResourceRecord::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_id"), this->resource_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_bytes"), this->size_bytes, 
      "<value of type int64_t>");
}

bool ServiceWorkerResourceRecord::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace storage

namespace mojo {


// static
bool StructTraits<::storage::mojom::ServiceWorkerRegistrationData::DataView, ::storage::mojom::ServiceWorkerRegistrationDataPtr>::Read(
    ::storage::mojom::ServiceWorkerRegistrationData::DataView input,
    ::storage::mojom::ServiceWorkerRegistrationDataPtr* output) {
  bool success = true;
  ::storage::mojom::ServiceWorkerRegistrationDataPtr result(::storage::mojom::ServiceWorkerRegistrationData::New());
  
      if (success)
        result->registration_id = input.registration_id();
      if (success && !input.ReadScope(&result->scope))
        success = false;
      if (success && !input.ReadScript(&result->script))
        success = false;
      if (success && !input.ReadScriptType(&result->script_type))
        success = false;
      if (success && !input.ReadUpdateViaCache(&result->update_via_cache))
        success = false;
      if (success)
        result->version_id = input.version_id();
      if (success)
        result->is_active = input.is_active();
      if (success)
        result->has_fetch_handler = input.has_fetch_handler();
      if (success && !input.ReadLastUpdateCheck(&result->last_update_check))
        success = false;
      if (success && !input.ReadScriptResponseTime(&result->script_response_time))
        success = false;
      if (success && !input.ReadOriginTrialTokens(&result->origin_trial_tokens))
        success = false;
      if (success && !input.ReadNavigationPreloadState(&result->navigation_preload_state))
        success = false;
      if (success && !input.ReadUsedFeatures(&result->used_features))
        success = false;
      if (success)
        result->resources_total_size_bytes = input.resources_total_size_bytes();
      if (success && !input.ReadCrossOriginEmbedderPolicy(&result->cross_origin_embedder_policy))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::ServiceWorkerResourceRecord::DataView, ::storage::mojom::ServiceWorkerResourceRecordPtr>::Read(
    ::storage::mojom::ServiceWorkerResourceRecord::DataView input,
    ::storage::mojom::ServiceWorkerResourceRecordPtr* output) {
  bool success = true;
  ::storage::mojom::ServiceWorkerResourceRecordPtr result(::storage::mojom::ServiceWorkerResourceRecord::New());
  
      if (success)
        result->resource_id = input.resource_id();
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->size_bytes = input.size_bytes();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif