// components/services/storage/public/mojom/service_worker_storage_control.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "components/services/storage/public/mojom/storage_policy_update.mojom.h"
#include "components/services/storage/public/mojom/service_worker_database.mojom.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_JUMBO_H_
#endif


namespace storage {
namespace mojom {


ServiceWorkerLiveVersionRefAsyncWaiter::ServiceWorkerLiveVersionRefAsyncWaiter(
    ServiceWorkerLiveVersionRef* proxy) : proxy_(proxy) {}

ServiceWorkerLiveVersionRefAsyncWaiter::~ServiceWorkerLiveVersionRefAsyncWaiter() = default;




void ServiceWorkerDataPipeStateNotifierInterceptorForTesting::OnComplete(int32_t status) {
  GetForwardingInterface()->OnComplete(std::move(status));
}
ServiceWorkerDataPipeStateNotifierAsyncWaiter::ServiceWorkerDataPipeStateNotifierAsyncWaiter(
    ServiceWorkerDataPipeStateNotifier* proxy) : proxy_(proxy) {}

ServiceWorkerDataPipeStateNotifierAsyncWaiter::~ServiceWorkerDataPipeStateNotifierAsyncWaiter() = default;




void ServiceWorkerResourceReaderInterceptorForTesting::ReadResponseHead(ReadResponseHeadCallback callback) {
  GetForwardingInterface()->ReadResponseHead(std::move(callback));
}
void ServiceWorkerResourceReaderInterceptorForTesting::ReadData(int64_t size, ::mojo::PendingRemote<ServiceWorkerDataPipeStateNotifier> notifier, ReadDataCallback callback) {
  GetForwardingInterface()->ReadData(std::move(size), std::move(notifier), std::move(callback));
}
ServiceWorkerResourceReaderAsyncWaiter::ServiceWorkerResourceReaderAsyncWaiter(
    ServiceWorkerResourceReader* proxy) : proxy_(proxy) {}

ServiceWorkerResourceReaderAsyncWaiter::~ServiceWorkerResourceReaderAsyncWaiter() = default;

void ServiceWorkerResourceReaderAsyncWaiter::ReadResponseHead(
    int32_t* out_status, ::network::mojom::URLResponseHeadPtr* out_response_head, base::Optional<::mojo_base::BigBuffer>* out_metadata) {
  base::RunLoop loop;
  proxy_->ReadResponseHead(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status
,
             ::network::mojom::URLResponseHeadPtr* out_response_head
,
             base::Optional<::mojo_base::BigBuffer>* out_metadata
,
             int32_t status,
             ::network::mojom::URLResponseHeadPtr response_head,
             base::Optional<::mojo_base::BigBuffer> metadata) {*out_status = std::move(status);*out_response_head = std::move(response_head);*out_metadata = std::move(metadata);
            loop->Quit();
          },
          &loop,
          out_status,
          out_response_head,
          out_metadata));
  loop.Run();
}
void ServiceWorkerResourceReaderAsyncWaiter::ReadData(
    int64_t size, ::mojo::PendingRemote<ServiceWorkerDataPipeStateNotifier> notifier, ::mojo::ScopedDataPipeConsumerHandle* out_pipe) {
  base::RunLoop loop;
  proxy_->ReadData(std::move(size),std::move(notifier),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::ScopedDataPipeConsumerHandle* out_pipe
,
             ::mojo::ScopedDataPipeConsumerHandle pipe) {*out_pipe = std::move(pipe);
            loop->Quit();
          },
          &loop,
          out_pipe));
  loop.Run();
}



void ServiceWorkerResourceWriterInterceptorForTesting::WriteResponseHead(::network::mojom::URLResponseHeadPtr response_head, WriteResponseHeadCallback callback) {
  GetForwardingInterface()->WriteResponseHead(std::move(response_head), std::move(callback));
}
void ServiceWorkerResourceWriterInterceptorForTesting::WriteData(::mojo_base::BigBuffer data, WriteDataCallback callback) {
  GetForwardingInterface()->WriteData(std::move(data), std::move(callback));
}
ServiceWorkerResourceWriterAsyncWaiter::ServiceWorkerResourceWriterAsyncWaiter(
    ServiceWorkerResourceWriter* proxy) : proxy_(proxy) {}

ServiceWorkerResourceWriterAsyncWaiter::~ServiceWorkerResourceWriterAsyncWaiter() = default;

void ServiceWorkerResourceWriterAsyncWaiter::WriteResponseHead(
    ::network::mojom::URLResponseHeadPtr response_head, int32_t* out_status) {
  base::RunLoop loop;
  proxy_->WriteResponseHead(std::move(response_head),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status
,
             int32_t status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerResourceWriterAsyncWaiter::WriteData(
    ::mojo_base::BigBuffer data, int32_t* out_status) {
  base::RunLoop loop;
  proxy_->WriteData(std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status
,
             int32_t status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}



void ServiceWorkerResourceMetadataWriterInterceptorForTesting::WriteMetadata(::mojo_base::BigBuffer data, WriteMetadataCallback callback) {
  GetForwardingInterface()->WriteMetadata(std::move(data), std::move(callback));
}
ServiceWorkerResourceMetadataWriterAsyncWaiter::ServiceWorkerResourceMetadataWriterAsyncWaiter(
    ServiceWorkerResourceMetadataWriter* proxy) : proxy_(proxy) {}

ServiceWorkerResourceMetadataWriterAsyncWaiter::~ServiceWorkerResourceMetadataWriterAsyncWaiter() = default;

void ServiceWorkerResourceMetadataWriterAsyncWaiter::WriteMetadata(
    ::mojo_base::BigBuffer data, int32_t* out_status) {
  base::RunLoop loop;
  proxy_->WriteMetadata(std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status
,
             int32_t status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}



void ServiceWorkerStorageControlInterceptorForTesting::Disable(DisableCallback callback) {
  GetForwardingInterface()->Disable(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::Delete(DeleteCallback callback) {
  GetForwardingInterface()->Delete(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::Recover(std::vector<ServiceWorkerLiveVersionInfoPtr> versions, RecoverCallback callback) {
  GetForwardingInterface()->Recover(std::move(versions), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetRegisteredOrigins(GetRegisteredOriginsCallback callback) {
  GetForwardingInterface()->GetRegisteredOrigins(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::FindRegistrationForClientUrl(const ::GURL& client_url, FindRegistrationForClientUrlCallback callback) {
  GetForwardingInterface()->FindRegistrationForClientUrl(std::move(client_url), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::FindRegistrationForScope(const ::GURL& scope, FindRegistrationForScopeCallback callback) {
  GetForwardingInterface()->FindRegistrationForScope(std::move(scope), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::FindRegistrationForId(int64_t registration_id, const base::Optional<::url::Origin>& origin, FindRegistrationForIdCallback callback) {
  GetForwardingInterface()->FindRegistrationForId(std::move(registration_id), std::move(origin), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetRegistrationsForOrigin(const ::url::Origin& origin, GetRegistrationsForOriginCallback callback) {
  GetForwardingInterface()->GetRegistrationsForOrigin(std::move(origin), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUsageForOrigin(const ::url::Origin& origin, GetUsageForOriginCallback callback) {
  GetForwardingInterface()->GetUsageForOrigin(std::move(origin), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetAllRegistrationsDeprecated(GetAllRegistrationsDeprecatedCallback callback) {
  GetForwardingInterface()->GetAllRegistrationsDeprecated(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::StoreRegistration(::storage::mojom::ServiceWorkerRegistrationDataPtr registration, std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources, StoreRegistrationCallback callback) {
  GetForwardingInterface()->StoreRegistration(std::move(registration), std::move(resources), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::DeleteRegistration(int64_t registration_id, const ::GURL& origin, DeleteRegistrationCallback callback) {
  GetForwardingInterface()->DeleteRegistration(std::move(registration_id), std::move(origin), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::UpdateToActiveState(int64_t registration_id, const ::GURL& origin, UpdateToActiveStateCallback callback) {
  GetForwardingInterface()->UpdateToActiveState(std::move(registration_id), std::move(origin), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::UpdateLastUpdateCheckTime(int64_t registration_id, const ::GURL& origin, ::base::Time last_update_check_time, UpdateLastUpdateCheckTimeCallback callback) {
  GetForwardingInterface()->UpdateLastUpdateCheckTime(std::move(registration_id), std::move(origin), std::move(last_update_check_time), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::UpdateNavigationPreloadEnabled(int64_t registration_id, const ::GURL& origin, bool enable, UpdateNavigationPreloadEnabledCallback callback) {
  GetForwardingInterface()->UpdateNavigationPreloadEnabled(std::move(registration_id), std::move(origin), std::move(enable), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::UpdateNavigationPreloadHeader(int64_t registration_id, const ::GURL& origin, const std::string& value, UpdateNavigationPreloadHeaderCallback callback) {
  GetForwardingInterface()->UpdateNavigationPreloadHeader(std::move(registration_id), std::move(origin), std::move(value), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetNewRegistrationId(GetNewRegistrationIdCallback callback) {
  GetForwardingInterface()->GetNewRegistrationId(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetNewVersionId(GetNewVersionIdCallback callback) {
  GetForwardingInterface()->GetNewVersionId(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetNewResourceId(GetNewResourceIdCallback callback) {
  GetForwardingInterface()->GetNewResourceId(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::CreateResourceReader(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceReader> reader) {
  GetForwardingInterface()->CreateResourceReader(std::move(resource_id), std::move(reader));
}
void ServiceWorkerStorageControlInterceptorForTesting::CreateResourceWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceWriter> writer) {
  GetForwardingInterface()->CreateResourceWriter(std::move(resource_id), std::move(writer));
}
void ServiceWorkerStorageControlInterceptorForTesting::CreateResourceMetadataWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter> writer) {
  GetForwardingInterface()->CreateResourceMetadataWriter(std::move(resource_id), std::move(writer));
}
void ServiceWorkerStorageControlInterceptorForTesting::StoreUncommittedResourceId(int64_t resource_id, StoreUncommittedResourceIdCallback callback) {
  GetForwardingInterface()->StoreUncommittedResourceId(std::move(resource_id), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::DoomUncommittedResources(const std::vector<int64_t>& resource_ids, DoomUncommittedResourcesCallback callback) {
  GetForwardingInterface()->DoomUncommittedResources(std::move(resource_ids), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUserData(int64_t registration_id, const std::vector<std::string>& keys, GetUserDataCallback callback) {
  GetForwardingInterface()->GetUserData(std::move(registration_id), std::move(keys), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::StoreUserData(int64_t registration_id, const ::url::Origin& origin, std::vector<ServiceWorkerUserDataPtr> user_data, StoreUserDataCallback callback) {
  GetForwardingInterface()->StoreUserData(std::move(registration_id), std::move(origin), std::move(user_data), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::ClearUserData(int64_t registration_id, const std::vector<std::string>& keys, ClearUserDataCallback callback) {
  GetForwardingInterface()->ClearUserData(std::move(registration_id), std::move(keys), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUserDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserDataByKeyPrefixCallback callback) {
  GetForwardingInterface()->GetUserDataByKeyPrefix(std::move(registration_id), std::move(key_prefix), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUserKeysAndDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserKeysAndDataByKeyPrefixCallback callback) {
  GetForwardingInterface()->GetUserKeysAndDataByKeyPrefix(std::move(registration_id), std::move(key_prefix), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::ClearUserDataByKeyPrefixes(int64_t registratation_id, const std::vector<std::string>& key_prefixes, ClearUserDataByKeyPrefixesCallback callback) {
  GetForwardingInterface()->ClearUserDataByKeyPrefixes(std::move(registratation_id), std::move(key_prefixes), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUserDataForAllRegistrations(const std::string& key, GetUserDataForAllRegistrationsCallback callback) {
  GetForwardingInterface()->GetUserDataForAllRegistrations(std::move(key), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, GetUserDataForAllRegistrationsByKeyPrefixCallback callback) {
  GetForwardingInterface()->GetUserDataForAllRegistrationsByKeyPrefix(std::move(key_prefix), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::ClearUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, ClearUserDataForAllRegistrationsByKeyPrefixCallback callback) {
  GetForwardingInterface()->ClearUserDataForAllRegistrationsByKeyPrefix(std::move(key_prefix), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::PerformStorageCleanup(PerformStorageCleanupCallback callback) {
  GetForwardingInterface()->PerformStorageCleanup(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates, ApplyPolicyUpdatesCallback callback) {
  GetForwardingInterface()->ApplyPolicyUpdates(std::move(policy_updates), std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetPurgingResourceIdsForTest(GetPurgingResourceIdsForTestCallback callback) {
  GetForwardingInterface()->GetPurgingResourceIdsForTest(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetPurgeableResourceIdsForTest(GetPurgeableResourceIdsForTestCallback callback) {
  GetForwardingInterface()->GetPurgeableResourceIdsForTest(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUncommittedResourceIdsForTest(GetUncommittedResourceIdsForTestCallback callback) {
  GetForwardingInterface()->GetUncommittedResourceIdsForTest(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::SetPurgingCompleteCallbackForTest(SetPurgingCompleteCallbackForTestCallback callback) {
  GetForwardingInterface()->SetPurgingCompleteCallbackForTest(std::move(callback));
}
ServiceWorkerStorageControlAsyncWaiter::ServiceWorkerStorageControlAsyncWaiter(
    ServiceWorkerStorageControl* proxy) : proxy_(proxy) {}

ServiceWorkerStorageControlAsyncWaiter::~ServiceWorkerStorageControlAsyncWaiter() = default;

void ServiceWorkerStorageControlAsyncWaiter::Disable(
    ) {
  base::RunLoop loop;
  proxy_->Disable(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::Delete(
    ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->Delete(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::Recover(
    std::vector<ServiceWorkerLiveVersionInfoPtr> versions) {
  base::RunLoop loop;
  proxy_->Recover(std::move(versions),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetRegisteredOrigins(
    std::vector<::url::Origin>* out_origins) {
  base::RunLoop loop;
  proxy_->GetRegisteredOrigins(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::url::Origin>* out_origins
,
             const std::vector<::url::Origin>& origins) {*out_origins = std::move(origins);
            loop->Quit();
          },
          &loop,
          out_origins));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::FindRegistrationForClientUrl(
    const ::GURL& client_url, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, ServiceWorkerFindRegistrationResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->FindRegistrationForClientUrl(std::move(client_url),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ServiceWorkerFindRegistrationResultPtr* out_result
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             ServiceWorkerFindRegistrationResultPtr result) {*out_status = std::move(status);*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_status,
          out_result));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::FindRegistrationForScope(
    const ::GURL& scope, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, ServiceWorkerFindRegistrationResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->FindRegistrationForScope(std::move(scope),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ServiceWorkerFindRegistrationResultPtr* out_result
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             ServiceWorkerFindRegistrationResultPtr result) {*out_status = std::move(status);*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_status,
          out_result));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::FindRegistrationForId(
    int64_t registration_id, const base::Optional<::url::Origin>& origin, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, ServiceWorkerFindRegistrationResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->FindRegistrationForId(std::move(registration_id),std::move(origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ServiceWorkerFindRegistrationResultPtr* out_result
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             ServiceWorkerFindRegistrationResultPtr result) {*out_status = std::move(status);*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_status,
          out_result));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetRegistrationsForOrigin(
    const ::url::Origin& origin, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<ServiceWorkerFindRegistrationResultPtr>* out_registrations) {
  base::RunLoop loop;
  proxy_->GetRegistrationsForOrigin(std::move(origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<ServiceWorkerFindRegistrationResultPtr>* out_registrations
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             std::vector<ServiceWorkerFindRegistrationResultPtr> registrations) {*out_status = std::move(status);*out_registrations = std::move(registrations);
            loop->Quit();
          },
          &loop,
          out_status,
          out_registrations));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetUsageForOrigin(
    const ::url::Origin& origin, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, int64_t* out_usage) {
  base::RunLoop loop;
  proxy_->GetUsageForOrigin(std::move(origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             int64_t* out_usage
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             int64_t usage) {*out_status = std::move(status);*out_usage = std::move(usage);
            loop->Quit();
          },
          &loop,
          out_status,
          out_usage));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetAllRegistrationsDeprecated(
    ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr>* out_registrations) {
  base::RunLoop loop;
  proxy_->GetAllRegistrationsDeprecated(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr>* out_registrations
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr> registrations) {*out_status = std::move(status);*out_registrations = std::move(registrations);
            loop->Quit();
          },
          &loop,
          out_status,
          out_registrations));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::StoreRegistration(
    ::storage::mojom::ServiceWorkerRegistrationDataPtr registration, std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, uint64_t* out_deleted_resources_size) {
  base::RunLoop loop;
  proxy_->StoreRegistration(std::move(registration),std::move(resources),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             uint64_t* out_deleted_resources_size
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             uint64_t deleted_resources_size) {*out_status = std::move(status);*out_deleted_resources_size = std::move(deleted_resources_size);
            loop->Quit();
          },
          &loop,
          out_status,
          out_deleted_resources_size));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::DeleteRegistration(
    int64_t registration_id, const ::GURL& origin, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, uint64_t* out_deleted_resources_size, ServiceWorkerStorageOriginState* out_origin_state) {
  base::RunLoop loop;
  proxy_->DeleteRegistration(std::move(registration_id),std::move(origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             uint64_t* out_deleted_resources_size
,
             ServiceWorkerStorageOriginState* out_origin_state
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             uint64_t deleted_resources_size,
             ServiceWorkerStorageOriginState origin_state) {*out_status = std::move(status);*out_deleted_resources_size = std::move(deleted_resources_size);*out_origin_state = std::move(origin_state);
            loop->Quit();
          },
          &loop,
          out_status,
          out_deleted_resources_size,
          out_origin_state));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::UpdateToActiveState(
    int64_t registration_id, const ::GURL& origin, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->UpdateToActiveState(std::move(registration_id),std::move(origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::UpdateLastUpdateCheckTime(
    int64_t registration_id, const ::GURL& origin, ::base::Time last_update_check_time, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->UpdateLastUpdateCheckTime(std::move(registration_id),std::move(origin),std::move(last_update_check_time),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::UpdateNavigationPreloadEnabled(
    int64_t registration_id, const ::GURL& origin, bool enable, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->UpdateNavigationPreloadEnabled(std::move(registration_id),std::move(origin),std::move(enable),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::UpdateNavigationPreloadHeader(
    int64_t registration_id, const ::GURL& origin, const std::string& value, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->UpdateNavigationPreloadHeader(std::move(registration_id),std::move(origin),std::move(value),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetNewRegistrationId(
    int64_t* out_registration_id) {
  base::RunLoop loop;
  proxy_->GetNewRegistrationId(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_registration_id
,
             int64_t registration_id) {*out_registration_id = std::move(registration_id);
            loop->Quit();
          },
          &loop,
          out_registration_id));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetNewVersionId(
    int64_t* out_version_id, ::mojo::PendingRemote<ServiceWorkerLiveVersionRef>* out_version_reference) {
  base::RunLoop loop;
  proxy_->GetNewVersionId(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_version_id
,
             ::mojo::PendingRemote<ServiceWorkerLiveVersionRef>* out_version_reference
,
             int64_t version_id,
             ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> version_reference) {*out_version_id = std::move(version_id);*out_version_reference = std::move(version_reference);
            loop->Quit();
          },
          &loop,
          out_version_id,
          out_version_reference));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetNewResourceId(
    int64_t* out_resource_id) {
  base::RunLoop loop;
  proxy_->GetNewResourceId(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_resource_id
,
             int64_t resource_id) {*out_resource_id = std::move(resource_id);
            loop->Quit();
          },
          &loop,
          out_resource_id));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::StoreUncommittedResourceId(
    int64_t resource_id, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->StoreUncommittedResourceId(std::move(resource_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::DoomUncommittedResources(
    const std::vector<int64_t>& resource_ids, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->DoomUncommittedResources(std::move(resource_ids),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetUserData(
    int64_t registration_id, const std::vector<std::string>& keys, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<std::string>* out_values) {
  base::RunLoop loop;
  proxy_->GetUserData(std::move(registration_id),std::move(keys),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<std::string>* out_values
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const std::vector<std::string>& values) {*out_status = std::move(status);*out_values = std::move(values);
            loop->Quit();
          },
          &loop,
          out_status,
          out_values));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::StoreUserData(
    int64_t registration_id, const ::url::Origin& origin, std::vector<ServiceWorkerUserDataPtr> user_data, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->StoreUserData(std::move(registration_id),std::move(origin),std::move(user_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::ClearUserData(
    int64_t registration_id, const std::vector<std::string>& keys, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->ClearUserData(std::move(registration_id),std::move(keys),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetUserDataByKeyPrefix(
    int64_t registration_id, const std::string& key_prefix, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<std::string>* out_values) {
  base::RunLoop loop;
  proxy_->GetUserDataByKeyPrefix(std::move(registration_id),std::move(key_prefix),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<std::string>* out_values
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const std::vector<std::string>& values) {*out_status = std::move(status);*out_values = std::move(values);
            loop->Quit();
          },
          &loop,
          out_status,
          out_values));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetUserKeysAndDataByKeyPrefix(
    int64_t registration_id, const std::string& key_prefix, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, base::flat_map<std::string, std::string>* out_user_data) {
  base::RunLoop loop;
  proxy_->GetUserKeysAndDataByKeyPrefix(std::move(registration_id),std::move(key_prefix),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             base::flat_map<std::string, std::string>* out_user_data
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const base::flat_map<std::string, std::string>& user_data) {*out_status = std::move(status);*out_user_data = std::move(user_data);
            loop->Quit();
          },
          &loop,
          out_status,
          out_user_data));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::ClearUserDataByKeyPrefixes(
    int64_t registratation_id, const std::vector<std::string>& key_prefixes, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->ClearUserDataByKeyPrefixes(std::move(registratation_id),std::move(key_prefixes),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetUserDataForAllRegistrations(
    const std::string& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<ServiceWorkerUserDataPtr>* out_values) {
  base::RunLoop loop;
  proxy_->GetUserDataForAllRegistrations(std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<ServiceWorkerUserDataPtr>* out_values
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             std::vector<ServiceWorkerUserDataPtr> values) {*out_status = std::move(status);*out_values = std::move(values);
            loop->Quit();
          },
          &loop,
          out_status,
          out_values));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetUserDataForAllRegistrationsByKeyPrefix(
    const std::string& key_prefix, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<ServiceWorkerUserDataPtr>* out_values) {
  base::RunLoop loop;
  proxy_->GetUserDataForAllRegistrationsByKeyPrefix(std::move(key_prefix),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<ServiceWorkerUserDataPtr>* out_values
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             std::vector<ServiceWorkerUserDataPtr> values) {*out_status = std::move(status);*out_values = std::move(values);
            loop->Quit();
          },
          &loop,
          out_status,
          out_values));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::ClearUserDataForAllRegistrationsByKeyPrefix(
    const std::string& key_prefix, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->ClearUserDataForAllRegistrationsByKeyPrefix(std::move(key_prefix),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::PerformStorageCleanup(
    ) {
  base::RunLoop loop;
  proxy_->PerformStorageCleanup(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::ApplyPolicyUpdates(
    std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->ApplyPolicyUpdates(std::move(policy_updates),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetPurgingResourceIdsForTest(
    ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<int64_t>* out_resource_ids) {
  base::RunLoop loop;
  proxy_->GetPurgingResourceIdsForTest(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<int64_t>* out_resource_ids
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const std::vector<int64_t>& resource_ids) {*out_status = std::move(status);*out_resource_ids = std::move(resource_ids);
            loop->Quit();
          },
          &loop,
          out_status,
          out_resource_ids));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetPurgeableResourceIdsForTest(
    ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<int64_t>* out_resource_ids) {
  base::RunLoop loop;
  proxy_->GetPurgeableResourceIdsForTest(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<int64_t>* out_resource_ids
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const std::vector<int64_t>& resource_ids) {*out_status = std::move(status);*out_resource_ids = std::move(resource_ids);
            loop->Quit();
          },
          &loop,
          out_status,
          out_resource_ids));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::GetUncommittedResourceIdsForTest(
    ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<int64_t>* out_resource_ids) {
  base::RunLoop loop;
  proxy_->GetUncommittedResourceIdsForTest(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<int64_t>* out_resource_ids
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const std::vector<int64_t>& resource_ids) {*out_status = std::move(status);*out_resource_ids = std::move(resource_ids);
            loop->Quit();
          },
          &loop,
          out_status,
          out_resource_ids));
  loop.Run();
}
void ServiceWorkerStorageControlAsyncWaiter::SetPurgingCompleteCallbackForTest(
    ) {
  base::RunLoop loop;
  proxy_->SetPurgingCompleteCallbackForTest(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace mojom
}  // namespace storage

#if defined(__clang__)
#pragma clang diagnostic pop
#endif