// components/services/storage/public/mojom/service_worker_storage_control.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/service_worker_storage_control.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-params-data.h"
#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
ServiceWorkerLiveVersionInfo::ServiceWorkerLiveVersionInfo()
    : id(),
      purgeable_resources(),
      reference() {}

ServiceWorkerLiveVersionInfo::ServiceWorkerLiveVersionInfo(
    int64_t id_in,
    std::vector<int64_t> purgeable_resources_in,
    ::mojo::PendingReceiver<ServiceWorkerLiveVersionRef> reference_in)
    : id(std::move(id_in)),
      purgeable_resources(std::move(purgeable_resources_in)),
      reference(std::move(reference_in)) {}

ServiceWorkerLiveVersionInfo::~ServiceWorkerLiveVersionInfo() = default;

void ServiceWorkerLiveVersionInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "purgeable_resources"), this->purgeable_resources, 
      "<value of type const std::vector<int64_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reference"), this->reference, 
      "<value of type ::mojo::PendingReceiver<ServiceWorkerLiveVersionRef>>");
}

bool ServiceWorkerLiveVersionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerFindRegistrationResult::ServiceWorkerFindRegistrationResult()
    : version_reference(),
      registration(),
      resources() {}

ServiceWorkerFindRegistrationResult::ServiceWorkerFindRegistrationResult(
    ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> version_reference_in,
    ::storage::mojom::ServiceWorkerRegistrationDataPtr registration_in,
    std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources_in)
    : version_reference(std::move(version_reference_in)),
      registration(std::move(registration_in)),
      resources(std::move(resources_in)) {}

ServiceWorkerFindRegistrationResult::~ServiceWorkerFindRegistrationResult() = default;

void ServiceWorkerFindRegistrationResult::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_reference"), this->version_reference, 
      "<value of type ::mojo::PendingRemote<ServiceWorkerLiveVersionRef>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration"), this->registration, 
      "<value of type ::storage::mojom::ServiceWorkerRegistrationDataPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resources"), this->resources, 
      "<value of type std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr>>");
}

bool ServiceWorkerFindRegistrationResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerUserData::ServiceWorkerUserData()
    : registration_id(),
      key(),
      value() {}

ServiceWorkerUserData::ServiceWorkerUserData(
    int64_t registration_id_in,
    const std::string& key_in,
    const std::string& value_in)
    : registration_id(std::move(registration_id_in)),
      key(std::move(key_in)),
      value(std::move(value_in)) {}

ServiceWorkerUserData::~ServiceWorkerUserData() = default;
size_t ServiceWorkerUserData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->registration_id);
  seed = mojo::internal::Hash(seed, this->key);
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void ServiceWorkerUserData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration_id"), this->registration_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value, 
      "<value of type const std::string&>");
}

bool ServiceWorkerUserData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ServiceWorkerLiveVersionRef::Name_[] = "storage.mojom.ServiceWorkerLiveVersionRef";

ServiceWorkerLiveVersionRefProxy::ServiceWorkerLiveVersionRefProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool ServiceWorkerLiveVersionRefStubDispatch::Accept(
    ServiceWorkerLiveVersionRef* impl,
    mojo::Message* message) {
  return false;
}

// static
bool ServiceWorkerLiveVersionRefStubDispatch::AcceptWithResponder(
    ServiceWorkerLiveVersionRef* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}



bool ServiceWorkerLiveVersionRefRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::ServiceWorkerLiveVersionRef::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

const char ServiceWorkerDataPipeStateNotifier::Name_[] = "storage.mojom.ServiceWorkerDataPipeStateNotifier";

ServiceWorkerDataPipeStateNotifierProxy::ServiceWorkerDataPipeStateNotifierProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerDataPipeStateNotifierProxy::OnComplete(
    int32_t in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerDataPipeStateNotifier::OnComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerDataPipeStateNotifier_OnComplete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerDataPipeStateNotifier_OnComplete_Params_Data> params(
          message);
  params.Allocate();
  params->status = in_status;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerDataPipeStateNotifier::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ServiceWorkerDataPipeStateNotifierStubDispatch::Accept(
    ServiceWorkerDataPipeStateNotifier* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorkerDataPipeStateNotifier_OnComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerDataPipeStateNotifier::OnComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerDataPipeStateNotifier::OnComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerDataPipeStateNotifier_OnComplete_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerDataPipeStateNotifier_OnComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_status{};
      ServiceWorkerDataPipeStateNotifier_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_status = input_data_view.status();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerDataPipeStateNotifier::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(
std::move(p_status));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerDataPipeStateNotifierStubDispatch::AcceptWithResponder(
    ServiceWorkerDataPipeStateNotifier* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerDataPipeStateNotifier_OnComplete_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerDataPipeStateNotifierValidationInfo[] = {
    {internal::kServiceWorkerDataPipeStateNotifier_OnComplete_Name,
     {&internal::ServiceWorkerDataPipeStateNotifier_OnComplete_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ServiceWorkerDataPipeStateNotifierRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::ServiceWorkerDataPipeStateNotifier::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerDataPipeStateNotifierValidationInfo);
}

const char ServiceWorkerResourceReader::Name_[] = "storage.mojom.ServiceWorkerResourceReader";

class ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback(
      ServiceWorkerResourceReader::ReadResponseHeadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerResourceReader::ReadResponseHeadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback);
};

class ServiceWorkerResourceReader_ReadData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerResourceReader_ReadData_ForwardToCallback(
      ServiceWorkerResourceReader::ReadDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerResourceReader::ReadDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerResourceReader_ReadData_ForwardToCallback);
};

ServiceWorkerResourceReaderProxy::ServiceWorkerResourceReaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerResourceReaderProxy::ReadResponseHead(
    ReadResponseHeadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerResourceReader::ReadResponseHead");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerResourceReader_ReadResponseHead_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceReader_ReadResponseHead_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceReader::Name_);
  message.set_method_name("ReadResponseHead");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerResourceReaderProxy::ReadData(
    int64_t in_size, ::mojo::PendingRemote<ServiceWorkerDataPipeStateNotifier> in_notifier, ReadDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerResourceReader::ReadData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notifier"), in_notifier, 
                        "<value of type ::mojo::PendingRemote<ServiceWorkerDataPipeStateNotifier>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerResourceReader_ReadData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceReader_ReadData_Params_Data> params(
          message);
  params.Allocate();
  params->size = in_size;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::ServiceWorkerDataPipeStateNotifierInterfaceBase>>(
      in_notifier, &params->notifier, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->notifier),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid notifier in ServiceWorkerResourceReader.ReadData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceReader::Name_);
  message.set_method_name("ReadData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerResourceReader_ReadData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder {
 public:
  static ServiceWorkerResourceReader::ReadResponseHeadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder> proxy(
        new ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerResourceReader::ReadResponseHeadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status, ::network::mojom::URLResponseHeadPtr in_response_head, base::Optional<::mojo_base::BigBuffer> in_metadata);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder);
};

bool ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerResourceReader::ReadResponseHeadCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_status{};
  ::network::mojom::URLResponseHeadPtr p_response_head{};
  base::Optional<::mojo_base::BigBuffer> p_metadata{};
  ServiceWorkerResourceReader_ReadResponseHead_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status = input_data_view.status();
  if (success && !input_data_view.ReadResponseHead(&p_response_head))
    success = false;
  if (success && !input_data_view.ReadMetadata(&p_metadata))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerResourceReader::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_response_head), 
std::move(p_metadata));
  return true;
}

void ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder::Run(
    int32_t in_status, ::network::mojom::URLResponseHeadPtr in_response_head, base::Optional<::mojo_base::BigBuffer> in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerResourceReader::ReadResponseHeadCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_head"), in_response_head, 
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata, 
                        "<value of type base::Optional<::mojo_base::BigBuffer>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerResourceReader_ReadResponseHead_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->status = in_status;
  mojo::internal::MessageFragment<
      typename decltype(params->response_head)::BaseType> response_head_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_response_head, response_head_fragment);
  params->response_head.Set(
      response_head_fragment.is_null() ? nullptr : response_head_fragment.data());
  mojo::internal::MessageFragment<decltype(params->metadata)>
      metadata_fragment(params.message());
  metadata_fragment.Claim(&params->metadata);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_metadata, metadata_fragment, true);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerResourceReader::ReadResponseHeadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceReader::Name_);
  message.set_method_name("ReadResponseHead");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerResourceReader_ReadData_ProxyToResponder {
 public:
  static ServiceWorkerResourceReader::ReadDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerResourceReader_ReadData_ProxyToResponder> proxy(
        new ServiceWorkerResourceReader_ReadData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerResourceReader_ReadData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerResourceReader_ReadData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerResourceReader_ReadData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerResourceReader::ReadDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::ScopedDataPipeConsumerHandle in_pipe);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerResourceReader_ReadData_ProxyToResponder);
};

bool ServiceWorkerResourceReader_ReadData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerResourceReader::ReadDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerResourceReader_ReadData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerResourceReader_ReadData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::mojo::ScopedDataPipeConsumerHandle p_pipe{};
  ServiceWorkerResourceReader_ReadData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_pipe = input_data_view.TakePipe();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerResourceReader::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_pipe));
  return true;
}

void ServiceWorkerResourceReader_ReadData_ProxyToResponder::Run(
    ::mojo::ScopedDataPipeConsumerHandle in_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerResourceReader::ReadDataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pipe"), in_pipe, 
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerResourceReader_ReadData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceReader_ReadData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_pipe, &params->pipe, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerResourceReader::ReadDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceReader::Name_);
  message.set_method_name("ReadData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerResourceReaderStubDispatch::Accept(
    ServiceWorkerResourceReader* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorkerResourceReader_ReadResponseHead_Name: {
      break;
    }
    case internal::kServiceWorkerResourceReader_ReadData_Name: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerResourceReaderStubDispatch::AcceptWithResponder(
    ServiceWorkerResourceReader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerResourceReader_ReadResponseHead_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerResourceReader::ReadResponseHead",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerResourceReader::ReadResponseHead");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerResourceReader_ReadResponseHead_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerResourceReader_ReadResponseHead_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerResourceReader_ReadResponseHead_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerResourceReader::Name_, 0, false);
        return false;
      }
      ServiceWorkerResourceReader::ReadResponseHeadCallback callback =
          ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadResponseHead(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerResourceReader_ReadData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerResourceReader::ReadData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerResourceReader::ReadData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerResourceReader_ReadData_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerResourceReader_ReadData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_size{};
      ::mojo::PendingRemote<ServiceWorkerDataPipeStateNotifier> p_notifier{};
      ServiceWorkerResourceReader_ReadData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_size = input_data_view.size();
      if (success) {
        p_notifier =
            input_data_view.TakeNotifier<decltype(p_notifier)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerResourceReader::Name_, 1, false);
        return false;
      }
      ServiceWorkerResourceReader::ReadDataCallback callback =
          ServiceWorkerResourceReader_ReadData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadData(
std::move(p_size), 
std::move(p_notifier), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerResourceReaderValidationInfo[] = {
    {internal::kServiceWorkerResourceReader_ReadResponseHead_Name,
     {&internal::ServiceWorkerResourceReader_ReadResponseHead_Params_Data::Validate,
      &internal::ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerResourceReader_ReadData_Name,
     {&internal::ServiceWorkerResourceReader_ReadData_Params_Data::Validate,
      &internal::ServiceWorkerResourceReader_ReadData_ResponseParams_Data::Validate}},
};

bool ServiceWorkerResourceReaderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::ServiceWorkerResourceReader::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerResourceReaderValidationInfo);
}

bool ServiceWorkerResourceReaderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::ServiceWorkerResourceReader::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kServiceWorkerResourceReaderValidationInfo);

}
const char ServiceWorkerResourceWriter::Name_[] = "storage.mojom.ServiceWorkerResourceWriter";

class ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback(
      ServiceWorkerResourceWriter::WriteResponseHeadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerResourceWriter::WriteResponseHeadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback);
};

class ServiceWorkerResourceWriter_WriteData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerResourceWriter_WriteData_ForwardToCallback(
      ServiceWorkerResourceWriter::WriteDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerResourceWriter::WriteDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerResourceWriter_WriteData_ForwardToCallback);
};

ServiceWorkerResourceWriterProxy::ServiceWorkerResourceWriterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerResourceWriterProxy::WriteResponseHead(
    ::network::mojom::URLResponseHeadPtr in_response_head, WriteResponseHeadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerResourceWriter::WriteResponseHead", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_head"), in_response_head, 
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerResourceWriter_WriteResponseHead_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceWriter_WriteResponseHead_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response_head)::BaseType> response_head_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_response_head, response_head_fragment);
  params->response_head.Set(
      response_head_fragment.is_null() ? nullptr : response_head_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response_head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_head in ServiceWorkerResourceWriter.WriteResponseHead request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceWriter::Name_);
  message.set_method_name("WriteResponseHead");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerResourceWriterProxy::WriteData(
    ::mojo_base::BigBuffer in_data, WriteDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerResourceWriter::WriteData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerResourceWriter_WriteData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceWriter_WriteData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ServiceWorkerResourceWriter.WriteData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceWriter::Name_);
  message.set_method_name("WriteData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerResourceWriter_WriteData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder {
 public:
  static ServiceWorkerResourceWriter::WriteResponseHeadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder> proxy(
        new ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerResourceWriter::WriteResponseHeadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder);
};

bool ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerResourceWriter::WriteResponseHeadCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_status{};
  ServiceWorkerResourceWriter_WriteResponseHead_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status = input_data_view.status();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerResourceWriter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder::Run(
    int32_t in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerResourceWriter::WriteResponseHeadCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerResourceWriter_WriteResponseHead_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->status = in_status;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerResourceWriter::WriteResponseHeadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceWriter::Name_);
  message.set_method_name("WriteResponseHead");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerResourceWriter_WriteData_ProxyToResponder {
 public:
  static ServiceWorkerResourceWriter::WriteDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerResourceWriter_WriteData_ProxyToResponder> proxy(
        new ServiceWorkerResourceWriter_WriteData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerResourceWriter_WriteData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerResourceWriter_WriteData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerResourceWriter_WriteData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerResourceWriter::WriteDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerResourceWriter_WriteData_ProxyToResponder);
};

bool ServiceWorkerResourceWriter_WriteData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerResourceWriter::WriteDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerResourceWriter_WriteData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerResourceWriter_WriteData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_status{};
  ServiceWorkerResourceWriter_WriteData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status = input_data_view.status();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerResourceWriter::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerResourceWriter_WriteData_ProxyToResponder::Run(
    int32_t in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerResourceWriter::WriteDataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerResourceWriter_WriteData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceWriter_WriteData_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->status = in_status;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerResourceWriter::WriteDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceWriter::Name_);
  message.set_method_name("WriteData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerResourceWriterStubDispatch::Accept(
    ServiceWorkerResourceWriter* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorkerResourceWriter_WriteResponseHead_Name: {
      break;
    }
    case internal::kServiceWorkerResourceWriter_WriteData_Name: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerResourceWriterStubDispatch::AcceptWithResponder(
    ServiceWorkerResourceWriter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerResourceWriter_WriteResponseHead_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerResourceWriter::WriteResponseHead",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerResourceWriter::WriteResponseHead");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerResourceWriter_WriteResponseHead_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerResourceWriter_WriteResponseHead_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::network::mojom::URLResponseHeadPtr p_response_head{};
      ServiceWorkerResourceWriter_WriteResponseHead_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponseHead(&p_response_head))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerResourceWriter::Name_, 0, false);
        return false;
      }
      ServiceWorkerResourceWriter::WriteResponseHeadCallback callback =
          ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteResponseHead(
std::move(p_response_head), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerResourceWriter_WriteData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerResourceWriter::WriteData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerResourceWriter::WriteData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerResourceWriter_WriteData_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerResourceWriter_WriteData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo_base::BigBuffer p_data{};
      ServiceWorkerResourceWriter_WriteData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerResourceWriter::Name_, 1, false);
        return false;
      }
      ServiceWorkerResourceWriter::WriteDataCallback callback =
          ServiceWorkerResourceWriter_WriteData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteData(
std::move(p_data), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerResourceWriterValidationInfo[] = {
    {internal::kServiceWorkerResourceWriter_WriteResponseHead_Name,
     {&internal::ServiceWorkerResourceWriter_WriteResponseHead_Params_Data::Validate,
      &internal::ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerResourceWriter_WriteData_Name,
     {&internal::ServiceWorkerResourceWriter_WriteData_Params_Data::Validate,
      &internal::ServiceWorkerResourceWriter_WriteData_ResponseParams_Data::Validate}},
};

bool ServiceWorkerResourceWriterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::ServiceWorkerResourceWriter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerResourceWriterValidationInfo);
}

bool ServiceWorkerResourceWriterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::ServiceWorkerResourceWriter::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kServiceWorkerResourceWriterValidationInfo);

}
const char ServiceWorkerResourceMetadataWriter::Name_[] = "storage.mojom.ServiceWorkerResourceMetadataWriter";

class ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback(
      ServiceWorkerResourceMetadataWriter::WriteMetadataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerResourceMetadataWriter::WriteMetadataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback);
};

ServiceWorkerResourceMetadataWriterProxy::ServiceWorkerResourceMetadataWriterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerResourceMetadataWriterProxy::WriteMetadata(
    ::mojo_base::BigBuffer in_data, WriteMetadataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerResourceMetadataWriter::WriteMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerResourceMetadataWriter_WriteMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ServiceWorkerResourceMetadataWriter.WriteMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceMetadataWriter::Name_);
  message.set_method_name("WriteMetadata");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder {
 public:
  static ServiceWorkerResourceMetadataWriter::WriteMetadataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder> proxy(
        new ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerResourceMetadataWriter::WriteMetadataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder);
};

bool ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerResourceMetadataWriter::WriteMetadataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_status{};
  ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status = input_data_view.status();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerResourceMetadataWriter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder::Run(
    int32_t in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerResourceMetadataWriter::WriteMetadataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerResourceMetadataWriter_WriteMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->status = in_status;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerResourceMetadataWriter::WriteMetadataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceMetadataWriter::Name_);
  message.set_method_name("WriteMetadata");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerResourceMetadataWriterStubDispatch::Accept(
    ServiceWorkerResourceMetadataWriter* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorkerResourceMetadataWriter_WriteMetadata_Name: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerResourceMetadataWriterStubDispatch::AcceptWithResponder(
    ServiceWorkerResourceMetadataWriter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerResourceMetadataWriter_WriteMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerResourceMetadataWriter::WriteMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerResourceMetadataWriter::WriteMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo_base::BigBuffer p_data{};
      ServiceWorkerResourceMetadataWriter_WriteMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerResourceMetadataWriter::Name_, 0, false);
        return false;
      }
      ServiceWorkerResourceMetadataWriter::WriteMetadataCallback callback =
          ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteMetadata(
std::move(p_data), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerResourceMetadataWriterValidationInfo[] = {
    {internal::kServiceWorkerResourceMetadataWriter_WriteMetadata_Name,
     {&internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data::Validate,
      &internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data::Validate}},
};

bool ServiceWorkerResourceMetadataWriterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::ServiceWorkerResourceMetadataWriter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerResourceMetadataWriterValidationInfo);
}

bool ServiceWorkerResourceMetadataWriterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::ServiceWorkerResourceMetadataWriter::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kServiceWorkerResourceMetadataWriterValidationInfo);

}
const char ServiceWorkerStorageControl::Name_[] = "storage.mojom.ServiceWorkerStorageControl";

class ServiceWorkerStorageControl_Disable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_Disable_ForwardToCallback(
      ServiceWorkerStorageControl::DisableCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::DisableCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_Disable_ForwardToCallback);
};

class ServiceWorkerStorageControl_Delete_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_Delete_ForwardToCallback(
      ServiceWorkerStorageControl::DeleteCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::DeleteCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_Delete_ForwardToCallback);
};

class ServiceWorkerStorageControl_Recover_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_Recover_ForwardToCallback(
      ServiceWorkerStorageControl::RecoverCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::RecoverCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_Recover_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetRegisteredOrigins_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetRegisteredOrigins_ForwardToCallback(
      ServiceWorkerStorageControl::GetRegisteredOriginsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetRegisteredOriginsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetRegisteredOrigins_ForwardToCallback);
};

class ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback(
      ServiceWorkerStorageControl::FindRegistrationForClientUrlCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::FindRegistrationForClientUrlCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback);
};

class ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback(
      ServiceWorkerStorageControl::FindRegistrationForScopeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::FindRegistrationForScopeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback);
};

class ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback(
      ServiceWorkerStorageControl::FindRegistrationForIdCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::FindRegistrationForIdCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetRegistrationsForOrigin_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetRegistrationsForOrigin_ForwardToCallback(
      ServiceWorkerStorageControl::GetRegistrationsForOriginCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetRegistrationsForOriginCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetRegistrationsForOrigin_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetUsageForOrigin_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUsageForOrigin_ForwardToCallback(
      ServiceWorkerStorageControl::GetUsageForOriginCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUsageForOriginCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUsageForOrigin_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback(
      ServiceWorkerStorageControl::GetAllRegistrationsDeprecatedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetAllRegistrationsDeprecatedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback);
};

class ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback(
      ServiceWorkerStorageControl::StoreRegistrationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::StoreRegistrationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback);
};

class ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback(
      ServiceWorkerStorageControl::DeleteRegistrationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::DeleteRegistrationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback);
};

class ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback(
      ServiceWorkerStorageControl::UpdateToActiveStateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::UpdateToActiveStateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback);
};

class ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback(
      ServiceWorkerStorageControl::UpdateLastUpdateCheckTimeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::UpdateLastUpdateCheckTimeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback);
};

class ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback(
      ServiceWorkerStorageControl::UpdateNavigationPreloadEnabledCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::UpdateNavigationPreloadEnabledCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback);
};

class ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback(
      ServiceWorkerStorageControl::UpdateNavigationPreloadHeaderCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::UpdateNavigationPreloadHeaderCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback(
      ServiceWorkerStorageControl::GetNewRegistrationIdCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetNewRegistrationIdCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback(
      ServiceWorkerStorageControl::GetNewVersionIdCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetNewVersionIdCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback(
      ServiceWorkerStorageControl::GetNewResourceIdCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetNewResourceIdCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback);
};

class ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback(
      ServiceWorkerStorageControl::StoreUncommittedResourceIdCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::StoreUncommittedResourceIdCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback);
};

class ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback(
      ServiceWorkerStorageControl::DoomUncommittedResourcesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::DoomUncommittedResourcesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetUserData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUserData_ForwardToCallback(
      ServiceWorkerStorageControl::GetUserDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUserDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUserData_ForwardToCallback);
};

class ServiceWorkerStorageControl_StoreUserData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_StoreUserData_ForwardToCallback(
      ServiceWorkerStorageControl::StoreUserDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::StoreUserDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_StoreUserData_ForwardToCallback);
};

class ServiceWorkerStorageControl_ClearUserData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_ClearUserData_ForwardToCallback(
      ServiceWorkerStorageControl::ClearUserDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::ClearUserDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_ClearUserData_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback(
      ServiceWorkerStorageControl::GetUserDataByKeyPrefixCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUserDataByKeyPrefixCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback(
      ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefixCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefixCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback);
};

class ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback(
      ServiceWorkerStorageControl::ClearUserDataByKeyPrefixesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::ClearUserDataByKeyPrefixesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback(
      ServiceWorkerStorageControl::GetUserDataForAllRegistrationsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUserDataForAllRegistrationsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback(
      ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefixCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefixCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback);
};

class ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback(
      ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefixCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefixCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback);
};

class ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback(
      ServiceWorkerStorageControl::PerformStorageCleanupCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::PerformStorageCleanupCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback);
};

class ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback(
      ServiceWorkerStorageControl::ApplyPolicyUpdatesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::ApplyPolicyUpdatesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback(
      ServiceWorkerStorageControl::GetPurgingResourceIdsForTestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetPurgingResourceIdsForTestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback(
      ServiceWorkerStorageControl::GetPurgeableResourceIdsForTestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetPurgeableResourceIdsForTestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback);
};

class ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback(
      ServiceWorkerStorageControl::GetUncommittedResourceIdsForTestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUncommittedResourceIdsForTestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback);
};

class ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback(
      ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback);
};

ServiceWorkerStorageControlProxy::ServiceWorkerStorageControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerStorageControlProxy::Disable(
    DisableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerStorageControl::Disable");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_Disable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_Disable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("Disable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_Disable_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::Delete(
    DeleteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerStorageControl::Delete");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_Delete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_Delete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("Delete");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_Delete_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::Recover(
    std::vector<ServiceWorkerLiveVersionInfoPtr> in_versions, RecoverCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::Recover", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("versions"), in_versions, 
                        "<value of type std::vector<ServiceWorkerLiveVersionInfoPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_Recover_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_Recover_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->versions)::BaseType>
      versions_fragment(params.message());
  const mojo::internal::ContainerValidateParams versions_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerLiveVersionInfoDataView>>(
      in_versions, versions_fragment, &versions_validate_params);
  params->versions.Set(
      versions_fragment.is_null() ? nullptr : versions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->versions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null versions in ServiceWorkerStorageControl.Recover request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("Recover");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_Recover_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetRegisteredOrigins(
    GetRegisteredOriginsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerStorageControl::GetRegisteredOrigins");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetRegisteredOrigins_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetRegisteredOrigins_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetRegisteredOrigins");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetRegisteredOrigins_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::FindRegistrationForClientUrl(
    const ::GURL& in_client_url, FindRegistrationForClientUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::FindRegistrationForClientUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_url"), in_client_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_FindRegistrationForClientUrl_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_url)::BaseType> client_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_client_url, client_url_fragment);
  params->client_url.Set(
      client_url_fragment.is_null() ? nullptr : client_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->client_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_url in ServiceWorkerStorageControl.FindRegistrationForClientUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("FindRegistrationForClientUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::FindRegistrationForScope(
    const ::GURL& in_scope, FindRegistrationForScopeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::FindRegistrationForScope", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scope"), in_scope, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_FindRegistrationForScope_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->scope)::BaseType> scope_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_scope, scope_fragment);
  params->scope.Set(
      scope_fragment.is_null() ? nullptr : scope_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->scope.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scope in ServiceWorkerStorageControl.FindRegistrationForScope request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("FindRegistrationForScope");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::FindRegistrationForId(
    int64_t in_registration_id, const base::Optional<::url::Origin>& in_origin, FindRegistrationForIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::FindRegistrationForId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const base::Optional<::url::Origin>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_FindRegistrationForId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_FindRegistrationForId_Params_Data> params(
          message);
  params.Allocate();
  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("FindRegistrationForId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetRegistrationsForOrigin(
    const ::url::Origin& in_origin, GetRegistrationsForOriginCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::GetRegistrationsForOrigin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::url::Origin&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetRegistrationsForOrigin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetRegistrationsForOrigin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in ServiceWorkerStorageControl.GetRegistrationsForOrigin request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetRegistrationsForOrigin");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetRegistrationsForOrigin_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetUsageForOrigin(
    const ::url::Origin& in_origin, GetUsageForOriginCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::GetUsageForOrigin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::url::Origin&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUsageForOrigin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUsageForOrigin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in ServiceWorkerStorageControl.GetUsageForOrigin request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUsageForOrigin");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUsageForOrigin_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetAllRegistrationsDeprecated(
    GetAllRegistrationsDeprecatedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerStorageControl::GetAllRegistrationsDeprecated");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetAllRegistrationsDeprecated");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::StoreRegistration(
    ::storage::mojom::ServiceWorkerRegistrationDataPtr in_registration, std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> in_resources, StoreRegistrationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::StoreRegistration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration, 
                        "<value of type ::storage::mojom::ServiceWorkerRegistrationDataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources, 
                        "<value of type std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_StoreRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_StoreRegistration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerRegistrationDataDataView>(
      in_registration, registration_fragment);
  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->registration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registration in ServiceWorkerStorageControl.StoreRegistration request");
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  const mojo::internal::ContainerValidateParams resources_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerResourceRecordDataView>>(
      in_resources, resources_fragment, &resources_validate_params);
  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in ServiceWorkerStorageControl.StoreRegistration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("StoreRegistration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::DeleteRegistration(
    int64_t in_registration_id, const ::GURL& in_origin, DeleteRegistrationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::DeleteRegistration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_DeleteRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_DeleteRegistration_Params_Data> params(
          message);
  params.Allocate();
  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in ServiceWorkerStorageControl.DeleteRegistration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("DeleteRegistration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::UpdateToActiveState(
    int64_t in_registration_id, const ::GURL& in_origin, UpdateToActiveStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::UpdateToActiveState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_UpdateToActiveState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateToActiveState_Params_Data> params(
          message);
  params.Allocate();
  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in ServiceWorkerStorageControl.UpdateToActiveState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateToActiveState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::UpdateLastUpdateCheckTime(
    int64_t in_registration_id, const ::GURL& in_origin, ::base::Time in_last_update_check_time, UpdateLastUpdateCheckTimeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::UpdateLastUpdateCheckTime", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("last_update_check_time"), in_last_update_check_time, 
                        "<value of type ::base::Time>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data> params(
          message);
  params.Allocate();
  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in ServiceWorkerStorageControl.UpdateLastUpdateCheckTime request");
  mojo::internal::MessageFragment<
      typename decltype(params->last_update_check_time)::BaseType> last_update_check_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_update_check_time, last_update_check_time_fragment);
  params->last_update_check_time.Set(
      last_update_check_time_fragment.is_null() ? nullptr : last_update_check_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->last_update_check_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_update_check_time in ServiceWorkerStorageControl.UpdateLastUpdateCheckTime request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateLastUpdateCheckTime");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::UpdateNavigationPreloadEnabled(
    int64_t in_registration_id, const ::GURL& in_origin, bool in_enable, UpdateNavigationPreloadEnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable"), in_enable, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data> params(
          message);
  params.Allocate();
  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in ServiceWorkerStorageControl.UpdateNavigationPreloadEnabled request");
  params->enable = in_enable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateNavigationPreloadEnabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::UpdateNavigationPreloadHeader(
    int64_t in_registration_id, const ::GURL& in_origin, const std::string& in_value, UpdateNavigationPreloadHeaderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadHeader", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data> params(
          message);
  params.Allocate();
  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in ServiceWorkerStorageControl.UpdateNavigationPreloadHeader request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_value, value_fragment);
  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in ServiceWorkerStorageControl.UpdateNavigationPreloadHeader request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateNavigationPreloadHeader");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetNewRegistrationId(
    GetNewRegistrationIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerStorageControl::GetNewRegistrationId");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetNewRegistrationId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetNewRegistrationId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetNewVersionId(
    GetNewVersionIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerStorageControl::GetNewVersionId");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetNewVersionId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetNewVersionId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetNewVersionId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetNewResourceId(
    GetNewResourceIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerStorageControl::GetNewResourceId");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetNewResourceId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetNewResourceId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetNewResourceId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::CreateResourceReader(
    int64_t in_resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceReader> in_reader) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::CreateResourceReader", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_id"), in_resource_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reader"), in_reader, 
                        "<value of type ::mojo::PendingReceiver<ServiceWorkerResourceReader>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_CreateResourceReader_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_CreateResourceReader_Params_Data> params(
          message);
  params.Allocate();
  params->resource_id = in_resource_id;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::ServiceWorkerResourceReaderInterfaceBase>>(
      in_reader, &params->reader, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->reader),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid reader in ServiceWorkerStorageControl.CreateResourceReader request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("CreateResourceReader");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerStorageControlProxy::CreateResourceWriter(
    int64_t in_resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceWriter> in_writer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::CreateResourceWriter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_id"), in_resource_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writer"), in_writer, 
                        "<value of type ::mojo::PendingReceiver<ServiceWorkerResourceWriter>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_CreateResourceWriter_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_CreateResourceWriter_Params_Data> params(
          message);
  params.Allocate();
  params->resource_id = in_resource_id;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::ServiceWorkerResourceWriterInterfaceBase>>(
      in_writer, &params->writer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->writer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid writer in ServiceWorkerStorageControl.CreateResourceWriter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("CreateResourceWriter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerStorageControlProxy::CreateResourceMetadataWriter(
    int64_t in_resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter> in_writer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::CreateResourceMetadataWriter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_id"), in_resource_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writer"), in_writer, 
                        "<value of type ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_CreateResourceMetadataWriter_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data> params(
          message);
  params.Allocate();
  params->resource_id = in_resource_id;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::ServiceWorkerResourceMetadataWriterInterfaceBase>>(
      in_writer, &params->writer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->writer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid writer in ServiceWorkerStorageControl.CreateResourceMetadataWriter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("CreateResourceMetadataWriter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerStorageControlProxy::StoreUncommittedResourceId(
    int64_t in_resource_id, StoreUncommittedResourceIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::StoreUncommittedResourceId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_id"), in_resource_id, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_StoreUncommittedResourceId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data> params(
          message);
  params.Allocate();
  params->resource_id = in_resource_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("StoreUncommittedResourceId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::DoomUncommittedResources(
    const std::vector<int64_t>& in_resource_ids, DoomUncommittedResourcesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::DoomUncommittedResources", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_ids"), in_resource_ids, 
                        "<value of type const std::vector<int64_t>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_DoomUncommittedResources_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resource_ids)::BaseType>
      resource_ids_fragment(params.message());
  const mojo::internal::ContainerValidateParams resource_ids_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
      in_resource_ids, resource_ids_fragment, &resource_ids_validate_params);
  params->resource_ids.Set(
      resource_ids_fragment.is_null() ? nullptr : resource_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resource_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource_ids in ServiceWorkerStorageControl.DoomUncommittedResources request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("DoomUncommittedResources");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetUserData(
    int64_t in_registration_id, const std::vector<std::string>& in_keys, GetUserDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::GetUserData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys"), in_keys, 
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUserData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserData_Params_Data> params(
          message);
  params.Allocate();
  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->keys)::BaseType>
      keys_fragment(params.message());
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_keys, keys_fragment, &keys_validate_params);
  params->keys.Set(
      keys_fragment.is_null() ? nullptr : keys_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keys in ServiceWorkerStorageControl.GetUserData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUserData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::StoreUserData(
    int64_t in_registration_id, const ::url::Origin& in_origin, std::vector<ServiceWorkerUserDataPtr> in_user_data, StoreUserDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::StoreUserData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_data"), in_user_data, 
                        "<value of type std::vector<ServiceWorkerUserDataPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_StoreUserData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_StoreUserData_Params_Data> params(
          message);
  params.Allocate();
  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in ServiceWorkerStorageControl.StoreUserData request");
  mojo::internal::MessageFragment<
      typename decltype(params->user_data)::BaseType>
      user_data_fragment(params.message());
  const mojo::internal::ContainerValidateParams user_data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerUserDataDataView>>(
      in_user_data, user_data_fragment, &user_data_validate_params);
  params->user_data.Set(
      user_data_fragment.is_null() ? nullptr : user_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->user_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_data in ServiceWorkerStorageControl.StoreUserData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("StoreUserData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_StoreUserData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::ClearUserData(
    int64_t in_registration_id, const std::vector<std::string>& in_keys, ClearUserDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::ClearUserData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys"), in_keys, 
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_ClearUserData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ClearUserData_Params_Data> params(
          message);
  params.Allocate();
  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->keys)::BaseType>
      keys_fragment(params.message());
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_keys, keys_fragment, &keys_validate_params);
  params->keys.Set(
      keys_fragment.is_null() ? nullptr : keys_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keys in ServiceWorkerStorageControl.ClearUserData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ClearUserData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_ClearUserData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetUserDataByKeyPrefix(
    int64_t in_registration_id, const std::string& in_key_prefix, GetUserDataByKeyPrefixCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::GetUserDataByKeyPrefix", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_prefix"), in_key_prefix, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUserDataByKeyPrefix_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data> params(
          message);
  params.Allocate();
  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key_prefix)::BaseType> key_prefix_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key_prefix, key_prefix_fragment);
  params->key_prefix.Set(
      key_prefix_fragment.is_null() ? nullptr : key_prefix_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_prefix.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_prefix in ServiceWorkerStorageControl.GetUserDataByKeyPrefix request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserDataByKeyPrefix");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetUserKeysAndDataByKeyPrefix(
    int64_t in_registration_id, const std::string& in_key_prefix, GetUserKeysAndDataByKeyPrefixCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefix", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_prefix"), in_key_prefix, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data> params(
          message);
  params.Allocate();
  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key_prefix)::BaseType> key_prefix_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key_prefix, key_prefix_fragment);
  params->key_prefix.Set(
      key_prefix_fragment.is_null() ? nullptr : key_prefix_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_prefix.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_prefix in ServiceWorkerStorageControl.GetUserKeysAndDataByKeyPrefix request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserKeysAndDataByKeyPrefix");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::ClearUserDataByKeyPrefixes(
    int64_t in_registratation_id, const std::vector<std::string>& in_key_prefixes, ClearUserDataByKeyPrefixesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::ClearUserDataByKeyPrefixes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registratation_id"), in_registratation_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_prefixes"), in_key_prefixes, 
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data> params(
          message);
  params.Allocate();
  params->registratation_id = in_registratation_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key_prefixes)::BaseType>
      key_prefixes_fragment(params.message());
  const mojo::internal::ContainerValidateParams key_prefixes_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_key_prefixes, key_prefixes_fragment, &key_prefixes_validate_params);
  params->key_prefixes.Set(
      key_prefixes_fragment.is_null() ? nullptr : key_prefixes_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_prefixes.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_prefixes in ServiceWorkerStorageControl.ClearUserDataByKeyPrefixes request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ClearUserDataByKeyPrefixes");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetUserDataForAllRegistrations(
    const std::string& in_key, GetUserDataForAllRegistrationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrations", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUserDataForAllRegistrations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key, key_fragment);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in ServiceWorkerStorageControl.GetUserDataForAllRegistrations request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserDataForAllRegistrations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetUserDataForAllRegistrationsByKeyPrefix(
    const std::string& in_key_prefix, GetUserDataForAllRegistrationsByKeyPrefixCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefix", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_prefix"), in_key_prefix, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_prefix)::BaseType> key_prefix_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key_prefix, key_prefix_fragment);
  params->key_prefix.Set(
      key_prefix_fragment.is_null() ? nullptr : key_prefix_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_prefix.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_prefix in ServiceWorkerStorageControl.GetUserDataForAllRegistrationsByKeyPrefix request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserDataForAllRegistrationsByKeyPrefix");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::ClearUserDataForAllRegistrationsByKeyPrefix(
    const std::string& in_key_prefix, ClearUserDataForAllRegistrationsByKeyPrefixCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefix", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_prefix"), in_key_prefix, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_prefix)::BaseType> key_prefix_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key_prefix, key_prefix_fragment);
  params->key_prefix.Set(
      key_prefix_fragment.is_null() ? nullptr : key_prefix_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_prefix.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_prefix in ServiceWorkerStorageControl.ClearUserDataForAllRegistrationsByKeyPrefix request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ClearUserDataForAllRegistrationsByKeyPrefix");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::PerformStorageCleanup(
    PerformStorageCleanupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerStorageControl::PerformStorageCleanup");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_PerformStorageCleanup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("PerformStorageCleanup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::ApplyPolicyUpdates(
    std::vector<::storage::mojom::StoragePolicyUpdatePtr> in_policy_updates, ApplyPolicyUpdatesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::ServiceWorkerStorageControl::ApplyPolicyUpdates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_updates"), in_policy_updates, 
                        "<value of type std::vector<::storage::mojom::StoragePolicyUpdatePtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_ApplyPolicyUpdates_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->policy_updates)::BaseType>
      policy_updates_fragment(params.message());
  const mojo::internal::ContainerValidateParams policy_updates_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::StoragePolicyUpdateDataView>>(
      in_policy_updates, policy_updates_fragment, &policy_updates_validate_params);
  params->policy_updates.Set(
      policy_updates_fragment.is_null() ? nullptr : policy_updates_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_updates.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_updates in ServiceWorkerStorageControl.ApplyPolicyUpdates request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ApplyPolicyUpdates");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetPurgingResourceIdsForTest(
    GetPurgingResourceIdsForTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForTest");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetPurgingResourceIdsForTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetPurgeableResourceIdsForTest(
    GetPurgeableResourceIdsForTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerStorageControl::GetPurgeableResourceIdsForTest");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetPurgeableResourceIdsForTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::GetUncommittedResourceIdsForTest(
    GetUncommittedResourceIdsForTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerStorageControl::GetUncommittedResourceIdsForTest");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUncommittedResourceIdsForTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerStorageControlProxy::SetPurgingCompleteCallbackForTest(
    SetPurgingCompleteCallbackForTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTest");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("SetPurgingCompleteCallbackForTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ServiceWorkerStorageControl_Disable_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::DisableCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_Disable_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_Disable_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_Disable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_Disable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_Disable_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::DisableCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_Disable_ProxyToResponder);
};

bool ServiceWorkerStorageControl_Disable_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::DisableCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_Disable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_Disable_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ServiceWorkerStorageControl_Disable_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ServiceWorkerStorageControl_Disable_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::DisableCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_Disable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_Disable_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::DisableCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("Disable");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_Delete_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::DeleteCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_Delete_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_Delete_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_Delete_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_Delete_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_Delete_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::DeleteCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_Delete_ProxyToResponder);
};

bool ServiceWorkerStorageControl_Delete_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::DeleteCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_Delete_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_Delete_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_Delete_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerStorageControl_Delete_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::DeleteCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_Delete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_Delete_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::DeleteCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("Delete");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_Recover_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::RecoverCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_Recover_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_Recover_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_Recover_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_Recover_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_Recover_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::RecoverCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_Recover_ProxyToResponder);
};

bool ServiceWorkerStorageControl_Recover_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::RecoverCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_Recover_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_Recover_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ServiceWorkerStorageControl_Recover_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ServiceWorkerStorageControl_Recover_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::RecoverCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_Recover_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_Recover_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::RecoverCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("Recover");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetRegisteredOrigins_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetRegisteredOriginsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetRegisteredOrigins_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetRegisteredOrigins_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetRegisteredOrigins_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetRegisteredOrigins_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetRegisteredOrigins_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetRegisteredOriginsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::url::Origin>& in_origins);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetRegisteredOrigins_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetRegisteredOrigins_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetRegisteredOriginsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetRegisteredOrigins_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetRegisteredOrigins_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::url::Origin> p_origins{};
  ServiceWorkerStorageControl_GetRegisteredOrigins_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOrigins(&p_origins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_origins));
  return true;
}

void ServiceWorkerStorageControl_GetRegisteredOrigins_ProxyToResponder::Run(
    const std::vector<::url::Origin>& in_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetRegisteredOriginsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origins"), in_origins, 
                        "<value of type const std::vector<::url::Origin>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetRegisteredOrigins_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetRegisteredOrigins_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origins)::BaseType>
      origins_fragment(params.message());
  const mojo::internal::ContainerValidateParams origins_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
      in_origins, origins_fragment, &origins_validate_params);
  params->origins.Set(
      origins_fragment.is_null() ? nullptr : origins_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origins.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origins in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetRegisteredOriginsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetRegisteredOrigins");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::FindRegistrationForClientUrlCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::FindRegistrationForClientUrlCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder);
};

bool ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::FindRegistrationForClientUrlCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerFindRegistrationResultPtr p_result{};
  ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_result));
  return true;
}

void ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::FindRegistrationForClientUrlCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ServiceWorkerFindRegistrationResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_FindRegistrationForClientUrl_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerFindRegistrationResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::FindRegistrationForClientUrlCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("FindRegistrationForClientUrl");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::FindRegistrationForScopeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::FindRegistrationForScopeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder);
};

bool ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::FindRegistrationForScopeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerFindRegistrationResultPtr p_result{};
  ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_result));
  return true;
}

void ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::FindRegistrationForScopeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ServiceWorkerFindRegistrationResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_FindRegistrationForScope_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerFindRegistrationResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::FindRegistrationForScopeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("FindRegistrationForScope");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::FindRegistrationForIdCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::FindRegistrationForIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder);
};

bool ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::FindRegistrationForIdCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerFindRegistrationResultPtr p_result{};
  ServiceWorkerStorageControl_FindRegistrationForId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_result));
  return true;
}

void ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::FindRegistrationForIdCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ServiceWorkerFindRegistrationResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_FindRegistrationForId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerFindRegistrationResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::FindRegistrationForIdCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("FindRegistrationForId");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetRegistrationsForOrigin_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetRegistrationsForOriginCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetRegistrationsForOrigin_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetRegistrationsForOrigin_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetRegistrationsForOrigin_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetRegistrationsForOrigin_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetRegistrationsForOrigin_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetRegistrationsForOriginCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<ServiceWorkerFindRegistrationResultPtr> in_registrations);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetRegistrationsForOrigin_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetRegistrationsForOrigin_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetRegistrationsForOriginCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetRegistrationsForOrigin_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetRegistrationsForOrigin_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<ServiceWorkerFindRegistrationResultPtr> p_registrations{};
  ServiceWorkerStorageControl_GetRegistrationsForOrigin_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadRegistrations(&p_registrations))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_registrations));
  return true;
}

void ServiceWorkerStorageControl_GetRegistrationsForOrigin_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<ServiceWorkerFindRegistrationResultPtr> in_registrations) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetRegistrationsForOriginCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registrations"), in_registrations, 
                        "<value of type std::vector<ServiceWorkerFindRegistrationResultPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetRegistrationsForOrigin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetRegistrationsForOrigin_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->registrations)::BaseType>
      registrations_fragment(params.message());
  const mojo::internal::ContainerValidateParams registrations_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerFindRegistrationResultDataView>>(
      in_registrations, registrations_fragment, &registrations_validate_params);
  params->registrations.Set(
      registrations_fragment.is_null() ? nullptr : registrations_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->registrations.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registrations in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetRegistrationsForOriginCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetRegistrationsForOrigin");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUsageForOrigin_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUsageForOriginCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUsageForOrigin_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUsageForOrigin_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUsageForOrigin_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUsageForOrigin_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetUsageForOrigin_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetUsageForOriginCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, int64_t in_usage);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUsageForOrigin_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetUsageForOrigin_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetUsageForOriginCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUsageForOrigin_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUsageForOrigin_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  int64_t p_usage{};
  ServiceWorkerStorageControl_GetUsageForOrigin_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success)
    p_usage = input_data_view.usage();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_usage));
  return true;
}

void ServiceWorkerStorageControl_GetUsageForOrigin_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, int64_t in_usage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUsageForOriginCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage"), in_usage, 
                        "<value of type int64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUsageForOrigin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUsageForOrigin_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  params->usage = in_usage;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUsageForOriginCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUsageForOrigin");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetAllRegistrationsDeprecatedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetAllRegistrationsDeprecatedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr> in_registrations);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetAllRegistrationsDeprecatedCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr> p_registrations{};
  ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadRegistrations(&p_registrations))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_registrations));
  return true;
}

void ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr> in_registrations) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetAllRegistrationsDeprecatedCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registrations"), in_registrations, 
                        "<value of type std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->registrations)::BaseType>
      registrations_fragment(params.message());
  const mojo::internal::ContainerValidateParams registrations_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerRegistrationDataDataView>>(
      in_registrations, registrations_fragment, &registrations_validate_params);
  params->registrations.Set(
      registrations_fragment.is_null() ? nullptr : registrations_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->registrations.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registrations in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetAllRegistrationsDeprecatedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetAllRegistrationsDeprecated");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::StoreRegistrationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::StoreRegistrationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, uint64_t in_deleted_resources_size);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder);
};

bool ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::StoreRegistrationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  uint64_t p_deleted_resources_size{};
  ServiceWorkerStorageControl_StoreRegistration_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success)
    p_deleted_resources_size = input_data_view.deleted_resources_size();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_deleted_resources_size));
  return true;
}

void ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, uint64_t in_deleted_resources_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::StoreRegistrationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("deleted_resources_size"), in_deleted_resources_size, 
                        "<value of type uint64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_StoreRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  params->deleted_resources_size = in_deleted_resources_size;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::StoreRegistrationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("StoreRegistration");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::DeleteRegistrationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::DeleteRegistrationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, uint64_t in_deleted_resources_size, ServiceWorkerStorageOriginState in_origin_state);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder);
};

bool ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::DeleteRegistrationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  uint64_t p_deleted_resources_size{};
  ServiceWorkerStorageOriginState p_origin_state{};
  ServiceWorkerStorageControl_DeleteRegistration_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success)
    p_deleted_resources_size = input_data_view.deleted_resources_size();
  if (success && !input_data_view.ReadOriginState(&p_origin_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_deleted_resources_size), 
std::move(p_origin_state));
  return true;
}

void ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, uint64_t in_deleted_resources_size, ServiceWorkerStorageOriginState in_origin_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::DeleteRegistrationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("deleted_resources_size"), in_deleted_resources_size, 
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_state"), in_origin_state, 
                        "<value of type ServiceWorkerStorageOriginState>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_DeleteRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  params->deleted_resources_size = in_deleted_resources_size;
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerStorageOriginState>(
      in_origin_state, &params->origin_state);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::DeleteRegistrationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("DeleteRegistration");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::UpdateToActiveStateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::UpdateToActiveStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder);
};

bool ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::UpdateToActiveStateCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_UpdateToActiveState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateToActiveStateCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_UpdateToActiveState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateToActiveStateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateToActiveState");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::UpdateLastUpdateCheckTimeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::UpdateLastUpdateCheckTimeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder);
};

bool ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::UpdateLastUpdateCheckTimeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateLastUpdateCheckTimeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateLastUpdateCheckTimeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateLastUpdateCheckTime");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::UpdateNavigationPreloadEnabledCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::UpdateNavigationPreloadEnabledCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder);
};

bool ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadEnabledCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadEnabledCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadEnabledCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateNavigationPreloadEnabled");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::UpdateNavigationPreloadHeaderCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::UpdateNavigationPreloadHeaderCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder);
};

bool ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadHeaderCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadHeaderCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadHeaderCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateNavigationPreloadHeader");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetNewRegistrationIdCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetNewRegistrationIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_registration_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetNewRegistrationIdCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_registration_id{};
  ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_registration_id = input_data_view.registration_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_registration_id));
  return true;
}

void ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder::Run(
    int64_t in_registration_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetNewRegistrationIdCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id, 
                        "<value of type int64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetNewRegistrationId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->registration_id = in_registration_id;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetNewRegistrationIdCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetNewRegistrationId");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetNewVersionIdCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetNewVersionIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_version_id, ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> in_version_reference);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetNewVersionIdCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_version_id{};
  ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> p_version_reference{};
  ServiceWorkerStorageControl_GetNewVersionId_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_version_id = input_data_view.version_id();
  if (success) {
    p_version_reference =
        input_data_view.TakeVersionReference<decltype(p_version_reference)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 17, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_version_id), 
std::move(p_version_reference));
  return true;
}

void ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder::Run(
    int64_t in_version_id, ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> in_version_reference) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetNewVersionIdCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version_id"), in_version_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version_reference"), in_version_reference, 
                        "<value of type ::mojo::PendingRemote<ServiceWorkerLiveVersionRef>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetNewVersionId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->version_id = in_version_id;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::ServiceWorkerLiveVersionRefInterfaceBase>>(
      in_version_reference, &params->version_reference, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetNewVersionIdCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetNewVersionId");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetNewResourceIdCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetNewResourceIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_resource_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetNewResourceIdCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_resource_id{};
  ServiceWorkerStorageControl_GetNewResourceId_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_resource_id = input_data_view.resource_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 18, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_resource_id));
  return true;
}

void ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder::Run(
    int64_t in_resource_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetNewResourceIdCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_id"), in_resource_id, 
                        "<value of type int64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetNewResourceId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->resource_id = in_resource_id;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetNewResourceIdCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetNewResourceId");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::StoreUncommittedResourceIdCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::StoreUncommittedResourceIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder);
};

bool ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::StoreUncommittedResourceIdCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 22, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::StoreUncommittedResourceIdCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_StoreUncommittedResourceId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::StoreUncommittedResourceIdCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("StoreUncommittedResourceId");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::DoomUncommittedResourcesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::DoomUncommittedResourcesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder);
};

bool ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::DoomUncommittedResourcesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 23, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::DoomUncommittedResourcesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_DoomUncommittedResources_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::DoomUncommittedResourcesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("DoomUncommittedResources");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUserData_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUserDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUserData_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUserData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUserData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUserData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetUserData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetUserDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<std::string>& in_values);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUserData_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetUserData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetUserDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUserData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUserData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<std::string> p_values{};
  ServiceWorkerStorageControl_GetUserData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadValues(&p_values))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 24, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_values));
  return true;
}

void ServiceWorkerStorageControl_GetUserData_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<std::string>& in_values) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("values"), in_values, 
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUserData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->values)::BaseType>
      values_fragment(params.message());
  const mojo::internal::ContainerValidateParams values_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_values, values_fragment, &values_validate_params);
  params->values.Set(
      values_fragment.is_null() ? nullptr : values_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->values.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null values in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_StoreUserData_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::StoreUserDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_StoreUserData_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_StoreUserData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_StoreUserData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_StoreUserData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_StoreUserData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::StoreUserDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_StoreUserData_ProxyToResponder);
};

bool ServiceWorkerStorageControl_StoreUserData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::StoreUserDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_StoreUserData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 25, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerStorageControl_StoreUserData_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::StoreUserDataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_StoreUserData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::StoreUserDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("StoreUserData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_ClearUserData_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::ClearUserDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_ClearUserData_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_ClearUserData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_ClearUserData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_ClearUserData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_ClearUserData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::ClearUserDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_ClearUserData_ProxyToResponder);
};

bool ServiceWorkerStorageControl_ClearUserData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::ClearUserDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_ClearUserData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 26, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerStorageControl_ClearUserData_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::ClearUserDataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_ClearUserData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::ClearUserDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ClearUserData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUserDataByKeyPrefixCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetUserDataByKeyPrefixCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<std::string>& in_values);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetUserDataByKeyPrefixCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<std::string> p_values{};
  ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadValues(&p_values))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 27, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_values));
  return true;
}

void ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<std::string>& in_values) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataByKeyPrefixCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("values"), in_values, 
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUserDataByKeyPrefix_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->values)::BaseType>
      values_fragment(params.message());
  const mojo::internal::ContainerValidateParams values_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_values, values_fragment, &values_validate_params);
  params->values.Set(
      values_fragment.is_null() ? nullptr : values_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->values.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null values in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataByKeyPrefixCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserDataByKeyPrefix");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefixCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefixCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const base::flat_map<std::string, std::string>& in_user_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefixCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  base::flat_map<std::string, std::string> p_user_data{};
  ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadUserData(&p_user_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 28, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_user_data));
  return true;
}

void ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const base::flat_map<std::string, std::string>& in_user_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefixCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_data"), in_user_data, 
                        "<value of type const base::flat_map<std::string, std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->user_data)::BaseType>
      user_data_fragment(params.message());
  const mojo::internal::ContainerValidateParams user_data_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_user_data, user_data_fragment, &user_data_validate_params);
  params->user_data.Set(
      user_data_fragment.is_null() ? nullptr : user_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->user_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_data in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefixCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserKeysAndDataByKeyPrefix");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::ClearUserDataByKeyPrefixesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::ClearUserDataByKeyPrefixesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder);
};

bool ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::ClearUserDataByKeyPrefixesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 29, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::ClearUserDataByKeyPrefixesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::ClearUserDataByKeyPrefixesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ClearUserDataByKeyPrefixes");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUserDataForAllRegistrationsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetUserDataForAllRegistrationsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<ServiceWorkerUserDataPtr> in_values);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<ServiceWorkerUserDataPtr> p_values{};
  ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadValues(&p_values))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 30, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_values));
  return true;
}

void ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<ServiceWorkerUserDataPtr> in_values) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("values"), in_values, 
                        "<value of type std::vector<ServiceWorkerUserDataPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUserDataForAllRegistrations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->values)::BaseType>
      values_fragment(params.message());
  const mojo::internal::ContainerValidateParams values_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerUserDataDataView>>(
      in_values, values_fragment, &values_validate_params);
  params->values.Set(
      values_fragment.is_null() ? nullptr : values_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->values.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null values in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserDataForAllRegistrations");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefixCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefixCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<ServiceWorkerUserDataPtr> in_values);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefixCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<ServiceWorkerUserDataPtr> p_values{};
  ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadValues(&p_values))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 31, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_values));
  return true;
}

void ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<ServiceWorkerUserDataPtr> in_values) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefixCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("values"), in_values, 
                        "<value of type std::vector<ServiceWorkerUserDataPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->values)::BaseType>
      values_fragment(params.message());
  const mojo::internal::ContainerValidateParams values_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerUserDataDataView>>(
      in_values, values_fragment, &values_validate_params);
  params->values.Set(
      values_fragment.is_null() ? nullptr : values_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->values.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null values in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefixCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserDataForAllRegistrationsByKeyPrefix");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefixCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefixCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder);
};

bool ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefixCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 32, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefixCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefixCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ClearUserDataForAllRegistrationsByKeyPrefix");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::PerformStorageCleanupCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::PerformStorageCleanupCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder);
};

bool ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::PerformStorageCleanupCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 33, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::PerformStorageCleanupCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_PerformStorageCleanup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::PerformStorageCleanupCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("PerformStorageCleanup");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::ApplyPolicyUpdatesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::ApplyPolicyUpdatesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder);
};

bool ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::ApplyPolicyUpdatesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 34, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::ApplyPolicyUpdatesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_ApplyPolicyUpdates_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::ApplyPolicyUpdatesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ApplyPolicyUpdates");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetPurgingResourceIdsForTestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetPurgingResourceIdsForTestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForTestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<int64_t> p_resource_ids{};
  ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResourceIds(&p_resource_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 35, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_resource_ids));
  return true;
}

void ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForTestCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_ids"), in_resource_ids, 
                        "<value of type const std::vector<int64_t>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->resource_ids)::BaseType>
      resource_ids_fragment(params.message());
  const mojo::internal::ContainerValidateParams resource_ids_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
      in_resource_ids, resource_ids_fragment, &resource_ids_validate_params);
  params->resource_ids.Set(
      resource_ids_fragment.is_null() ? nullptr : resource_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resource_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource_ids in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForTestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetPurgingResourceIdsForTest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetPurgeableResourceIdsForTestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetPurgeableResourceIdsForTestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetPurgeableResourceIdsForTestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<int64_t> p_resource_ids{};
  ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResourceIds(&p_resource_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 36, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_resource_ids));
  return true;
}

void ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetPurgeableResourceIdsForTestCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_ids"), in_resource_ids, 
                        "<value of type const std::vector<int64_t>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->resource_ids)::BaseType>
      resource_ids_fragment(params.message());
  const mojo::internal::ContainerValidateParams resource_ids_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
      in_resource_ids, resource_ids_fragment, &resource_ids_validate_params);
  params->resource_ids.Set(
      resource_ids_fragment.is_null() ? nullptr : resource_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resource_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource_ids in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetPurgeableResourceIdsForTestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetPurgeableResourceIdsForTest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUncommittedResourceIdsForTestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::GetUncommittedResourceIdsForTestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder);
};

bool ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::GetUncommittedResourceIdsForTestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<int64_t> p_resource_ids{};
  ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResourceIds(&p_resource_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 37, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_resource_ids));
  return true;
}

void ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUncommittedResourceIdsForTestCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_ids"), in_resource_ids, 
                        "<value of type const std::vector<int64_t>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->resource_ids)::BaseType>
      resource_ids_fragment(params.message());
  const mojo::internal::ContainerValidateParams resource_ids_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
      in_resource_ids, resource_ids_fragment, &resource_ids_validate_params);
  params->resource_ids.Set(
      resource_ids_fragment.is_null() ? nullptr : resource_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resource_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource_ids in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUncommittedResourceIdsForTestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUncommittedResourceIdsForTest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder);
};

bool ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 38, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTestCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("SetPurgingCompleteCallbackForTest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerStorageControlStubDispatch::Accept(
    ServiceWorkerStorageControl* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceWorkerStorageControl_Disable_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_Delete_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_Recover_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetRegisteredOrigins_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_FindRegistrationForClientUrl_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_FindRegistrationForScope_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_FindRegistrationForId_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetRegistrationsForOrigin_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetUsageForOrigin_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_StoreRegistration_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_DeleteRegistration_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_UpdateToActiveState_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetNewRegistrationId_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetNewVersionId_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetNewResourceId_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_CreateResourceReader_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::CreateResourceReader",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::CreateResourceReader");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerStorageControl_CreateResourceReader_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerStorageControl_CreateResourceReader_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_resource_id{};
      ::mojo::PendingReceiver<ServiceWorkerResourceReader> p_reader{};
      ServiceWorkerStorageControl_CreateResourceReader_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_resource_id = input_data_view.resource_id();
      if (success) {
        p_reader =
            input_data_view.TakeReader<decltype(p_reader)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateResourceReader(
std::move(p_resource_id), 
std::move(p_reader));
      return true;
    }
    case internal::kServiceWorkerStorageControl_CreateResourceWriter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::CreateResourceWriter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::CreateResourceWriter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerStorageControl_CreateResourceWriter_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerStorageControl_CreateResourceWriter_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_resource_id{};
      ::mojo::PendingReceiver<ServiceWorkerResourceWriter> p_writer{};
      ServiceWorkerStorageControl_CreateResourceWriter_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_resource_id = input_data_view.resource_id();
      if (success) {
        p_writer =
            input_data_view.TakeWriter<decltype(p_writer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateResourceWriter(
std::move(p_resource_id), 
std::move(p_writer));
      return true;
    }
    case internal::kServiceWorkerStorageControl_CreateResourceMetadataWriter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::CreateResourceMetadataWriter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::CreateResourceMetadataWriter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_resource_id{};
      ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter> p_writer{};
      ServiceWorkerStorageControl_CreateResourceMetadataWriter_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_resource_id = input_data_view.resource_id();
      if (success) {
        p_writer =
            input_data_view.TakeWriter<decltype(p_writer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateResourceMetadataWriter(
std::move(p_resource_id), 
std::move(p_writer));
      return true;
    }
    case internal::kServiceWorkerStorageControl_StoreUncommittedResourceId_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_DoomUncommittedResources_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetUserData_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_StoreUserData_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_ClearUserData_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetUserDataByKeyPrefix_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetUserDataForAllRegistrations_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_PerformStorageCleanup_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_ApplyPolicyUpdates_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Name: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerStorageControlStubDispatch::AcceptWithResponder(
    ServiceWorkerStorageControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerStorageControl_Disable_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::Disable",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::Disable");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_Disable_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_Disable_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStorageControl_Disable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 0, false);
        return false;
      }
      ServiceWorkerStorageControl::DisableCallback callback =
          ServiceWorkerStorageControl_Disable_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Disable(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_Delete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::Delete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::Delete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_Delete_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_Delete_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStorageControl_Delete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 1, false);
        return false;
      }
      ServiceWorkerStorageControl::DeleteCallback callback =
          ServiceWorkerStorageControl_Delete_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_Recover_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::Recover",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::Recover");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_Recover_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_Recover_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<ServiceWorkerLiveVersionInfoPtr> p_versions{};
      ServiceWorkerStorageControl_Recover_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVersions(&p_versions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 2, false);
        return false;
      }
      ServiceWorkerStorageControl::RecoverCallback callback =
          ServiceWorkerStorageControl_Recover_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Recover(
std::move(p_versions), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetRegisteredOrigins_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetRegisteredOrigins",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetRegisteredOrigins");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetRegisteredOrigins_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetRegisteredOrigins_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStorageControl_GetRegisteredOrigins_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 3, false);
        return false;
      }
      ServiceWorkerStorageControl::GetRegisteredOriginsCallback callback =
          ServiceWorkerStorageControl_GetRegisteredOrigins_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegisteredOrigins(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_FindRegistrationForClientUrl_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::FindRegistrationForClientUrl",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::FindRegistrationForClientUrl");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_client_url{};
      ServiceWorkerStorageControl_FindRegistrationForClientUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUrl(&p_client_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 4, false);
        return false;
      }
      ServiceWorkerStorageControl::FindRegistrationForClientUrlCallback callback =
          ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FindRegistrationForClientUrl(
std::move(p_client_url), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_FindRegistrationForScope_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::FindRegistrationForScope",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::FindRegistrationForScope");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_scope{};
      ServiceWorkerStorageControl_FindRegistrationForScope_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScope(&p_scope))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 5, false);
        return false;
      }
      ServiceWorkerStorageControl::FindRegistrationForScopeCallback callback =
          ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FindRegistrationForScope(
std::move(p_scope), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_FindRegistrationForId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::FindRegistrationForId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::FindRegistrationForId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_FindRegistrationForId_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_FindRegistrationForId_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_registration_id{};
      base::Optional<::url::Origin> p_origin{};
      ServiceWorkerStorageControl_FindRegistrationForId_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 6, false);
        return false;
      }
      ServiceWorkerStorageControl::FindRegistrationForIdCallback callback =
          ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FindRegistrationForId(
std::move(p_registration_id), 
std::move(p_origin), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetRegistrationsForOrigin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetRegistrationsForOrigin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetRegistrationsForOrigin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetRegistrationsForOrigin_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetRegistrationsForOrigin_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      ServiceWorkerStorageControl_GetRegistrationsForOrigin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 7, false);
        return false;
      }
      ServiceWorkerStorageControl::GetRegistrationsForOriginCallback callback =
          ServiceWorkerStorageControl_GetRegistrationsForOrigin_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistrationsForOrigin(
std::move(p_origin), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetUsageForOrigin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUsageForOrigin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUsageForOrigin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetUsageForOrigin_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUsageForOrigin_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      ServiceWorkerStorageControl_GetUsageForOrigin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 8, false);
        return false;
      }
      ServiceWorkerStorageControl::GetUsageForOriginCallback callback =
          ServiceWorkerStorageControl_GetUsageForOrigin_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUsageForOrigin(
std::move(p_origin), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetAllRegistrationsDeprecated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetAllRegistrationsDeprecated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 9, false);
        return false;
      }
      ServiceWorkerStorageControl::GetAllRegistrationsDeprecatedCallback callback =
          ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllRegistrationsDeprecated(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_StoreRegistration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::StoreRegistration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::StoreRegistration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_StoreRegistration_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_StoreRegistration_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::storage::mojom::ServiceWorkerRegistrationDataPtr p_registration{};
      std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> p_resources{};
      ServiceWorkerStorageControl_StoreRegistration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 10, false);
        return false;
      }
      ServiceWorkerStorageControl::StoreRegistrationCallback callback =
          ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StoreRegistration(
std::move(p_registration), 
std::move(p_resources), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_DeleteRegistration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::DeleteRegistration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::DeleteRegistration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_DeleteRegistration_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_DeleteRegistration_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_registration_id{};
      ::GURL p_origin{};
      ServiceWorkerStorageControl_DeleteRegistration_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 11, false);
        return false;
      }
      ServiceWorkerStorageControl::DeleteRegistrationCallback callback =
          ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteRegistration(
std::move(p_registration_id), 
std::move(p_origin), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_UpdateToActiveState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateToActiveState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateToActiveState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_UpdateToActiveState_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_UpdateToActiveState_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_registration_id{};
      ::GURL p_origin{};
      ServiceWorkerStorageControl_UpdateToActiveState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 12, false);
        return false;
      }
      ServiceWorkerStorageControl::UpdateToActiveStateCallback callback =
          ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateToActiveState(
std::move(p_registration_id), 
std::move(p_origin), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateLastUpdateCheckTime",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateLastUpdateCheckTime");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_registration_id{};
      ::GURL p_origin{};
      ::base::Time p_last_update_check_time{};
      ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadLastUpdateCheckTime(&p_last_update_check_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 13, false);
        return false;
      }
      ServiceWorkerStorageControl::UpdateLastUpdateCheckTimeCallback callback =
          ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateLastUpdateCheckTime(
std::move(p_registration_id), 
std::move(p_origin), 
std::move(p_last_update_check_time), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadEnabled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadEnabled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_registration_id{};
      ::GURL p_origin{};
      bool p_enable{};
      ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success)
        p_enable = input_data_view.enable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 14, false);
        return false;
      }
      ServiceWorkerStorageControl::UpdateNavigationPreloadEnabledCallback callback =
          ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateNavigationPreloadEnabled(
std::move(p_registration_id), 
std::move(p_origin), 
std::move(p_enable), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadHeader",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadHeader");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_registration_id{};
      ::GURL p_origin{};
      std::string p_value{};
      ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 15, false);
        return false;
      }
      ServiceWorkerStorageControl::UpdateNavigationPreloadHeaderCallback callback =
          ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateNavigationPreloadHeader(
std::move(p_registration_id), 
std::move(p_origin), 
std::move(p_value), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetNewRegistrationId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetNewRegistrationId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetNewRegistrationId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStorageControl_GetNewRegistrationId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 16, false);
        return false;
      }
      ServiceWorkerStorageControl::GetNewRegistrationIdCallback callback =
          ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNewRegistrationId(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetNewVersionId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetNewVersionId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetNewVersionId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetNewVersionId_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetNewVersionId_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStorageControl_GetNewVersionId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 17, false);
        return false;
      }
      ServiceWorkerStorageControl::GetNewVersionIdCallback callback =
          ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNewVersionId(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetNewResourceId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetNewResourceId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetNewResourceId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetNewResourceId_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetNewResourceId_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStorageControl_GetNewResourceId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 18, false);
        return false;
      }
      ServiceWorkerStorageControl::GetNewResourceIdCallback callback =
          ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNewResourceId(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_CreateResourceReader_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_CreateResourceWriter_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_CreateResourceMetadataWriter_Name: {
      break;
    }
    case internal::kServiceWorkerStorageControl_StoreUncommittedResourceId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::StoreUncommittedResourceId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::StoreUncommittedResourceId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_resource_id{};
      ServiceWorkerStorageControl_StoreUncommittedResourceId_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_resource_id = input_data_view.resource_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 22, false);
        return false;
      }
      ServiceWorkerStorageControl::StoreUncommittedResourceIdCallback callback =
          ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StoreUncommittedResourceId(
std::move(p_resource_id), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_DoomUncommittedResources_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::DoomUncommittedResources",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::DoomUncommittedResources");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<int64_t> p_resource_ids{};
      ServiceWorkerStorageControl_DoomUncommittedResources_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResourceIds(&p_resource_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 23, false);
        return false;
      }
      ServiceWorkerStorageControl::DoomUncommittedResourcesCallback callback =
          ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DoomUncommittedResources(
std::move(p_resource_ids), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetUserData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetUserData_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUserData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_registration_id{};
      std::vector<std::string> p_keys{};
      ServiceWorkerStorageControl_GetUserData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKeys(&p_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 24, false);
        return false;
      }
      ServiceWorkerStorageControl::GetUserDataCallback callback =
          ServiceWorkerStorageControl_GetUserData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserData(
std::move(p_registration_id), 
std::move(p_keys), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_StoreUserData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::StoreUserData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::StoreUserData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_StoreUserData_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_StoreUserData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_registration_id{};
      ::url::Origin p_origin{};
      std::vector<ServiceWorkerUserDataPtr> p_user_data{};
      ServiceWorkerStorageControl_StoreUserData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadUserData(&p_user_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 25, false);
        return false;
      }
      ServiceWorkerStorageControl::StoreUserDataCallback callback =
          ServiceWorkerStorageControl_StoreUserData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StoreUserData(
std::move(p_registration_id), 
std::move(p_origin), 
std::move(p_user_data), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_ClearUserData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::ClearUserData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::ClearUserData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_ClearUserData_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_ClearUserData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_registration_id{};
      std::vector<std::string> p_keys{};
      ServiceWorkerStorageControl_ClearUserData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKeys(&p_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 26, false);
        return false;
      }
      ServiceWorkerStorageControl::ClearUserDataCallback callback =
          ServiceWorkerStorageControl_ClearUserData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearUserData(
std::move(p_registration_id), 
std::move(p_keys), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetUserDataByKeyPrefix_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataByKeyPrefix",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataByKeyPrefix");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_registration_id{};
      std::string p_key_prefix{};
      ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKeyPrefix(&p_key_prefix))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 27, false);
        return false;
      }
      ServiceWorkerStorageControl::GetUserDataByKeyPrefixCallback callback =
          ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserDataByKeyPrefix(
std::move(p_registration_id), 
std::move(p_key_prefix), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefix",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefix");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_registration_id{};
      std::string p_key_prefix{};
      ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKeyPrefix(&p_key_prefix))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 28, false);
        return false;
      }
      ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefixCallback callback =
          ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserKeysAndDataByKeyPrefix(
std::move(p_registration_id), 
std::move(p_key_prefix), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::ClearUserDataByKeyPrefixes",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::ClearUserDataByKeyPrefixes");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_registratation_id{};
      std::vector<std::string> p_key_prefixes{};
      ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registratation_id = input_data_view.registratation_id();
      if (success && !input_data_view.ReadKeyPrefixes(&p_key_prefixes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 29, false);
        return false;
      }
      ServiceWorkerStorageControl::ClearUserDataByKeyPrefixesCallback callback =
          ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearUserDataByKeyPrefixes(
std::move(p_registratation_id), 
std::move(p_key_prefixes), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetUserDataForAllRegistrations_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrations",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrations");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_key{};
      ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 30, false);
        return false;
      }
      ServiceWorkerStorageControl::GetUserDataForAllRegistrationsCallback callback =
          ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserDataForAllRegistrations(
std::move(p_key), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefix",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefix");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_key_prefix{};
      ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyPrefix(&p_key_prefix))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 31, false);
        return false;
      }
      ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefixCallback callback =
          ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserDataForAllRegistrationsByKeyPrefix(
std::move(p_key_prefix), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefix",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefix");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_key_prefix{};
      ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyPrefix(&p_key_prefix))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 32, false);
        return false;
      }
      ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefixCallback callback =
          ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearUserDataForAllRegistrationsByKeyPrefix(
std::move(p_key_prefix), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_PerformStorageCleanup_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::PerformStorageCleanup",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::PerformStorageCleanup");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStorageControl_PerformStorageCleanup_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 33, false);
        return false;
      }
      ServiceWorkerStorageControl::PerformStorageCleanupCallback callback =
          ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformStorageCleanup(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_ApplyPolicyUpdates_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::ApplyPolicyUpdates",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::ApplyPolicyUpdates");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<::storage::mojom::StoragePolicyUpdatePtr> p_policy_updates{};
      ServiceWorkerStorageControl_ApplyPolicyUpdates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicyUpdates(&p_policy_updates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 34, false);
        return false;
      }
      ServiceWorkerStorageControl::ApplyPolicyUpdatesCallback callback =
          ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyPolicyUpdates(
std::move(p_policy_updates), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForTest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForTest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 35, false);
        return false;
      }
      ServiceWorkerStorageControl::GetPurgingResourceIdsForTestCallback callback =
          ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPurgingResourceIdsForTest(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetPurgeableResourceIdsForTest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetPurgeableResourceIdsForTest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 36, false);
        return false;
      }
      ServiceWorkerStorageControl::GetPurgeableResourceIdsForTestCallback callback =
          ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPurgeableResourceIdsForTest(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUncommittedResourceIdsForTest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::GetUncommittedResourceIdsForTest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 37, false);
        return false;
      }
      ServiceWorkerStorageControl::GetUncommittedResourceIdsForTestCallback callback =
          ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUncommittedResourceIdsForTest(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 38, false);
        return false;
      }
      ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTestCallback callback =
          ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPurgingCompleteCallbackForTest(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerStorageControlValidationInfo[] = {
    {internal::kServiceWorkerStorageControl_Disable_Name,
     {&internal::ServiceWorkerStorageControl_Disable_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_Disable_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_Delete_Name,
     {&internal::ServiceWorkerStorageControl_Delete_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_Delete_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_Recover_Name,
     {&internal::ServiceWorkerStorageControl_Recover_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_Recover_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetRegisteredOrigins_Name,
     {&internal::ServiceWorkerStorageControl_GetRegisteredOrigins_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetRegisteredOrigins_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_FindRegistrationForClientUrl_Name,
     {&internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_FindRegistrationForScope_Name,
     {&internal::ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_FindRegistrationForId_Name,
     {&internal::ServiceWorkerStorageControl_FindRegistrationForId_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetRegistrationsForOrigin_Name,
     {&internal::ServiceWorkerStorageControl_GetRegistrationsForOrigin_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetRegistrationsForOrigin_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetUsageForOrigin_Name,
     {&internal::ServiceWorkerStorageControl_GetUsageForOrigin_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetUsageForOrigin_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Name,
     {&internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_StoreRegistration_Name,
     {&internal::ServiceWorkerStorageControl_StoreRegistration_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_DeleteRegistration_Name,
     {&internal::ServiceWorkerStorageControl_DeleteRegistration_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_UpdateToActiveState_Name,
     {&internal::ServiceWorkerStorageControl_UpdateToActiveState_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Name,
     {&internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Name,
     {&internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Name,
     {&internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetNewRegistrationId_Name,
     {&internal::ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetNewVersionId_Name,
     {&internal::ServiceWorkerStorageControl_GetNewVersionId_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetNewResourceId_Name,
     {&internal::ServiceWorkerStorageControl_GetNewResourceId_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_CreateResourceReader_Name,
     {&internal::ServiceWorkerStorageControl_CreateResourceReader_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerStorageControl_CreateResourceWriter_Name,
     {&internal::ServiceWorkerStorageControl_CreateResourceWriter_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerStorageControl_CreateResourceMetadataWriter_Name,
     {&internal::ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerStorageControl_StoreUncommittedResourceId_Name,
     {&internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_DoomUncommittedResources_Name,
     {&internal::ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetUserData_Name,
     {&internal::ServiceWorkerStorageControl_GetUserData_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetUserData_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_StoreUserData_Name,
     {&internal::ServiceWorkerStorageControl_StoreUserData_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_ClearUserData_Name,
     {&internal::ServiceWorkerStorageControl_ClearUserData_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetUserDataByKeyPrefix_Name,
     {&internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Name,
     {&internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Name,
     {&internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetUserDataForAllRegistrations_Name,
     {&internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Name,
     {&internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Name,
     {&internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_PerformStorageCleanup_Name,
     {&internal::ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_ApplyPolicyUpdates_Name,
     {&internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Name,
     {&internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Name,
     {&internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Name,
     {&internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Name,
     {&internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data::Validate,
      &internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data::Validate}},
};

bool ServiceWorkerStorageControlRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::ServiceWorkerStorageControl::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerStorageControlValidationInfo);
}

bool ServiceWorkerStorageControlResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::ServiceWorkerStorageControl::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kServiceWorkerStorageControlValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {


// static
bool StructTraits<::storage::mojom::ServiceWorkerLiveVersionInfo::DataView, ::storage::mojom::ServiceWorkerLiveVersionInfoPtr>::Read(
    ::storage::mojom::ServiceWorkerLiveVersionInfo::DataView input,
    ::storage::mojom::ServiceWorkerLiveVersionInfoPtr* output) {
  bool success = true;
  ::storage::mojom::ServiceWorkerLiveVersionInfoPtr result(::storage::mojom::ServiceWorkerLiveVersionInfo::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadPurgeableResources(&result->purgeable_resources))
        success = false;
      if (success) {
        result->reference =
            input.TakeReference<decltype(result->reference)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::ServiceWorkerFindRegistrationResult::DataView, ::storage::mojom::ServiceWorkerFindRegistrationResultPtr>::Read(
    ::storage::mojom::ServiceWorkerFindRegistrationResult::DataView input,
    ::storage::mojom::ServiceWorkerFindRegistrationResultPtr* output) {
  bool success = true;
  ::storage::mojom::ServiceWorkerFindRegistrationResultPtr result(::storage::mojom::ServiceWorkerFindRegistrationResult::New());
  
      if (success) {
        result->version_reference =
            input.TakeVersionReference<decltype(result->version_reference)>();
      }
      if (success && !input.ReadRegistration(&result->registration))
        success = false;
      if (success && !input.ReadResources(&result->resources))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::ServiceWorkerUserData::DataView, ::storage::mojom::ServiceWorkerUserDataPtr>::Read(
    ::storage::mojom::ServiceWorkerUserData::DataView input,
    ::storage::mojom::ServiceWorkerUserDataPtr* output) {
  bool success = true;
  ::storage::mojom::ServiceWorkerUserDataPtr result(::storage::mojom::ServiceWorkerUserData::New());
  
      if (success)
        result->registration_id = input.registration_id();
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif