// components/services/storage/public/mojom/session_storage_control.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/session_storage_control.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/services/storage/public/mojom/session_storage_control.mojom-params-data.h"
#include "components/services/storage/public/mojom/session_storage_control.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/session_storage_control.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
SessionStorageUsageInfo::SessionStorageUsageInfo()
    : origin(),
      namespace_id() {}

SessionStorageUsageInfo::SessionStorageUsageInfo(
    const ::url::Origin& origin_in,
    const std::string& namespace_id_in)
    : origin(std::move(origin_in)),
      namespace_id(std::move(namespace_id_in)) {}

SessionStorageUsageInfo::~SessionStorageUsageInfo() = default;

void SessionStorageUsageInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin, 
      "<value of type const ::url::Origin&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "namespace_id"), this->namespace_id, 
      "<value of type const std::string&>");
}

bool SessionStorageUsageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SessionStorageControl::Name_[] = "storage.mojom.SessionStorageControl";

class SessionStorageControl_BindNamespace_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_BindNamespace_ForwardToCallback(
      SessionStorageControl::BindNamespaceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::BindNamespaceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_BindNamespace_ForwardToCallback);
};

class SessionStorageControl_BindStorageArea_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_BindStorageArea_ForwardToCallback(
      SessionStorageControl::BindStorageAreaCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::BindStorageAreaCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_BindStorageArea_ForwardToCallback);
};

class SessionStorageControl_GetUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_GetUsage_ForwardToCallback(
      SessionStorageControl::GetUsageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::GetUsageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_GetUsage_ForwardToCallback);
};

class SessionStorageControl_DeleteStorage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_DeleteStorage_ForwardToCallback(
      SessionStorageControl::DeleteStorageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::DeleteStorageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_DeleteStorage_ForwardToCallback);
};

class SessionStorageControl_CleanUpStorage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_CleanUpStorage_ForwardToCallback(
      SessionStorageControl::CleanUpStorageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::CleanUpStorageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_CleanUpStorage_ForwardToCallback);
};

class SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback(
      SessionStorageControl::ScavengeUnusedNamespacesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::ScavengeUnusedNamespacesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback);
};

class SessionStorageControl_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_Flush_ForwardToCallback(
      SessionStorageControl::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::FlushCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_Flush_ForwardToCallback);
};

SessionStorageControlProxy::SessionStorageControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SessionStorageControlProxy::BindNamespace(
    const std::string& in_namespace_id, ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> in_receiver, BindNamespaceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::SessionStorageControl::BindNamespace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_BindNamespace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_BindNamespace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_namespace_id, namespace_id_fragment);
  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->namespace_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null namespace_id in SessionStorageControl.BindNamespace request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SessionStorageNamespaceInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in SessionStorageControl.BindNamespace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("BindNamespace");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_BindNamespace_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SessionStorageControlProxy::BindStorageArea(
    const ::url::Origin& in_origin, const std::string& in_namespace_id, ::mojo::PendingReceiver<::blink::mojom::StorageArea> in_receiver, BindStorageAreaCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::SessionStorageControl::BindStorageArea", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::StorageArea>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_BindStorageArea_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_BindStorageArea_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in SessionStorageControl.BindStorageArea request");
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_namespace_id, namespace_id_fragment);
  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->namespace_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null namespace_id in SessionStorageControl.BindStorageArea request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::StorageAreaInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in SessionStorageControl.BindStorageArea request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("BindStorageArea");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_BindStorageArea_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SessionStorageControlProxy::GetUsage(
    GetUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::SessionStorageControl::GetUsage");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_GetUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_GetUsage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("GetUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_GetUsage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SessionStorageControlProxy::DeleteStorage(
    const ::url::Origin& in_origin, const std::string& in_namespace_id, DeleteStorageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::SessionStorageControl::DeleteStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin, 
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_DeleteStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_DeleteStorage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in SessionStorageControl.DeleteStorage request");
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_namespace_id, namespace_id_fragment);
  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->namespace_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null namespace_id in SessionStorageControl.DeleteStorage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("DeleteStorage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_DeleteStorage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SessionStorageControlProxy::CleanUpStorage(
    CleanUpStorageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::SessionStorageControl::CleanUpStorage");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_CleanUpStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_CleanUpStorage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("CleanUpStorage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_CleanUpStorage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SessionStorageControlProxy::ScavengeUnusedNamespaces(
    ScavengeUnusedNamespacesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::SessionStorageControl::ScavengeUnusedNamespaces");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_ScavengeUnusedNamespaces_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_ScavengeUnusedNamespaces_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("ScavengeUnusedNamespaces");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SessionStorageControlProxy::Flush(
    FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::SessionStorageControl::Flush");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_Flush_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SessionStorageControlProxy::PurgeMemory(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::SessionStorageControl::PurgeMemory");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_PurgeMemory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_PurgeMemory_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("PurgeMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SessionStorageControlProxy::CreateNamespace(
    const std::string& in_namespace_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::SessionStorageControl::CreateNamespace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_CreateNamespace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_CreateNamespace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_namespace_id, namespace_id_fragment);
  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->namespace_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null namespace_id in SessionStorageControl.CreateNamespace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("CreateNamespace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SessionStorageControlProxy::CloneNamespace(
    const std::string& in_namespace_id_to_clone, const std::string& in_clone_namespace_id, SessionStorageCloneType in_clone_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::SessionStorageControl::CloneNamespace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id_to_clone"), in_namespace_id_to_clone, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clone_namespace_id"), in_clone_namespace_id, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clone_type"), in_clone_type, 
                        "<value of type SessionStorageCloneType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_CloneNamespace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_CloneNamespace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id_to_clone)::BaseType> namespace_id_to_clone_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_namespace_id_to_clone, namespace_id_to_clone_fragment);
  params->namespace_id_to_clone.Set(
      namespace_id_to_clone_fragment.is_null() ? nullptr : namespace_id_to_clone_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->namespace_id_to_clone.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null namespace_id_to_clone in SessionStorageControl.CloneNamespace request");
  mojo::internal::MessageFragment<
      typename decltype(params->clone_namespace_id)::BaseType> clone_namespace_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_clone_namespace_id, clone_namespace_id_fragment);
  params->clone_namespace_id.Set(
      clone_namespace_id_fragment.is_null() ? nullptr : clone_namespace_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->clone_namespace_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clone_namespace_id in SessionStorageControl.CloneNamespace request");
  mojo::internal::Serialize<::storage::mojom::SessionStorageCloneType>(
      in_clone_type, &params->clone_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("CloneNamespace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SessionStorageControlProxy::DeleteNamespace(
    const std::string& in_namespace_id, bool in_should_persist) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::SessionStorageControl::DeleteNamespace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_persist"), in_should_persist, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_DeleteNamespace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_DeleteNamespace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_namespace_id, namespace_id_fragment);
  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->namespace_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null namespace_id in SessionStorageControl.DeleteNamespace request");
  params->should_persist = in_should_persist;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("DeleteNamespace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class SessionStorageControl_BindNamespace_ProxyToResponder {
 public:
  static SessionStorageControl::BindNamespaceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SessionStorageControl_BindNamespace_ProxyToResponder> proxy(
        new SessionStorageControl_BindNamespace_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SessionStorageControl_BindNamespace_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_BindNamespace_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SessionStorageControl_BindNamespace_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SessionStorageControl::BindNamespaceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_BindNamespace_ProxyToResponder);
};

bool SessionStorageControl_BindNamespace_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::SessionStorageControl::BindNamespaceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SessionStorageControl_BindNamespace_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_BindNamespace_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  SessionStorageControl_BindNamespace_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void SessionStorageControl_BindNamespace_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::SessionStorageControl::BindNamespaceCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_BindNamespace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_BindNamespace_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::SessionStorageControl::BindNamespaceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("BindNamespace");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SessionStorageControl_BindStorageArea_ProxyToResponder {
 public:
  static SessionStorageControl::BindStorageAreaCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SessionStorageControl_BindStorageArea_ProxyToResponder> proxy(
        new SessionStorageControl_BindStorageArea_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SessionStorageControl_BindStorageArea_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_BindStorageArea_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SessionStorageControl_BindStorageArea_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SessionStorageControl::BindStorageAreaCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_BindStorageArea_ProxyToResponder);
};

bool SessionStorageControl_BindStorageArea_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::SessionStorageControl::BindStorageAreaCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SessionStorageControl_BindStorageArea_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_BindStorageArea_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  SessionStorageControl_BindStorageArea_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void SessionStorageControl_BindStorageArea_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::SessionStorageControl::BindStorageAreaCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_BindStorageArea_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_BindStorageArea_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::SessionStorageControl::BindStorageAreaCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("BindStorageArea");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SessionStorageControl_GetUsage_ProxyToResponder {
 public:
  static SessionStorageControl::GetUsageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SessionStorageControl_GetUsage_ProxyToResponder> proxy(
        new SessionStorageControl_GetUsage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SessionStorageControl_GetUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_GetUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SessionStorageControl_GetUsage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SessionStorageControl::GetUsageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<SessionStorageUsageInfoPtr> in_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_GetUsage_ProxyToResponder);
};

bool SessionStorageControl_GetUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::SessionStorageControl::GetUsageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SessionStorageControl_GetUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_GetUsage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<SessionStorageUsageInfoPtr> p_info{};
  SessionStorageControl_GetUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void SessionStorageControl_GetUsage_ProxyToResponder::Run(
    std::vector<SessionStorageUsageInfoPtr> in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::SessionStorageControl::GetUsageCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info, 
                        "<value of type std::vector<SessionStorageUsageInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_GetUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_GetUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType>
      info_fragment(params.message());
  const mojo::internal::ContainerValidateParams info_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::SessionStorageUsageInfoDataView>>(
      in_info, info_fragment, &info_validate_params);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::SessionStorageControl::GetUsageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("GetUsage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SessionStorageControl_DeleteStorage_ProxyToResponder {
 public:
  static SessionStorageControl::DeleteStorageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SessionStorageControl_DeleteStorage_ProxyToResponder> proxy(
        new SessionStorageControl_DeleteStorage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SessionStorageControl_DeleteStorage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_DeleteStorage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SessionStorageControl_DeleteStorage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SessionStorageControl::DeleteStorageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_DeleteStorage_ProxyToResponder);
};

bool SessionStorageControl_DeleteStorage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::SessionStorageControl::DeleteStorageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SessionStorageControl_DeleteStorage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_DeleteStorage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SessionStorageControl_DeleteStorage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void SessionStorageControl_DeleteStorage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::SessionStorageControl::DeleteStorageCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_DeleteStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_DeleteStorage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::SessionStorageControl::DeleteStorageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("DeleteStorage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SessionStorageControl_CleanUpStorage_ProxyToResponder {
 public:
  static SessionStorageControl::CleanUpStorageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SessionStorageControl_CleanUpStorage_ProxyToResponder> proxy(
        new SessionStorageControl_CleanUpStorage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SessionStorageControl_CleanUpStorage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_CleanUpStorage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SessionStorageControl_CleanUpStorage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SessionStorageControl::CleanUpStorageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_CleanUpStorage_ProxyToResponder);
};

bool SessionStorageControl_CleanUpStorage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::SessionStorageControl::CleanUpStorageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SessionStorageControl_CleanUpStorage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_CleanUpStorage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SessionStorageControl_CleanUpStorage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void SessionStorageControl_CleanUpStorage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::SessionStorageControl::CleanUpStorageCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_CleanUpStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_CleanUpStorage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::SessionStorageControl::CleanUpStorageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("CleanUpStorage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder {
 public:
  static SessionStorageControl::ScavengeUnusedNamespacesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder> proxy(
        new SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SessionStorageControl::ScavengeUnusedNamespacesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder);
};

bool SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::SessionStorageControl::ScavengeUnusedNamespacesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SessionStorageControl_ScavengeUnusedNamespaces_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_ScavengeUnusedNamespaces_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SessionStorageControl_ScavengeUnusedNamespaces_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::SessionStorageControl::ScavengeUnusedNamespacesCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_ScavengeUnusedNamespaces_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_ScavengeUnusedNamespaces_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::SessionStorageControl::ScavengeUnusedNamespacesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("ScavengeUnusedNamespaces");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SessionStorageControl_Flush_ProxyToResponder {
 public:
  static SessionStorageControl::FlushCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SessionStorageControl_Flush_ProxyToResponder> proxy(
        new SessionStorageControl_Flush_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SessionStorageControl_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SessionStorageControl_Flush_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SessionStorageControl::FlushCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SessionStorageControl_Flush_ProxyToResponder);
};

bool SessionStorageControl_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::SessionStorageControl::FlushCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SessionStorageControl_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SessionStorageControl_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void SessionStorageControl_Flush_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::SessionStorageControl::FlushCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSessionStorageControl_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::SessionStorageControl::FlushCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SessionStorageControlStubDispatch::Accept(
    SessionStorageControl* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSessionStorageControl_BindNamespace_Name: {
      break;
    }
    case internal::kSessionStorageControl_BindStorageArea_Name: {
      break;
    }
    case internal::kSessionStorageControl_GetUsage_Name: {
      break;
    }
    case internal::kSessionStorageControl_DeleteStorage_Name: {
      break;
    }
    case internal::kSessionStorageControl_CleanUpStorage_Name: {
      break;
    }
    case internal::kSessionStorageControl_ScavengeUnusedNamespaces_Name: {
      break;
    }
    case internal::kSessionStorageControl_Flush_Name: {
      break;
    }
    case internal::kSessionStorageControl_PurgeMemory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::SessionStorageControl::PurgeMemory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::SessionStorageControl::PurgeMemory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SessionStorageControl_PurgeMemory_Params_Data* params =
          reinterpret_cast<internal::SessionStorageControl_PurgeMemory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SessionStorageControl_PurgeMemory_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PurgeMemory();
      return true;
    }
    case internal::kSessionStorageControl_CreateNamespace_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::SessionStorageControl::CreateNamespace",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::SessionStorageControl::CreateNamespace");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SessionStorageControl_CreateNamespace_Params_Data* params =
          reinterpret_cast<internal::SessionStorageControl_CreateNamespace_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_namespace_id{};
      SessionStorageControl_CreateNamespace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNamespace(
std::move(p_namespace_id));
      return true;
    }
    case internal::kSessionStorageControl_CloneNamespace_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::SessionStorageControl::CloneNamespace",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::SessionStorageControl::CloneNamespace");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SessionStorageControl_CloneNamespace_Params_Data* params =
          reinterpret_cast<internal::SessionStorageControl_CloneNamespace_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_namespace_id_to_clone{};
      std::string p_clone_namespace_id{};
      SessionStorageCloneType p_clone_type{};
      SessionStorageControl_CloneNamespace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNamespaceIdToClone(&p_namespace_id_to_clone))
        success = false;
      if (success && !input_data_view.ReadCloneNamespaceId(&p_clone_namespace_id))
        success = false;
      if (success && !input_data_view.ReadCloneType(&p_clone_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloneNamespace(
std::move(p_namespace_id_to_clone), 
std::move(p_clone_namespace_id), 
std::move(p_clone_type));
      return true;
    }
    case internal::kSessionStorageControl_DeleteNamespace_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::SessionStorageControl::DeleteNamespace",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::SessionStorageControl::DeleteNamespace");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SessionStorageControl_DeleteNamespace_Params_Data* params =
          reinterpret_cast<internal::SessionStorageControl_DeleteNamespace_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_namespace_id{};
      bool p_should_persist{};
      SessionStorageControl_DeleteNamespace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (success)
        p_should_persist = input_data_view.should_persist();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteNamespace(
std::move(p_namespace_id), 
std::move(p_should_persist));
      return true;
    }
  }
  return false;
}

// static
bool SessionStorageControlStubDispatch::AcceptWithResponder(
    SessionStorageControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSessionStorageControl_BindNamespace_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::SessionStorageControl::BindNamespace",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::SessionStorageControl::BindNamespace");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SessionStorageControl_BindNamespace_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_BindNamespace_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_namespace_id{};
      ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> p_receiver{};
      SessionStorageControl_BindNamespace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 0, false);
        return false;
      }
      SessionStorageControl::BindNamespaceCallback callback =
          SessionStorageControl_BindNamespace_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindNamespace(
std::move(p_namespace_id), 
std::move(p_receiver), std::move(callback));
      return true;
    }
    case internal::kSessionStorageControl_BindStorageArea_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::SessionStorageControl::BindStorageArea",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::SessionStorageControl::BindStorageArea");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SessionStorageControl_BindStorageArea_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_BindStorageArea_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      std::string p_namespace_id{};
      ::mojo::PendingReceiver<::blink::mojom::StorageArea> p_receiver{};
      SessionStorageControl_BindStorageArea_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 1, false);
        return false;
      }
      SessionStorageControl::BindStorageAreaCallback callback =
          SessionStorageControl_BindStorageArea_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindStorageArea(
std::move(p_origin), 
std::move(p_namespace_id), 
std::move(p_receiver), std::move(callback));
      return true;
    }
    case internal::kSessionStorageControl_GetUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::SessionStorageControl::GetUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::SessionStorageControl::GetUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SessionStorageControl_GetUsage_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_GetUsage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SessionStorageControl_GetUsage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 2, false);
        return false;
      }
      SessionStorageControl::GetUsageCallback callback =
          SessionStorageControl_GetUsage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUsage(std::move(callback));
      return true;
    }
    case internal::kSessionStorageControl_DeleteStorage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::SessionStorageControl::DeleteStorage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::SessionStorageControl::DeleteStorage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SessionStorageControl_DeleteStorage_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_DeleteStorage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      std::string p_namespace_id{};
      SessionStorageControl_DeleteStorage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 3, false);
        return false;
      }
      SessionStorageControl::DeleteStorageCallback callback =
          SessionStorageControl_DeleteStorage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteStorage(
std::move(p_origin), 
std::move(p_namespace_id), std::move(callback));
      return true;
    }
    case internal::kSessionStorageControl_CleanUpStorage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::SessionStorageControl::CleanUpStorage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::SessionStorageControl::CleanUpStorage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SessionStorageControl_CleanUpStorage_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_CleanUpStorage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SessionStorageControl_CleanUpStorage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 4, false);
        return false;
      }
      SessionStorageControl::CleanUpStorageCallback callback =
          SessionStorageControl_CleanUpStorage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CleanUpStorage(std::move(callback));
      return true;
    }
    case internal::kSessionStorageControl_ScavengeUnusedNamespaces_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::SessionStorageControl::ScavengeUnusedNamespaces",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::SessionStorageControl::ScavengeUnusedNamespaces");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SessionStorageControl_ScavengeUnusedNamespaces_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_ScavengeUnusedNamespaces_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SessionStorageControl_ScavengeUnusedNamespaces_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 5, false);
        return false;
      }
      SessionStorageControl::ScavengeUnusedNamespacesCallback callback =
          SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScavengeUnusedNamespaces(std::move(callback));
      return true;
    }
    case internal::kSessionStorageControl_Flush_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::SessionStorageControl::Flush",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::SessionStorageControl::Flush");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SessionStorageControl_Flush_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_Flush_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SessionStorageControl_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 6, false);
        return false;
      }
      SessionStorageControl::FlushCallback callback =
          SessionStorageControl_Flush_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(std::move(callback));
      return true;
    }
    case internal::kSessionStorageControl_PurgeMemory_Name: {
      break;
    }
    case internal::kSessionStorageControl_CreateNamespace_Name: {
      break;
    }
    case internal::kSessionStorageControl_CloneNamespace_Name: {
      break;
    }
    case internal::kSessionStorageControl_DeleteNamespace_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSessionStorageControlValidationInfo[] = {
    {internal::kSessionStorageControl_BindNamespace_Name,
     {&internal::SessionStorageControl_BindNamespace_Params_Data::Validate,
      &internal::SessionStorageControl_BindNamespace_ResponseParams_Data::Validate}},
    {internal::kSessionStorageControl_BindStorageArea_Name,
     {&internal::SessionStorageControl_BindStorageArea_Params_Data::Validate,
      &internal::SessionStorageControl_BindStorageArea_ResponseParams_Data::Validate}},
    {internal::kSessionStorageControl_GetUsage_Name,
     {&internal::SessionStorageControl_GetUsage_Params_Data::Validate,
      &internal::SessionStorageControl_GetUsage_ResponseParams_Data::Validate}},
    {internal::kSessionStorageControl_DeleteStorage_Name,
     {&internal::SessionStorageControl_DeleteStorage_Params_Data::Validate,
      &internal::SessionStorageControl_DeleteStorage_ResponseParams_Data::Validate}},
    {internal::kSessionStorageControl_CleanUpStorage_Name,
     {&internal::SessionStorageControl_CleanUpStorage_Params_Data::Validate,
      &internal::SessionStorageControl_CleanUpStorage_ResponseParams_Data::Validate}},
    {internal::kSessionStorageControl_ScavengeUnusedNamespaces_Name,
     {&internal::SessionStorageControl_ScavengeUnusedNamespaces_Params_Data::Validate,
      &internal::SessionStorageControl_ScavengeUnusedNamespaces_ResponseParams_Data::Validate}},
    {internal::kSessionStorageControl_Flush_Name,
     {&internal::SessionStorageControl_Flush_Params_Data::Validate,
      &internal::SessionStorageControl_Flush_ResponseParams_Data::Validate}},
    {internal::kSessionStorageControl_PurgeMemory_Name,
     {&internal::SessionStorageControl_PurgeMemory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSessionStorageControl_CreateNamespace_Name,
     {&internal::SessionStorageControl_CreateNamespace_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSessionStorageControl_CloneNamespace_Name,
     {&internal::SessionStorageControl_CloneNamespace_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSessionStorageControl_DeleteNamespace_Name,
     {&internal::SessionStorageControl_DeleteNamespace_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SessionStorageControlRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::SessionStorageControl::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSessionStorageControlValidationInfo);
}

bool SessionStorageControlResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::SessionStorageControl::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSessionStorageControlValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {


// static
bool StructTraits<::storage::mojom::SessionStorageUsageInfo::DataView, ::storage::mojom::SessionStorageUsageInfoPtr>::Read(
    ::storage::mojom::SessionStorageUsageInfo::DataView input,
    ::storage::mojom::SessionStorageUsageInfoPtr* output) {
  bool success = true;
  ::storage::mojom::SessionStorageUsageInfoPtr result(::storage::mojom::SessionStorageUsageInfo::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadNamespaceId(&result->namespace_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif