// components/web_package/mojom/web_bundle_parser.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/web_package/mojom/web_bundle_parser.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/read_only_file.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_JUMBO_H_
#define COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_JUMBO_H_
#endif


namespace web_package {
namespace mojom {


void WebBundleParserFactoryInterceptorForTesting::GetParserForFile(::mojo::PendingReceiver<WebBundleParser> receiver, ::base::File file) {
  GetForwardingInterface()->GetParserForFile(std::move(receiver), std::move(file));
}
void WebBundleParserFactoryInterceptorForTesting::GetParserForDataSource(::mojo::PendingReceiver<WebBundleParser> receiver, ::mojo::PendingRemote<BundleDataSource> data_source) {
  GetForwardingInterface()->GetParserForDataSource(std::move(receiver), std::move(data_source));
}
WebBundleParserFactoryAsyncWaiter::WebBundleParserFactoryAsyncWaiter(
    WebBundleParserFactory* proxy) : proxy_(proxy) {}

WebBundleParserFactoryAsyncWaiter::~WebBundleParserFactoryAsyncWaiter() = default;




void WebBundleParserInterceptorForTesting::ParseMetadata(ParseMetadataCallback callback) {
  GetForwardingInterface()->ParseMetadata(std::move(callback));
}
void WebBundleParserInterceptorForTesting::ParseResponse(uint64_t response_offset, uint64_t response_length, ParseResponseCallback callback) {
  GetForwardingInterface()->ParseResponse(std::move(response_offset), std::move(response_length), std::move(callback));
}
WebBundleParserAsyncWaiter::WebBundleParserAsyncWaiter(
    WebBundleParser* proxy) : proxy_(proxy) {}

WebBundleParserAsyncWaiter::~WebBundleParserAsyncWaiter() = default;

void WebBundleParserAsyncWaiter::ParseMetadata(
    BundleMetadataPtr* out_Result, BundleMetadataParseErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->ParseMetadata(
      base::BindOnce(
          [](base::RunLoop* loop,
             BundleMetadataPtr* out_Result
,
             BundleMetadataParseErrorPtr* out_error
,
             BundleMetadataPtr Result,
             BundleMetadataParseErrorPtr error) {*out_Result = std::move(Result);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_Result,
          out_error));
  loop.Run();
}
void WebBundleParserAsyncWaiter::ParseResponse(
    uint64_t response_offset, uint64_t response_length, BundleResponsePtr* out_Result, BundleResponseParseErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->ParseResponse(std::move(response_offset),std::move(response_length),
      base::BindOnce(
          [](base::RunLoop* loop,
             BundleResponsePtr* out_Result
,
             BundleResponseParseErrorPtr* out_error
,
             BundleResponsePtr Result,
             BundleResponseParseErrorPtr error) {*out_Result = std::move(Result);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_Result,
          out_error));
  loop.Run();
}



void BundleDataSourceInterceptorForTesting::Read(uint64_t offset, uint64_t length, ReadCallback callback) {
  GetForwardingInterface()->Read(std::move(offset), std::move(length), std::move(callback));
}
BundleDataSourceAsyncWaiter::BundleDataSourceAsyncWaiter(
    BundleDataSource* proxy) : proxy_(proxy) {}

BundleDataSourceAsyncWaiter::~BundleDataSourceAsyncWaiter() = default;

void BundleDataSourceAsyncWaiter::Read(
    uint64_t offset, uint64_t length, base::Optional<std::vector<uint8_t>>* out_buffer) {
  base::RunLoop loop;
  proxy_->Read(std::move(offset),std::move(length),
      base::BindOnce(
          [](base::RunLoop* loop,
             base::Optional<std::vector<uint8_t>>* out_buffer
,
             const base::Optional<std::vector<uint8_t>>& buffer) {*out_buffer = std::move(buffer);
            loop->Quit();
          },
          &loop,
          out_buffer));
  loop.Run();
}





}  // namespace mojom
}  // namespace web_package

#if defined(__clang__)
#pragma clang diagnostic pop
#endif