// components/web_package/mojom/web_bundle_parser.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/web_package/mojom/web_bundle_parser.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/web_package/mojom/web_bundle_parser.mojom-params-data.h"
#include "components/web_package/mojom/web_bundle_parser.mojom-shared-message-ids.h"

#include "components/web_package/mojom/web_bundle_parser.mojom-import-headers.h"


#ifndef COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_JUMBO_H_
#define COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_JUMBO_H_
#endif
namespace web_package {
namespace mojom {
BundleMetadataParseError::BundleMetadataParseError()
    : type(),
      fallback_url(),
      message() {}

BundleMetadataParseError::BundleMetadataParseError(
    BundleParseErrorType type_in,
    const ::GURL& fallback_url_in,
    const std::string& message_in)
    : type(std::move(type_in)),
      fallback_url(std::move(fallback_url_in)),
      message(std::move(message_in)) {}

BundleMetadataParseError::~BundleMetadataParseError() = default;

void BundleMetadataParseError::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type, 
      "<value of type BundleParseErrorType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fallback_url"), this->fallback_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message, 
      "<value of type const std::string&>");
}

bool BundleMetadataParseError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleResponseParseError::BundleResponseParseError()
    : type(),
      message() {}

BundleResponseParseError::BundleResponseParseError(
    BundleParseErrorType type_in,
    const std::string& message_in)
    : type(std::move(type_in)),
      message(std::move(message_in)) {}

BundleResponseParseError::~BundleResponseParseError() = default;
size_t BundleResponseParseError::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->type);
  seed = mojo::internal::Hash(seed, this->message);
  return seed;
}

void BundleResponseParseError::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type, 
      "<value of type BundleParseErrorType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message, 
      "<value of type const std::string&>");
}

bool BundleResponseParseError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleMetadata::BundleMetadata()
    : primary_url(),
      requests(),
      manifest_url(),
      authorities(),
      vouched_subsets() {}

BundleMetadata::BundleMetadata(
    const ::GURL& primary_url_in,
    base::flat_map<::GURL, BundleIndexValuePtr> requests_in,
    const ::GURL& manifest_url_in,
    std::vector<AugmentedCertificatePtr> authorities_in,
    std::vector<VouchedSubsetPtr> vouched_subsets_in)
    : primary_url(std::move(primary_url_in)),
      requests(std::move(requests_in)),
      manifest_url(std::move(manifest_url_in)),
      authorities(std::move(authorities_in)),
      vouched_subsets(std::move(vouched_subsets_in)) {}

BundleMetadata::~BundleMetadata() = default;

void BundleMetadata::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_url"), this->primary_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requests"), this->requests, 
      "<value of type base::flat_map<::GURL, BundleIndexValuePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manifest_url"), this->manifest_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authorities"), this->authorities, 
      "<value of type std::vector<AugmentedCertificatePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vouched_subsets"), this->vouched_subsets, 
      "<value of type std::vector<VouchedSubsetPtr>>");
}

bool BundleMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleIndexValue::BundleIndexValue()
    : variants_value(),
      response_locations() {}

BundleIndexValue::BundleIndexValue(
    const std::string& variants_value_in,
    std::vector<BundleResponseLocationPtr> response_locations_in)
    : variants_value(std::move(variants_value_in)),
      response_locations(std::move(response_locations_in)) {}

BundleIndexValue::~BundleIndexValue() = default;

void BundleIndexValue::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "variants_value"), this->variants_value, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_locations"), this->response_locations, 
      "<value of type std::vector<BundleResponseLocationPtr>>");
}

bool BundleIndexValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleResponseLocation::BundleResponseLocation()
    : offset(),
      length() {}

BundleResponseLocation::BundleResponseLocation(
    uint64_t offset_in,
    uint64_t length_in)
    : offset(std::move(offset_in)),
      length(std::move(length_in)) {}

BundleResponseLocation::~BundleResponseLocation() = default;
size_t BundleResponseLocation::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->offset);
  seed = mojo::internal::Hash(seed, this->length);
  return seed;
}

void BundleResponseLocation::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length"), this->length, 
      "<value of type uint64_t>");
}

bool BundleResponseLocation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AugmentedCertificate::AugmentedCertificate()
    : cert(),
      ocsp(),
      sct() {}

AugmentedCertificate::AugmentedCertificate(
    std::vector<uint8_t> cert_in,
    base::Optional<std::vector<uint8_t>> ocsp_in,
    base::Optional<std::vector<uint8_t>> sct_in)
    : cert(std::move(cert_in)),
      ocsp(std::move(ocsp_in)),
      sct(std::move(sct_in)) {}

AugmentedCertificate::~AugmentedCertificate() = default;

void AugmentedCertificate::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cert"), this->cert, 
      "<value of type const std::vector<uint8_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ocsp"), this->ocsp, 
      "<value of type const base::Optional<std::vector<uint8_t>>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sct"), this->sct, 
      "<value of type const base::Optional<std::vector<uint8_t>>&>");
}

bool AugmentedCertificate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VouchedSubset::VouchedSubset()
    : authority(),
      sig(),
      raw_signed(),
      parsed_signed() {}

VouchedSubset::VouchedSubset(
    uint64_t authority_in,
    std::vector<uint8_t> sig_in,
    std::vector<uint8_t> raw_signed_in,
    SignedSubsetPtr parsed_signed_in)
    : authority(std::move(authority_in)),
      sig(std::move(sig_in)),
      raw_signed(std::move(raw_signed_in)),
      parsed_signed(std::move(parsed_signed_in)) {}

VouchedSubset::~VouchedSubset() = default;

void VouchedSubset::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authority"), this->authority, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sig"), this->sig, 
      "<value of type const std::vector<uint8_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_signed"), this->raw_signed, 
      "<value of type const std::vector<uint8_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parsed_signed"), this->parsed_signed, 
      "<value of type SignedSubsetPtr>");
}

bool VouchedSubset::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignedSubset::SignedSubset()
    : validity_url(),
      auth_sha256(),
      date(),
      expires(),
      subset_hashes() {}

SignedSubset::SignedSubset(
    const ::GURL& validity_url_in,
    std::vector<uint8_t> auth_sha256_in,
    uint64_t date_in,
    uint64_t expires_in,
    base::flat_map<::GURL, SubsetHashesValuePtr> subset_hashes_in)
    : validity_url(std::move(validity_url_in)),
      auth_sha256(std::move(auth_sha256_in)),
      date(std::move(date_in)),
      expires(std::move(expires_in)),
      subset_hashes(std::move(subset_hashes_in)) {}

SignedSubset::~SignedSubset() = default;

void SignedSubset::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "validity_url"), this->validity_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auth_sha256"), this->auth_sha256, 
      "<value of type const std::vector<uint8_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "date"), this->date, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expires"), this->expires, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subset_hashes"), this->subset_hashes, 
      "<value of type base::flat_map<::GURL, SubsetHashesValuePtr>>");
}

bool SignedSubset::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SubsetHashesValue::SubsetHashesValue()
    : variants_value(),
      resource_integrities() {}

SubsetHashesValue::SubsetHashesValue(
    const std::string& variants_value_in,
    std::vector<ResourceIntegrityPtr> resource_integrities_in)
    : variants_value(std::move(variants_value_in)),
      resource_integrities(std::move(resource_integrities_in)) {}

SubsetHashesValue::~SubsetHashesValue() = default;

void SubsetHashesValue::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "variants_value"), this->variants_value, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_integrities"), this->resource_integrities, 
      "<value of type std::vector<ResourceIntegrityPtr>>");
}

bool SubsetHashesValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResourceIntegrity::ResourceIntegrity()
    : header_sha256(),
      payload_integrity_header() {}

ResourceIntegrity::ResourceIntegrity(
    std::vector<uint8_t> header_sha256_in,
    const std::string& payload_integrity_header_in)
    : header_sha256(std::move(header_sha256_in)),
      payload_integrity_header(std::move(payload_integrity_header_in)) {}

ResourceIntegrity::~ResourceIntegrity() = default;

void ResourceIntegrity::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header_sha256"), this->header_sha256, 
      "<value of type const std::vector<uint8_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload_integrity_header"), this->payload_integrity_header, 
      "<value of type const std::string&>");
}

bool ResourceIntegrity::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundleResponse::BundleResponse()
    : response_code(),
      response_headers(),
      payload_offset(),
      payload_length() {}

BundleResponse::BundleResponse(
    int32_t response_code_in,
    const base::flat_map<std::string, std::string>& response_headers_in,
    uint64_t payload_offset_in,
    uint64_t payload_length_in)
    : response_code(std::move(response_code_in)),
      response_headers(std::move(response_headers_in)),
      payload_offset(std::move(payload_offset_in)),
      payload_length(std::move(payload_length_in)) {}

BundleResponse::~BundleResponse() = default;

void BundleResponse::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_code"), this->response_code, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_headers"), this->response_headers, 
      "<value of type const base::flat_map<std::string, std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload_offset"), this->payload_offset, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload_length"), this->payload_length, 
      "<value of type uint64_t>");
}

bool BundleResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char WebBundleParserFactory::Name_[] = "web_package.mojom.WebBundleParserFactory";

WebBundleParserFactoryProxy::WebBundleParserFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebBundleParserFactoryProxy::GetParserForFile(
    ::mojo::PendingReceiver<WebBundleParser> in_receiver, ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "web_package::mojom::WebBundleParserFactory::GetParserForFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<WebBundleParser>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file, 
                        "<value of type ::base::File>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebBundleParserFactory_GetParserForFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParserFactory_GetParserForFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::web_package::mojom::WebBundleParserInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in WebBundleParserFactory.GetParserForFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file in WebBundleParserFactory.GetParserForFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParserFactory::Name_);
  message.set_method_name("GetParserForFile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebBundleParserFactoryProxy::GetParserForDataSource(
    ::mojo::PendingReceiver<WebBundleParser> in_receiver, ::mojo::PendingRemote<BundleDataSource> in_data_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "web_package::mojom::WebBundleParserFactory::GetParserForDataSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<WebBundleParser>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_source"), in_data_source, 
                        "<value of type ::mojo::PendingRemote<BundleDataSource>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebBundleParserFactory_GetParserForDataSource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParserFactory_GetParserForDataSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::web_package::mojom::WebBundleParserInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in WebBundleParserFactory.GetParserForDataSource request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::web_package::mojom::BundleDataSourceInterfaceBase>>(
      in_data_source, &params->data_source, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->data_source),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid data_source in WebBundleParserFactory.GetParserForDataSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParserFactory::Name_);
  message.set_method_name("GetParserForDataSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebBundleParserFactoryStubDispatch::Accept(
    WebBundleParserFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebBundleParserFactory_GetParserForFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)web_package::mojom::WebBundleParserFactory::GetParserForFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)web_package::mojom::WebBundleParserFactory::GetParserForFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebBundleParserFactory_GetParserForFile_Params_Data* params =
          reinterpret_cast<internal::WebBundleParserFactory_GetParserForFile_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<WebBundleParser> p_receiver{};
      ::base::File p_file{};
      WebBundleParserFactory_GetParserForFile_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleParserFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetParserForFile(
std::move(p_receiver), 
std::move(p_file));
      return true;
    }
    case internal::kWebBundleParserFactory_GetParserForDataSource_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)web_package::mojom::WebBundleParserFactory::GetParserForDataSource",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)web_package::mojom::WebBundleParserFactory::GetParserForDataSource");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebBundleParserFactory_GetParserForDataSource_Params_Data* params =
          reinterpret_cast<internal::WebBundleParserFactory_GetParserForDataSource_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<WebBundleParser> p_receiver{};
      ::mojo::PendingRemote<BundleDataSource> p_data_source{};
      WebBundleParserFactory_GetParserForDataSource_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_data_source =
            input_data_view.TakeDataSource<decltype(p_data_source)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleParserFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetParserForDataSource(
std::move(p_receiver), 
std::move(p_data_source));
      return true;
    }
  }
  return false;
}

// static
bool WebBundleParserFactoryStubDispatch::AcceptWithResponder(
    WebBundleParserFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebBundleParserFactory_GetParserForFile_Name: {
      break;
    }
    case internal::kWebBundleParserFactory_GetParserForDataSource_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebBundleParserFactoryValidationInfo[] = {
    {internal::kWebBundleParserFactory_GetParserForFile_Name,
     {&internal::WebBundleParserFactory_GetParserForFile_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebBundleParserFactory_GetParserForDataSource_Name,
     {&internal::WebBundleParserFactory_GetParserForDataSource_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebBundleParserFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::web_package::mojom::WebBundleParserFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebBundleParserFactoryValidationInfo);
}

const char WebBundleParser::Name_[] = "web_package.mojom.WebBundleParser";

class WebBundleParser_ParseMetadata_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBundleParser_ParseMetadata_ForwardToCallback(
      WebBundleParser::ParseMetadataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebBundleParser::ParseMetadataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebBundleParser_ParseMetadata_ForwardToCallback);
};

class WebBundleParser_ParseResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBundleParser_ParseResponse_ForwardToCallback(
      WebBundleParser::ParseResponseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebBundleParser::ParseResponseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebBundleParser_ParseResponse_ForwardToCallback);
};

WebBundleParserProxy::WebBundleParserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebBundleParserProxy::ParseMetadata(
    ParseMetadataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "web_package::mojom::WebBundleParser::ParseMetadata");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebBundleParser_ParseMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParser_ParseMetadata_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParser::Name_);
  message.set_method_name("ParseMetadata");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBundleParser_ParseMetadata_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WebBundleParserProxy::ParseResponse(
    uint64_t in_response_offset, uint64_t in_response_length, ParseResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "web_package::mojom::WebBundleParser::ParseResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_offset"), in_response_offset, 
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_length"), in_response_length, 
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebBundleParser_ParseResponse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParser_ParseResponse_Params_Data> params(
          message);
  params.Allocate();
  params->response_offset = in_response_offset;
  params->response_length = in_response_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParser::Name_);
  message.set_method_name("ParseResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBundleParser_ParseResponse_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class WebBundleParser_ParseMetadata_ProxyToResponder {
 public:
  static WebBundleParser::ParseMetadataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebBundleParser_ParseMetadata_ProxyToResponder> proxy(
        new WebBundleParser_ParseMetadata_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebBundleParser_ParseMetadata_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBundleParser_ParseMetadata_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebBundleParser_ParseMetadata_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebBundleParser::ParseMetadataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BundleMetadataPtr in_Result, BundleMetadataParseErrorPtr in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebBundleParser_ParseMetadata_ProxyToResponder);
};

bool WebBundleParser_ParseMetadata_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "web_package::mojom::WebBundleParser::ParseMetadataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebBundleParser_ParseMetadata_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBundleParser_ParseMetadata_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BundleMetadataPtr p_Result{};
  BundleMetadataParseErrorPtr p_error{};
  WebBundleParser_ParseMetadata_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_Result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBundleParser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_Result), 
std::move(p_error));
  return true;
}

void WebBundleParser_ParseMetadata_ProxyToResponder::Run(
    BundleMetadataPtr in_Result, BundleMetadataParseErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)web_package::mojom::WebBundleParser::ParseMetadataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("Result"), in_Result, 
                        "<value of type BundleMetadataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type BundleMetadataParseErrorPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebBundleParser_ParseMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParser_ParseMetadata_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->Result)::BaseType> Result_fragment(
          params.message());
  mojo::internal::Serialize<::web_package::mojom::BundleMetadataDataView>(
      in_Result, Result_fragment);
  params->Result.Set(
      Result_fragment.is_null() ? nullptr : Result_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<::web_package::mojom::BundleMetadataParseErrorDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)web_package::mojom::WebBundleParser::ParseMetadataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParser::Name_);
  message.set_method_name("ParseMetadata");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBundleParser_ParseResponse_ProxyToResponder {
 public:
  static WebBundleParser::ParseResponseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebBundleParser_ParseResponse_ProxyToResponder> proxy(
        new WebBundleParser_ParseResponse_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebBundleParser_ParseResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBundleParser_ParseResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebBundleParser_ParseResponse_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebBundleParser::ParseResponseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BundleResponsePtr in_Result, BundleResponseParseErrorPtr in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebBundleParser_ParseResponse_ProxyToResponder);
};

bool WebBundleParser_ParseResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "web_package::mojom::WebBundleParser::ParseResponseCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebBundleParser_ParseResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBundleParser_ParseResponse_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BundleResponsePtr p_Result{};
  BundleResponseParseErrorPtr p_error{};
  WebBundleParser_ParseResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_Result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBundleParser::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_Result), 
std::move(p_error));
  return true;
}

void WebBundleParser_ParseResponse_ProxyToResponder::Run(
    BundleResponsePtr in_Result, BundleResponseParseErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)web_package::mojom::WebBundleParser::ParseResponseCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("Result"), in_Result, 
                        "<value of type BundleResponsePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type BundleResponseParseErrorPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebBundleParser_ParseResponse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::WebBundleParser_ParseResponse_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->Result)::BaseType> Result_fragment(
          params.message());
  mojo::internal::Serialize<::web_package::mojom::BundleResponseDataView>(
      in_Result, Result_fragment);
  params->Result.Set(
      Result_fragment.is_null() ? nullptr : Result_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<::web_package::mojom::BundleResponseParseErrorDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)web_package::mojom::WebBundleParser::ParseResponseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleParser::Name_);
  message.set_method_name("ParseResponse");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebBundleParserStubDispatch::Accept(
    WebBundleParser* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebBundleParser_ParseMetadata_Name: {
      break;
    }
    case internal::kWebBundleParser_ParseResponse_Name: {
      break;
    }
  }
  return false;
}

// static
bool WebBundleParserStubDispatch::AcceptWithResponder(
    WebBundleParser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebBundleParser_ParseMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)web_package::mojom::WebBundleParser::ParseMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)web_package::mojom::WebBundleParser::ParseMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebBundleParser_ParseMetadata_Params_Data* params =
          reinterpret_cast<
              internal::WebBundleParser_ParseMetadata_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WebBundleParser_ParseMetadata_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleParser::Name_, 0, false);
        return false;
      }
      WebBundleParser::ParseMetadataCallback callback =
          WebBundleParser_ParseMetadata_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseMetadata(std::move(callback));
      return true;
    }
    case internal::kWebBundleParser_ParseResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)web_package::mojom::WebBundleParser::ParseResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)web_package::mojom::WebBundleParser::ParseResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebBundleParser_ParseResponse_Params_Data* params =
          reinterpret_cast<
              internal::WebBundleParser_ParseResponse_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_response_offset{};
      uint64_t p_response_length{};
      WebBundleParser_ParseResponse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_response_offset = input_data_view.response_offset();
      if (success)
        p_response_length = input_data_view.response_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleParser::Name_, 1, false);
        return false;
      }
      WebBundleParser::ParseResponseCallback callback =
          WebBundleParser_ParseResponse_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseResponse(
std::move(p_response_offset), 
std::move(p_response_length), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebBundleParserValidationInfo[] = {
    {internal::kWebBundleParser_ParseMetadata_Name,
     {&internal::WebBundleParser_ParseMetadata_Params_Data::Validate,
      &internal::WebBundleParser_ParseMetadata_ResponseParams_Data::Validate}},
    {internal::kWebBundleParser_ParseResponse_Name,
     {&internal::WebBundleParser_ParseResponse_Params_Data::Validate,
      &internal::WebBundleParser_ParseResponse_ResponseParams_Data::Validate}},
};

bool WebBundleParserRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::web_package::mojom::WebBundleParser::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebBundleParserValidationInfo);
}

bool WebBundleParserResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::web_package::mojom::WebBundleParser::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kWebBundleParserValidationInfo);

}
const char BundleDataSource::Name_[] = "web_package.mojom.BundleDataSource";

class BundleDataSource_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BundleDataSource_Read_ForwardToCallback(
      BundleDataSource::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BundleDataSource::ReadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BundleDataSource_Read_ForwardToCallback);
};

BundleDataSourceProxy::BundleDataSourceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BundleDataSourceProxy::Read(
    uint64_t in_offset, uint64_t in_length, ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "web_package::mojom::BundleDataSource::Read", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset, 
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length, 
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBundleDataSource_Read_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::BundleDataSource_Read_Params_Data> params(
          message);
  params.Allocate();
  params->offset = in_offset;
  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BundleDataSource::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BundleDataSource_Read_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class BundleDataSource_Read_ProxyToResponder {
 public:
  static BundleDataSource::ReadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BundleDataSource_Read_ProxyToResponder> proxy(
        new BundleDataSource_Read_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BundleDataSource_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BundleDataSource_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BundleDataSource_Read_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BundleDataSource::ReadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::Optional<std::vector<uint8_t>>& in_buffer);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BundleDataSource_Read_ProxyToResponder);
};

bool BundleDataSource_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "web_package::mojom::BundleDataSource::ReadCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BundleDataSource_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BundleDataSource_Read_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  base::Optional<std::vector<uint8_t>> p_buffer{};
  BundleDataSource_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBuffer(&p_buffer))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BundleDataSource::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_buffer));
  return true;
}

void BundleDataSource_Read_ProxyToResponder::Run(
    const base::Optional<std::vector<uint8_t>>& in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)web_package::mojom::BundleDataSource::ReadCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type const base::Optional<std::vector<uint8_t>>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBundleDataSource_Read_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::web_package::mojom::internal::BundleDataSource_Read_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType>
      buffer_fragment(params.message());
  const mojo::internal::ContainerValidateParams buffer_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_buffer, buffer_fragment, &buffer_validate_params);
  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)web_package::mojom::BundleDataSource::ReadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BundleDataSource::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BundleDataSourceStubDispatch::Accept(
    BundleDataSource* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBundleDataSource_Read_Name: {
      break;
    }
  }
  return false;
}

// static
bool BundleDataSourceStubDispatch::AcceptWithResponder(
    BundleDataSource* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBundleDataSource_Read_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)web_package::mojom::BundleDataSource::Read",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)web_package::mojom::BundleDataSource::Read");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BundleDataSource_Read_Params_Data* params =
          reinterpret_cast<
              internal::BundleDataSource_Read_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_offset{};
      uint64_t p_length{};
      BundleDataSource_Read_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BundleDataSource::Name_, 0, false);
        return false;
      }
      BundleDataSource::ReadCallback callback =
          BundleDataSource_Read_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(
std::move(p_offset), 
std::move(p_length), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBundleDataSourceValidationInfo[] = {
    {internal::kBundleDataSource_Read_Name,
     {&internal::BundleDataSource_Read_Params_Data::Validate,
      &internal::BundleDataSource_Read_ResponseParams_Data::Validate}},
};

bool BundleDataSourceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::web_package::mojom::BundleDataSource::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBundleDataSourceValidationInfo);
}

bool BundleDataSourceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::web_package::mojom::BundleDataSource::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kBundleDataSourceValidationInfo);

}
}  // namespace mojom
}  // namespace web_package

namespace mojo {


// static
bool StructTraits<::web_package::mojom::BundleMetadataParseError::DataView, ::web_package::mojom::BundleMetadataParseErrorPtr>::Read(
    ::web_package::mojom::BundleMetadataParseError::DataView input,
    ::web_package::mojom::BundleMetadataParseErrorPtr* output) {
  bool success = true;
  ::web_package::mojom::BundleMetadataParseErrorPtr result(::web_package::mojom::BundleMetadataParseError::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadFallbackUrl(&result->fallback_url))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleResponseParseError::DataView, ::web_package::mojom::BundleResponseParseErrorPtr>::Read(
    ::web_package::mojom::BundleResponseParseError::DataView input,
    ::web_package::mojom::BundleResponseParseErrorPtr* output) {
  bool success = true;
  ::web_package::mojom::BundleResponseParseErrorPtr result(::web_package::mojom::BundleResponseParseError::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleMetadata::DataView, ::web_package::mojom::BundleMetadataPtr>::Read(
    ::web_package::mojom::BundleMetadata::DataView input,
    ::web_package::mojom::BundleMetadataPtr* output) {
  bool success = true;
  ::web_package::mojom::BundleMetadataPtr result(::web_package::mojom::BundleMetadata::New());
  
      if (success && !input.ReadPrimaryUrl(&result->primary_url))
        success = false;
      if (success && !input.ReadRequests(&result->requests))
        success = false;
      if (success && !input.ReadManifestUrl(&result->manifest_url))
        success = false;
      if (success && !input.ReadAuthorities(&result->authorities))
        success = false;
      if (success && !input.ReadVouchedSubsets(&result->vouched_subsets))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleIndexValue::DataView, ::web_package::mojom::BundleIndexValuePtr>::Read(
    ::web_package::mojom::BundleIndexValue::DataView input,
    ::web_package::mojom::BundleIndexValuePtr* output) {
  bool success = true;
  ::web_package::mojom::BundleIndexValuePtr result(::web_package::mojom::BundleIndexValue::New());
  
      if (success && !input.ReadVariantsValue(&result->variants_value))
        success = false;
      if (success && !input.ReadResponseLocations(&result->response_locations))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleResponseLocation::DataView, ::web_package::mojom::BundleResponseLocationPtr>::Read(
    ::web_package::mojom::BundleResponseLocation::DataView input,
    ::web_package::mojom::BundleResponseLocationPtr* output) {
  bool success = true;
  ::web_package::mojom::BundleResponseLocationPtr result(::web_package::mojom::BundleResponseLocation::New());
  
      if (success)
        result->offset = input.offset();
      if (success)
        result->length = input.length();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::AugmentedCertificate::DataView, ::web_package::mojom::AugmentedCertificatePtr>::Read(
    ::web_package::mojom::AugmentedCertificate::DataView input,
    ::web_package::mojom::AugmentedCertificatePtr* output) {
  bool success = true;
  ::web_package::mojom::AugmentedCertificatePtr result(::web_package::mojom::AugmentedCertificate::New());
  
      if (success && !input.ReadCert(&result->cert))
        success = false;
      if (success && !input.ReadOcsp(&result->ocsp))
        success = false;
      if (success && !input.ReadSct(&result->sct))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::VouchedSubset::DataView, ::web_package::mojom::VouchedSubsetPtr>::Read(
    ::web_package::mojom::VouchedSubset::DataView input,
    ::web_package::mojom::VouchedSubsetPtr* output) {
  bool success = true;
  ::web_package::mojom::VouchedSubsetPtr result(::web_package::mojom::VouchedSubset::New());
  
      if (success)
        result->authority = input.authority();
      if (success && !input.ReadSig(&result->sig))
        success = false;
      if (success && !input.ReadRawSigned(&result->raw_signed))
        success = false;
      if (success && !input.ReadParsedSigned(&result->parsed_signed))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::SignedSubset::DataView, ::web_package::mojom::SignedSubsetPtr>::Read(
    ::web_package::mojom::SignedSubset::DataView input,
    ::web_package::mojom::SignedSubsetPtr* output) {
  bool success = true;
  ::web_package::mojom::SignedSubsetPtr result(::web_package::mojom::SignedSubset::New());
  
      if (success && !input.ReadValidityUrl(&result->validity_url))
        success = false;
      if (success && !input.ReadAuthSha256(&result->auth_sha256))
        success = false;
      if (success)
        result->date = input.date();
      if (success)
        result->expires = input.expires();
      if (success && !input.ReadSubsetHashes(&result->subset_hashes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::SubsetHashesValue::DataView, ::web_package::mojom::SubsetHashesValuePtr>::Read(
    ::web_package::mojom::SubsetHashesValue::DataView input,
    ::web_package::mojom::SubsetHashesValuePtr* output) {
  bool success = true;
  ::web_package::mojom::SubsetHashesValuePtr result(::web_package::mojom::SubsetHashesValue::New());
  
      if (success && !input.ReadVariantsValue(&result->variants_value))
        success = false;
      if (success && !input.ReadResourceIntegrities(&result->resource_integrities))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::ResourceIntegrity::DataView, ::web_package::mojom::ResourceIntegrityPtr>::Read(
    ::web_package::mojom::ResourceIntegrity::DataView input,
    ::web_package::mojom::ResourceIntegrityPtr* output) {
  bool success = true;
  ::web_package::mojom::ResourceIntegrityPtr result(::web_package::mojom::ResourceIntegrity::New());
  
      if (success && !input.ReadHeaderSha256(&result->header_sha256))
        success = false;
      if (success && !input.ReadPayloadIntegrityHeader(&result->payload_integrity_header))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::web_package::mojom::BundleResponse::DataView, ::web_package::mojom::BundleResponsePtr>::Read(
    ::web_package::mojom::BundleResponse::DataView input,
    ::web_package::mojom::BundleResponsePtr* output) {
  bool success = true;
  ::web_package::mojom::BundleResponsePtr result(::web_package::mojom::BundleResponse::New());
  
      if (success)
        result->response_code = input.response_code();
      if (success && !input.ReadResponseHeaders(&result->response_headers))
        success = false;
      if (success)
        result->payload_offset = input.payload_offset();
      if (success)
        result->payload_length = input.payload_length();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif