// content/browser/conversions/conversion_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/browser/conversions/conversion_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/browser/conversions/conversion_internals.mojom-params-data.h"
#include "content/browser/conversions/conversion_internals.mojom-shared-message-ids.h"

#include "content/browser/conversions/conversion_internals.mojom-import-headers.h"


#ifndef CONTENT_BROWSER_CONVERSIONS_CONVERSION_INTERNALS_MOJOM_JUMBO_H_
#define CONTENT_BROWSER_CONVERSIONS_CONVERSION_INTERNALS_MOJOM_JUMBO_H_
#endif
namespace mojom {
WebUIConversionReport::WebUIConversionReport()
    : impression_data(),
      conversion_data(),
      conversion_origin(),
      reporting_origin(),
      report_time(),
      attribution_credit() {}

WebUIConversionReport::WebUIConversionReport(
    const std::string& impression_data_in,
    const std::string& conversion_data_in,
    const ::url::Origin& conversion_origin_in,
    const ::url::Origin& reporting_origin_in,
    double report_time_in,
    int32_t attribution_credit_in)
    : impression_data(std::move(impression_data_in)),
      conversion_data(std::move(conversion_data_in)),
      conversion_origin(std::move(conversion_origin_in)),
      reporting_origin(std::move(reporting_origin_in)),
      report_time(std::move(report_time_in)),
      attribution_credit(std::move(attribution_credit_in)) {}

WebUIConversionReport::~WebUIConversionReport() = default;

void WebUIConversionReport::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression_data"), this->impression_data, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conversion_data"), this->conversion_data, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conversion_origin"), this->conversion_origin, 
      "<value of type const ::url::Origin&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_origin"), this->reporting_origin, 
      "<value of type const ::url::Origin&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_time"), this->report_time, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_credit"), this->attribution_credit, 
      "<value of type int32_t>");
}

bool WebUIConversionReport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIImpression::WebUIImpression()
    : impression_data(),
      impression_origin(),
      conversion_destination(),
      reporting_origin(),
      impression_time(),
      expiry_time() {}

WebUIImpression::WebUIImpression(
    const std::string& impression_data_in,
    const ::url::Origin& impression_origin_in,
    const ::url::Origin& conversion_destination_in,
    const ::url::Origin& reporting_origin_in,
    double impression_time_in,
    double expiry_time_in)
    : impression_data(std::move(impression_data_in)),
      impression_origin(std::move(impression_origin_in)),
      conversion_destination(std::move(conversion_destination_in)),
      reporting_origin(std::move(reporting_origin_in)),
      impression_time(std::move(impression_time_in)),
      expiry_time(std::move(expiry_time_in)) {}

WebUIImpression::~WebUIImpression() = default;

void WebUIImpression::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression_data"), this->impression_data, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression_origin"), this->impression_origin, 
      "<value of type const ::url::Origin&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conversion_destination"), this->conversion_destination, 
      "<value of type const ::url::Origin&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_origin"), this->reporting_origin, 
      "<value of type const ::url::Origin&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression_time"), this->impression_time, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiry_time"), this->expiry_time, 
      "<value of type double>");
}

bool WebUIImpression::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ConversionInternalsHandler::Name_[] = "mojom.ConversionInternalsHandler";

class ConversionInternalsHandler_IsMeasurementEnabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ConversionInternalsHandler_IsMeasurementEnabled_ForwardToCallback(
      ConversionInternalsHandler::IsMeasurementEnabledCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ConversionInternalsHandler::IsMeasurementEnabledCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ConversionInternalsHandler_IsMeasurementEnabled_ForwardToCallback);
};

class ConversionInternalsHandler_GetActiveImpressions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ConversionInternalsHandler_GetActiveImpressions_ForwardToCallback(
      ConversionInternalsHandler::GetActiveImpressionsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ConversionInternalsHandler::GetActiveImpressionsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ConversionInternalsHandler_GetActiveImpressions_ForwardToCallback);
};

class ConversionInternalsHandler_GetPendingReports_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ConversionInternalsHandler_GetPendingReports_ForwardToCallback(
      ConversionInternalsHandler::GetPendingReportsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ConversionInternalsHandler::GetPendingReportsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ConversionInternalsHandler_GetPendingReports_ForwardToCallback);
};

class ConversionInternalsHandler_SendPendingReports_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ConversionInternalsHandler_SendPendingReports_ForwardToCallback(
      ConversionInternalsHandler::SendPendingReportsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ConversionInternalsHandler::SendPendingReportsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ConversionInternalsHandler_SendPendingReports_ForwardToCallback);
};

class ConversionInternalsHandler_ClearStorage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ConversionInternalsHandler_ClearStorage_ForwardToCallback(
      ConversionInternalsHandler::ClearStorageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ConversionInternalsHandler::ClearStorageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ConversionInternalsHandler_ClearStorage_ForwardToCallback);
};

ConversionInternalsHandlerProxy::ConversionInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ConversionInternalsHandlerProxy::IsMeasurementEnabled(
    IsMeasurementEnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "mojom::ConversionInternalsHandler::IsMeasurementEnabled");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kConversionInternalsHandler_IsMeasurementEnabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ConversionInternalsHandler_IsMeasurementEnabled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConversionInternalsHandler::Name_);
  message.set_method_name("IsMeasurementEnabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ConversionInternalsHandler_IsMeasurementEnabled_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ConversionInternalsHandlerProxy::GetActiveImpressions(
    GetActiveImpressionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "mojom::ConversionInternalsHandler::GetActiveImpressions");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kConversionInternalsHandler_GetActiveImpressions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ConversionInternalsHandler_GetActiveImpressions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConversionInternalsHandler::Name_);
  message.set_method_name("GetActiveImpressions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ConversionInternalsHandler_GetActiveImpressions_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ConversionInternalsHandlerProxy::GetPendingReports(
    GetPendingReportsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "mojom::ConversionInternalsHandler::GetPendingReports");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kConversionInternalsHandler_GetPendingReports_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ConversionInternalsHandler_GetPendingReports_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConversionInternalsHandler::Name_);
  message.set_method_name("GetPendingReports");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ConversionInternalsHandler_GetPendingReports_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ConversionInternalsHandlerProxy::SendPendingReports(
    SendPendingReportsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "mojom::ConversionInternalsHandler::SendPendingReports");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kConversionInternalsHandler_SendPendingReports_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ConversionInternalsHandler_SendPendingReports_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConversionInternalsHandler::Name_);
  message.set_method_name("SendPendingReports");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ConversionInternalsHandler_SendPendingReports_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ConversionInternalsHandlerProxy::ClearStorage(
    ClearStorageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "mojom::ConversionInternalsHandler::ClearStorage");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kConversionInternalsHandler_ClearStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ConversionInternalsHandler_ClearStorage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConversionInternalsHandler::Name_);
  message.set_method_name("ClearStorage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ConversionInternalsHandler_ClearStorage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ConversionInternalsHandler_IsMeasurementEnabled_ProxyToResponder {
 public:
  static ConversionInternalsHandler::IsMeasurementEnabledCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ConversionInternalsHandler_IsMeasurementEnabled_ProxyToResponder> proxy(
        new ConversionInternalsHandler_IsMeasurementEnabled_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ConversionInternalsHandler_IsMeasurementEnabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ConversionInternalsHandler_IsMeasurementEnabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ConversionInternalsHandler_IsMeasurementEnabled_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ConversionInternalsHandler::IsMeasurementEnabledCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_enabled);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ConversionInternalsHandler_IsMeasurementEnabled_ProxyToResponder);
};

bool ConversionInternalsHandler_IsMeasurementEnabled_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "mojom::ConversionInternalsHandler::IsMeasurementEnabledCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ConversionInternalsHandler_IsMeasurementEnabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ConversionInternalsHandler_IsMeasurementEnabled_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_enabled{};
  ConversionInternalsHandler_IsMeasurementEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ConversionInternalsHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_enabled));
  return true;
}

void ConversionInternalsHandler_IsMeasurementEnabled_ProxyToResponder::Run(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)mojom::ConversionInternalsHandler::IsMeasurementEnabledCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kConversionInternalsHandler_IsMeasurementEnabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ConversionInternalsHandler_IsMeasurementEnabled_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)mojom::ConversionInternalsHandler::IsMeasurementEnabledCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConversionInternalsHandler::Name_);
  message.set_method_name("IsMeasurementEnabled");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ConversionInternalsHandler_GetActiveImpressions_ProxyToResponder {
 public:
  static ConversionInternalsHandler::GetActiveImpressionsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ConversionInternalsHandler_GetActiveImpressions_ProxyToResponder> proxy(
        new ConversionInternalsHandler_GetActiveImpressions_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ConversionInternalsHandler_GetActiveImpressions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ConversionInternalsHandler_GetActiveImpressions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ConversionInternalsHandler_GetActiveImpressions_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ConversionInternalsHandler::GetActiveImpressionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<WebUIImpressionPtr> in_impressions);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ConversionInternalsHandler_GetActiveImpressions_ProxyToResponder);
};

bool ConversionInternalsHandler_GetActiveImpressions_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "mojom::ConversionInternalsHandler::GetActiveImpressionsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ConversionInternalsHandler_GetActiveImpressions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ConversionInternalsHandler_GetActiveImpressions_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<WebUIImpressionPtr> p_impressions{};
  ConversionInternalsHandler_GetActiveImpressions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadImpressions(&p_impressions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ConversionInternalsHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_impressions));
  return true;
}

void ConversionInternalsHandler_GetActiveImpressions_ProxyToResponder::Run(
    std::vector<WebUIImpressionPtr> in_impressions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)mojom::ConversionInternalsHandler::GetActiveImpressionsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("impressions"), in_impressions, 
                        "<value of type std::vector<WebUIImpressionPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kConversionInternalsHandler_GetActiveImpressions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ConversionInternalsHandler_GetActiveImpressions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->impressions)::BaseType>
      impressions_fragment(params.message());
  const mojo::internal::ContainerValidateParams impressions_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::mojom::WebUIImpressionDataView>>(
      in_impressions, impressions_fragment, &impressions_validate_params);
  params->impressions.Set(
      impressions_fragment.is_null() ? nullptr : impressions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->impressions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null impressions in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)mojom::ConversionInternalsHandler::GetActiveImpressionsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConversionInternalsHandler::Name_);
  message.set_method_name("GetActiveImpressions");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ConversionInternalsHandler_GetPendingReports_ProxyToResponder {
 public:
  static ConversionInternalsHandler::GetPendingReportsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ConversionInternalsHandler_GetPendingReports_ProxyToResponder> proxy(
        new ConversionInternalsHandler_GetPendingReports_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ConversionInternalsHandler_GetPendingReports_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ConversionInternalsHandler_GetPendingReports_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ConversionInternalsHandler_GetPendingReports_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ConversionInternalsHandler::GetPendingReportsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<WebUIConversionReportPtr> in_reports);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ConversionInternalsHandler_GetPendingReports_ProxyToResponder);
};

bool ConversionInternalsHandler_GetPendingReports_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "mojom::ConversionInternalsHandler::GetPendingReportsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ConversionInternalsHandler_GetPendingReports_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ConversionInternalsHandler_GetPendingReports_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<WebUIConversionReportPtr> p_reports{};
  ConversionInternalsHandler_GetPendingReports_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReports(&p_reports))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ConversionInternalsHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_reports));
  return true;
}

void ConversionInternalsHandler_GetPendingReports_ProxyToResponder::Run(
    std::vector<WebUIConversionReportPtr> in_reports) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)mojom::ConversionInternalsHandler::GetPendingReportsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reports"), in_reports, 
                        "<value of type std::vector<WebUIConversionReportPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kConversionInternalsHandler_GetPendingReports_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ConversionInternalsHandler_GetPendingReports_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reports)::BaseType>
      reports_fragment(params.message());
  const mojo::internal::ContainerValidateParams reports_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::mojom::WebUIConversionReportDataView>>(
      in_reports, reports_fragment, &reports_validate_params);
  params->reports.Set(
      reports_fragment.is_null() ? nullptr : reports_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reports.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reports in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)mojom::ConversionInternalsHandler::GetPendingReportsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConversionInternalsHandler::Name_);
  message.set_method_name("GetPendingReports");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ConversionInternalsHandler_SendPendingReports_ProxyToResponder {
 public:
  static ConversionInternalsHandler::SendPendingReportsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ConversionInternalsHandler_SendPendingReports_ProxyToResponder> proxy(
        new ConversionInternalsHandler_SendPendingReports_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ConversionInternalsHandler_SendPendingReports_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ConversionInternalsHandler_SendPendingReports_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ConversionInternalsHandler_SendPendingReports_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ConversionInternalsHandler::SendPendingReportsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ConversionInternalsHandler_SendPendingReports_ProxyToResponder);
};

bool ConversionInternalsHandler_SendPendingReports_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "mojom::ConversionInternalsHandler::SendPendingReportsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ConversionInternalsHandler_SendPendingReports_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ConversionInternalsHandler_SendPendingReports_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ConversionInternalsHandler_SendPendingReports_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ConversionInternalsHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ConversionInternalsHandler_SendPendingReports_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)mojom::ConversionInternalsHandler::SendPendingReportsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kConversionInternalsHandler_SendPendingReports_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ConversionInternalsHandler_SendPendingReports_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)mojom::ConversionInternalsHandler::SendPendingReportsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConversionInternalsHandler::Name_);
  message.set_method_name("SendPendingReports");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ConversionInternalsHandler_ClearStorage_ProxyToResponder {
 public:
  static ConversionInternalsHandler::ClearStorageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ConversionInternalsHandler_ClearStorage_ProxyToResponder> proxy(
        new ConversionInternalsHandler_ClearStorage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ConversionInternalsHandler_ClearStorage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ConversionInternalsHandler_ClearStorage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ConversionInternalsHandler_ClearStorage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ConversionInternalsHandler::ClearStorageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ConversionInternalsHandler_ClearStorage_ProxyToResponder);
};

bool ConversionInternalsHandler_ClearStorage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "mojom::ConversionInternalsHandler::ClearStorageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ConversionInternalsHandler_ClearStorage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ConversionInternalsHandler_ClearStorage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ConversionInternalsHandler_ClearStorage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ConversionInternalsHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ConversionInternalsHandler_ClearStorage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)mojom::ConversionInternalsHandler::ClearStorageCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kConversionInternalsHandler_ClearStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ConversionInternalsHandler_ClearStorage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)mojom::ConversionInternalsHandler::ClearStorageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConversionInternalsHandler::Name_);
  message.set_method_name("ClearStorage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ConversionInternalsHandlerStubDispatch::Accept(
    ConversionInternalsHandler* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kConversionInternalsHandler_IsMeasurementEnabled_Name: {
      break;
    }
    case internal::kConversionInternalsHandler_GetActiveImpressions_Name: {
      break;
    }
    case internal::kConversionInternalsHandler_GetPendingReports_Name: {
      break;
    }
    case internal::kConversionInternalsHandler_SendPendingReports_Name: {
      break;
    }
    case internal::kConversionInternalsHandler_ClearStorage_Name: {
      break;
    }
  }
  return false;
}

// static
bool ConversionInternalsHandlerStubDispatch::AcceptWithResponder(
    ConversionInternalsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kConversionInternalsHandler_IsMeasurementEnabled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)mojom::ConversionInternalsHandler::IsMeasurementEnabled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)mojom::ConversionInternalsHandler::IsMeasurementEnabled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ConversionInternalsHandler_IsMeasurementEnabled_Params_Data* params =
          reinterpret_cast<
              internal::ConversionInternalsHandler_IsMeasurementEnabled_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ConversionInternalsHandler_IsMeasurementEnabled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ConversionInternalsHandler::Name_, 0, false);
        return false;
      }
      ConversionInternalsHandler::IsMeasurementEnabledCallback callback =
          ConversionInternalsHandler_IsMeasurementEnabled_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsMeasurementEnabled(std::move(callback));
      return true;
    }
    case internal::kConversionInternalsHandler_GetActiveImpressions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)mojom::ConversionInternalsHandler::GetActiveImpressions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)mojom::ConversionInternalsHandler::GetActiveImpressions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ConversionInternalsHandler_GetActiveImpressions_Params_Data* params =
          reinterpret_cast<
              internal::ConversionInternalsHandler_GetActiveImpressions_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ConversionInternalsHandler_GetActiveImpressions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ConversionInternalsHandler::Name_, 1, false);
        return false;
      }
      ConversionInternalsHandler::GetActiveImpressionsCallback callback =
          ConversionInternalsHandler_GetActiveImpressions_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetActiveImpressions(std::move(callback));
      return true;
    }
    case internal::kConversionInternalsHandler_GetPendingReports_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)mojom::ConversionInternalsHandler::GetPendingReports",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)mojom::ConversionInternalsHandler::GetPendingReports");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ConversionInternalsHandler_GetPendingReports_Params_Data* params =
          reinterpret_cast<
              internal::ConversionInternalsHandler_GetPendingReports_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ConversionInternalsHandler_GetPendingReports_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ConversionInternalsHandler::Name_, 2, false);
        return false;
      }
      ConversionInternalsHandler::GetPendingReportsCallback callback =
          ConversionInternalsHandler_GetPendingReports_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPendingReports(std::move(callback));
      return true;
    }
    case internal::kConversionInternalsHandler_SendPendingReports_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)mojom::ConversionInternalsHandler::SendPendingReports",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)mojom::ConversionInternalsHandler::SendPendingReports");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ConversionInternalsHandler_SendPendingReports_Params_Data* params =
          reinterpret_cast<
              internal::ConversionInternalsHandler_SendPendingReports_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ConversionInternalsHandler_SendPendingReports_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ConversionInternalsHandler::Name_, 3, false);
        return false;
      }
      ConversionInternalsHandler::SendPendingReportsCallback callback =
          ConversionInternalsHandler_SendPendingReports_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendPendingReports(std::move(callback));
      return true;
    }
    case internal::kConversionInternalsHandler_ClearStorage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)mojom::ConversionInternalsHandler::ClearStorage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)mojom::ConversionInternalsHandler::ClearStorage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ConversionInternalsHandler_ClearStorage_Params_Data* params =
          reinterpret_cast<
              internal::ConversionInternalsHandler_ClearStorage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ConversionInternalsHandler_ClearStorage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ConversionInternalsHandler::Name_, 4, false);
        return false;
      }
      ConversionInternalsHandler::ClearStorageCallback callback =
          ConversionInternalsHandler_ClearStorage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearStorage(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kConversionInternalsHandlerValidationInfo[] = {
    {internal::kConversionInternalsHandler_IsMeasurementEnabled_Name,
     {&internal::ConversionInternalsHandler_IsMeasurementEnabled_Params_Data::Validate,
      &internal::ConversionInternalsHandler_IsMeasurementEnabled_ResponseParams_Data::Validate}},
    {internal::kConversionInternalsHandler_GetActiveImpressions_Name,
     {&internal::ConversionInternalsHandler_GetActiveImpressions_Params_Data::Validate,
      &internal::ConversionInternalsHandler_GetActiveImpressions_ResponseParams_Data::Validate}},
    {internal::kConversionInternalsHandler_GetPendingReports_Name,
     {&internal::ConversionInternalsHandler_GetPendingReports_Params_Data::Validate,
      &internal::ConversionInternalsHandler_GetPendingReports_ResponseParams_Data::Validate}},
    {internal::kConversionInternalsHandler_SendPendingReports_Name,
     {&internal::ConversionInternalsHandler_SendPendingReports_Params_Data::Validate,
      &internal::ConversionInternalsHandler_SendPendingReports_ResponseParams_Data::Validate}},
    {internal::kConversionInternalsHandler_ClearStorage_Name,
     {&internal::ConversionInternalsHandler_ClearStorage_Params_Data::Validate,
      &internal::ConversionInternalsHandler_ClearStorage_ResponseParams_Data::Validate}},
};

bool ConversionInternalsHandlerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::mojom::ConversionInternalsHandler::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kConversionInternalsHandlerValidationInfo);
}

bool ConversionInternalsHandlerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::mojom::ConversionInternalsHandler::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kConversionInternalsHandlerValidationInfo);

}
}  // namespace mojom

namespace mojo {


// static
bool StructTraits<::mojom::WebUIConversionReport::DataView, ::mojom::WebUIConversionReportPtr>::Read(
    ::mojom::WebUIConversionReport::DataView input,
    ::mojom::WebUIConversionReportPtr* output) {
  bool success = true;
  ::mojom::WebUIConversionReportPtr result(::mojom::WebUIConversionReport::New());
  
      if (success && !input.ReadImpressionData(&result->impression_data))
        success = false;
      if (success && !input.ReadConversionData(&result->conversion_data))
        success = false;
      if (success && !input.ReadConversionOrigin(&result->conversion_origin))
        success = false;
      if (success && !input.ReadReportingOrigin(&result->reporting_origin))
        success = false;
      if (success)
        result->report_time = input.report_time();
      if (success)
        result->attribution_credit = input.attribution_credit();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::WebUIImpression::DataView, ::mojom::WebUIImpressionPtr>::Read(
    ::mojom::WebUIImpression::DataView input,
    ::mojom::WebUIImpressionPtr* output) {
  bool success = true;
  ::mojom::WebUIImpressionPtr result(::mojom::WebUIImpression::New());
  
      if (success && !input.ReadImpressionData(&result->impression_data))
        success = false;
      if (success && !input.ReadImpressionOrigin(&result->impression_origin))
        success = false;
      if (success && !input.ReadConversionDestination(&result->conversion_destination))
        success = false;
      if (success && !input.ReadReportingOrigin(&result->reporting_origin))
        success = false;
      if (success)
        result->impression_time = input.impression_time();
      if (success)
        result->expiry_time = input.expiry_time();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif