// content/browser/process_internals/process_internals.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "content/browser/process_internals/process_internals.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "url/mojom/url.mojom.h"


#ifndef CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_JUMBO_H_
#define CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_JUMBO_H_
#endif


namespace mojom {


void ProcessInternalsHandlerInterceptorForTesting::GetIsolationMode(GetIsolationModeCallback callback) {
  GetForwardingInterface()->GetIsolationMode(std::move(callback));
}
void ProcessInternalsHandlerInterceptorForTesting::GetUserTriggeredIsolatedOrigins(GetUserTriggeredIsolatedOriginsCallback callback) {
  GetForwardingInterface()->GetUserTriggeredIsolatedOrigins(std::move(callback));
}
void ProcessInternalsHandlerInterceptorForTesting::GetGloballyIsolatedOrigins(GetGloballyIsolatedOriginsCallback callback) {
  GetForwardingInterface()->GetGloballyIsolatedOrigins(std::move(callback));
}
void ProcessInternalsHandlerInterceptorForTesting::GetAllWebContentsInfo(GetAllWebContentsInfoCallback callback) {
  GetForwardingInterface()->GetAllWebContentsInfo(std::move(callback));
}
ProcessInternalsHandlerAsyncWaiter::ProcessInternalsHandlerAsyncWaiter(
    ProcessInternalsHandler* proxy) : proxy_(proxy) {}

ProcessInternalsHandlerAsyncWaiter::~ProcessInternalsHandlerAsyncWaiter() = default;

void ProcessInternalsHandlerAsyncWaiter::GetIsolationMode(
    std::string* out_mode) {
  base::RunLoop loop;
  proxy_->GetIsolationMode(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_mode
,
             const std::string& mode) {*out_mode = std::move(mode);
            loop->Quit();
          },
          &loop,
          out_mode));
  loop.Run();
}
void ProcessInternalsHandlerAsyncWaiter::GetUserTriggeredIsolatedOrigins(
    std::vector<std::string>* out_isolated_origins) {
  base::RunLoop loop;
  proxy_->GetUserTriggeredIsolatedOrigins(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_isolated_origins
,
             const std::vector<std::string>& isolated_origins) {*out_isolated_origins = std::move(isolated_origins);
            loop->Quit();
          },
          &loop,
          out_isolated_origins));
  loop.Run();
}
void ProcessInternalsHandlerAsyncWaiter::GetGloballyIsolatedOrigins(
    std::vector<IsolatedOriginInfoPtr>* out_isolated_origins) {
  base::RunLoop loop;
  proxy_->GetGloballyIsolatedOrigins(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<IsolatedOriginInfoPtr>* out_isolated_origins
,
             std::vector<IsolatedOriginInfoPtr> isolated_origins) {*out_isolated_origins = std::move(isolated_origins);
            loop->Quit();
          },
          &loop,
          out_isolated_origins));
  loop.Run();
}
void ProcessInternalsHandlerAsyncWaiter::GetAllWebContentsInfo(
    std::vector<WebContentsInfoPtr>* out_infos) {
  base::RunLoop loop;
  proxy_->GetAllWebContentsInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<WebContentsInfoPtr>* out_infos
,
             std::vector<WebContentsInfoPtr> infos) {*out_infos = std::move(infos);
            loop->Quit();
          },
          &loop,
          out_infos));
  loop.Run();
}





}  // namespace mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif