// content/browser/process_internals/process_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/browser/process_internals/process_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/browser/process_internals/process_internals.mojom-params-data.h"
#include "content/browser/process_internals/process_internals.mojom-shared-message-ids.h"

#include "content/browser/process_internals/process_internals.mojom-import-headers.h"


#ifndef CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_JUMBO_H_
#define CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_JUMBO_H_
#endif
namespace mojom {
SiteInstanceInfo::SiteInstanceInfo()
    : id(),
      locked(),
      site_url(),
      process_lock_url(),
      is_origin_keyed() {}

SiteInstanceInfo::SiteInstanceInfo(
    int32_t id_in,
    bool locked_in,
    const base::Optional<::GURL>& site_url_in,
    const base::Optional<::GURL>& process_lock_url_in,
    bool is_origin_keyed_in)
    : id(std::move(id_in)),
      locked(std::move(locked_in)),
      site_url(std::move(site_url_in)),
      process_lock_url(std::move(process_lock_url_in)),
      is_origin_keyed(std::move(is_origin_keyed_in)) {}

SiteInstanceInfo::~SiteInstanceInfo() = default;

void SiteInstanceInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "locked"), this->locked, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_url"), this->site_url, 
      "<value of type const base::Optional<::GURL>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_lock_url"), this->process_lock_url, 
      "<value of type const base::Optional<::GURL>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_origin_keyed"), this->is_origin_keyed, 
      "<value of type bool>");
}

bool SiteInstanceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FrameInfo::FrameInfo()
    : routing_id(),
      agent_scheduling_group_id(),
      process_id(),
      site_instance(),
      last_committed_url(),
      subframes(),
      is_bfcached() {}

FrameInfo::FrameInfo(
    int32_t routing_id_in,
    int32_t agent_scheduling_group_id_in,
    int32_t process_id_in,
    SiteInstanceInfoPtr site_instance_in,
    const base::Optional<::GURL>& last_committed_url_in,
    std::vector<FrameInfoPtr> subframes_in,
    bool is_bfcached_in)
    : routing_id(std::move(routing_id_in)),
      agent_scheduling_group_id(std::move(agent_scheduling_group_id_in)),
      process_id(std::move(process_id_in)),
      site_instance(std::move(site_instance_in)),
      last_committed_url(std::move(last_committed_url_in)),
      subframes(std::move(subframes_in)),
      is_bfcached(std::move(is_bfcached_in)) {}

FrameInfo::~FrameInfo() = default;

void FrameInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id"), this->routing_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "agent_scheduling_group_id"), this->agent_scheduling_group_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_id"), this->process_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_instance"), this->site_instance, 
      "<value of type SiteInstanceInfoPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_committed_url"), this->last_committed_url, 
      "<value of type const base::Optional<::GURL>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subframes"), this->subframes, 
      "<value of type std::vector<FrameInfoPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_bfcached"), this->is_bfcached, 
      "<value of type bool>");
}

bool FrameInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebContentsInfo::WebContentsInfo()
    : title(),
      root_frame(),
      bfcached_root_frames() {}

WebContentsInfo::WebContentsInfo(
    const std::string& title_in,
    FrameInfoPtr root_frame_in,
    std::vector<FrameInfoPtr> bfcached_root_frames_in)
    : title(std::move(title_in)),
      root_frame(std::move(root_frame_in)),
      bfcached_root_frames(std::move(bfcached_root_frames_in)) {}

WebContentsInfo::~WebContentsInfo() = default;

void WebContentsInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_frame"), this->root_frame, 
      "<value of type FrameInfoPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bfcached_root_frames"), this->bfcached_root_frames, 
      "<value of type std::vector<FrameInfoPtr>>");
}

bool WebContentsInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IsolatedOriginInfo::IsolatedOriginInfo()
    : origin(),
      source() {}

IsolatedOriginInfo::IsolatedOriginInfo(
    const std::string& origin_in,
    const std::string& source_in)
    : origin(std::move(origin_in)),
      source(std::move(source_in)) {}

IsolatedOriginInfo::~IsolatedOriginInfo() = default;
size_t IsolatedOriginInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->origin);
  seed = mojo::internal::Hash(seed, this->source);
  return seed;
}

void IsolatedOriginInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source, 
      "<value of type const std::string&>");
}

bool IsolatedOriginInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ProcessInternalsHandler::Name_[] = "mojom.ProcessInternalsHandler";

class ProcessInternalsHandler_GetIsolationMode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetIsolationMode_ForwardToCallback(
      ProcessInternalsHandler::GetIsolationModeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetIsolationModeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ProcessInternalsHandler_GetIsolationMode_ForwardToCallback);
};

class ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback(
      ProcessInternalsHandler::GetUserTriggeredIsolatedOriginsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetUserTriggeredIsolatedOriginsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback);
};

class ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback(
      ProcessInternalsHandler::GetGloballyIsolatedOriginsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetGloballyIsolatedOriginsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback);
};

class ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback(
      ProcessInternalsHandler::GetAllWebContentsInfoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetAllWebContentsInfoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback);
};

ProcessInternalsHandlerProxy::ProcessInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProcessInternalsHandlerProxy::GetIsolationMode(
    GetIsolationModeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "mojom::ProcessInternalsHandler::GetIsolationMode");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessInternalsHandler_GetIsolationMode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetIsolationMode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetIsolationMode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetIsolationMode_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ProcessInternalsHandlerProxy::GetUserTriggeredIsolatedOrigins(
    GetUserTriggeredIsolatedOriginsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "mojom::ProcessInternalsHandler::GetUserTriggeredIsolatedOrigins");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetUserTriggeredIsolatedOrigins");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ProcessInternalsHandlerProxy::GetGloballyIsolatedOrigins(
    GetGloballyIsolatedOriginsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "mojom::ProcessInternalsHandler::GetGloballyIsolatedOrigins");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessInternalsHandler_GetGloballyIsolatedOrigins_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetGloballyIsolatedOrigins");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ProcessInternalsHandlerProxy::GetAllWebContentsInfo(
    GetAllWebContentsInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "mojom::ProcessInternalsHandler::GetAllWebContentsInfo");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessInternalsHandler_GetAllWebContentsInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetAllWebContentsInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ProcessInternalsHandler_GetIsolationMode_ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetIsolationModeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ProcessInternalsHandler_GetIsolationMode_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetIsolationMode_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ProcessInternalsHandler_GetIsolationMode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetIsolationMode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ProcessInternalsHandler_GetIsolationMode_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProcessInternalsHandler::GetIsolationModeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_mode);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ProcessInternalsHandler_GetIsolationMode_ProxyToResponder);
};

bool ProcessInternalsHandler_GetIsolationMode_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "mojom::ProcessInternalsHandler::GetIsolationModeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::string p_mode{};
  ProcessInternalsHandler_GetIsolationMode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMode(&p_mode))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProcessInternalsHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_mode));
  return true;
}

void ProcessInternalsHandler_GetIsolationMode_ProxyToResponder::Run(
    const std::string& in_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)mojom::ProcessInternalsHandler::GetIsolationModeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode, 
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessInternalsHandler_GetIsolationMode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->mode)::BaseType> mode_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_mode, mode_fragment);
  params->mode.Set(
      mode_fragment.is_null() ? nullptr : mode_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mode.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mode in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)mojom::ProcessInternalsHandler::GetIsolationModeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetIsolationMode");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetUserTriggeredIsolatedOriginsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProcessInternalsHandler::GetUserTriggeredIsolatedOriginsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_isolated_origins);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder);
};

bool ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "mojom::ProcessInternalsHandler::GetUserTriggeredIsolatedOriginsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<std::string> p_isolated_origins{};
  ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadIsolatedOrigins(&p_isolated_origins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProcessInternalsHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_isolated_origins));
  return true;
}

void ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder::Run(
    const std::vector<std::string>& in_isolated_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)mojom::ProcessInternalsHandler::GetUserTriggeredIsolatedOriginsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("isolated_origins"), in_isolated_origins, 
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->isolated_origins)::BaseType>
      isolated_origins_fragment(params.message());
  const mojo::internal::ContainerValidateParams isolated_origins_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_isolated_origins, isolated_origins_fragment, &isolated_origins_validate_params);
  params->isolated_origins.Set(
      isolated_origins_fragment.is_null() ? nullptr : isolated_origins_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->isolated_origins.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null isolated_origins in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)mojom::ProcessInternalsHandler::GetUserTriggeredIsolatedOriginsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetUserTriggeredIsolatedOrigins");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetGloballyIsolatedOriginsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProcessInternalsHandler::GetGloballyIsolatedOriginsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<IsolatedOriginInfoPtr> in_isolated_origins);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder);
};

bool ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "mojom::ProcessInternalsHandler::GetGloballyIsolatedOriginsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<IsolatedOriginInfoPtr> p_isolated_origins{};
  ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadIsolatedOrigins(&p_isolated_origins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProcessInternalsHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_isolated_origins));
  return true;
}

void ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder::Run(
    std::vector<IsolatedOriginInfoPtr> in_isolated_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)mojom::ProcessInternalsHandler::GetGloballyIsolatedOriginsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("isolated_origins"), in_isolated_origins, 
                        "<value of type std::vector<IsolatedOriginInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessInternalsHandler_GetGloballyIsolatedOrigins_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->isolated_origins)::BaseType>
      isolated_origins_fragment(params.message());
  const mojo::internal::ContainerValidateParams isolated_origins_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::mojom::IsolatedOriginInfoDataView>>(
      in_isolated_origins, isolated_origins_fragment, &isolated_origins_validate_params);
  params->isolated_origins.Set(
      isolated_origins_fragment.is_null() ? nullptr : isolated_origins_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->isolated_origins.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null isolated_origins in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)mojom::ProcessInternalsHandler::GetGloballyIsolatedOriginsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetGloballyIsolatedOrigins");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetAllWebContentsInfoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProcessInternalsHandler::GetAllWebContentsInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<WebContentsInfoPtr> in_infos);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder);
};

bool ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "mojom::ProcessInternalsHandler::GetAllWebContentsInfoCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<WebContentsInfoPtr> p_infos{};
  ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfos(&p_infos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProcessInternalsHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_infos));
  return true;
}

void ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder::Run(
    std::vector<WebContentsInfoPtr> in_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)mojom::ProcessInternalsHandler::GetAllWebContentsInfoCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("infos"), in_infos, 
                        "<value of type std::vector<WebContentsInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessInternalsHandler_GetAllWebContentsInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->infos)::BaseType>
      infos_fragment(params.message());
  const mojo::internal::ContainerValidateParams infos_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::mojom::WebContentsInfoDataView>>(
      in_infos, infos_fragment, &infos_validate_params);
  params->infos.Set(
      infos_fragment.is_null() ? nullptr : infos_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->infos.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null infos in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)mojom::ProcessInternalsHandler::GetAllWebContentsInfoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetAllWebContentsInfo");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProcessInternalsHandlerStubDispatch::Accept(
    ProcessInternalsHandler* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProcessInternalsHandler_GetIsolationMode_Name: {
      break;
    }
    case internal::kProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Name: {
      break;
    }
    case internal::kProcessInternalsHandler_GetGloballyIsolatedOrigins_Name: {
      break;
    }
    case internal::kProcessInternalsHandler_GetAllWebContentsInfo_Name: {
      break;
    }
  }
  return false;
}

// static
bool ProcessInternalsHandlerStubDispatch::AcceptWithResponder(
    ProcessInternalsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProcessInternalsHandler_GetIsolationMode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)mojom::ProcessInternalsHandler::GetIsolationMode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)mojom::ProcessInternalsHandler::GetIsolationMode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ProcessInternalsHandler_GetIsolationMode_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetIsolationMode_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ProcessInternalsHandler_GetIsolationMode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessInternalsHandler::Name_, 0, false);
        return false;
      }
      ProcessInternalsHandler::GetIsolationModeCallback callback =
          ProcessInternalsHandler_GetIsolationMode_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIsolationMode(std::move(callback));
      return true;
    }
    case internal::kProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)mojom::ProcessInternalsHandler::GetUserTriggeredIsolatedOrigins",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)mojom::ProcessInternalsHandler::GetUserTriggeredIsolatedOrigins");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessInternalsHandler::Name_, 1, false);
        return false;
      }
      ProcessInternalsHandler::GetUserTriggeredIsolatedOriginsCallback callback =
          ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserTriggeredIsolatedOrigins(std::move(callback));
      return true;
    }
    case internal::kProcessInternalsHandler_GetGloballyIsolatedOrigins_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)mojom::ProcessInternalsHandler::GetGloballyIsolatedOrigins",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)mojom::ProcessInternalsHandler::GetGloballyIsolatedOrigins");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessInternalsHandler::Name_, 2, false);
        return false;
      }
      ProcessInternalsHandler::GetGloballyIsolatedOriginsCallback callback =
          ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetGloballyIsolatedOrigins(std::move(callback));
      return true;
    }
    case internal::kProcessInternalsHandler_GetAllWebContentsInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)mojom::ProcessInternalsHandler::GetAllWebContentsInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)mojom::ProcessInternalsHandler::GetAllWebContentsInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ProcessInternalsHandler_GetAllWebContentsInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessInternalsHandler::Name_, 3, false);
        return false;
      }
      ProcessInternalsHandler::GetAllWebContentsInfoCallback callback =
          ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllWebContentsInfo(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProcessInternalsHandlerValidationInfo[] = {
    {internal::kProcessInternalsHandler_GetIsolationMode_Name,
     {&internal::ProcessInternalsHandler_GetIsolationMode_Params_Data::Validate,
      &internal::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data::Validate}},
    {internal::kProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Name,
     {&internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data::Validate,
      &internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data::Validate}},
    {internal::kProcessInternalsHandler_GetGloballyIsolatedOrigins_Name,
     {&internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data::Validate,
      &internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data::Validate}},
    {internal::kProcessInternalsHandler_GetAllWebContentsInfo_Name,
     {&internal::ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data::Validate,
      &internal::ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data::Validate}},
};

bool ProcessInternalsHandlerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::mojom::ProcessInternalsHandler::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProcessInternalsHandlerValidationInfo);
}

bool ProcessInternalsHandlerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::mojom::ProcessInternalsHandler::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kProcessInternalsHandlerValidationInfo);

}
}  // namespace mojom

namespace mojo {


// static
bool StructTraits<::mojom::SiteInstanceInfo::DataView, ::mojom::SiteInstanceInfoPtr>::Read(
    ::mojom::SiteInstanceInfo::DataView input,
    ::mojom::SiteInstanceInfoPtr* output) {
  bool success = true;
  ::mojom::SiteInstanceInfoPtr result(::mojom::SiteInstanceInfo::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->locked = input.locked();
      if (success && !input.ReadSiteUrl(&result->site_url))
        success = false;
      if (success && !input.ReadProcessLockUrl(&result->process_lock_url))
        success = false;
      if (success)
        result->is_origin_keyed = input.is_origin_keyed();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::FrameInfo::DataView, ::mojom::FrameInfoPtr>::Read(
    ::mojom::FrameInfo::DataView input,
    ::mojom::FrameInfoPtr* output) {
  bool success = true;
  ::mojom::FrameInfoPtr result(::mojom::FrameInfo::New());
  
      if (success)
        result->routing_id = input.routing_id();
      if (success)
        result->agent_scheduling_group_id = input.agent_scheduling_group_id();
      if (success)
        result->process_id = input.process_id();
      if (success && !input.ReadSiteInstance(&result->site_instance))
        success = false;
      if (success && !input.ReadLastCommittedUrl(&result->last_committed_url))
        success = false;
      if (success && !input.ReadSubframes(&result->subframes))
        success = false;
      if (success)
        result->is_bfcached = input.is_bfcached();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::WebContentsInfo::DataView, ::mojom::WebContentsInfoPtr>::Read(
    ::mojom::WebContentsInfo::DataView input,
    ::mojom::WebContentsInfoPtr* output) {
  bool success = true;
  ::mojom::WebContentsInfoPtr result(::mojom::WebContentsInfo::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadRootFrame(&result->root_frame))
        success = false;
      if (success && !input.ReadBfcachedRootFrames(&result->bfcached_root_frames))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::IsolatedOriginInfo::DataView, ::mojom::IsolatedOriginInfoPtr>::Read(
    ::mojom::IsolatedOriginInfo::DataView input,
    ::mojom::IsolatedOriginInfoPtr* output) {
  bool success = true;
  ::mojom::IsolatedOriginInfoPtr result(::mojom::IsolatedOriginInfo::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif