// content/common/child_process.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/child_process.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/child_process.mojom-params-data.h"
#include "content/common/child_process.mojom-shared-message-ids.h"

#include "content/common/child_process.mojom-import-headers.h"


#ifndef CONTENT_COMMON_CHILD_PROCESS_MOJOM_JUMBO_H_
#define CONTENT_COMMON_CHILD_PROCESS_MOJOM_JUMBO_H_
#endif
namespace content {
namespace mojom {
const char ChildProcessHost::Name_[] = "content.mojom.ChildProcessHost";

ChildProcessHostProxy::ChildProcessHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChildProcessHostProxy::BindHostReceiver(
    ::mojo::GenericPendingReceiver in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::ChildProcessHost::BindHostReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::GenericPendingReceiver>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kChildProcessHost_BindHostReceiver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcessHost_BindHostReceiver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->receiver)::BaseType> receiver_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::GenericPendingReceiverDataView>(
      in_receiver, receiver_fragment);
  params->receiver.Set(
      receiver_fragment.is_null() ? nullptr : receiver_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->receiver.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null receiver in ChildProcessHost.BindHostReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcessHost::Name_);
  message.set_method_name("BindHostReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ChildProcessHostStubDispatch::Accept(
    ChildProcessHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kChildProcessHost_BindHostReceiver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::ChildProcessHost::BindHostReceiver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::ChildProcessHost::BindHostReceiver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ChildProcessHost_BindHostReceiver_Params_Data* params =
          reinterpret_cast<internal::ChildProcessHost_BindHostReceiver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::GenericPendingReceiver p_receiver{};
      ChildProcessHost_BindHostReceiver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReceiver(&p_receiver))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcessHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindHostReceiver(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool ChildProcessHostStubDispatch::AcceptWithResponder(
    ChildProcessHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kChildProcessHost_BindHostReceiver_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kChildProcessHostValidationInfo[] = {
    {internal::kChildProcessHost_BindHostReceiver_Name,
     {&internal::ChildProcessHost_BindHostReceiver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ChildProcessHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::ChildProcessHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kChildProcessHostValidationInfo);
}

const char ChildProcess::Name_[] = "content.mojom.ChildProcess";

ChildProcessProxy::ChildProcessProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChildProcessProxy::ProcessShutdown(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::ChildProcess::ProcessShutdown");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kChildProcess_ProcessShutdown_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_ProcessShutdown_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("ProcessShutdown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ChildProcessProxy::GetBackgroundTracingAgentProvider(
    ::mojo::PendingReceiver<::tracing::mojom::BackgroundTracingAgentProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::ChildProcess::GetBackgroundTracingAgentProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::tracing::mojom::BackgroundTracingAgentProvider>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kChildProcess_GetBackgroundTracingAgentProvider_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_GetBackgroundTracingAgentProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::tracing::mojom::BackgroundTracingAgentProviderInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in ChildProcess.GetBackgroundTracingAgentProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("GetBackgroundTracingAgentProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ChildProcessProxy::EnableSystemTracingService(
    ::mojo::PendingRemote<::tracing::mojom::SystemTracingService> in_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::ChildProcess::EnableSystemTracingService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote"), in_remote, 
                        "<value of type ::mojo::PendingRemote<::tracing::mojom::SystemTracingService>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kChildProcess_EnableSystemTracingService_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_EnableSystemTracingService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::tracing::mojom::SystemTracingServiceInterfaceBase>>(
      in_remote, &params->remote, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid remote in ChildProcess.EnableSystemTracingService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("EnableSystemTracingService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ChildProcessProxy::CrashHungProcess(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::ChildProcess::CrashHungProcess");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kChildProcess_CrashHungProcess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_CrashHungProcess_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("CrashHungProcess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ChildProcessProxy::BootstrapLegacyIpc(
    ::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::ChildProcess::BootstrapLegacyIpc", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kChildProcess_BootstrapLegacyIpc_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_BootstrapLegacyIpc_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::IPC::mojom::ChannelBootstrapInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in ChildProcess.BootstrapLegacyIpc request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("BootstrapLegacyIpc");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ChildProcessProxy::RunServiceDeprecated(
    const std::string& in_service_name, ::mojo::ScopedMessagePipeHandle in_service_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::ChildProcess::RunServiceDeprecated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_name"), in_service_name, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_pipe"), in_service_pipe, 
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kChildProcess_RunServiceDeprecated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_RunServiceDeprecated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_name)::BaseType> service_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_service_name, service_name_fragment);
  params->service_name.Set(
      service_name_fragment.is_null() ? nullptr : service_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->service_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null service_name in ChildProcess.RunServiceDeprecated request");
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
      in_service_pipe, &params->service_pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->service_pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid service_pipe in ChildProcess.RunServiceDeprecated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("RunServiceDeprecated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ChildProcessProxy::BindServiceInterface(
    ::mojo::GenericPendingReceiver in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::ChildProcess::BindServiceInterface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::GenericPendingReceiver>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kChildProcess_BindServiceInterface_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_BindServiceInterface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->receiver)::BaseType> receiver_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::GenericPendingReceiverDataView>(
      in_receiver, receiver_fragment);
  params->receiver.Set(
      receiver_fragment.is_null() ? nullptr : receiver_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->receiver.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null receiver in ChildProcess.BindServiceInterface request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("BindServiceInterface");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ChildProcessProxy::BindReceiver(
    ::mojo::GenericPendingReceiver in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::ChildProcess::BindReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::GenericPendingReceiver>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kChildProcess_BindReceiver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_BindReceiver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->receiver)::BaseType> receiver_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::GenericPendingReceiverDataView>(
      in_receiver, receiver_fragment);
  params->receiver.Set(
      receiver_fragment.is_null() ? nullptr : receiver_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->receiver.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null receiver in ChildProcess.BindReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("BindReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ChildProcessStubDispatch::Accept(
    ChildProcess* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kChildProcess_ProcessShutdown_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::ChildProcess::ProcessShutdown",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::ChildProcess::ProcessShutdown");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ChildProcess_ProcessShutdown_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_ProcessShutdown_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ChildProcess_ProcessShutdown_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProcessShutdown();
      return true;
    }
    case internal::kChildProcess_GetBackgroundTracingAgentProvider_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::ChildProcess::GetBackgroundTracingAgentProvider",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::ChildProcess::GetBackgroundTracingAgentProvider");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ChildProcess_GetBackgroundTracingAgentProvider_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_GetBackgroundTracingAgentProvider_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::tracing::mojom::BackgroundTracingAgentProvider> p_receiver{};
      ChildProcess_GetBackgroundTracingAgentProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBackgroundTracingAgentProvider(
std::move(p_receiver));
      return true;
    }
    case internal::kChildProcess_EnableSystemTracingService_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::ChildProcess::EnableSystemTracingService",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::ChildProcess::EnableSystemTracingService");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ChildProcess_EnableSystemTracingService_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_EnableSystemTracingService_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::tracing::mojom::SystemTracingService> p_remote{};
      ChildProcess_EnableSystemTracingService_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_remote =
            input_data_view.TakeRemote<decltype(p_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableSystemTracingService(
std::move(p_remote));
      return true;
    }
    case internal::kChildProcess_CrashHungProcess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::ChildProcess::CrashHungProcess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::ChildProcess::CrashHungProcess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ChildProcess_CrashHungProcess_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_CrashHungProcess_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ChildProcess_CrashHungProcess_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CrashHungProcess();
      return true;
    }
    case internal::kChildProcess_BootstrapLegacyIpc_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::ChildProcess::BootstrapLegacyIpc",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::ChildProcess::BootstrapLegacyIpc");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ChildProcess_BootstrapLegacyIpc_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_BootstrapLegacyIpc_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap> p_receiver{};
      ChildProcess_BootstrapLegacyIpc_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BootstrapLegacyIpc(
std::move(p_receiver));
      return true;
    }
    case internal::kChildProcess_RunServiceDeprecated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::ChildProcess::RunServiceDeprecated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::ChildProcess::RunServiceDeprecated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ChildProcess_RunServiceDeprecated_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_RunServiceDeprecated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_service_name{};
      ::mojo::ScopedMessagePipeHandle p_service_pipe{};
      ChildProcess_RunServiceDeprecated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceName(&p_service_name))
        success = false;
      if (success)
        p_service_pipe = input_data_view.TakeServicePipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunServiceDeprecated(
std::move(p_service_name), 
std::move(p_service_pipe));
      return true;
    }
    case internal::kChildProcess_BindServiceInterface_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::ChildProcess::BindServiceInterface",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::ChildProcess::BindServiceInterface");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ChildProcess_BindServiceInterface_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_BindServiceInterface_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::GenericPendingReceiver p_receiver{};
      ChildProcess_BindServiceInterface_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReceiver(&p_receiver))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindServiceInterface(
std::move(p_receiver));
      return true;
    }
    case internal::kChildProcess_BindReceiver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::ChildProcess::BindReceiver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::ChildProcess::BindReceiver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ChildProcess_BindReceiver_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_BindReceiver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::GenericPendingReceiver p_receiver{};
      ChildProcess_BindReceiver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReceiver(&p_receiver))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindReceiver(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool ChildProcessStubDispatch::AcceptWithResponder(
    ChildProcess* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kChildProcess_ProcessShutdown_Name: {
      break;
    }
    case internal::kChildProcess_GetBackgroundTracingAgentProvider_Name: {
      break;
    }
    case internal::kChildProcess_EnableSystemTracingService_Name: {
      break;
    }
    case internal::kChildProcess_CrashHungProcess_Name: {
      break;
    }
    case internal::kChildProcess_BootstrapLegacyIpc_Name: {
      break;
    }
    case internal::kChildProcess_RunServiceDeprecated_Name: {
      break;
    }
    case internal::kChildProcess_BindServiceInterface_Name: {
      break;
    }
    case internal::kChildProcess_BindReceiver_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kChildProcessValidationInfo[] = {
    {internal::kChildProcess_ProcessShutdown_Name,
     {&internal::ChildProcess_ProcessShutdown_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kChildProcess_GetBackgroundTracingAgentProvider_Name,
     {&internal::ChildProcess_GetBackgroundTracingAgentProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kChildProcess_EnableSystemTracingService_Name,
     {&internal::ChildProcess_EnableSystemTracingService_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kChildProcess_CrashHungProcess_Name,
     {&internal::ChildProcess_CrashHungProcess_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kChildProcess_BootstrapLegacyIpc_Name,
     {&internal::ChildProcess_BootstrapLegacyIpc_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kChildProcess_RunServiceDeprecated_Name,
     {&internal::ChildProcess_RunServiceDeprecated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kChildProcess_BindServiceInterface_Name,
     {&internal::ChildProcess_BindServiceInterface_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kChildProcess_BindReceiver_Name,
     {&internal::ChildProcess_BindReceiver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ChildProcessRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::ChildProcess::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kChildProcessValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif