// content/common/field_trial_recorder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/field_trial_recorder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/field_trial_recorder.mojom-params-data.h"
#include "content/common/field_trial_recorder.mojom-shared-message-ids.h"

#include "content/common/field_trial_recorder.mojom-import-headers.h"


#ifndef CONTENT_COMMON_FIELD_TRIAL_RECORDER_MOJOM_JUMBO_H_
#define CONTENT_COMMON_FIELD_TRIAL_RECORDER_MOJOM_JUMBO_H_
#endif
namespace content {
namespace mojom {
const char FieldTrialRecorder::Name_[] = "content.mojom.FieldTrialRecorder";

FieldTrialRecorderProxy::FieldTrialRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FieldTrialRecorderProxy::FieldTrialActivated(
    const std::string& in_trial_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FieldTrialRecorder::FieldTrialActivated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trial_name"), in_trial_name, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFieldTrialRecorder_FieldTrialActivated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FieldTrialRecorder_FieldTrialActivated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->trial_name)::BaseType> trial_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_trial_name, trial_name_fragment);
  params->trial_name.Set(
      trial_name_fragment.is_null() ? nullptr : trial_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->trial_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trial_name in FieldTrialRecorder.FieldTrialActivated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FieldTrialRecorder::Name_);
  message.set_method_name("FieldTrialActivated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FieldTrialRecorderStubDispatch::Accept(
    FieldTrialRecorder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFieldTrialRecorder_FieldTrialActivated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FieldTrialRecorder::FieldTrialActivated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FieldTrialRecorder::FieldTrialActivated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FieldTrialRecorder_FieldTrialActivated_Params_Data* params =
          reinterpret_cast<internal::FieldTrialRecorder_FieldTrialActivated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_trial_name{};
      FieldTrialRecorder_FieldTrialActivated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTrialName(&p_trial_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FieldTrialRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FieldTrialActivated(
std::move(p_trial_name));
      return true;
    }
  }
  return false;
}

// static
bool FieldTrialRecorderStubDispatch::AcceptWithResponder(
    FieldTrialRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFieldTrialRecorder_FieldTrialActivated_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFieldTrialRecorderValidationInfo[] = {
    {internal::kFieldTrialRecorder_FieldTrialActivated_Name,
     {&internal::FieldTrialRecorder_FieldTrialActivated_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FieldTrialRecorderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FieldTrialRecorder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFieldTrialRecorderValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif