// content/common/frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/frame.mojom-params-data.h"
#include "content/common/frame.mojom-shared-message-ids.h"

#include "content/common/frame.mojom-import-headers.h"


#ifndef CONTENT_COMMON_FRAME_MOJOM_JUMBO_H_
#define CONTENT_COMMON_FRAME_MOJOM_JUMBO_H_
#include "content/common/frame_messages.h"
#include "content/public/common/common_param_traits.h"
#include "services/network/public/cpp/p2p_param_traits.h"
#include "third_party/blink/common/feature_policy/feature_policy_mojom_traits.h"
#endif
namespace content {
namespace mojom {
CreateViewParams::CreateViewParams()
    : renderer_preferences(),
      web_preferences(),
      view_id(::IPC::mojom::kRoutingIdNone),
      session_storage_namespace_id(),
      opener_frame_token(),
      replication_state(),
      devtools_main_frame_token(),
      main_frame(),
      hidden(),
      never_composited(),
      window_was_created_with_opener(),
      renderer_wide_named_frame_lookup(),
      type(),
      blink_page_broadcast() {}

CreateViewParams::CreateViewParams(
    const ::blink::RendererPreferences& renderer_preferences_in,
    const ::blink::web_pref::WebPreferences& web_preferences_in,
    int32_t view_id_in,
    const std::string& session_storage_namespace_id_in,
    const base::Optional<::blink::FrameToken>& opener_frame_token_in,
    ::content::mojom::FrameReplicationStatePtr replication_state_in,
    const ::base::UnguessableToken& devtools_main_frame_token_in,
    CreateMainFrameUnionPtr main_frame_in,
    bool hidden_in,
    bool never_composited_in,
    bool window_was_created_with_opener_in,
    bool renderer_wide_named_frame_lookup_in,
    ViewWidgetType type_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast> blink_page_broadcast_in)
    : renderer_preferences(std::move(renderer_preferences_in)),
      web_preferences(std::move(web_preferences_in)),
      view_id(std::move(view_id_in)),
      session_storage_namespace_id(std::move(session_storage_namespace_id_in)),
      opener_frame_token(std::move(opener_frame_token_in)),
      replication_state(std::move(replication_state_in)),
      devtools_main_frame_token(std::move(devtools_main_frame_token_in)),
      main_frame(std::move(main_frame_in)),
      hidden(std::move(hidden_in)),
      never_composited(std::move(never_composited_in)),
      window_was_created_with_opener(std::move(window_was_created_with_opener_in)),
      renderer_wide_named_frame_lookup(std::move(renderer_wide_named_frame_lookup_in)),
      type(std::move(type_in)),
      blink_page_broadcast(std::move(blink_page_broadcast_in)) {}

CreateViewParams::~CreateViewParams() = default;

void CreateViewParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_preferences"), this->renderer_preferences, 
      "<value of type const ::blink::RendererPreferences&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_preferences"), this->web_preferences, 
      "<value of type const ::blink::web_pref::WebPreferences&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_id"), this->view_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_storage_namespace_id"), this->session_storage_namespace_id, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opener_frame_token"), this->opener_frame_token, 
      "<value of type const base::Optional<::blink::FrameToken>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "replication_state"), this->replication_state, 
      "<value of type ::content::mojom::FrameReplicationStatePtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_main_frame_token"), this->devtools_main_frame_token, 
      "<value of type const ::base::UnguessableToken&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame"), this->main_frame, 
      "<value of type CreateMainFrameUnionPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hidden"), this->hidden, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "never_composited"), this->never_composited, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_was_created_with_opener"), this->window_was_created_with_opener, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_wide_named_frame_lookup"), this->renderer_wide_named_frame_lookup, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type, 
      "<value of type ViewWidgetType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blink_page_broadcast"), this->blink_page_broadcast, 
      "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast>>");
}

bool CreateViewParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateLocalMainFrameParams::CreateLocalMainFrameParams()
    : token(),
      routing_id(::IPC::mojom::kRoutingIdNone),
      frame(),
      interface_broker(),
      has_committed_real_load(),
      policy_container(),
      widget_params() {}

CreateLocalMainFrameParams::CreateLocalMainFrameParams(
    const ::blink::LocalFrameToken& token_in,
    int32_t routing_id_in,
    ::mojo::PendingAssociatedReceiver<Frame> frame_in,
    ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> interface_broker_in,
    bool has_committed_real_load_in,
    ::blink::mojom::PolicyContainerPtr policy_container_in,
    CreateFrameWidgetParamsPtr widget_params_in)
    : token(std::move(token_in)),
      routing_id(std::move(routing_id_in)),
      frame(std::move(frame_in)),
      interface_broker(std::move(interface_broker_in)),
      has_committed_real_load(std::move(has_committed_real_load_in)),
      policy_container(std::move(policy_container_in)),
      widget_params(std::move(widget_params_in)) {}

CreateLocalMainFrameParams::~CreateLocalMainFrameParams() = default;

void CreateLocalMainFrameParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token, 
      "<value of type const ::blink::LocalFrameToken&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id"), this->routing_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame"), this->frame, 
      "<value of type ::mojo::PendingAssociatedReceiver<Frame>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interface_broker"), this->interface_broker, 
      "<value of type ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_committed_real_load"), this->has_committed_real_load, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_container"), this->policy_container, 
      "<value of type ::blink::mojom::PolicyContainerPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_params"), this->widget_params, 
      "<value of type CreateFrameWidgetParamsPtr>");
}

bool CreateLocalMainFrameParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateRemoteMainFrameParams::CreateRemoteMainFrameParams()
    : token(),
      routing_id(::IPC::mojom::kRoutingIdNone) {}

CreateRemoteMainFrameParams::CreateRemoteMainFrameParams(
    const ::blink::RemoteFrameToken& token_in,
    int32_t routing_id_in)
    : token(std::move(token_in)),
      routing_id(std::move(routing_id_in)) {}

CreateRemoteMainFrameParams::~CreateRemoteMainFrameParams() = default;

void CreateRemoteMainFrameParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token, 
      "<value of type const ::blink::RemoteFrameToken&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id"), this->routing_id, 
      "<value of type int32_t>");
}

bool CreateRemoteMainFrameParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateFrameWidgetParams::CreateFrameWidgetParams()
    : routing_id(),
      frame_widget_host(),
      frame_widget(),
      widget_host(),
      widget(),
      visual_properties() {}

CreateFrameWidgetParams::CreateFrameWidgetParams(
    int32_t routing_id_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget_in,
    const ::blink::VisualProperties& visual_properties_in)
    : routing_id(std::move(routing_id_in)),
      frame_widget_host(std::move(frame_widget_host_in)),
      frame_widget(std::move(frame_widget_in)),
      widget_host(std::move(widget_host_in)),
      widget(std::move(widget_in)),
      visual_properties(std::move(visual_properties_in)) {}

CreateFrameWidgetParams::~CreateFrameWidgetParams() = default;

void CreateFrameWidgetParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id"), this->routing_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_widget_host"), this->frame_widget_host, 
      "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_widget"), this->frame_widget, 
      "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_host"), this->widget_host, 
      "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget"), this->widget, 
      "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visual_properties"), this->visual_properties, 
      "<value of type const ::blink::VisualProperties&>");
}

bool CreateFrameWidgetParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateFrameParams::CreateFrameParams()
    : token(),
      routing_id(),
      previous_routing_id(),
      opener_frame_token(),
      parent_routing_id(),
      previous_sibling_routing_id(),
      interface_broker(),
      replication_state(),
      devtools_frame_token(),
      frame_owner_properties(),
      widget_params(),
      has_committed_real_load(),
      policy_container(),
      frame() {}

CreateFrameParams::CreateFrameParams(
    const ::blink::LocalFrameToken& token_in,
    int32_t routing_id_in,
    int32_t previous_routing_id_in,
    const base::Optional<::blink::FrameToken>& opener_frame_token_in,
    int32_t parent_routing_id_in,
    int32_t previous_sibling_routing_id_in,
    ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> interface_broker_in,
    ::content::mojom::FrameReplicationStatePtr replication_state_in,
    const ::base::UnguessableToken& devtools_frame_token_in,
    ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties_in,
    CreateFrameWidgetParamsPtr widget_params_in,
    bool has_committed_real_load_in,
    ::blink::mojom::PolicyContainerPtr policy_container_in,
    ::mojo::PendingAssociatedReceiver<Frame> frame_in)
    : token(std::move(token_in)),
      routing_id(std::move(routing_id_in)),
      previous_routing_id(std::move(previous_routing_id_in)),
      opener_frame_token(std::move(opener_frame_token_in)),
      parent_routing_id(std::move(parent_routing_id_in)),
      previous_sibling_routing_id(std::move(previous_sibling_routing_id_in)),
      interface_broker(std::move(interface_broker_in)),
      replication_state(std::move(replication_state_in)),
      devtools_frame_token(std::move(devtools_frame_token_in)),
      frame_owner_properties(std::move(frame_owner_properties_in)),
      widget_params(std::move(widget_params_in)),
      has_committed_real_load(std::move(has_committed_real_load_in)),
      policy_container(std::move(policy_container_in)),
      frame(std::move(frame_in)) {}

CreateFrameParams::~CreateFrameParams() = default;

void CreateFrameParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token, 
      "<value of type const ::blink::LocalFrameToken&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id"), this->routing_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "previous_routing_id"), this->previous_routing_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opener_frame_token"), this->opener_frame_token, 
      "<value of type const base::Optional<::blink::FrameToken>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_routing_id"), this->parent_routing_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "previous_sibling_routing_id"), this->previous_sibling_routing_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interface_broker"), this->interface_broker, 
      "<value of type ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "replication_state"), this->replication_state, 
      "<value of type ::content::mojom::FrameReplicationStatePtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_frame_token"), this->devtools_frame_token, 
      "<value of type const ::base::UnguessableToken&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_owner_properties"), this->frame_owner_properties, 
      "<value of type ::blink::mojom::FrameOwnerPropertiesPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_params"), this->widget_params, 
      "<value of type CreateFrameWidgetParamsPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_committed_real_load"), this->has_committed_real_load, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_container"), this->policy_container, 
      "<value of type ::blink::mojom::PolicyContainerPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame"), this->frame, 
      "<value of type ::mojo::PendingAssociatedReceiver<Frame>>");
}

bool CreateFrameParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SnapshotAccessibilityTreeParams::SnapshotAccessibilityTreeParams()
    : ax_mode(),
      exclude_offscreen(),
      max_nodes(),
      timeout() {}

SnapshotAccessibilityTreeParams::SnapshotAccessibilityTreeParams(
    uint32_t ax_mode_in,
    bool exclude_offscreen_in,
    uint64_t max_nodes_in,
    ::base::TimeDelta timeout_in)
    : ax_mode(std::move(ax_mode_in)),
      exclude_offscreen(std::move(exclude_offscreen_in)),
      max_nodes(std::move(max_nodes_in)),
      timeout(std::move(timeout_in)) {}

SnapshotAccessibilityTreeParams::~SnapshotAccessibilityTreeParams() = default;

void SnapshotAccessibilityTreeParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ax_mode"), this->ax_mode, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclude_offscreen"), this->exclude_offscreen, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_nodes"), this->max_nodes, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timeout"), this->timeout, 
      "<value of type ::base::TimeDelta>");
}

bool SnapshotAccessibilityTreeParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateNewWindowParams::CreateNewWindowParams()
    : allow_popup(),
      window_container_type(),
      session_storage_namespace_id(),
      clone_from_session_storage_namespace_id(),
      frame_name(),
      opener_suppressed(),
      disposition(),
      target_url(),
      referrer(),
      features(),
      impression() {}

CreateNewWindowParams::CreateNewWindowParams(
    bool allow_popup_in,
    ::content::mojom::WindowContainerType window_container_type_in,
    const std::string& session_storage_namespace_id_in,
    const std::string& clone_from_session_storage_namespace_id_in,
    const std::string& frame_name_in,
    bool opener_suppressed_in,
    ::WindowOpenDisposition disposition_in,
    const ::GURL& target_url_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    ::blink::mojom::WindowFeaturesPtr features_in,
    const base::Optional<::blink::Impression>& impression_in)
    : allow_popup(std::move(allow_popup_in)),
      window_container_type(std::move(window_container_type_in)),
      session_storage_namespace_id(std::move(session_storage_namespace_id_in)),
      clone_from_session_storage_namespace_id(std::move(clone_from_session_storage_namespace_id_in)),
      frame_name(std::move(frame_name_in)),
      opener_suppressed(std::move(opener_suppressed_in)),
      disposition(std::move(disposition_in)),
      target_url(std::move(target_url_in)),
      referrer(std::move(referrer_in)),
      features(std::move(features_in)),
      impression(std::move(impression_in)) {}

CreateNewWindowParams::~CreateNewWindowParams() = default;

void CreateNewWindowParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_popup"), this->allow_popup, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_container_type"), this->window_container_type, 
      "<value of type ::content::mojom::WindowContainerType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_storage_namespace_id"), this->session_storage_namespace_id, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clone_from_session_storage_namespace_id"), this->clone_from_session_storage_namespace_id, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_name"), this->frame_name, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opener_suppressed"), this->opener_suppressed, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disposition"), this->disposition, 
      "<value of type ::WindowOpenDisposition>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_url"), this->target_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer, 
      "<value of type ::blink::mojom::ReferrerPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "features"), this->features, 
      "<value of type ::blink::mojom::WindowFeaturesPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression"), this->impression, 
      "<value of type const base::Optional<::blink::Impression>&>");
}

bool CreateNewWindowParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateNewWindowReply::CreateNewWindowReply()
    : route_id(),
      main_frame_token(),
      main_frame_route_id(),
      frame(),
      widget_params(),
      page_broadcast(),
      main_frame_interface_broker(),
      cloned_session_storage_namespace_id(),
      devtools_main_frame_token(),
      wait_for_debugger(),
      policy_container() {}

CreateNewWindowReply::CreateNewWindowReply(
    int32_t route_id_in,
    const ::blink::LocalFrameToken& main_frame_token_in,
    int32_t main_frame_route_id_in,
    ::mojo::PendingAssociatedReceiver<Frame> frame_in,
    CreateFrameWidgetParamsPtr widget_params_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast> page_broadcast_in,
    ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> main_frame_interface_broker_in,
    const std::string& cloned_session_storage_namespace_id_in,
    const ::base::UnguessableToken& devtools_main_frame_token_in,
    bool wait_for_debugger_in,
    ::blink::mojom::PolicyContainerPtr policy_container_in)
    : route_id(std::move(route_id_in)),
      main_frame_token(std::move(main_frame_token_in)),
      main_frame_route_id(std::move(main_frame_route_id_in)),
      frame(std::move(frame_in)),
      widget_params(std::move(widget_params_in)),
      page_broadcast(std::move(page_broadcast_in)),
      main_frame_interface_broker(std::move(main_frame_interface_broker_in)),
      cloned_session_storage_namespace_id(std::move(cloned_session_storage_namespace_id_in)),
      devtools_main_frame_token(std::move(devtools_main_frame_token_in)),
      wait_for_debugger(std::move(wait_for_debugger_in)),
      policy_container(std::move(policy_container_in)) {}

CreateNewWindowReply::~CreateNewWindowReply() = default;

void CreateNewWindowReply::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "route_id"), this->route_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_token"), this->main_frame_token, 
      "<value of type const ::blink::LocalFrameToken&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_route_id"), this->main_frame_route_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame"), this->frame, 
      "<value of type ::mojo::PendingAssociatedReceiver<Frame>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_params"), this->widget_params, 
      "<value of type CreateFrameWidgetParamsPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_broadcast"), this->page_broadcast, 
      "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_interface_broker"), this->main_frame_interface_broker, 
      "<value of type ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cloned_session_storage_namespace_id"), this->cloned_session_storage_namespace_id, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_main_frame_token"), this->devtools_main_frame_token, 
      "<value of type const ::base::UnguessableToken&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_debugger"), this->wait_for_debugger, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_container"), this->policy_container, 
      "<value of type ::blink::mojom::PolicyContainerPtr>");
}

bool CreateNewWindowReply::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OpenURLParams::OpenURLParams()
    : url(),
      initiator_origin(),
      initiator_frame_token(),
      post_body(),
      extra_headers(),
      referrer(),
      disposition(),
      should_replace_current_entry(),
      user_gesture(),
      triggering_event_info(),
      blob_url_token(),
      href_translate(),
      impression(),
      download_policy(),
      initiator_policy_container_keep_alive_handle() {}

OpenURLParams::OpenURLParams(
    const ::GURL& url_in,
    const ::url::Origin& initiator_origin_in,
    const base::Optional<::blink::LocalFrameToken>& initiator_frame_token_in,
    ::scoped_refptr<::network::ResourceRequestBody> post_body_in,
    const std::string& extra_headers_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    ::WindowOpenDisposition disposition_in,
    bool should_replace_current_entry_in,
    bool user_gesture_in,
    ::blink::mojom::TriggeringEventInfo triggering_event_info_in,
    ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token_in,
    const std::string& href_translate_in,
    const base::Optional<::blink::Impression>& impression_in,
    const ::blink::NavigationDownloadPolicy& download_policy_in,
    ::mojo::PendingRemote<::blink::mojom::PolicyContainerHostKeepAliveHandle> initiator_policy_container_keep_alive_handle_in)
    : url(std::move(url_in)),
      initiator_origin(std::move(initiator_origin_in)),
      initiator_frame_token(std::move(initiator_frame_token_in)),
      post_body(std::move(post_body_in)),
      extra_headers(std::move(extra_headers_in)),
      referrer(std::move(referrer_in)),
      disposition(std::move(disposition_in)),
      should_replace_current_entry(std::move(should_replace_current_entry_in)),
      user_gesture(std::move(user_gesture_in)),
      triggering_event_info(std::move(triggering_event_info_in)),
      blob_url_token(std::move(blob_url_token_in)),
      href_translate(std::move(href_translate_in)),
      impression(std::move(impression_in)),
      download_policy(std::move(download_policy_in)),
      initiator_policy_container_keep_alive_handle(std::move(initiator_policy_container_keep_alive_handle_in)) {}

OpenURLParams::~OpenURLParams() = default;

void OpenURLParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_origin"), this->initiator_origin, 
      "<value of type const ::url::Origin&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_frame_token"), this->initiator_frame_token, 
      "<value of type const base::Optional<::blink::LocalFrameToken>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "post_body"), this->post_body, 
      "<value of type ::scoped_refptr<::network::ResourceRequestBody>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_headers"), this->extra_headers, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer, 
      "<value of type ::blink::mojom::ReferrerPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disposition"), this->disposition, 
      "<value of type ::WindowOpenDisposition>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_replace_current_entry"), this->should_replace_current_entry, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_gesture"), this->user_gesture, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "triggering_event_info"), this->triggering_event_info, 
      "<value of type ::blink::mojom::TriggeringEventInfo>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blob_url_token"), this->blob_url_token, 
      "<value of type ::mojo::PendingRemote<::blink::mojom::BlobURLToken>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "href_translate"), this->href_translate, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression"), this->impression, 
      "<value of type const base::Optional<::blink::Impression>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "download_policy"), this->download_policy, 
      "<value of type const ::blink::NavigationDownloadPolicy&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_policy_container_keep_alive_handle"), this->initiator_policy_container_keep_alive_handle, 
      "<value of type ::mojo::PendingRemote<::blink::mojom::PolicyContainerHostKeepAliveHandle>>");
}

bool OpenURLParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateMainFrameUnion::CreateMainFrameUnion() : tag_(Tag::LOCAL_PARAMS) {
  data_.local_params = new CreateLocalMainFrameParamsPtr;
}

CreateMainFrameUnion::~CreateMainFrameUnion() {
  DestroyActive();
}


void CreateMainFrameUnion::set_local_params(
    CreateLocalMainFrameParamsPtr local_params) {
  if (tag_ == Tag::LOCAL_PARAMS) {
    *(data_.local_params) = std::move(local_params);
  } else {
    DestroyActive();
    tag_ = Tag::LOCAL_PARAMS;
    data_.local_params = new CreateLocalMainFrameParamsPtr(
        std::move(local_params));
  }
}
void CreateMainFrameUnion::set_remote_params(
    CreateRemoteMainFrameParamsPtr remote_params) {
  if (tag_ == Tag::REMOTE_PARAMS) {
    *(data_.remote_params) = std::move(remote_params);
  } else {
    DestroyActive();
    tag_ = Tag::REMOTE_PARAMS;
    data_.remote_params = new CreateRemoteMainFrameParamsPtr(
        std::move(remote_params));
  }
}

void CreateMainFrameUnion::DestroyActive() {
  switch (tag_) {

    case Tag::LOCAL_PARAMS:

      delete data_.local_params;
      break;
    case Tag::REMOTE_PARAMS:

      delete data_.remote_params;
      break;
  }
}

bool CreateMainFrameUnion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char FrameHTMLSerializerHandler::Name_[] = "content.mojom.FrameHTMLSerializerHandler";

FrameHTMLSerializerHandlerProxy::FrameHTMLSerializerHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameHTMLSerializerHandlerProxy::DidReceiveData(
    const std::string& in_data_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHTMLSerializerHandler::DidReceiveData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_buffer"), in_data_buffer, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHTMLSerializerHandler_DidReceiveData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHTMLSerializerHandler_DidReceiveData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data_buffer)::BaseType> data_buffer_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_data_buffer, data_buffer_fragment);
  params->data_buffer.Set(
      data_buffer_fragment.is_null() ? nullptr : data_buffer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data_buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_buffer in FrameHTMLSerializerHandler.DidReceiveData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHTMLSerializerHandler::Name_);
  message.set_method_name("DidReceiveData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHTMLSerializerHandlerProxy::Done(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::FrameHTMLSerializerHandler::Done");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHTMLSerializerHandler_Done_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHTMLSerializerHandler_Done_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHTMLSerializerHandler::Name_);
  message.set_method_name("Done");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameHTMLSerializerHandlerStubDispatch::Accept(
    FrameHTMLSerializerHandler* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFrameHTMLSerializerHandler_DidReceiveData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHTMLSerializerHandler::DidReceiveData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHTMLSerializerHandler::DidReceiveData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHTMLSerializerHandler_DidReceiveData_Params_Data* params =
          reinterpret_cast<internal::FrameHTMLSerializerHandler_DidReceiveData_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_data_buffer{};
      FrameHTMLSerializerHandler_DidReceiveData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDataBuffer(&p_data_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHTMLSerializerHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReceiveData(
std::move(p_data_buffer));
      return true;
    }
    case internal::kFrameHTMLSerializerHandler_Done_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHTMLSerializerHandler::Done",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHTMLSerializerHandler::Done");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHTMLSerializerHandler_Done_Params_Data* params =
          reinterpret_cast<internal::FrameHTMLSerializerHandler_Done_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameHTMLSerializerHandler_Done_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHTMLSerializerHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Done();
      return true;
    }
  }
  return false;
}

// static
bool FrameHTMLSerializerHandlerStubDispatch::AcceptWithResponder(
    FrameHTMLSerializerHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameHTMLSerializerHandler_DidReceiveData_Name: {
      break;
    }
    case internal::kFrameHTMLSerializerHandler_Done_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameHTMLSerializerHandlerValidationInfo[] = {
    {internal::kFrameHTMLSerializerHandler_DidReceiveData_Name,
     {&internal::FrameHTMLSerializerHandler_DidReceiveData_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHTMLSerializerHandler_Done_Name,
     {&internal::FrameHTMLSerializerHandler_Done_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameHTMLSerializerHandlerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FrameHTMLSerializerHandler::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameHTMLSerializerHandlerValidationInfo);
}

const char Frame::Name_[] = "content.mojom.Frame";

class Frame_CommitSameDocumentNavigation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Frame_CommitSameDocumentNavigation_ForwardToCallback(
      Frame::CommitSameDocumentNavigationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Frame::CommitSameDocumentNavigationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Frame_CommitSameDocumentNavigation_ForwardToCallback);
};

class Frame_JavaScriptMethodExecuteRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Frame_JavaScriptMethodExecuteRequest_ForwardToCallback(
      Frame::JavaScriptMethodExecuteRequestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Frame::JavaScriptMethodExecuteRequestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Frame_JavaScriptMethodExecuteRequest_ForwardToCallback);
};

class Frame_JavaScriptExecuteRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Frame_JavaScriptExecuteRequest_ForwardToCallback(
      Frame::JavaScriptExecuteRequestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Frame::JavaScriptExecuteRequestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Frame_JavaScriptExecuteRequest_ForwardToCallback);
};

class Frame_JavaScriptExecuteRequestForTests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Frame_JavaScriptExecuteRequestForTests_ForwardToCallback(
      Frame::JavaScriptExecuteRequestForTestsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Frame::JavaScriptExecuteRequestForTestsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Frame_JavaScriptExecuteRequestForTests_ForwardToCallback);
};

class Frame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Frame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback(
      Frame::JavaScriptExecuteRequestInIsolatedWorldCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Frame::JavaScriptExecuteRequestInIsolatedWorldCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Frame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback);
};

class Frame_GetCanonicalUrlForSharing_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Frame_GetCanonicalUrlForSharing_ForwardToCallback(
      Frame::GetCanonicalUrlForSharingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Frame::GetCanonicalUrlForSharingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Frame_GetCanonicalUrlForSharing_ForwardToCallback);
};

class Frame_SnapshotAccessibilityTree_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Frame_SnapshotAccessibilityTree_ForwardToCallback(
      Frame::SnapshotAccessibilityTreeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Frame::SnapshotAccessibilityTreeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Frame_SnapshotAccessibilityTree_ForwardToCallback);
};

FrameProxy::FrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameProxy::CommitSameDocumentNavigation(
    ::content::mojom::CommonNavigationParamsPtr in_common_params, ::content::mojom::CommitNavigationParamsPtr in_request_params, CommitSameDocumentNavigationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::CommitSameDocumentNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("common_params"), in_common_params, 
                        "<value of type ::content::mojom::CommonNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_params"), in_request_params, 
                        "<value of type ::content::mojom::CommitNavigationParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_CommitSameDocumentNavigation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_CommitSameDocumentNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->common_params)::BaseType> common_params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::CommonNavigationParamsDataView>(
      in_common_params, common_params_fragment);
  params->common_params.Set(
      common_params_fragment.is_null() ? nullptr : common_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->common_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null common_params in Frame.CommitSameDocumentNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_params)::BaseType> request_params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::CommitNavigationParamsDataView>(
      in_request_params, request_params_fragment);
  params->request_params.Set(
      request_params_fragment.is_null() ? nullptr : request_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_params in Frame.CommitSameDocumentNavigation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("CommitSameDocumentNavigation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Frame_CommitSameDocumentNavigation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameProxy::HandleRendererDebugURL(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::HandleRendererDebugURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_HandleRendererDebugURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_HandleRendererDebugURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in Frame.HandleRendererDebugURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("HandleRendererDebugURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::UpdateSubresourceLoaderFactories(
    ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::UpdateSubresourceLoaderFactories", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_factories"), in_subresource_loader_factories, 
                        "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_UpdateSubresourceLoaderFactories_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_UpdateSubresourceLoaderFactories_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
      in_subresource_loader_factories, subresource_loader_factories_fragment);
  params->subresource_loader_factories.Set(
      subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->subresource_loader_factories.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subresource_loader_factories in Frame.UpdateSubresourceLoaderFactories request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("UpdateSubresourceLoaderFactories");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::BindDevToolsAgent(
    ::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> in_agent_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> in_agent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::BindDevToolsAgent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent_host"), in_agent_host, 
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent, 
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_BindDevToolsAgent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_BindDevToolsAgent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::DevToolsAgentHostAssociatedPtrInfoDataView>(
      in_agent_host, &params->agent_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid agent_host in Frame.BindDevToolsAgent request");
  mojo::internal::Serialize<::blink::mojom::DevToolsAgentAssociatedRequestDataView>(
      in_agent, &params->agent, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid agent in Frame.BindDevToolsAgent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("BindDevToolsAgent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::JavaScriptMethodExecuteRequest(
    const ::base::string16& in_object_name, const ::base::string16& in_method_name, ::base::Value in_arguments, bool in_wants_result, JavaScriptMethodExecuteRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::JavaScriptMethodExecuteRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_name"), in_object_name, 
                        "<value of type const ::base::string16&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method_name"), in_method_name, 
                        "<value of type const ::base::string16&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("arguments"), in_arguments, 
                        "<value of type ::base::Value>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wants_result"), in_wants_result, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_JavaScriptMethodExecuteRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_JavaScriptMethodExecuteRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->object_name)::BaseType> object_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_object_name, object_name_fragment);
  params->object_name.Set(
      object_name_fragment.is_null() ? nullptr : object_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->object_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null object_name in Frame.JavaScriptMethodExecuteRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->method_name)::BaseType> method_name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_method_name, method_name_fragment);
  params->method_name.Set(
      method_name_fragment.is_null() ? nullptr : method_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->method_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_name in Frame.JavaScriptMethodExecuteRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->arguments)::BaseType> arguments_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_arguments, arguments_fragment);
  params->arguments.Set(
      arguments_fragment.is_null() ? nullptr : arguments_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->arguments.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null arguments in Frame.JavaScriptMethodExecuteRequest request");
  params->wants_result = in_wants_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("JavaScriptMethodExecuteRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Frame_JavaScriptMethodExecuteRequest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameProxy::JavaScriptExecuteRequest(
    const ::base::string16& in_javascript, bool in_wants_result, JavaScriptExecuteRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::JavaScriptExecuteRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript"), in_javascript, 
                        "<value of type const ::base::string16&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wants_result"), in_wants_result, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_JavaScriptExecuteRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_JavaScriptExecuteRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript)::BaseType> javascript_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_javascript, javascript_fragment);
  params->javascript.Set(
      javascript_fragment.is_null() ? nullptr : javascript_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->javascript.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null javascript in Frame.JavaScriptExecuteRequest request");
  params->wants_result = in_wants_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("JavaScriptExecuteRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Frame_JavaScriptExecuteRequest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameProxy::JavaScriptExecuteRequestForTests(
    const ::base::string16& in_javascript, bool in_wants_result, bool in_has_user_gesture, int32_t in_world_id, JavaScriptExecuteRequestForTestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::JavaScriptExecuteRequestForTests", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript"), in_javascript, 
                        "<value of type const ::base::string16&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wants_result"), in_wants_result, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_user_gesture"), in_has_user_gesture, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("world_id"), in_world_id, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_JavaScriptExecuteRequestForTests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_JavaScriptExecuteRequestForTests_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript)::BaseType> javascript_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_javascript, javascript_fragment);
  params->javascript.Set(
      javascript_fragment.is_null() ? nullptr : javascript_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->javascript.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null javascript in Frame.JavaScriptExecuteRequestForTests request");
  params->wants_result = in_wants_result;
  params->has_user_gesture = in_has_user_gesture;
  params->world_id = in_world_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("JavaScriptExecuteRequestForTests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Frame_JavaScriptExecuteRequestForTests_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameProxy::JavaScriptExecuteRequestInIsolatedWorld(
    const ::base::string16& in_javascript, bool in_wants_result, int32_t in_world_id, JavaScriptExecuteRequestInIsolatedWorldCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::JavaScriptExecuteRequestInIsolatedWorld", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript"), in_javascript, 
                        "<value of type const ::base::string16&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wants_result"), in_wants_result, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("world_id"), in_world_id, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_JavaScriptExecuteRequestInIsolatedWorld_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript)::BaseType> javascript_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_javascript, javascript_fragment);
  params->javascript.Set(
      javascript_fragment.is_null() ? nullptr : javascript_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->javascript.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null javascript in Frame.JavaScriptExecuteRequestInIsolatedWorld request");
  params->wants_result = in_wants_result;
  params->world_id = in_world_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("JavaScriptExecuteRequestInIsolatedWorld");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Frame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameProxy::SetWantErrorMessageStackTrace(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::Frame::SetWantErrorMessageStackTrace");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_SetWantErrorMessageStackTrace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_SetWantErrorMessageStackTrace_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("SetWantErrorMessageStackTrace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::Unload(
    int32_t in_new_remote_frame_routing_id, bool in_is_loading, ::content::mojom::FrameReplicationStatePtr in_new_remote_frame_replication_state, const ::blink::RemoteFrameToken& in_new_remote_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::Unload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_remote_frame_routing_id"), in_new_remote_frame_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_loading"), in_is_loading, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_remote_frame_replication_state"), in_new_remote_frame_replication_state, 
                        "<value of type ::content::mojom::FrameReplicationStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_remote_frame_token"), in_new_remote_frame_token, 
                        "<value of type const ::blink::RemoteFrameToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_Unload_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_Unload_Params_Data> params(
          message);
  params.Allocate();
  params->new_remote_frame_routing_id = in_new_remote_frame_routing_id;
  params->is_loading = in_is_loading;
  mojo::internal::MessageFragment<
      typename decltype(params->new_remote_frame_replication_state)::BaseType> new_remote_frame_replication_state_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::FrameReplicationStateDataView>(
      in_new_remote_frame_replication_state, new_remote_frame_replication_state_fragment);
  params->new_remote_frame_replication_state.Set(
      new_remote_frame_replication_state_fragment.is_null() ? nullptr : new_remote_frame_replication_state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_remote_frame_replication_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_remote_frame_replication_state in Frame.Unload request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_remote_frame_token)::BaseType> new_remote_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
      in_new_remote_frame_token, new_remote_frame_token_fragment);
  params->new_remote_frame_token.Set(
      new_remote_frame_token_fragment.is_null() ? nullptr : new_remote_frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_remote_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_remote_frame_token in Frame.Unload request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("Unload");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::Delete(
    FrameDeleteIntention in_intention) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::Delete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intention"), in_intention, 
                        "<value of type FrameDeleteIntention>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_Delete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_Delete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::content::mojom::FrameDeleteIntention>(
      in_intention, &params->intention);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("Delete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::BlockRequests(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::Frame::BlockRequests");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_BlockRequests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_BlockRequests_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("BlockRequests");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::ResumeBlockedRequests(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::Frame::ResumeBlockedRequests");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_ResumeBlockedRequests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_ResumeBlockedRequests_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("ResumeBlockedRequests");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::GetInterfaceProvider(
    ::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> in_interfaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::GetInterfaceProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interfaces"), in_interfaces, 
                        "<value of type ::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_GetInterfaceProvider_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_GetInterfaceProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::service_manager::mojom::InterfaceProviderInterfaceBase>>(
      in_interfaces, &params->interfaces, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->interfaces),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid interfaces in Frame.GetInterfaceProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("GetInterfaceProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameProxy::GetCanonicalUrlForSharing(
    GetCanonicalUrlForSharingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::Frame::GetCanonicalUrlForSharing");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_GetCanonicalUrlForSharing_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_GetCanonicalUrlForSharing_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("GetCanonicalUrlForSharing");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Frame_GetCanonicalUrlForSharing_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameProxy::SnapshotAccessibilityTree(
    SnapshotAccessibilityTreeParamsPtr in_params, SnapshotAccessibilityTreeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::SnapshotAccessibilityTree", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type SnapshotAccessibilityTreeParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_SnapshotAccessibilityTree_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_SnapshotAccessibilityTree_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::SnapshotAccessibilityTreeParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in Frame.SnapshotAccessibilityTree request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("SnapshotAccessibilityTree");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Frame_SnapshotAccessibilityTree_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameProxy::GetSerializedHtmlWithLocalLinks(
    const base::flat_map<::GURL, ::base::FilePath>& in_url_map, const base::flat_map<::blink::FrameToken, ::base::FilePath>& in_frame_token_map, bool in_save_with_empty_url, ::mojo::PendingRemote<FrameHTMLSerializerHandler> in_handler_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Frame::GetSerializedHtmlWithLocalLinks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_map"), in_url_map, 
                        "<value of type const base::flat_map<::GURL, ::base::FilePath>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token_map"), in_frame_token_map, 
                        "<value of type const base::flat_map<::blink::FrameToken, ::base::FilePath>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("save_with_empty_url"), in_save_with_empty_url, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler_remote"), in_handler_remote, 
                        "<value of type ::mojo::PendingRemote<FrameHTMLSerializerHandler>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_GetSerializedHtmlWithLocalLinks_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_GetSerializedHtmlWithLocalLinks_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url_map)::BaseType>
      url_map_fragment(params.message());
  const mojo::internal::ContainerValidateParams url_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<::url::mojom::UrlDataView, ::mojo_base::mojom::FilePathDataView>>(
      in_url_map, url_map_fragment, &url_map_validate_params);
  params->url_map.Set(
      url_map_fragment.is_null() ? nullptr : url_map_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url_map.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_map in Frame.GetSerializedHtmlWithLocalLinks request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token_map)::BaseType>
      frame_token_map_fragment(params.message());
  const mojo::internal::ContainerValidateParams frame_token_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::FrameTokenDataView, ::mojo_base::mojom::FilePathDataView>>(
      in_frame_token_map, frame_token_map_fragment, &frame_token_map_validate_params);
  params->frame_token_map.Set(
      frame_token_map_fragment.is_null() ? nullptr : frame_token_map_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_token_map.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_token_map in Frame.GetSerializedHtmlWithLocalLinks request");
  params->save_with_empty_url = in_save_with_empty_url;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::content::mojom::FrameHTMLSerializerHandlerInterfaceBase>>(
      in_handler_remote, &params->handler_remote, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->handler_remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid handler_remote in Frame.GetSerializedHtmlWithLocalLinks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("GetSerializedHtmlWithLocalLinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class Frame_CommitSameDocumentNavigation_ProxyToResponder {
 public:
  static Frame::CommitSameDocumentNavigationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Frame_CommitSameDocumentNavigation_ProxyToResponder> proxy(
        new Frame_CommitSameDocumentNavigation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Frame_CommitSameDocumentNavigation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Frame_CommitSameDocumentNavigation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Frame_CommitSameDocumentNavigation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Frame::CommitSameDocumentNavigationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::CommitResult in_commit_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Frame_CommitSameDocumentNavigation_ProxyToResponder);
};

bool Frame_CommitSameDocumentNavigation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::Frame::CommitSameDocumentNavigationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Frame_CommitSameDocumentNavigation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Frame_CommitSameDocumentNavigation_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::CommitResult p_commit_result{};
  Frame_CommitSameDocumentNavigation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCommitResult(&p_commit_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Frame::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_commit_result));
  return true;
}

void Frame_CommitSameDocumentNavigation_ProxyToResponder::Run(
    ::blink::mojom::CommitResult in_commit_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::Frame::CommitSameDocumentNavigationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("commit_result"), in_commit_result, 
                        "<value of type ::blink::mojom::CommitResult>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_CommitSameDocumentNavigation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_CommitSameDocumentNavigation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::CommitResult>(
      in_commit_result, &params->commit_result);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::Frame::CommitSameDocumentNavigationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("CommitSameDocumentNavigation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Frame_JavaScriptMethodExecuteRequest_ProxyToResponder {
 public:
  static Frame::JavaScriptMethodExecuteRequestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Frame_JavaScriptMethodExecuteRequest_ProxyToResponder> proxy(
        new Frame_JavaScriptMethodExecuteRequest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Frame_JavaScriptMethodExecuteRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Frame_JavaScriptMethodExecuteRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Frame_JavaScriptMethodExecuteRequest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Frame::JavaScriptMethodExecuteRequestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Frame_JavaScriptMethodExecuteRequest_ProxyToResponder);
};

bool Frame_JavaScriptMethodExecuteRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::Frame::JavaScriptMethodExecuteRequestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Frame_JavaScriptMethodExecuteRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Frame_JavaScriptMethodExecuteRequest_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::Value p_result{};
  Frame_JavaScriptMethodExecuteRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Frame::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void Frame_JavaScriptMethodExecuteRequest_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::Frame::JavaScriptMethodExecuteRequestCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::base::Value>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_JavaScriptMethodExecuteRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_JavaScriptMethodExecuteRequest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::Frame::JavaScriptMethodExecuteRequestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("JavaScriptMethodExecuteRequest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Frame_JavaScriptExecuteRequest_ProxyToResponder {
 public:
  static Frame::JavaScriptExecuteRequestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Frame_JavaScriptExecuteRequest_ProxyToResponder> proxy(
        new Frame_JavaScriptExecuteRequest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Frame_JavaScriptExecuteRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Frame_JavaScriptExecuteRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Frame_JavaScriptExecuteRequest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Frame::JavaScriptExecuteRequestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Frame_JavaScriptExecuteRequest_ProxyToResponder);
};

bool Frame_JavaScriptExecuteRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::Frame::JavaScriptExecuteRequestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Frame_JavaScriptExecuteRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Frame_JavaScriptExecuteRequest_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::Value p_result{};
  Frame_JavaScriptExecuteRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Frame::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void Frame_JavaScriptExecuteRequest_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::Frame::JavaScriptExecuteRequestCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::base::Value>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_JavaScriptExecuteRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_JavaScriptExecuteRequest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::Frame::JavaScriptExecuteRequestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("JavaScriptExecuteRequest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Frame_JavaScriptExecuteRequestForTests_ProxyToResponder {
 public:
  static Frame::JavaScriptExecuteRequestForTestsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Frame_JavaScriptExecuteRequestForTests_ProxyToResponder> proxy(
        new Frame_JavaScriptExecuteRequestForTests_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Frame_JavaScriptExecuteRequestForTests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Frame_JavaScriptExecuteRequestForTests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Frame_JavaScriptExecuteRequestForTests_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Frame::JavaScriptExecuteRequestForTestsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Frame_JavaScriptExecuteRequestForTests_ProxyToResponder);
};

bool Frame_JavaScriptExecuteRequestForTests_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::Frame::JavaScriptExecuteRequestForTestsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Frame_JavaScriptExecuteRequestForTests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Frame_JavaScriptExecuteRequestForTests_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::Value p_result{};
  Frame_JavaScriptExecuteRequestForTests_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Frame::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void Frame_JavaScriptExecuteRequestForTests_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::Frame::JavaScriptExecuteRequestForTestsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::base::Value>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_JavaScriptExecuteRequestForTests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_JavaScriptExecuteRequestForTests_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::Frame::JavaScriptExecuteRequestForTestsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("JavaScriptExecuteRequestForTests");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Frame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder {
 public:
  static Frame::JavaScriptExecuteRequestInIsolatedWorldCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Frame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder> proxy(
        new Frame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Frame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Frame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Frame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Frame::JavaScriptExecuteRequestInIsolatedWorldCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Frame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder);
};

bool Frame_JavaScriptExecuteRequestInIsolatedWorld_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::Frame::JavaScriptExecuteRequestInIsolatedWorldCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Frame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Frame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::Value p_result{};
  Frame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Frame::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void Frame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::Frame::JavaScriptExecuteRequestInIsolatedWorldCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::base::Value>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_JavaScriptExecuteRequestInIsolatedWorld_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::Frame::JavaScriptExecuteRequestInIsolatedWorldCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("JavaScriptExecuteRequestInIsolatedWorld");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Frame_GetCanonicalUrlForSharing_ProxyToResponder {
 public:
  static Frame::GetCanonicalUrlForSharingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Frame_GetCanonicalUrlForSharing_ProxyToResponder> proxy(
        new Frame_GetCanonicalUrlForSharing_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Frame_GetCanonicalUrlForSharing_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Frame_GetCanonicalUrlForSharing_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Frame_GetCanonicalUrlForSharing_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Frame::GetCanonicalUrlForSharingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::Optional<::GURL>& in_canonical_url);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Frame_GetCanonicalUrlForSharing_ProxyToResponder);
};

bool Frame_GetCanonicalUrlForSharing_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::Frame::GetCanonicalUrlForSharingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Frame_GetCanonicalUrlForSharing_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Frame_GetCanonicalUrlForSharing_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  base::Optional<::GURL> p_canonical_url{};
  Frame_GetCanonicalUrlForSharing_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCanonicalUrl(&p_canonical_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Frame::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_canonical_url));
  return true;
}

void Frame_GetCanonicalUrlForSharing_ProxyToResponder::Run(
    const base::Optional<::GURL>& in_canonical_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::Frame::GetCanonicalUrlForSharingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("canonical_url"), in_canonical_url, 
                        "<value of type const base::Optional<::GURL>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_GetCanonicalUrlForSharing_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_GetCanonicalUrlForSharing_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->canonical_url)::BaseType> canonical_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_canonical_url, canonical_url_fragment);
  params->canonical_url.Set(
      canonical_url_fragment.is_null() ? nullptr : canonical_url_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::Frame::GetCanonicalUrlForSharingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("GetCanonicalUrlForSharing");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Frame_SnapshotAccessibilityTree_ProxyToResponder {
 public:
  static Frame::SnapshotAccessibilityTreeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Frame_SnapshotAccessibilityTree_ProxyToResponder> proxy(
        new Frame_SnapshotAccessibilityTree_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Frame_SnapshotAccessibilityTree_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Frame_SnapshotAccessibilityTree_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Frame_SnapshotAccessibilityTree_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Frame::SnapshotAccessibilityTreeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::ui::AXTreeUpdate& in_snapshot);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Frame_SnapshotAccessibilityTree_ProxyToResponder);
};

bool Frame_SnapshotAccessibilityTree_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::Frame::SnapshotAccessibilityTreeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Frame_SnapshotAccessibilityTree_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Frame_SnapshotAccessibilityTree_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::ui::AXTreeUpdate p_snapshot{};
  Frame_SnapshotAccessibilityTree_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSnapshot(&p_snapshot))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Frame::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_snapshot));
  return true;
}

void Frame_SnapshotAccessibilityTree_ProxyToResponder::Run(
    const ::ui::AXTreeUpdate& in_snapshot) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::Frame::SnapshotAccessibilityTreeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("snapshot"), in_snapshot, 
                        "<value of type const ::ui::AXTreeUpdate&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrame_SnapshotAccessibilityTree_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Frame_SnapshotAccessibilityTree_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->snapshot)::BaseType> snapshot_fragment(
          params.message());
  mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView>(
      in_snapshot, snapshot_fragment);
  params->snapshot.Set(
      snapshot_fragment.is_null() ? nullptr : snapshot_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->snapshot.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null snapshot in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::Frame::SnapshotAccessibilityTreeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Frame::Name_);
  message.set_method_name("SnapshotAccessibilityTree");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FrameStubDispatch::Accept(
    Frame* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFrame_CommitSameDocumentNavigation_Name: {
      break;
    }
    case internal::kFrame_HandleRendererDebugURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::HandleRendererDebugURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::HandleRendererDebugURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_HandleRendererDebugURL_Params_Data* params =
          reinterpret_cast<internal::Frame_HandleRendererDebugURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      Frame_HandleRendererDebugURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleRendererDebugURL(
std::move(p_url));
      return true;
    }
    case internal::kFrame_UpdateSubresourceLoaderFactories_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::UpdateSubresourceLoaderFactories",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::UpdateSubresourceLoaderFactories");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_UpdateSubresourceLoaderFactories_Params_Data* params =
          reinterpret_cast<internal::Frame_UpdateSubresourceLoaderFactories_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      Frame_UpdateSubresourceLoaderFactories_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSubresourceLoaderFactories(
std::move(p_subresource_loader_factories));
      return true;
    }
    case internal::kFrame_BindDevToolsAgent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::BindDevToolsAgent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::BindDevToolsAgent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_BindDevToolsAgent_Params_Data* params =
          reinterpret_cast<internal::Frame_BindDevToolsAgent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> p_agent_host{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> p_agent{};
      Frame_BindDevToolsAgent_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent_host =
            input_data_view.TakeAgentHost<decltype(p_agent_host)>();
      }
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindDevToolsAgent(
std::move(p_agent_host), 
std::move(p_agent));
      return true;
    }
    case internal::kFrame_JavaScriptMethodExecuteRequest_Name: {
      break;
    }
    case internal::kFrame_JavaScriptExecuteRequest_Name: {
      break;
    }
    case internal::kFrame_JavaScriptExecuteRequestForTests_Name: {
      break;
    }
    case internal::kFrame_JavaScriptExecuteRequestInIsolatedWorld_Name: {
      break;
    }
    case internal::kFrame_SetWantErrorMessageStackTrace_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::SetWantErrorMessageStackTrace",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::SetWantErrorMessageStackTrace");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_SetWantErrorMessageStackTrace_Params_Data* params =
          reinterpret_cast<internal::Frame_SetWantErrorMessageStackTrace_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Frame_SetWantErrorMessageStackTrace_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWantErrorMessageStackTrace();
      return true;
    }
    case internal::kFrame_Unload_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::Unload",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::Unload");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_Unload_Params_Data* params =
          reinterpret_cast<internal::Frame_Unload_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_new_remote_frame_routing_id{};
      bool p_is_loading{};
      ::content::mojom::FrameReplicationStatePtr p_new_remote_frame_replication_state{};
      ::blink::RemoteFrameToken p_new_remote_frame_token{};
      Frame_Unload_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_new_remote_frame_routing_id = input_data_view.new_remote_frame_routing_id();
      if (success)
        p_is_loading = input_data_view.is_loading();
      if (success && !input_data_view.ReadNewRemoteFrameReplicationState(&p_new_remote_frame_replication_state))
        success = false;
      if (success && !input_data_view.ReadNewRemoteFrameToken(&p_new_remote_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unload(
std::move(p_new_remote_frame_routing_id), 
std::move(p_is_loading), 
std::move(p_new_remote_frame_replication_state), 
std::move(p_new_remote_frame_token));
      return true;
    }
    case internal::kFrame_Delete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::Delete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::Delete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_Delete_Params_Data* params =
          reinterpret_cast<internal::Frame_Delete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameDeleteIntention p_intention{};
      Frame_Delete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIntention(&p_intention))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(
std::move(p_intention));
      return true;
    }
    case internal::kFrame_BlockRequests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::BlockRequests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::BlockRequests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_BlockRequests_Params_Data* params =
          reinterpret_cast<internal::Frame_BlockRequests_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Frame_BlockRequests_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BlockRequests();
      return true;
    }
    case internal::kFrame_ResumeBlockedRequests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::ResumeBlockedRequests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::ResumeBlockedRequests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_ResumeBlockedRequests_Params_Data* params =
          reinterpret_cast<internal::Frame_ResumeBlockedRequests_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Frame_ResumeBlockedRequests_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResumeBlockedRequests();
      return true;
    }
    case internal::kFrame_GetInterfaceProvider_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::GetInterfaceProvider",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::GetInterfaceProvider");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_GetInterfaceProvider_Params_Data* params =
          reinterpret_cast<internal::Frame_GetInterfaceProvider_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> p_interfaces{};
      Frame_GetInterfaceProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_interfaces =
            input_data_view.TakeInterfaces<decltype(p_interfaces)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInterfaceProvider(
std::move(p_interfaces));
      return true;
    }
    case internal::kFrame_GetCanonicalUrlForSharing_Name: {
      break;
    }
    case internal::kFrame_SnapshotAccessibilityTree_Name: {
      break;
    }
    case internal::kFrame_GetSerializedHtmlWithLocalLinks_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::GetSerializedHtmlWithLocalLinks",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::GetSerializedHtmlWithLocalLinks");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Frame_GetSerializedHtmlWithLocalLinks_Params_Data* params =
          reinterpret_cast<internal::Frame_GetSerializedHtmlWithLocalLinks_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::flat_map<::GURL, ::base::FilePath> p_url_map{};
      base::flat_map<::blink::FrameToken, ::base::FilePath> p_frame_token_map{};
      bool p_save_with_empty_url{};
      ::mojo::PendingRemote<FrameHTMLSerializerHandler> p_handler_remote{};
      Frame_GetSerializedHtmlWithLocalLinks_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrlMap(&p_url_map))
        success = false;
      if (success && !input_data_view.ReadFrameTokenMap(&p_frame_token_map))
        success = false;
      if (success)
        p_save_with_empty_url = input_data_view.save_with_empty_url();
      if (success) {
        p_handler_remote =
            input_data_view.TakeHandlerRemote<decltype(p_handler_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSerializedHtmlWithLocalLinks(
std::move(p_url_map), 
std::move(p_frame_token_map), 
std::move(p_save_with_empty_url), 
std::move(p_handler_remote));
      return true;
    }
  }
  return false;
}

// static
bool FrameStubDispatch::AcceptWithResponder(
    Frame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrame_CommitSameDocumentNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::CommitSameDocumentNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::CommitSameDocumentNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Frame_CommitSameDocumentNavigation_Params_Data* params =
          reinterpret_cast<
              internal::Frame_CommitSameDocumentNavigation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::content::mojom::CommonNavigationParamsPtr p_common_params{};
      ::content::mojom::CommitNavigationParamsPtr p_request_params{};
      Frame_CommitSameDocumentNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommonParams(&p_common_params))
        success = false;
      if (success && !input_data_view.ReadRequestParams(&p_request_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 0, false);
        return false;
      }
      Frame::CommitSameDocumentNavigationCallback callback =
          Frame_CommitSameDocumentNavigation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitSameDocumentNavigation(
std::move(p_common_params), 
std::move(p_request_params), std::move(callback));
      return true;
    }
    case internal::kFrame_HandleRendererDebugURL_Name: {
      break;
    }
    case internal::kFrame_UpdateSubresourceLoaderFactories_Name: {
      break;
    }
    case internal::kFrame_BindDevToolsAgent_Name: {
      break;
    }
    case internal::kFrame_JavaScriptMethodExecuteRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::JavaScriptMethodExecuteRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::JavaScriptMethodExecuteRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Frame_JavaScriptMethodExecuteRequest_Params_Data* params =
          reinterpret_cast<
              internal::Frame_JavaScriptMethodExecuteRequest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::string16 p_object_name{};
      ::base::string16 p_method_name{};
      ::base::Value p_arguments{};
      bool p_wants_result{};
      Frame_JavaScriptMethodExecuteRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadObjectName(&p_object_name))
        success = false;
      if (success && !input_data_view.ReadMethodName(&p_method_name))
        success = false;
      if (success && !input_data_view.ReadArguments(&p_arguments))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 4, false);
        return false;
      }
      Frame::JavaScriptMethodExecuteRequestCallback callback =
          Frame_JavaScriptMethodExecuteRequest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptMethodExecuteRequest(
std::move(p_object_name), 
std::move(p_method_name), 
std::move(p_arguments), 
std::move(p_wants_result), std::move(callback));
      return true;
    }
    case internal::kFrame_JavaScriptExecuteRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::JavaScriptExecuteRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::JavaScriptExecuteRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Frame_JavaScriptExecuteRequest_Params_Data* params =
          reinterpret_cast<
              internal::Frame_JavaScriptExecuteRequest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::string16 p_javascript{};
      bool p_wants_result{};
      Frame_JavaScriptExecuteRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 5, false);
        return false;
      }
      Frame::JavaScriptExecuteRequestCallback callback =
          Frame_JavaScriptExecuteRequest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptExecuteRequest(
std::move(p_javascript), 
std::move(p_wants_result), std::move(callback));
      return true;
    }
    case internal::kFrame_JavaScriptExecuteRequestForTests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::JavaScriptExecuteRequestForTests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::JavaScriptExecuteRequestForTests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Frame_JavaScriptExecuteRequestForTests_Params_Data* params =
          reinterpret_cast<
              internal::Frame_JavaScriptExecuteRequestForTests_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::string16 p_javascript{};
      bool p_wants_result{};
      bool p_has_user_gesture{};
      int32_t p_world_id{};
      Frame_JavaScriptExecuteRequestForTests_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (success)
        p_has_user_gesture = input_data_view.has_user_gesture();
      if (success)
        p_world_id = input_data_view.world_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 6, false);
        return false;
      }
      Frame::JavaScriptExecuteRequestForTestsCallback callback =
          Frame_JavaScriptExecuteRequestForTests_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptExecuteRequestForTests(
std::move(p_javascript), 
std::move(p_wants_result), 
std::move(p_has_user_gesture), 
std::move(p_world_id), std::move(callback));
      return true;
    }
    case internal::kFrame_JavaScriptExecuteRequestInIsolatedWorld_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::JavaScriptExecuteRequestInIsolatedWorld",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::JavaScriptExecuteRequestInIsolatedWorld");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Frame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data* params =
          reinterpret_cast<
              internal::Frame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::string16 p_javascript{};
      bool p_wants_result{};
      int32_t p_world_id{};
      Frame_JavaScriptExecuteRequestInIsolatedWorld_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJavascript(&p_javascript))
        success = false;
      if (success)
        p_wants_result = input_data_view.wants_result();
      if (success)
        p_world_id = input_data_view.world_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 7, false);
        return false;
      }
      Frame::JavaScriptExecuteRequestInIsolatedWorldCallback callback =
          Frame_JavaScriptExecuteRequestInIsolatedWorld_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptExecuteRequestInIsolatedWorld(
std::move(p_javascript), 
std::move(p_wants_result), 
std::move(p_world_id), std::move(callback));
      return true;
    }
    case internal::kFrame_SetWantErrorMessageStackTrace_Name: {
      break;
    }
    case internal::kFrame_Unload_Name: {
      break;
    }
    case internal::kFrame_Delete_Name: {
      break;
    }
    case internal::kFrame_BlockRequests_Name: {
      break;
    }
    case internal::kFrame_ResumeBlockedRequests_Name: {
      break;
    }
    case internal::kFrame_GetInterfaceProvider_Name: {
      break;
    }
    case internal::kFrame_GetCanonicalUrlForSharing_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::GetCanonicalUrlForSharing",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::GetCanonicalUrlForSharing");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Frame_GetCanonicalUrlForSharing_Params_Data* params =
          reinterpret_cast<
              internal::Frame_GetCanonicalUrlForSharing_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Frame_GetCanonicalUrlForSharing_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 14, false);
        return false;
      }
      Frame::GetCanonicalUrlForSharingCallback callback =
          Frame_GetCanonicalUrlForSharing_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCanonicalUrlForSharing(std::move(callback));
      return true;
    }
    case internal::kFrame_SnapshotAccessibilityTree_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Frame::SnapshotAccessibilityTree",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Frame::SnapshotAccessibilityTree");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Frame_SnapshotAccessibilityTree_Params_Data* params =
          reinterpret_cast<
              internal::Frame_SnapshotAccessibilityTree_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SnapshotAccessibilityTreeParamsPtr p_params{};
      Frame_SnapshotAccessibilityTree_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Frame::Name_, 15, false);
        return false;
      }
      Frame::SnapshotAccessibilityTreeCallback callback =
          Frame_SnapshotAccessibilityTree_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SnapshotAccessibilityTree(
std::move(p_params), std::move(callback));
      return true;
    }
    case internal::kFrame_GetSerializedHtmlWithLocalLinks_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameValidationInfo[] = {
    {internal::kFrame_CommitSameDocumentNavigation_Name,
     {&internal::Frame_CommitSameDocumentNavigation_Params_Data::Validate,
      &internal::Frame_CommitSameDocumentNavigation_ResponseParams_Data::Validate}},
    {internal::kFrame_HandleRendererDebugURL_Name,
     {&internal::Frame_HandleRendererDebugURL_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_UpdateSubresourceLoaderFactories_Name,
     {&internal::Frame_UpdateSubresourceLoaderFactories_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_BindDevToolsAgent_Name,
     {&internal::Frame_BindDevToolsAgent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_JavaScriptMethodExecuteRequest_Name,
     {&internal::Frame_JavaScriptMethodExecuteRequest_Params_Data::Validate,
      &internal::Frame_JavaScriptMethodExecuteRequest_ResponseParams_Data::Validate}},
    {internal::kFrame_JavaScriptExecuteRequest_Name,
     {&internal::Frame_JavaScriptExecuteRequest_Params_Data::Validate,
      &internal::Frame_JavaScriptExecuteRequest_ResponseParams_Data::Validate}},
    {internal::kFrame_JavaScriptExecuteRequestForTests_Name,
     {&internal::Frame_JavaScriptExecuteRequestForTests_Params_Data::Validate,
      &internal::Frame_JavaScriptExecuteRequestForTests_ResponseParams_Data::Validate}},
    {internal::kFrame_JavaScriptExecuteRequestInIsolatedWorld_Name,
     {&internal::Frame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data::Validate,
      &internal::Frame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data::Validate}},
    {internal::kFrame_SetWantErrorMessageStackTrace_Name,
     {&internal::Frame_SetWantErrorMessageStackTrace_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_Unload_Name,
     {&internal::Frame_Unload_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_Delete_Name,
     {&internal::Frame_Delete_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_BlockRequests_Name,
     {&internal::Frame_BlockRequests_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_ResumeBlockedRequests_Name,
     {&internal::Frame_ResumeBlockedRequests_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_GetInterfaceProvider_Name,
     {&internal::Frame_GetInterfaceProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrame_GetCanonicalUrlForSharing_Name,
     {&internal::Frame_GetCanonicalUrlForSharing_Params_Data::Validate,
      &internal::Frame_GetCanonicalUrlForSharing_ResponseParams_Data::Validate}},
    {internal::kFrame_SnapshotAccessibilityTree_Name,
     {&internal::Frame_SnapshotAccessibilityTree_Params_Data::Validate,
      &internal::Frame_SnapshotAccessibilityTree_ResponseParams_Data::Validate}},
    {internal::kFrame_GetSerializedHtmlWithLocalLinks_Name,
     {&internal::Frame_GetSerializedHtmlWithLocalLinks_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::Frame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameValidationInfo);
}

bool FrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::Frame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kFrameValidationInfo);

}
const char FrameBindingsControl::Name_[] = "content.mojom.FrameBindingsControl";

FrameBindingsControlProxy::FrameBindingsControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameBindingsControlProxy::AllowBindings(
    int32_t in_enabled_bindings_flags) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameBindingsControl::AllowBindings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled_bindings_flags"), in_enabled_bindings_flags, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameBindingsControl_AllowBindings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameBindingsControl_AllowBindings_Params_Data> params(
          message);
  params.Allocate();
  params->enabled_bindings_flags = in_enabled_bindings_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameBindingsControl::Name_);
  message.set_method_name("AllowBindings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameBindingsControlProxy::EnableMojoJsBindings(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::FrameBindingsControl::EnableMojoJsBindings");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameBindingsControl_EnableMojoJsBindings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameBindingsControl_EnableMojoJsBindings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameBindingsControl::Name_);
  message.set_method_name("EnableMojoJsBindings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameBindingsControlProxy::BindWebUI(
    ::mojo::PendingAssociatedReceiver<::content::mojom::WebUI> in_receiver, ::mojo::PendingAssociatedRemote<::content::mojom::WebUIHost> in_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameBindingsControl::BindWebUI", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingAssociatedReceiver<::content::mojom::WebUI>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote"), in_remote, 
                        "<value of type ::mojo::PendingAssociatedRemote<::content::mojom::WebUIHost>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameBindingsControl_BindWebUI_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameBindingsControl_BindWebUI_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::content::mojom::WebUIAssociatedRequestDataView>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid receiver in FrameBindingsControl.BindWebUI request");
  mojo::internal::Serialize<::content::mojom::WebUIHostAssociatedPtrInfoDataView>(
      in_remote, &params->remote, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid remote in FrameBindingsControl.BindWebUI request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameBindingsControl::Name_);
  message.set_method_name("BindWebUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameBindingsControlStubDispatch::Accept(
    FrameBindingsControl* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFrameBindingsControl_AllowBindings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameBindingsControl::AllowBindings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameBindingsControl::AllowBindings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameBindingsControl_AllowBindings_Params_Data* params =
          reinterpret_cast<internal::FrameBindingsControl_AllowBindings_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_enabled_bindings_flags{};
      FrameBindingsControl_AllowBindings_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled_bindings_flags = input_data_view.enabled_bindings_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameBindingsControl::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllowBindings(
std::move(p_enabled_bindings_flags));
      return true;
    }
    case internal::kFrameBindingsControl_EnableMojoJsBindings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameBindingsControl::EnableMojoJsBindings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameBindingsControl::EnableMojoJsBindings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameBindingsControl_EnableMojoJsBindings_Params_Data* params =
          reinterpret_cast<internal::FrameBindingsControl_EnableMojoJsBindings_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameBindingsControl_EnableMojoJsBindings_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameBindingsControl::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableMojoJsBindings();
      return true;
    }
    case internal::kFrameBindingsControl_BindWebUI_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameBindingsControl::BindWebUI",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameBindingsControl::BindWebUI");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameBindingsControl_BindWebUI_Params_Data* params =
          reinterpret_cast<internal::FrameBindingsControl_BindWebUI_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::content::mojom::WebUI> p_receiver{};
      ::mojo::PendingAssociatedRemote<::content::mojom::WebUIHost> p_remote{};
      FrameBindingsControl_BindWebUI_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_remote =
            input_data_view.TakeRemote<decltype(p_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameBindingsControl::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindWebUI(
std::move(p_receiver), 
std::move(p_remote));
      return true;
    }
  }
  return false;
}

// static
bool FrameBindingsControlStubDispatch::AcceptWithResponder(
    FrameBindingsControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameBindingsControl_AllowBindings_Name: {
      break;
    }
    case internal::kFrameBindingsControl_EnableMojoJsBindings_Name: {
      break;
    }
    case internal::kFrameBindingsControl_BindWebUI_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameBindingsControlValidationInfo[] = {
    {internal::kFrameBindingsControl_AllowBindings_Name,
     {&internal::FrameBindingsControl_AllowBindings_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameBindingsControl_EnableMojoJsBindings_Name,
     {&internal::FrameBindingsControl_EnableMojoJsBindings_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameBindingsControl_BindWebUI_Name,
     {&internal::FrameBindingsControl_BindWebUI_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameBindingsControlRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FrameBindingsControl::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameBindingsControlValidationInfo);
}

const char FrameHost::Name_[] = "content.mojom.FrameHost";
bool FrameHost::CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply) {
  NOTREACHED();
  return false;
}
bool FrameHost::CreatePortal(::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> portal, ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> client, int32_t* out_proxy_routing_id, ::content::mojom::FrameReplicationStatePtr* out_initial_replicated_state, ::blink::PortalToken* out_portal_token, ::blink::RemoteFrameToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token) {
  NOTREACHED();
  return false;
}
bool FrameHost::AdoptPortal(const ::blink::PortalToken& portal_token, int32_t* out_proxy_routing_id, ::content::mojom::FrameReplicationStatePtr* out_replicated_state, ::blink::RemoteFrameToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token) {
  NOTREACHED();
  return false;
}
class FrameHost_CreateNewWindow_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreateNewWindow_HandleSyncResponse(
      bool* result, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply)
      : result_(result), out_status_(out_status), out_reply_(out_reply) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  CreateNewWindowStatus* out_status_;
  CreateNewWindowReplyPtr* out_reply_;DISALLOW_COPY_AND_ASSIGN(FrameHost_CreateNewWindow_HandleSyncResponse);
};

class FrameHost_CreateNewWindow_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreateNewWindow_ForwardToCallback(
      FrameHost::CreateNewWindowCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameHost::CreateNewWindowCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameHost_CreateNewWindow_ForwardToCallback);
};
class FrameHost_CreatePortal_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreatePortal_HandleSyncResponse(
      bool* result, int32_t* out_proxy_routing_id, ::content::mojom::FrameReplicationStatePtr* out_initial_replicated_state, ::blink::PortalToken* out_portal_token, ::blink::RemoteFrameToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token)
      : result_(result), out_proxy_routing_id_(out_proxy_routing_id), out_initial_replicated_state_(out_initial_replicated_state), out_portal_token_(out_portal_token), out_frame_token_(out_frame_token), out_devtools_frame_token_(out_devtools_frame_token) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int32_t* out_proxy_routing_id_;
  ::content::mojom::FrameReplicationStatePtr* out_initial_replicated_state_;
  ::blink::PortalToken* out_portal_token_;
  ::blink::RemoteFrameToken* out_frame_token_;
  ::base::UnguessableToken* out_devtools_frame_token_;DISALLOW_COPY_AND_ASSIGN(FrameHost_CreatePortal_HandleSyncResponse);
};

class FrameHost_CreatePortal_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameHost_CreatePortal_ForwardToCallback(
      FrameHost::CreatePortalCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameHost::CreatePortalCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameHost_CreatePortal_ForwardToCallback);
};
class FrameHost_AdoptPortal_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameHost_AdoptPortal_HandleSyncResponse(
      bool* result, int32_t* out_proxy_routing_id, ::content::mojom::FrameReplicationStatePtr* out_replicated_state, ::blink::RemoteFrameToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token)
      : result_(result), out_proxy_routing_id_(out_proxy_routing_id), out_replicated_state_(out_replicated_state), out_frame_token_(out_frame_token), out_devtools_frame_token_(out_devtools_frame_token) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int32_t* out_proxy_routing_id_;
  ::content::mojom::FrameReplicationStatePtr* out_replicated_state_;
  ::blink::RemoteFrameToken* out_frame_token_;
  ::base::UnguessableToken* out_devtools_frame_token_;DISALLOW_COPY_AND_ASSIGN(FrameHost_AdoptPortal_HandleSyncResponse);
};

class FrameHost_AdoptPortal_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameHost_AdoptPortal_ForwardToCallback(
      FrameHost::AdoptPortalCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameHost::AdoptPortalCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameHost_AdoptPortal_ForwardToCallback);
};

FrameHostProxy::FrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FrameHostProxy::CreateNewWindow(
    CreateNewWindowParamsPtr param_params, CreateNewWindowStatus* out_param_status, CreateNewWindowReplyPtr* out_param_reply) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "content::mojom::FrameHost::CreateNewWindow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), param_params, 
                        "<value of type CreateNewWindowParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewWindow_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CreateNewWindow_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::CreateNewWindowParamsDataView>(
      param_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in FrameHost.CreateNewWindow request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewWindow");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreateNewWindow_HandleSyncResponse(
          &result, out_param_status, out_param_reply));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::FrameHost::CreateNewWindow", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), out_param_status, 
                        "<value of type CreateNewWindowStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reply"), out_param_reply, 
                        "<value of type CreateNewWindowReplyPtr>");
   });
#endif
  return result;
}

void FrameHostProxy::CreateNewWindow(
    CreateNewWindowParamsPtr in_params, CreateNewWindowCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::CreateNewWindow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type CreateNewWindowParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewWindow_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CreateNewWindow_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::CreateNewWindowParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in FrameHost.CreateNewWindow request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewWindow");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreateNewWindow_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool FrameHostProxy::CreatePortal(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> param_portal, ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> param_client, int32_t* out_param_proxy_routing_id, ::content::mojom::FrameReplicationStatePtr* out_param_initial_replicated_state, ::blink::PortalToken* out_param_portal_token, ::blink::RemoteFrameToken* out_param_frame_token, ::base::UnguessableToken* out_param_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "content::mojom::FrameHost::CreatePortal", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("portal"), param_portal, 
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::Portal>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), param_client, 
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreatePortal_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CreatePortal_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PortalAssociatedRequestDataView>(
      param_portal, &params->portal, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->portal),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid portal in FrameHost.CreatePortal request");
  mojo::internal::Serialize<::blink::mojom::PortalClientAssociatedPtrInfoDataView>(
      param_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in FrameHost.CreatePortal request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreatePortal");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreatePortal_HandleSyncResponse(
          &result, out_param_proxy_routing_id, out_param_initial_replicated_state, out_param_portal_token, out_param_frame_token, out_param_devtools_frame_token));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::FrameHost::CreatePortal", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_routing_id"), out_param_proxy_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initial_replicated_state"), out_param_initial_replicated_state, 
                        "<value of type ::content::mojom::FrameReplicationStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("portal_token"), out_param_portal_token, 
                        "<value of type const ::blink::PortalToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), out_param_frame_token, 
                        "<value of type const ::blink::RemoteFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_frame_token"), out_param_devtools_frame_token, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  return result;
}

void FrameHostProxy::CreatePortal(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> in_portal, ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> in_client, CreatePortalCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::CreatePortal", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("portal"), in_portal, 
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::Portal>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreatePortal_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CreatePortal_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PortalAssociatedRequestDataView>(
      in_portal, &params->portal, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->portal),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid portal in FrameHost.CreatePortal request");
  mojo::internal::Serialize<::blink::mojom::PortalClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in FrameHost.CreatePortal request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreatePortal");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_CreatePortal_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool FrameHostProxy::AdoptPortal(
    const ::blink::PortalToken& param_portal_token, int32_t* out_param_proxy_routing_id, ::content::mojom::FrameReplicationStatePtr* out_param_replicated_state, ::blink::RemoteFrameToken* out_param_frame_token, ::base::UnguessableToken* out_param_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "content::mojom::FrameHost::AdoptPortal", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("portal_token"), param_portal_token, 
                        "<value of type const ::blink::PortalToken&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_AdoptPortal_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_AdoptPortal_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->portal_token)::BaseType> portal_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PortalTokenDataView>(
      param_portal_token, portal_token_fragment);
  params->portal_token.Set(
      portal_token_fragment.is_null() ? nullptr : portal_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->portal_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null portal_token in FrameHost.AdoptPortal request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("AdoptPortal");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_AdoptPortal_HandleSyncResponse(
          &result, out_param_proxy_routing_id, out_param_replicated_state, out_param_frame_token, out_param_devtools_frame_token));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::FrameHost::AdoptPortal", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_routing_id"), out_param_proxy_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replicated_state"), out_param_replicated_state, 
                        "<value of type ::content::mojom::FrameReplicationStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), out_param_frame_token, 
                        "<value of type const ::blink::RemoteFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_frame_token"), out_param_devtools_frame_token, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  return result;
}

void FrameHostProxy::AdoptPortal(
    const ::blink::PortalToken& in_portal_token, AdoptPortalCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::AdoptPortal", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("portal_token"), in_portal_token, 
                        "<value of type const ::blink::PortalToken&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_AdoptPortal_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_AdoptPortal_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->portal_token)::BaseType> portal_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PortalTokenDataView>(
      in_portal_token, portal_token_fragment);
  params->portal_token.Set(
      portal_token_fragment.is_null() ? nullptr : portal_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->portal_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null portal_token in FrameHost.AdoptPortal request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("AdoptPortal");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameHost_AdoptPortal_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameHostProxy::CreateNewPopupWidget(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::PopupWidgetHost> in_popup_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> in_blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> in_blink_widget) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::CreateNewPopupWidget", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("popup_host"), in_popup_host, 
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::PopupWidgetHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blink_widget_host"), in_blink_widget_host, 
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blink_widget"), in_blink_widget, 
                        "<value of type ::mojo::PendingAssociatedRemote<::blink::mojom::Widget>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewPopupWidget_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CreateNewPopupWidget_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PopupWidgetHostAssociatedRequestDataView>(
      in_popup_host, &params->popup_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->popup_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid popup_host in FrameHost.CreateNewPopupWidget request");
  mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedRequestDataView>(
      in_blink_widget_host, &params->blink_widget_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blink_widget_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_widget_host in FrameHost.CreateNewPopupWidget request");
  mojo::internal::Serialize<::blink::mojom::WidgetAssociatedPtrInfoDataView>(
      in_blink_widget, &params->blink_widget, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blink_widget),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_widget in FrameHost.CreateNewPopupWidget request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewPopupWidget");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::CreateChildFrame(
    int32_t in_child_routing_id, ::mojo::PendingAssociatedRemote<Frame> in_frame, ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> in_browser_interface_broker, ::blink::mojom::PolicyContainerBindParamsPtr in_policy_container_bind_params, ::blink::mojom::TreeScopeType in_scope, const std::string& in_frame_name, const std::string& in_frame_unique_name, bool in_is_created_by_script, const ::blink::FramePolicy& in_frame_policy, ::blink::mojom::FrameOwnerPropertiesPtr in_frame_owner_properties, ::blink::mojom::FrameOwnerElementType in_frame_owner_element_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::CreateChildFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_routing_id"), in_child_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame, 
                        "<value of type ::mojo::PendingAssociatedRemote<Frame>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_interface_broker"), in_browser_interface_broker, 
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_container_bind_params"), in_policy_container_bind_params, 
                        "<value of type ::blink::mojom::PolicyContainerBindParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scope"), in_scope, 
                        "<value of type ::blink::mojom::TreeScopeType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_name"), in_frame_name, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_unique_name"), in_frame_unique_name, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_created_by_script"), in_is_created_by_script, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_policy"), in_frame_policy, 
                        "<value of type const ::blink::FramePolicy&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_owner_properties"), in_frame_owner_properties, 
                        "<value of type ::blink::mojom::FrameOwnerPropertiesPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_owner_element_type"), in_frame_owner_element_type, 
                        "<value of type ::blink::mojom::FrameOwnerElementType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateChildFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CreateChildFrame_Params_Data> params(
          message);
  params.Allocate();
  params->child_routing_id = in_child_routing_id;
  mojo::internal::Serialize<::content::mojom::FrameAssociatedPtrInfoDataView>(
      in_frame, &params->frame, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->frame),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid frame in FrameHost.CreateChildFrame request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
      in_browser_interface_broker, &params->browser_interface_broker, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->browser_interface_broker),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid browser_interface_broker in FrameHost.CreateChildFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_container_bind_params)::BaseType> policy_container_bind_params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PolicyContainerBindParamsDataView>(
      in_policy_container_bind_params, policy_container_bind_params_fragment);
  params->policy_container_bind_params.Set(
      policy_container_bind_params_fragment.is_null() ? nullptr : policy_container_bind_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_container_bind_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_container_bind_params in FrameHost.CreateChildFrame request");
  mojo::internal::Serialize<::blink::mojom::TreeScopeType>(
      in_scope, &params->scope);
  mojo::internal::MessageFragment<
      typename decltype(params->frame_name)::BaseType> frame_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_frame_name, frame_name_fragment);
  params->frame_name.Set(
      frame_name_fragment.is_null() ? nullptr : frame_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_name in FrameHost.CreateChildFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_unique_name)::BaseType> frame_unique_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_frame_unique_name, frame_unique_name_fragment);
  params->frame_unique_name.Set(
      frame_unique_name_fragment.is_null() ? nullptr : frame_unique_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_unique_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_unique_name in FrameHost.CreateChildFrame request");
  params->is_created_by_script = in_is_created_by_script;
  mojo::internal::MessageFragment<
      typename decltype(params->frame_policy)::BaseType> frame_policy_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
      in_frame_policy, frame_policy_fragment);
  params->frame_policy.Set(
      frame_policy_fragment.is_null() ? nullptr : frame_policy_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_policy in FrameHost.CreateChildFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_owner_properties)::BaseType> frame_owner_properties_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
      in_frame_owner_properties, frame_owner_properties_fragment);
  params->frame_owner_properties.Set(
      frame_owner_properties_fragment.is_null() ? nullptr : frame_owner_properties_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_owner_properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_owner_properties in FrameHost.CreateChildFrame request");
  mojo::internal::Serialize<::blink::mojom::FrameOwnerElementType>(
      in_frame_owner_element_type, &params->frame_owner_element_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateChildFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::DidCommitProvisionalLoad(
    ::content::mojom::DidCommitProvisionalLoadParamsPtr in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::DidCommitProvisionalLoad", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type ::content::mojom::DidCommitProvisionalLoadParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_params"), in_interface_params, 
                        "<value of type ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_DidCommitProvisionalLoad_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_DidCommitProvisionalLoad_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in FrameHost.DidCommitProvisionalLoad request");
  mojo::internal::MessageFragment<
      typename decltype(params->interface_params)::BaseType> interface_params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
      in_interface_params, interface_params_fragment);
  params->interface_params.Set(
      interface_params_fragment.is_null() ? nullptr : interface_params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidCommitProvisionalLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::DidCommitSameDocumentNavigation(
    ::content::mojom::DidCommitProvisionalLoadParamsPtr in_params, ::content::mojom::DidCommitSameDocumentNavigationParamsPtr in_same_document_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::DidCommitSameDocumentNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type ::content::mojom::DidCommitProvisionalLoadParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("same_document_params"), in_same_document_params, 
                        "<value of type ::content::mojom::DidCommitSameDocumentNavigationParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_DidCommitSameDocumentNavigation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_DidCommitSameDocumentNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in FrameHost.DidCommitSameDocumentNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->same_document_params)::BaseType> same_document_params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::DidCommitSameDocumentNavigationParamsDataView>(
      in_same_document_params, same_document_params_fragment);
  params->same_document_params.Set(
      same_document_params_fragment.is_null() ? nullptr : same_document_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->same_document_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null same_document_params in FrameHost.DidCommitSameDocumentNavigation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidCommitSameDocumentNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::BeginNavigation(
    ::content::mojom::CommonNavigationParamsPtr in_common_params, ::content::mojom::BeginNavigationParamsPtr in_begin_params, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> in_blob_url_token, ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> in_navigation_client, ::mojo::PendingRemote<::blink::mojom::NavigationInitiator> in_navigation_initiator, ::mojo::PendingRemote<::blink::mojom::PolicyContainerHostKeepAliveHandle> in_initiator_policy_container_keep_alive_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::BeginNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("common_params"), in_common_params, 
                        "<value of type ::content::mojom::CommonNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("begin_params"), in_begin_params, 
                        "<value of type ::content::mojom::BeginNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob_url_token"), in_blob_url_token, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::BlobURLToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("navigation_client"), in_navigation_client, 
                        "<value of type ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("navigation_initiator"), in_navigation_initiator, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::NavigationInitiator>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initiator_policy_container_keep_alive_handle"), in_initiator_policy_container_keep_alive_handle, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::PolicyContainerHostKeepAliveHandle>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_BeginNavigation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_BeginNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->common_params)::BaseType> common_params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::CommonNavigationParamsDataView>(
      in_common_params, common_params_fragment);
  params->common_params.Set(
      common_params_fragment.is_null() ? nullptr : common_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->common_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null common_params in FrameHost.BeginNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->begin_params)::BaseType> begin_params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::BeginNavigationParamsDataView>(
      in_begin_params, begin_params_fragment);
  params->begin_params.Set(
      begin_params_fragment.is_null() ? nullptr : begin_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->begin_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null begin_params in FrameHost.BeginNavigation request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
      in_blob_url_token, &params->blob_url_token, &params.message());
  mojo::internal::Serialize<::content::mojom::NavigationClientAssociatedPtrInfoDataView>(
      in_navigation_client, &params->navigation_client, &params.message());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NavigationInitiatorInterfaceBase>>(
      in_navigation_initiator, &params->navigation_initiator, &params.message());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PolicyContainerHostKeepAliveHandleInterfaceBase>>(
      in_initiator_policy_container_keep_alive_handle, &params->initiator_policy_container_keep_alive_handle, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("BeginNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::SubresourceResponseStarted(
    const ::GURL& in_url, uint32_t in_cert_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::SubresourceResponseStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cert_status"), in_cert_status, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_SubresourceResponseStarted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_SubresourceResponseStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in FrameHost.SubresourceResponseStarted request");
  params->cert_status = in_cert_status;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("SubresourceResponseStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::ResourceLoadComplete(
    ::blink::mojom::ResourceLoadInfoPtr in_url_load_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::ResourceLoadComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_load_info"), in_url_load_info, 
                        "<value of type ::blink::mojom::ResourceLoadInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_ResourceLoadComplete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_ResourceLoadComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url_load_info)::BaseType> url_load_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ResourceLoadInfoDataView>(
      in_url_load_info, url_load_info_fragment);
  params->url_load_info.Set(
      url_load_info_fragment.is_null() ? nullptr : url_load_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url_load_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_load_info in FrameHost.ResourceLoadComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("ResourceLoadComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::DidChangeName(
    const std::string& in_name, const std::string& in_unique_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::DidChangeName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unique_name"), in_unique_name, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_DidChangeName_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_DidChangeName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in FrameHost.DidChangeName request");
  mojo::internal::MessageFragment<
      typename decltype(params->unique_name)::BaseType> unique_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_unique_name, unique_name_fragment);
  params->unique_name.Set(
      unique_name_fragment.is_null() ? nullptr : unique_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->unique_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null unique_name in FrameHost.DidChangeName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidChangeName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::CancelInitialHistoryLoad(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::FrameHost::CancelInitialHistoryLoad");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CancelInitialHistoryLoad_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CancelInitialHistoryLoad_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CancelInitialHistoryLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::UpdateEncoding(
    const std::string& in_encoding_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::UpdateEncoding", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoding_name"), in_encoding_name, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_UpdateEncoding_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_UpdateEncoding_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->encoding_name)::BaseType> encoding_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_encoding_name, encoding_name_fragment);
  params->encoding_name.Set(
      encoding_name_fragment.is_null() ? nullptr : encoding_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->encoding_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null encoding_name in FrameHost.UpdateEncoding request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("UpdateEncoding");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::UpdateState(
    const ::blink::PageState& in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::UpdateState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state, 
                        "<value of type const ::blink::PageState&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_UpdateState_Name, kFlags, 0, 0,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_UpdateState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::PageStateDataView>(
      in_state, state_fragment);
  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in FrameHost.UpdateState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("UpdateState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::OpenURL(
    OpenURLParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameHost::OpenURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type OpenURLParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_OpenURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_OpenURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::OpenURLParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in FrameHost.OpenURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("OpenURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameHostProxy::DidStopLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::FrameHost::DidStopLoading");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_DidStopLoading_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_DidStopLoading_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("DidStopLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class FrameHost_CreateNewWindow_ProxyToResponder {
 public:
  static FrameHost::CreateNewWindowCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameHost_CreateNewWindow_ProxyToResponder> proxy(
        new FrameHost_CreateNewWindow_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameHost_CreateNewWindow_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameHost_CreateNewWindow_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameHost_CreateNewWindow_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameHost::CreateNewWindowCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateNewWindowStatus in_status, CreateNewWindowReplyPtr in_reply);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameHost_CreateNewWindow_ProxyToResponder);
};

bool FrameHost_CreateNewWindow_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameHost::CreateNewWindowCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FrameHost_CreateNewWindow_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameHost_CreateNewWindow_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CreateNewWindowStatus p_status{};
  CreateNewWindowReplyPtr p_reply{};
  FrameHost_CreateNewWindow_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadReply(&p_reply))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_reply));
  return true;
}

void FrameHost_CreateNewWindow_ProxyToResponder::Run(
    CreateNewWindowStatus in_status, CreateNewWindowReplyPtr in_reply) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameHost::CreateNewWindowCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type CreateNewWindowStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reply"), in_reply, 
                        "<value of type CreateNewWindowReplyPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreateNewWindow_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CreateNewWindow_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::content::mojom::CreateNewWindowStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->reply)::BaseType> reply_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::CreateNewWindowReplyDataView>(
      in_reply, reply_fragment);
  params->reply.Set(
      reply_fragment.is_null() ? nullptr : reply_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameHost::CreateNewWindowCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreateNewWindow");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameHost_CreateNewWindow_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FrameHost_CreateNewWindow_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameHost_CreateNewWindow_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  CreateNewWindowStatus p_status{};
  CreateNewWindowReplyPtr p_reply{};
  FrameHost_CreateNewWindow_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadReply(&p_reply))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 0, true);
    return false;
  }
  *out_status_ = std::move(p_status);
  *out_reply_ = std::move(p_reply);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class FrameHost_CreatePortal_ProxyToResponder {
 public:
  static FrameHost::CreatePortalCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameHost_CreatePortal_ProxyToResponder> proxy(
        new FrameHost_CreatePortal_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameHost_CreatePortal_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameHost_CreatePortal_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameHost_CreatePortal_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameHost::CreatePortalCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_proxy_routing_id, ::content::mojom::FrameReplicationStatePtr in_initial_replicated_state, const ::blink::PortalToken& in_portal_token, const ::blink::RemoteFrameToken& in_frame_token, const ::base::UnguessableToken& in_devtools_frame_token);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameHost_CreatePortal_ProxyToResponder);
};

bool FrameHost_CreatePortal_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameHost::CreatePortalCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FrameHost_CreatePortal_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameHost_CreatePortal_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_proxy_routing_id{};
  ::content::mojom::FrameReplicationStatePtr p_initial_replicated_state{};
  ::blink::PortalToken p_portal_token{};
  ::blink::RemoteFrameToken p_frame_token{};
  ::base::UnguessableToken p_devtools_frame_token{};
  FrameHost_CreatePortal_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_proxy_routing_id = input_data_view.proxy_routing_id();
  if (success && !input_data_view.ReadInitialReplicatedState(&p_initial_replicated_state))
    success = false;
  if (success && !input_data_view.ReadPortalToken(&p_portal_token))
    success = false;
  if (success && !input_data_view.ReadFrameToken(&p_frame_token))
    success = false;
  if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_proxy_routing_id), 
std::move(p_initial_replicated_state), 
std::move(p_portal_token), 
std::move(p_frame_token), 
std::move(p_devtools_frame_token));
  return true;
}

void FrameHost_CreatePortal_ProxyToResponder::Run(
    int32_t in_proxy_routing_id, ::content::mojom::FrameReplicationStatePtr in_initial_replicated_state, const ::blink::PortalToken& in_portal_token, const ::blink::RemoteFrameToken& in_frame_token, const ::base::UnguessableToken& in_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameHost::CreatePortalCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_routing_id"), in_proxy_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initial_replicated_state"), in_initial_replicated_state, 
                        "<value of type ::content::mojom::FrameReplicationStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("portal_token"), in_portal_token, 
                        "<value of type const ::blink::PortalToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token, 
                        "<value of type const ::blink::RemoteFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_frame_token"), in_devtools_frame_token, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_CreatePortal_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_CreatePortal_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->proxy_routing_id = in_proxy_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->initial_replicated_state)::BaseType> initial_replicated_state_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::FrameReplicationStateDataView>(
      in_initial_replicated_state, initial_replicated_state_fragment);
  params->initial_replicated_state.Set(
      initial_replicated_state_fragment.is_null() ? nullptr : initial_replicated_state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->initial_replicated_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initial_replicated_state in ");
  mojo::internal::MessageFragment<
      typename decltype(params->portal_token)::BaseType> portal_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PortalTokenDataView>(
      in_portal_token, portal_token_fragment);
  params->portal_token.Set(
      portal_token_fragment.is_null() ? nullptr : portal_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->portal_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null portal_token in ");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token)::BaseType> frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
      in_frame_token, frame_token_fragment);
  params->frame_token.Set(
      frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_token in ");
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_frame_token)::BaseType> devtools_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_frame_token, devtools_frame_token_fragment);
  params->devtools_frame_token.Set(
      devtools_frame_token_fragment.is_null() ? nullptr : devtools_frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtools_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_frame_token in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameHost::CreatePortalCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("CreatePortal");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameHost_CreatePortal_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FrameHost_CreatePortal_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameHost_CreatePortal_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  int32_t p_proxy_routing_id{};
  ::content::mojom::FrameReplicationStatePtr p_initial_replicated_state{};
  ::blink::PortalToken p_portal_token{};
  ::blink::RemoteFrameToken p_frame_token{};
  ::base::UnguessableToken p_devtools_frame_token{};
  FrameHost_CreatePortal_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_proxy_routing_id = input_data_view.proxy_routing_id();
  if (success && !input_data_view.ReadInitialReplicatedState(&p_initial_replicated_state))
    success = false;
  if (success && !input_data_view.ReadPortalToken(&p_portal_token))
    success = false;
  if (success && !input_data_view.ReadFrameToken(&p_frame_token))
    success = false;
  if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 1, true);
    return false;
  }
  *out_proxy_routing_id_ = std::move(p_proxy_routing_id);
  *out_initial_replicated_state_ = std::move(p_initial_replicated_state);
  *out_portal_token_ = std::move(p_portal_token);
  *out_frame_token_ = std::move(p_frame_token);
  *out_devtools_frame_token_ = std::move(p_devtools_frame_token);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class FrameHost_AdoptPortal_ProxyToResponder {
 public:
  static FrameHost::AdoptPortalCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameHost_AdoptPortal_ProxyToResponder> proxy(
        new FrameHost_AdoptPortal_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameHost_AdoptPortal_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameHost_AdoptPortal_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameHost_AdoptPortal_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameHost::AdoptPortalCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_proxy_routing_id, ::content::mojom::FrameReplicationStatePtr in_replicated_state, const ::blink::RemoteFrameToken& in_frame_token, const ::base::UnguessableToken& in_devtools_frame_token);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameHost_AdoptPortal_ProxyToResponder);
};

bool FrameHost_AdoptPortal_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::FrameHost::AdoptPortalCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FrameHost_AdoptPortal_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameHost_AdoptPortal_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_proxy_routing_id{};
  ::content::mojom::FrameReplicationStatePtr p_replicated_state{};
  ::blink::RemoteFrameToken p_frame_token{};
  ::base::UnguessableToken p_devtools_frame_token{};
  FrameHost_AdoptPortal_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_proxy_routing_id = input_data_view.proxy_routing_id();
  if (success && !input_data_view.ReadReplicatedState(&p_replicated_state))
    success = false;
  if (success && !input_data_view.ReadFrameToken(&p_frame_token))
    success = false;
  if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_proxy_routing_id), 
std::move(p_replicated_state), 
std::move(p_frame_token), 
std::move(p_devtools_frame_token));
  return true;
}

void FrameHost_AdoptPortal_ProxyToResponder::Run(
    int32_t in_proxy_routing_id, ::content::mojom::FrameReplicationStatePtr in_replicated_state, const ::blink::RemoteFrameToken& in_frame_token, const ::base::UnguessableToken& in_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::FrameHost::AdoptPortalCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_routing_id"), in_proxy_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replicated_state"), in_replicated_state, 
                        "<value of type ::content::mojom::FrameReplicationStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token, 
                        "<value of type const ::blink::RemoteFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_frame_token"), in_devtools_frame_token, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameHost_AdoptPortal_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FrameHost_AdoptPortal_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->proxy_routing_id = in_proxy_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->replicated_state)::BaseType> replicated_state_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::FrameReplicationStateDataView>(
      in_replicated_state, replicated_state_fragment);
  params->replicated_state.Set(
      replicated_state_fragment.is_null() ? nullptr : replicated_state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->replicated_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null replicated_state in ");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token)::BaseType> frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
      in_frame_token, frame_token_fragment);
  params->frame_token.Set(
      frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_token in ");
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_frame_token)::BaseType> devtools_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_frame_token, devtools_frame_token_fragment);
  params->devtools_frame_token.Set(
      devtools_frame_token_fragment.is_null() ? nullptr : devtools_frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtools_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_frame_token in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::FrameHost::AdoptPortalCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameHost::Name_);
  message.set_method_name("AdoptPortal");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameHost_AdoptPortal_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FrameHost_AdoptPortal_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameHost_AdoptPortal_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  int32_t p_proxy_routing_id{};
  ::content::mojom::FrameReplicationStatePtr p_replicated_state{};
  ::blink::RemoteFrameToken p_frame_token{};
  ::base::UnguessableToken p_devtools_frame_token{};
  FrameHost_AdoptPortal_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_proxy_routing_id = input_data_view.proxy_routing_id();
  if (success && !input_data_view.ReadReplicatedState(&p_replicated_state))
    success = false;
  if (success && !input_data_view.ReadFrameToken(&p_frame_token))
    success = false;
  if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameHost::Name_, 2, true);
    return false;
  }
  *out_proxy_routing_id_ = std::move(p_proxy_routing_id);
  *out_replicated_state_ = std::move(p_replicated_state);
  *out_frame_token_ = std::move(p_frame_token);
  *out_devtools_frame_token_ = std::move(p_devtools_frame_token);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool FrameHostStubDispatch::Accept(
    FrameHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFrameHost_CreateNewWindow_Name: {
      break;
    }
    case internal::kFrameHost_CreatePortal_Name: {
      break;
    }
    case internal::kFrameHost_AdoptPortal_Name: {
      break;
    }
    case internal::kFrameHost_CreateNewPopupWidget_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::CreateNewPopupWidget",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::CreateNewPopupWidget");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_CreateNewPopupWidget_Params_Data* params =
          reinterpret_cast<internal::FrameHost_CreateNewPopupWidget_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::blink::mojom::PopupWidgetHost> p_popup_host{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> p_blink_widget_host{};
      ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> p_blink_widget{};
      FrameHost_CreateNewPopupWidget_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_popup_host =
            input_data_view.TakePopupHost<decltype(p_popup_host)>();
      }
      if (success) {
        p_blink_widget_host =
            input_data_view.TakeBlinkWidgetHost<decltype(p_blink_widget_host)>();
      }
      if (success) {
        p_blink_widget =
            input_data_view.TakeBlinkWidget<decltype(p_blink_widget)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNewPopupWidget(
std::move(p_popup_host), 
std::move(p_blink_widget_host), 
std::move(p_blink_widget));
      return true;
    }
    case internal::kFrameHost_CreateChildFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::CreateChildFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::CreateChildFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_CreateChildFrame_Params_Data* params =
          reinterpret_cast<internal::FrameHost_CreateChildFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_child_routing_id{};
      ::mojo::PendingAssociatedRemote<Frame> p_frame{};
      ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> p_browser_interface_broker{};
      ::blink::mojom::PolicyContainerBindParamsPtr p_policy_container_bind_params{};
      ::blink::mojom::TreeScopeType p_scope{};
      std::string p_frame_name{};
      std::string p_frame_unique_name{};
      bool p_is_created_by_script{};
      ::blink::FramePolicy p_frame_policy{};
      ::blink::mojom::FrameOwnerPropertiesPtr p_frame_owner_properties{};
      ::blink::mojom::FrameOwnerElementType p_frame_owner_element_type{};
      FrameHost_CreateChildFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_child_routing_id = input_data_view.child_routing_id();
      if (success) {
        p_frame =
            input_data_view.TakeFrame<decltype(p_frame)>();
      }
      if (success) {
        p_browser_interface_broker =
            input_data_view.TakeBrowserInterfaceBroker<decltype(p_browser_interface_broker)>();
      }
      if (success && !input_data_view.ReadPolicyContainerBindParams(&p_policy_container_bind_params))
        success = false;
      if (success && !input_data_view.ReadScope(&p_scope))
        success = false;
      if (success && !input_data_view.ReadFrameName(&p_frame_name))
        success = false;
      if (success && !input_data_view.ReadFrameUniqueName(&p_frame_unique_name))
        success = false;
      if (success)
        p_is_created_by_script = input_data_view.is_created_by_script();
      if (success && !input_data_view.ReadFramePolicy(&p_frame_policy))
        success = false;
      if (success && !input_data_view.ReadFrameOwnerProperties(&p_frame_owner_properties))
        success = false;
      if (success && !input_data_view.ReadFrameOwnerElementType(&p_frame_owner_element_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateChildFrame(
std::move(p_child_routing_id), 
std::move(p_frame), 
std::move(p_browser_interface_broker), 
std::move(p_policy_container_bind_params), 
std::move(p_scope), 
std::move(p_frame_name), 
std::move(p_frame_unique_name), 
std::move(p_is_created_by_script), 
std::move(p_frame_policy), 
std::move(p_frame_owner_properties), 
std::move(p_frame_owner_element_type));
      return true;
    }
    case internal::kFrameHost_DidCommitProvisionalLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::DidCommitProvisionalLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::DidCommitProvisionalLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_DidCommitProvisionalLoad_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidCommitProvisionalLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::content::mojom::DidCommitProvisionalLoadParamsPtr p_params{};
      ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr p_interface_params{};
      FrameHost_DidCommitProvisionalLoad_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadInterfaceParams(&p_interface_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCommitProvisionalLoad(
std::move(p_params), 
std::move(p_interface_params));
      return true;
    }
    case internal::kFrameHost_DidCommitSameDocumentNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::DidCommitSameDocumentNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::DidCommitSameDocumentNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_DidCommitSameDocumentNavigation_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidCommitSameDocumentNavigation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::content::mojom::DidCommitProvisionalLoadParamsPtr p_params{};
      ::content::mojom::DidCommitSameDocumentNavigationParamsPtr p_same_document_params{};
      FrameHost_DidCommitSameDocumentNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadSameDocumentParams(&p_same_document_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCommitSameDocumentNavigation(
std::move(p_params), 
std::move(p_same_document_params));
      return true;
    }
    case internal::kFrameHost_BeginNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::BeginNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::BeginNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_BeginNavigation_Params_Data* params =
          reinterpret_cast<internal::FrameHost_BeginNavigation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::content::mojom::CommonNavigationParamsPtr p_common_params{};
      ::content::mojom::BeginNavigationParamsPtr p_begin_params{};
      ::mojo::PendingRemote<::blink::mojom::BlobURLToken> p_blob_url_token{};
      ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> p_navigation_client{};
      ::mojo::PendingRemote<::blink::mojom::NavigationInitiator> p_navigation_initiator{};
      ::mojo::PendingRemote<::blink::mojom::PolicyContainerHostKeepAliveHandle> p_initiator_policy_container_keep_alive_handle{};
      FrameHost_BeginNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommonParams(&p_common_params))
        success = false;
      if (success && !input_data_view.ReadBeginParams(&p_begin_params))
        success = false;
      if (success) {
        p_blob_url_token =
            input_data_view.TakeBlobUrlToken<decltype(p_blob_url_token)>();
      }
      if (success) {
        p_navigation_client =
            input_data_view.TakeNavigationClient<decltype(p_navigation_client)>();
      }
      if (success) {
        p_navigation_initiator =
            input_data_view.TakeNavigationInitiator<decltype(p_navigation_initiator)>();
      }
      if (success) {
        p_initiator_policy_container_keep_alive_handle =
            input_data_view.TakeInitiatorPolicyContainerKeepAliveHandle<decltype(p_initiator_policy_container_keep_alive_handle)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginNavigation(
std::move(p_common_params), 
std::move(p_begin_params), 
std::move(p_blob_url_token), 
std::move(p_navigation_client), 
std::move(p_navigation_initiator), 
std::move(p_initiator_policy_container_keep_alive_handle));
      return true;
    }
    case internal::kFrameHost_SubresourceResponseStarted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::SubresourceResponseStarted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::SubresourceResponseStarted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_SubresourceResponseStarted_Params_Data* params =
          reinterpret_cast<internal::FrameHost_SubresourceResponseStarted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      uint32_t p_cert_status{};
      FrameHost_SubresourceResponseStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_cert_status = input_data_view.cert_status();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubresourceResponseStarted(
std::move(p_url), 
std::move(p_cert_status));
      return true;
    }
    case internal::kFrameHost_ResourceLoadComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::ResourceLoadComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::ResourceLoadComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_ResourceLoadComplete_Params_Data* params =
          reinterpret_cast<internal::FrameHost_ResourceLoadComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ResourceLoadInfoPtr p_url_load_info{};
      FrameHost_ResourceLoadComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrlLoadInfo(&p_url_load_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResourceLoadComplete(
std::move(p_url_load_info));
      return true;
    }
    case internal::kFrameHost_DidChangeName_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::DidChangeName",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::DidChangeName");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_DidChangeName_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidChangeName_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_name{};
      std::string p_unique_name{};
      FrameHost_DidChangeName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadUniqueName(&p_unique_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeName(
std::move(p_name), 
std::move(p_unique_name));
      return true;
    }
    case internal::kFrameHost_CancelInitialHistoryLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::CancelInitialHistoryLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::CancelInitialHistoryLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_CancelInitialHistoryLoad_Params_Data* params =
          reinterpret_cast<internal::FrameHost_CancelInitialHistoryLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameHost_CancelInitialHistoryLoad_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelInitialHistoryLoad();
      return true;
    }
    case internal::kFrameHost_UpdateEncoding_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::UpdateEncoding",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::UpdateEncoding");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_UpdateEncoding_Params_Data* params =
          reinterpret_cast<internal::FrameHost_UpdateEncoding_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_encoding_name{};
      FrameHost_UpdateEncoding_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEncodingName(&p_encoding_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateEncoding(
std::move(p_encoding_name));
      return true;
    }
    case internal::kFrameHost_UpdateState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::UpdateState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::UpdateState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_UpdateState_Params_Data* params =
          reinterpret_cast<internal::FrameHost_UpdateState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::PageState p_state{};
      FrameHost_UpdateState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateState(
std::move(p_state));
      return true;
    }
    case internal::kFrameHost_OpenURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::OpenURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::OpenURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_OpenURL_Params_Data* params =
          reinterpret_cast<internal::FrameHost_OpenURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      OpenURLParamsPtr p_params{};
      FrameHost_OpenURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenURL(
std::move(p_params));
      return true;
    }
    case internal::kFrameHost_DidStopLoading_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::DidStopLoading",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::DidStopLoading");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameHost_DidStopLoading_Params_Data* params =
          reinterpret_cast<internal::FrameHost_DidStopLoading_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameHost_DidStopLoading_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStopLoading();
      return true;
    }
  }
  return false;
}

// static
bool FrameHostStubDispatch::AcceptWithResponder(
    FrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameHost_CreateNewWindow_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::CreateNewWindow",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::CreateNewWindow");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameHost_CreateNewWindow_Params_Data* params =
          reinterpret_cast<
              internal::FrameHost_CreateNewWindow_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CreateNewWindowParamsPtr p_params{};
      FrameHost_CreateNewWindow_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 0, false);
        return false;
      }
      FrameHost::CreateNewWindowCallback callback =
          FrameHost_CreateNewWindow_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNewWindow(
std::move(p_params), std::move(callback));
      return true;
    }
    case internal::kFrameHost_CreatePortal_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::CreatePortal",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::CreatePortal");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameHost_CreatePortal_Params_Data* params =
          reinterpret_cast<
              internal::FrameHost_CreatePortal_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> p_portal{};
      ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> p_client{};
      FrameHost_CreatePortal_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_portal =
            input_data_view.TakePortal<decltype(p_portal)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 1, false);
        return false;
      }
      FrameHost::CreatePortalCallback callback =
          FrameHost_CreatePortal_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePortal(
std::move(p_portal), 
std::move(p_client), std::move(callback));
      return true;
    }
    case internal::kFrameHost_AdoptPortal_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameHost::AdoptPortal",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameHost::AdoptPortal");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameHost_AdoptPortal_Params_Data* params =
          reinterpret_cast<
              internal::FrameHost_AdoptPortal_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::PortalToken p_portal_token{};
      FrameHost_AdoptPortal_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPortalToken(&p_portal_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameHost::Name_, 2, false);
        return false;
      }
      FrameHost::AdoptPortalCallback callback =
          FrameHost_AdoptPortal_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdoptPortal(
std::move(p_portal_token), std::move(callback));
      return true;
    }
    case internal::kFrameHost_CreateNewPopupWidget_Name: {
      break;
    }
    case internal::kFrameHost_CreateChildFrame_Name: {
      break;
    }
    case internal::kFrameHost_DidCommitProvisionalLoad_Name: {
      break;
    }
    case internal::kFrameHost_DidCommitSameDocumentNavigation_Name: {
      break;
    }
    case internal::kFrameHost_BeginNavigation_Name: {
      break;
    }
    case internal::kFrameHost_SubresourceResponseStarted_Name: {
      break;
    }
    case internal::kFrameHost_ResourceLoadComplete_Name: {
      break;
    }
    case internal::kFrameHost_DidChangeName_Name: {
      break;
    }
    case internal::kFrameHost_CancelInitialHistoryLoad_Name: {
      break;
    }
    case internal::kFrameHost_UpdateEncoding_Name: {
      break;
    }
    case internal::kFrameHost_UpdateState_Name: {
      break;
    }
    case internal::kFrameHost_OpenURL_Name: {
      break;
    }
    case internal::kFrameHost_DidStopLoading_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameHostValidationInfo[] = {
    {internal::kFrameHost_CreateNewWindow_Name,
     {&internal::FrameHost_CreateNewWindow_Params_Data::Validate,
      &internal::FrameHost_CreateNewWindow_ResponseParams_Data::Validate}},
    {internal::kFrameHost_CreatePortal_Name,
     {&internal::FrameHost_CreatePortal_Params_Data::Validate,
      &internal::FrameHost_CreatePortal_ResponseParams_Data::Validate}},
    {internal::kFrameHost_AdoptPortal_Name,
     {&internal::FrameHost_AdoptPortal_Params_Data::Validate,
      &internal::FrameHost_AdoptPortal_ResponseParams_Data::Validate}},
    {internal::kFrameHost_CreateNewPopupWidget_Name,
     {&internal::FrameHost_CreateNewPopupWidget_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_CreateChildFrame_Name,
     {&internal::FrameHost_CreateChildFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_DidCommitProvisionalLoad_Name,
     {&internal::FrameHost_DidCommitProvisionalLoad_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_DidCommitSameDocumentNavigation_Name,
     {&internal::FrameHost_DidCommitSameDocumentNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_BeginNavigation_Name,
     {&internal::FrameHost_BeginNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_SubresourceResponseStarted_Name,
     {&internal::FrameHost_SubresourceResponseStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_ResourceLoadComplete_Name,
     {&internal::FrameHost_ResourceLoadComplete_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_DidChangeName_Name,
     {&internal::FrameHost_DidChangeName_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_CancelInitialHistoryLoad_Name,
     {&internal::FrameHost_CancelInitialHistoryLoad_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_UpdateEncoding_Name,
     {&internal::FrameHost_UpdateEncoding_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_UpdateState_Name,
     {&internal::FrameHost_UpdateState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_OpenURL_Name,
     {&internal::FrameHost_OpenURL_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameHost_DidStopLoading_Name,
     {&internal::FrameHost_DidStopLoading_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FrameHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameHostValidationInfo);
}

bool FrameHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FrameHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kFrameHostValidationInfo);

}
}  // namespace mojom
}  // namespace content

namespace mojo {


// static
bool StructTraits<::content::mojom::CreateViewParams::DataView, ::content::mojom::CreateViewParamsPtr>::Read(
    ::content::mojom::CreateViewParams::DataView input,
    ::content::mojom::CreateViewParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateViewParamsPtr result(::content::mojom::CreateViewParams::New());
  
      if (success && !input.ReadRendererPreferences(&result->renderer_preferences))
        success = false;
      if (success && !input.ReadWebPreferences(&result->web_preferences))
        success = false;
      if (success)
        result->view_id = input.view_id();
      if (success && !input.ReadSessionStorageNamespaceId(&result->session_storage_namespace_id))
        success = false;
      if (success && !input.ReadOpenerFrameToken(&result->opener_frame_token))
        success = false;
      if (success && !input.ReadReplicationState(&result->replication_state))
        success = false;
      if (success && !input.ReadDevtoolsMainFrameToken(&result->devtools_main_frame_token))
        success = false;
      if (success && !input.ReadMainFrame(&result->main_frame))
        success = false;
      if (success)
        result->hidden = input.hidden();
      if (success)
        result->never_composited = input.never_composited();
      if (success)
        result->window_was_created_with_opener = input.window_was_created_with_opener();
      if (success)
        result->renderer_wide_named_frame_lookup = input.renderer_wide_named_frame_lookup();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success) {
        result->blink_page_broadcast =
            input.TakeBlinkPageBroadcast<decltype(result->blink_page_broadcast)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateLocalMainFrameParams::DataView, ::content::mojom::CreateLocalMainFrameParamsPtr>::Read(
    ::content::mojom::CreateLocalMainFrameParams::DataView input,
    ::content::mojom::CreateLocalMainFrameParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateLocalMainFrameParamsPtr result(::content::mojom::CreateLocalMainFrameParams::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success)
        result->routing_id = input.routing_id();
      if (success) {
        result->frame =
            input.TakeFrame<decltype(result->frame)>();
      }
      if (success) {
        result->interface_broker =
            input.TakeInterfaceBroker<decltype(result->interface_broker)>();
      }
      if (success)
        result->has_committed_real_load = input.has_committed_real_load();
      if (success && !input.ReadPolicyContainer(&result->policy_container))
        success = false;
      if (success && !input.ReadWidgetParams(&result->widget_params))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateRemoteMainFrameParams::DataView, ::content::mojom::CreateRemoteMainFrameParamsPtr>::Read(
    ::content::mojom::CreateRemoteMainFrameParams::DataView input,
    ::content::mojom::CreateRemoteMainFrameParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateRemoteMainFrameParamsPtr result(::content::mojom::CreateRemoteMainFrameParams::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success)
        result->routing_id = input.routing_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateFrameWidgetParams::DataView, ::content::mojom::CreateFrameWidgetParamsPtr>::Read(
    ::content::mojom::CreateFrameWidgetParams::DataView input,
    ::content::mojom::CreateFrameWidgetParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateFrameWidgetParamsPtr result(::content::mojom::CreateFrameWidgetParams::New());
  
      if (success)
        result->routing_id = input.routing_id();
      if (success) {
        result->frame_widget_host =
            input.TakeFrameWidgetHost<decltype(result->frame_widget_host)>();
      }
      if (success) {
        result->frame_widget =
            input.TakeFrameWidget<decltype(result->frame_widget)>();
      }
      if (success) {
        result->widget_host =
            input.TakeWidgetHost<decltype(result->widget_host)>();
      }
      if (success) {
        result->widget =
            input.TakeWidget<decltype(result->widget)>();
      }
      if (success && !input.ReadVisualProperties(&result->visual_properties))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateFrameParams::DataView, ::content::mojom::CreateFrameParamsPtr>::Read(
    ::content::mojom::CreateFrameParams::DataView input,
    ::content::mojom::CreateFrameParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateFrameParamsPtr result(::content::mojom::CreateFrameParams::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success)
        result->routing_id = input.routing_id();
      if (success)
        result->previous_routing_id = input.previous_routing_id();
      if (success && !input.ReadOpenerFrameToken(&result->opener_frame_token))
        success = false;
      if (success)
        result->parent_routing_id = input.parent_routing_id();
      if (success)
        result->previous_sibling_routing_id = input.previous_sibling_routing_id();
      if (success) {
        result->interface_broker =
            input.TakeInterfaceBroker<decltype(result->interface_broker)>();
      }
      if (success && !input.ReadReplicationState(&result->replication_state))
        success = false;
      if (success && !input.ReadDevtoolsFrameToken(&result->devtools_frame_token))
        success = false;
      if (success && !input.ReadFrameOwnerProperties(&result->frame_owner_properties))
        success = false;
      if (success && !input.ReadWidgetParams(&result->widget_params))
        success = false;
      if (success)
        result->has_committed_real_load = input.has_committed_real_load();
      if (success && !input.ReadPolicyContainer(&result->policy_container))
        success = false;
      if (success) {
        result->frame =
            input.TakeFrame<decltype(result->frame)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::SnapshotAccessibilityTreeParams::DataView, ::content::mojom::SnapshotAccessibilityTreeParamsPtr>::Read(
    ::content::mojom::SnapshotAccessibilityTreeParams::DataView input,
    ::content::mojom::SnapshotAccessibilityTreeParamsPtr* output) {
  bool success = true;
  ::content::mojom::SnapshotAccessibilityTreeParamsPtr result(::content::mojom::SnapshotAccessibilityTreeParams::New());
  
      if (success)
        result->ax_mode = input.ax_mode();
      if (success)
        result->exclude_offscreen = input.exclude_offscreen();
      if (success)
        result->max_nodes = input.max_nodes();
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateNewWindowParams::DataView, ::content::mojom::CreateNewWindowParamsPtr>::Read(
    ::content::mojom::CreateNewWindowParams::DataView input,
    ::content::mojom::CreateNewWindowParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateNewWindowParamsPtr result(::content::mojom::CreateNewWindowParams::New());
  
      if (success)
        result->allow_popup = input.allow_popup();
      if (success && !input.ReadWindowContainerType(&result->window_container_type))
        success = false;
      if (success && !input.ReadSessionStorageNamespaceId(&result->session_storage_namespace_id))
        success = false;
      if (success && !input.ReadCloneFromSessionStorageNamespaceId(&result->clone_from_session_storage_namespace_id))
        success = false;
      if (success && !input.ReadFrameName(&result->frame_name))
        success = false;
      if (success)
        result->opener_suppressed = input.opener_suppressed();
      if (success && !input.ReadDisposition(&result->disposition))
        success = false;
      if (success && !input.ReadTargetUrl(&result->target_url))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadFeatures(&result->features))
        success = false;
      if (success && !input.ReadImpression(&result->impression))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateNewWindowReply::DataView, ::content::mojom::CreateNewWindowReplyPtr>::Read(
    ::content::mojom::CreateNewWindowReply::DataView input,
    ::content::mojom::CreateNewWindowReplyPtr* output) {
  bool success = true;
  ::content::mojom::CreateNewWindowReplyPtr result(::content::mojom::CreateNewWindowReply::New());
  
      if (success)
        result->route_id = input.route_id();
      if (success && !input.ReadMainFrameToken(&result->main_frame_token))
        success = false;
      if (success)
        result->main_frame_route_id = input.main_frame_route_id();
      if (success) {
        result->frame =
            input.TakeFrame<decltype(result->frame)>();
      }
      if (success && !input.ReadWidgetParams(&result->widget_params))
        success = false;
      if (success) {
        result->page_broadcast =
            input.TakePageBroadcast<decltype(result->page_broadcast)>();
      }
      if (success) {
        result->main_frame_interface_broker =
            input.TakeMainFrameInterfaceBroker<decltype(result->main_frame_interface_broker)>();
      }
      if (success && !input.ReadClonedSessionStorageNamespaceId(&result->cloned_session_storage_namespace_id))
        success = false;
      if (success && !input.ReadDevtoolsMainFrameToken(&result->devtools_main_frame_token))
        success = false;
      if (success)
        result->wait_for_debugger = input.wait_for_debugger();
      if (success && !input.ReadPolicyContainer(&result->policy_container))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::OpenURLParams::DataView, ::content::mojom::OpenURLParamsPtr>::Read(
    ::content::mojom::OpenURLParams::DataView input,
    ::content::mojom::OpenURLParamsPtr* output) {
  bool success = true;
  ::content::mojom::OpenURLParamsPtr result(::content::mojom::OpenURLParams::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadInitiatorOrigin(&result->initiator_origin))
        success = false;
      if (success && !input.ReadInitiatorFrameToken(&result->initiator_frame_token))
        success = false;
      if (success && !input.ReadPostBody(&result->post_body))
        success = false;
      if (success && !input.ReadExtraHeaders(&result->extra_headers))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadDisposition(&result->disposition))
        success = false;
      if (success)
        result->should_replace_current_entry = input.should_replace_current_entry();
      if (success)
        result->user_gesture = input.user_gesture();
      if (success && !input.ReadTriggeringEventInfo(&result->triggering_event_info))
        success = false;
      if (success) {
        result->blob_url_token =
            input.TakeBlobUrlToken<decltype(result->blob_url_token)>();
      }
      if (success && !input.ReadHrefTranslate(&result->href_translate))
        success = false;
      if (success && !input.ReadImpression(&result->impression))
        success = false;
      if (success && !input.ReadDownloadPolicy(&result->download_policy))
        success = false;
      if (success) {
        result->initiator_policy_container_keep_alive_handle =
            input.TakeInitiatorPolicyContainerKeepAliveHandle<decltype(result->initiator_policy_container_keep_alive_handle)>();
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::content::mojom::CreateMainFrameUnion::DataView, ::content::mojom::CreateMainFrameUnionPtr>::Read(
    ::content::mojom::CreateMainFrameUnion::DataView input,
    ::content::mojom::CreateMainFrameUnionPtr* output) {
  using UnionType = ::content::mojom::CreateMainFrameUnion;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::LOCAL_PARAMS: {
      ::content::mojom::CreateLocalMainFrameParamsPtr result_local_params;
      if (!input.ReadLocalParams(&result_local_params))
        return false;

      *output = UnionType::NewLocalParams(
          std::move(result_local_params));
      break;
    }
    case Tag::REMOTE_PARAMS: {
      ::content::mojom::CreateRemoteMainFrameParamsPtr result_remote_params;
      if (!input.ReadRemoteParams(&result_remote_params))
        return false;

      *output = UnionType::NewRemoteParams(
          std::move(result_remote_params));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif