// content/common/frame_proxy.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/frame_proxy.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/frame_proxy.mojom-params-data.h"
#include "content/common/frame_proxy.mojom-shared-message-ids.h"

#include "content/common/frame_proxy.mojom-import-headers.h"


#ifndef CONTENT_COMMON_FRAME_PROXY_MOJOM_JUMBO_H_
#define CONTENT_COMMON_FRAME_PROXY_MOJOM_JUMBO_H_
#include "content/common/frame_messages.h"
#endif
namespace content {
namespace mojom {
const char RenderFrameProxyHost::Name_[] = "content.mojom.RenderFrameProxyHost";

RenderFrameProxyHostProxy::RenderFrameProxyHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderFrameProxyHostProxy::OpenURL(
    ::content::mojom::OpenURLParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RenderFrameProxyHost::OpenURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type ::content::mojom::OpenURLParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderFrameProxyHost_OpenURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderFrameProxyHost_OpenURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::OpenURLParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in RenderFrameProxyHost.OpenURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameProxyHost::Name_);
  message.set_method_name("OpenURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RenderFrameProxyHostStubDispatch::Accept(
    RenderFrameProxyHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRenderFrameProxyHost_OpenURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderFrameProxyHost::OpenURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderFrameProxyHost::OpenURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderFrameProxyHost_OpenURL_Params_Data* params =
          reinterpret_cast<internal::RenderFrameProxyHost_OpenURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::content::mojom::OpenURLParamsPtr p_params{};
      RenderFrameProxyHost_OpenURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameProxyHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenURL(
std::move(p_params));
      return true;
    }
  }
  return false;
}

// static
bool RenderFrameProxyHostStubDispatch::AcceptWithResponder(
    RenderFrameProxyHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderFrameProxyHost_OpenURL_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRenderFrameProxyHostValidationInfo[] = {
    {internal::kRenderFrameProxyHost_OpenURL_Name,
     {&internal::RenderFrameProxyHost_OpenURL_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RenderFrameProxyHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RenderFrameProxyHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRenderFrameProxyHostValidationInfo);
}

const char RenderFrameProxy::Name_[] = "content.mojom.RenderFrameProxy";

RenderFrameProxyProxy::RenderFrameProxyProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderFrameProxyProxy::ChildProcessGone(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::RenderFrameProxy::ChildProcessGone");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderFrameProxy_ChildProcessGone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderFrameProxy_ChildProcessGone_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameProxy::Name_);
  message.set_method_name("ChildProcessGone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RenderFrameProxyStubDispatch::Accept(
    RenderFrameProxy* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRenderFrameProxy_ChildProcessGone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderFrameProxy::ChildProcessGone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderFrameProxy::ChildProcessGone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderFrameProxy_ChildProcessGone_Params_Data* params =
          reinterpret_cast<internal::RenderFrameProxy_ChildProcessGone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RenderFrameProxy_ChildProcessGone_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameProxy::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChildProcessGone();
      return true;
    }
  }
  return false;
}

// static
bool RenderFrameProxyStubDispatch::AcceptWithResponder(
    RenderFrameProxy* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderFrameProxy_ChildProcessGone_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRenderFrameProxyValidationInfo[] = {
    {internal::kRenderFrameProxy_ChildProcessGone_Name,
     {&internal::RenderFrameProxy_ChildProcessGone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RenderFrameProxyRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RenderFrameProxy::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRenderFrameProxyValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif