// content/common/frame_replication_state.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/frame_replication_state.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/frame_replication_state.mojom-params-data.h"
#include "content/common/frame_replication_state.mojom-shared-message-ids.h"

#include "content/common/frame_replication_state.mojom-import-headers.h"


#ifndef CONTENT_COMMON_FRAME_REPLICATION_STATE_MOJOM_JUMBO_H_
#define CONTENT_COMMON_FRAME_REPLICATION_STATE_MOJOM_JUMBO_H_
#include "third_party/blink/common/feature_policy/feature_policy_mojom_traits.h"
#endif
namespace content {
namespace mojom {
FrameReplicationState::FrameReplicationState()
    : origin(),
      name(),
      unique_name(),
      feature_policy_header(),
      active_sandbox_flags(::network::mojom::WebSandboxFlags::kNone),
      frame_policy(),
      accumulated_csps(),
      scope(::blink::mojom::TreeScopeType::kDocument),
      insecure_request_policy(::blink::mojom::InsecureRequestPolicy::kLeaveInsecureRequestsAlone),
      insecure_navigations_set(),
      has_potentially_trustworthy_unique_origin(false),
      has_active_user_gesture(false),
      has_received_user_gesture_before_nav(false),
      frame_owner_element_type(::blink::mojom::FrameOwnerElementType::kNone),
      ad_frame_type(::blink::mojom::AdFrameType::kNonAd) {}

FrameReplicationState::FrameReplicationState(
    const ::url::Origin& origin_in,
    const std::string& name_in,
    const std::string& unique_name_in,
    std::vector<::blink::ParsedFeaturePolicyDeclaration> feature_policy_header_in,
    ::network::mojom::WebSandboxFlags active_sandbox_flags_in,
    const ::blink::FramePolicy& frame_policy_in,
    std::vector<::network::mojom::ContentSecurityPolicyPtr> accumulated_csps_in,
    ::blink::mojom::TreeScopeType scope_in,
    ::blink::mojom::InsecureRequestPolicy insecure_request_policy_in,
    std::vector<uint32_t> insecure_navigations_set_in,
    bool has_potentially_trustworthy_unique_origin_in,
    bool has_active_user_gesture_in,
    bool has_received_user_gesture_before_nav_in,
    ::blink::mojom::FrameOwnerElementType frame_owner_element_type_in,
    ::blink::mojom::AdFrameType ad_frame_type_in)
    : origin(std::move(origin_in)),
      name(std::move(name_in)),
      unique_name(std::move(unique_name_in)),
      feature_policy_header(std::move(feature_policy_header_in)),
      active_sandbox_flags(std::move(active_sandbox_flags_in)),
      frame_policy(std::move(frame_policy_in)),
      accumulated_csps(std::move(accumulated_csps_in)),
      scope(std::move(scope_in)),
      insecure_request_policy(std::move(insecure_request_policy_in)),
      insecure_navigations_set(std::move(insecure_navigations_set_in)),
      has_potentially_trustworthy_unique_origin(std::move(has_potentially_trustworthy_unique_origin_in)),
      has_active_user_gesture(std::move(has_active_user_gesture_in)),
      has_received_user_gesture_before_nav(std::move(has_received_user_gesture_before_nav_in)),
      frame_owner_element_type(std::move(frame_owner_element_type_in)),
      ad_frame_type(std::move(ad_frame_type_in)) {}

FrameReplicationState::~FrameReplicationState() = default;

void FrameReplicationState::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin, 
      "<value of type const ::url::Origin&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unique_name"), this->unique_name, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_policy_header"), this->feature_policy_header, 
      "<value of type const std::vector<::blink::ParsedFeaturePolicyDeclaration>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_sandbox_flags"), this->active_sandbox_flags, 
      "<value of type ::network::mojom::WebSandboxFlags>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_policy"), this->frame_policy, 
      "<value of type const ::blink::FramePolicy&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accumulated_csps"), this->accumulated_csps, 
      "<value of type std::vector<::network::mojom::ContentSecurityPolicyPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope"), this->scope, 
      "<value of type ::blink::mojom::TreeScopeType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "insecure_request_policy"), this->insecure_request_policy, 
      "<value of type ::blink::mojom::InsecureRequestPolicy>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "insecure_navigations_set"), this->insecure_navigations_set, 
      "<value of type const std::vector<uint32_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_potentially_trustworthy_unique_origin"), this->has_potentially_trustworthy_unique_origin, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_active_user_gesture"), this->has_active_user_gesture, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_received_user_gesture_before_nav"), this->has_received_user_gesture_before_nav, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_owner_element_type"), this->frame_owner_element_type, 
      "<value of type ::blink::mojom::FrameOwnerElementType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_frame_type"), this->ad_frame_type, 
      "<value of type ::blink::mojom::AdFrameType>");
}

bool FrameReplicationState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace content

namespace mojo {


// static
bool StructTraits<::content::mojom::FrameReplicationState::DataView, ::content::mojom::FrameReplicationStatePtr>::Read(
    ::content::mojom::FrameReplicationState::DataView input,
    ::content::mojom::FrameReplicationStatePtr* output) {
  bool success = true;
  ::content::mojom::FrameReplicationStatePtr result(::content::mojom::FrameReplicationState::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadUniqueName(&result->unique_name))
        success = false;
      if (success && !input.ReadFeaturePolicyHeader(&result->feature_policy_header))
        success = false;
      if (success && !input.ReadActiveSandboxFlags(&result->active_sandbox_flags))
        success = false;
      if (success && !input.ReadFramePolicy(&result->frame_policy))
        success = false;
      if (success && !input.ReadAccumulatedCsps(&result->accumulated_csps))
        success = false;
      if (success && !input.ReadScope(&result->scope))
        success = false;
      if (success && !input.ReadInsecureRequestPolicy(&result->insecure_request_policy))
        success = false;
      if (success && !input.ReadInsecureNavigationsSet(&result->insecure_navigations_set))
        success = false;
      if (success)
        result->has_potentially_trustworthy_unique_origin = input.has_potentially_trustworthy_unique_origin();
      if (success)
        result->has_active_user_gesture = input.has_active_user_gesture();
      if (success)
        result->has_received_user_gesture_before_nav = input.has_received_user_gesture_before_nav();
      if (success && !input.ReadFrameOwnerElementType(&result->frame_owner_element_type))
        success = false;
      if (success && !input.ReadAdFrameType(&result->ad_frame_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif