// content/common/histogram_fetcher.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/histogram_fetcher.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/histogram_fetcher.mojom-params-data.h"
namespace content {
namespace mojom {

namespace internal {


// static
bool ChildHistogramFetcherFactory_CreateFetcher_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ChildHistogramFetcherFactory_CreateFetcher_Params_Data* object = static_cast<const ChildHistogramFetcherFactory_CreateFetcher_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->shared_memory, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->child_histogram_fetcher, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->child_histogram_fetcher,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ChildHistogramFetcherFactory_CreateFetcher_Params_Data::ChildHistogramFetcherFactory_CreateFetcher_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data* object = static_cast<const ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data::ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data* object = static_cast<const ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->deltas, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams deltas_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->deltas, validation_context,
                                         &deltas_validate_params)) {
    return false;
  }

  return true;
}

ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data::ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content
