// content/common/histogram_fetcher.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/histogram_fetcher.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/histogram_fetcher.mojom-params-data.h"
#include "content/common/histogram_fetcher.mojom-shared-message-ids.h"

#include "content/common/histogram_fetcher.mojom-import-headers.h"


#ifndef CONTENT_COMMON_HISTOGRAM_FETCHER_MOJOM_JUMBO_H_
#define CONTENT_COMMON_HISTOGRAM_FETCHER_MOJOM_JUMBO_H_
#endif
namespace content {
namespace mojom {
const char ChildHistogramFetcherFactory::Name_[] = "content.mojom.ChildHistogramFetcherFactory";

ChildHistogramFetcherFactoryProxy::ChildHistogramFetcherFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChildHistogramFetcherFactoryProxy::CreateFetcher(
    ::base::WritableSharedMemoryRegion in_shared_memory, ::mojo::PendingReceiver<ChildHistogramFetcher> in_child_histogram_fetcher) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::ChildHistogramFetcherFactory::CreateFetcher", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_memory"), in_shared_memory, 
                        "<value of type ::base::WritableSharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_histogram_fetcher"), in_child_histogram_fetcher, 
                        "<value of type ::mojo::PendingReceiver<ChildHistogramFetcher>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kChildHistogramFetcherFactory_CreateFetcher_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildHistogramFetcherFactory_CreateFetcher_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->shared_memory)::BaseType> shared_memory_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::WritableSharedMemoryRegionDataView>(
      in_shared_memory, shared_memory_fragment);
  params->shared_memory.Set(
      shared_memory_fragment.is_null() ? nullptr : shared_memory_fragment.data());
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::content::mojom::ChildHistogramFetcherInterfaceBase>>(
      in_child_histogram_fetcher, &params->child_histogram_fetcher, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->child_histogram_fetcher),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid child_histogram_fetcher in ChildHistogramFetcherFactory.CreateFetcher request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildHistogramFetcherFactory::Name_);
  message.set_method_name("CreateFetcher");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ChildHistogramFetcherFactoryStubDispatch::Accept(
    ChildHistogramFetcherFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kChildHistogramFetcherFactory_CreateFetcher_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::ChildHistogramFetcherFactory::CreateFetcher",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::ChildHistogramFetcherFactory::CreateFetcher");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ChildHistogramFetcherFactory_CreateFetcher_Params_Data* params =
          reinterpret_cast<internal::ChildHistogramFetcherFactory_CreateFetcher_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::WritableSharedMemoryRegion p_shared_memory{};
      ::mojo::PendingReceiver<ChildHistogramFetcher> p_child_histogram_fetcher{};
      ChildHistogramFetcherFactory_CreateFetcher_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSharedMemory(&p_shared_memory))
        success = false;
      if (success) {
        p_child_histogram_fetcher =
            input_data_view.TakeChildHistogramFetcher<decltype(p_child_histogram_fetcher)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildHistogramFetcherFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFetcher(
std::move(p_shared_memory), 
std::move(p_child_histogram_fetcher));
      return true;
    }
  }
  return false;
}

// static
bool ChildHistogramFetcherFactoryStubDispatch::AcceptWithResponder(
    ChildHistogramFetcherFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kChildHistogramFetcherFactory_CreateFetcher_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kChildHistogramFetcherFactoryValidationInfo[] = {
    {internal::kChildHistogramFetcherFactory_CreateFetcher_Name,
     {&internal::ChildHistogramFetcherFactory_CreateFetcher_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ChildHistogramFetcherFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::ChildHistogramFetcherFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kChildHistogramFetcherFactoryValidationInfo);
}

const char ChildHistogramFetcher::Name_[] = "content.mojom.ChildHistogramFetcher";

class ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback(
      ChildHistogramFetcher::GetChildNonPersistentHistogramDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ChildHistogramFetcher::GetChildNonPersistentHistogramDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback);
};

ChildHistogramFetcherProxy::ChildHistogramFetcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChildHistogramFetcherProxy::GetChildNonPersistentHistogramData(
    GetChildNonPersistentHistogramDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::ChildHistogramFetcher::GetChildNonPersistentHistogramData");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kChildHistogramFetcher_GetChildNonPersistentHistogramData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildHistogramFetcher::Name_);
  message.set_method_name("GetChildNonPersistentHistogramData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder {
 public:
  static ChildHistogramFetcher::GetChildNonPersistentHistogramDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder> proxy(
        new ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ChildHistogramFetcher::GetChildNonPersistentHistogramDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_deltas);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder);
};

bool ChildHistogramFetcher_GetChildNonPersistentHistogramData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::ChildHistogramFetcher::GetChildNonPersistentHistogramDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<std::string> p_deltas{};
  ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDeltas(&p_deltas))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChildHistogramFetcher::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_deltas));
  return true;
}

void ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder::Run(
    const std::vector<std::string>& in_deltas) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::ChildHistogramFetcher::GetChildNonPersistentHistogramDataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("deltas"), in_deltas, 
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kChildHistogramFetcher_GetChildNonPersistentHistogramData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->deltas)::BaseType>
      deltas_fragment(params.message());
  const mojo::internal::ContainerValidateParams deltas_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_deltas, deltas_fragment, &deltas_validate_params);
  params->deltas.Set(
      deltas_fragment.is_null() ? nullptr : deltas_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->deltas.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null deltas in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::ChildHistogramFetcher::GetChildNonPersistentHistogramDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildHistogramFetcher::Name_);
  message.set_method_name("GetChildNonPersistentHistogramData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ChildHistogramFetcherStubDispatch::Accept(
    ChildHistogramFetcher* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kChildHistogramFetcher_GetChildNonPersistentHistogramData_Name: {
      break;
    }
  }
  return false;
}

// static
bool ChildHistogramFetcherStubDispatch::AcceptWithResponder(
    ChildHistogramFetcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kChildHistogramFetcher_GetChildNonPersistentHistogramData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::ChildHistogramFetcher::GetChildNonPersistentHistogramData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::ChildHistogramFetcher::GetChildNonPersistentHistogramData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data* params =
          reinterpret_cast<
              internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ChildHistogramFetcher_GetChildNonPersistentHistogramData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildHistogramFetcher::Name_, 0, false);
        return false;
      }
      ChildHistogramFetcher::GetChildNonPersistentHistogramDataCallback callback =
          ChildHistogramFetcher_GetChildNonPersistentHistogramData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetChildNonPersistentHistogramData(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kChildHistogramFetcherValidationInfo[] = {
    {internal::kChildHistogramFetcher_GetChildNonPersistentHistogramData_Name,
     {&internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_Params_Data::Validate,
      &internal::ChildHistogramFetcher_GetChildNonPersistentHistogramData_ResponseParams_Data::Validate}},
};

bool ChildHistogramFetcherRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::ChildHistogramFetcher::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kChildHistogramFetcherValidationInfo);
}

bool ChildHistogramFetcherResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::ChildHistogramFetcher::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kChildHistogramFetcherValidationInfo);

}
}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif