// content/common/input/input_injector.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/input/input_injector.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/input/input_injector.mojom-params-data.h"
#include "content/common/input/input_injector.mojom-shared-message-ids.h"

#include "content/common/input/input_injector.mojom-import-headers.h"


#ifndef CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_JUMBO_H_
#define CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_JUMBO_H_
#include "content/common/frame_messages.h"
#include "content/public/common/common_param_traits.h"
#include "services/network/public/cpp/p2p_param_traits.h"
#endif
namespace content {
namespace mojom {
SyntheticSmoothDrag::SyntheticSmoothDrag()
    : gesture_source_type(),
      start_point(),
      distances(),
      speed_in_pixels_s() {}

SyntheticSmoothDrag::SyntheticSmoothDrag(
    GestureSourceType gesture_source_type_in,
    const ::gfx::PointF& start_point_in,
    std::vector<::gfx::Vector2dF> distances_in,
    float speed_in_pixels_s_in)
    : gesture_source_type(std::move(gesture_source_type_in)),
      start_point(std::move(start_point_in)),
      distances(std::move(distances_in)),
      speed_in_pixels_s(std::move(speed_in_pixels_s_in)) {}

SyntheticSmoothDrag::~SyntheticSmoothDrag() = default;

void SyntheticSmoothDrag::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture_source_type"), this->gesture_source_type, 
      "<value of type GestureSourceType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_point"), this->start_point, 
      "<value of type const ::gfx::PointF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "distances"), this->distances, 
      "<value of type const std::vector<::gfx::Vector2dF>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "speed_in_pixels_s"), this->speed_in_pixels_s, 
      "<value of type float>");
}

bool SyntheticSmoothDrag::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SyntheticSmoothScroll::SyntheticSmoothScroll()
    : gesture_source_type(),
      anchor(),
      distances(),
      prevent_fling(),
      speed_in_pixels_s(),
      fling_velocity_x(),
      fling_velocity_y(),
      granularity(),
      modifiers() {}

SyntheticSmoothScroll::SyntheticSmoothScroll(
    GestureSourceType gesture_source_type_in,
    const ::gfx::PointF& anchor_in,
    std::vector<::gfx::Vector2dF> distances_in,
    bool prevent_fling_in,
    float speed_in_pixels_s_in,
    float fling_velocity_x_in,
    float fling_velocity_y_in,
    ::ui::ScrollGranularity granularity_in,
    int32_t modifiers_in)
    : gesture_source_type(std::move(gesture_source_type_in)),
      anchor(std::move(anchor_in)),
      distances(std::move(distances_in)),
      prevent_fling(std::move(prevent_fling_in)),
      speed_in_pixels_s(std::move(speed_in_pixels_s_in)),
      fling_velocity_x(std::move(fling_velocity_x_in)),
      fling_velocity_y(std::move(fling_velocity_y_in)),
      granularity(std::move(granularity_in)),
      modifiers(std::move(modifiers_in)) {}

SyntheticSmoothScroll::~SyntheticSmoothScroll() = default;

void SyntheticSmoothScroll::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture_source_type"), this->gesture_source_type, 
      "<value of type GestureSourceType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor"), this->anchor, 
      "<value of type const ::gfx::PointF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "distances"), this->distances, 
      "<value of type const std::vector<::gfx::Vector2dF>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prevent_fling"), this->prevent_fling, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "speed_in_pixels_s"), this->speed_in_pixels_s, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fling_velocity_x"), this->fling_velocity_x, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fling_velocity_y"), this->fling_velocity_y, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "granularity"), this->granularity, 
      "<value of type ::ui::ScrollGranularity>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifiers"), this->modifiers, 
      "<value of type int32_t>");
}

bool SyntheticSmoothScroll::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SyntheticPinch::SyntheticPinch()
    : scale_factor(),
      anchor(),
      relative_pointer_speed_in_pixels_s() {}

SyntheticPinch::SyntheticPinch(
    float scale_factor_in,
    const ::gfx::PointF& anchor_in,
    float relative_pointer_speed_in_pixels_s_in)
    : scale_factor(std::move(scale_factor_in)),
      anchor(std::move(anchor_in)),
      relative_pointer_speed_in_pixels_s(std::move(relative_pointer_speed_in_pixels_s_in)) {}

SyntheticPinch::~SyntheticPinch() = default;

void SyntheticPinch::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_factor"), this->scale_factor, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor"), this->anchor, 
      "<value of type const ::gfx::PointF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relative_pointer_speed_in_pixels_s"), this->relative_pointer_speed_in_pixels_s, 
      "<value of type float>");
}

bool SyntheticPinch::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SyntheticTap::SyntheticTap()
    : gesture_source_type(),
      position(),
      duration_ms() {}

SyntheticTap::SyntheticTap(
    GestureSourceType gesture_source_type_in,
    const ::gfx::PointF& position_in,
    float duration_ms_in)
    : gesture_source_type(std::move(gesture_source_type_in)),
      position(std::move(position_in)),
      duration_ms(std::move(duration_ms_in)) {}

SyntheticTap::~SyntheticTap() = default;

void SyntheticTap::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture_source_type"), this->gesture_source_type, 
      "<value of type GestureSourceType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position, 
      "<value of type const ::gfx::PointF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration_ms"), this->duration_ms, 
      "<value of type float>");
}

bool SyntheticTap::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SyntheticPointerActionParams::SyntheticPointerActionParams()
    : pointer_action_type(),
      position(),
      pointer_id(),
      button(),
      key_modifiers(),
      width(),
      height(),
      rotation_angle(),
      force(),
      timestamp(),
      duration() {}

SyntheticPointerActionParams::SyntheticPointerActionParams(
    PointerActionType pointer_action_type_in,
    const ::gfx::PointF& position_in,
    uint32_t pointer_id_in,
    SyntheticButton button_in,
    int32_t key_modifiers_in,
    float width_in,
    float height_in,
    float rotation_angle_in,
    float force_in,
    ::base::TimeTicks timestamp_in,
    ::base::TimeDelta duration_in)
    : pointer_action_type(std::move(pointer_action_type_in)),
      position(std::move(position_in)),
      pointer_id(std::move(pointer_id_in)),
      button(std::move(button_in)),
      key_modifiers(std::move(key_modifiers_in)),
      width(std::move(width_in)),
      height(std::move(height_in)),
      rotation_angle(std::move(rotation_angle_in)),
      force(std::move(force_in)),
      timestamp(std::move(timestamp_in)),
      duration(std::move(duration_in)) {}

SyntheticPointerActionParams::~SyntheticPointerActionParams() = default;

void SyntheticPointerActionParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_action_type"), this->pointer_action_type, 
      "<value of type PointerActionType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position, 
      "<value of type const ::gfx::PointF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_id"), this->pointer_id, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "button"), this->button, 
      "<value of type SyntheticButton>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_modifiers"), this->key_modifiers, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rotation_angle"), this->rotation_angle, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force"), this->force, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration, 
      "<value of type ::base::TimeDelta>");
}

bool SyntheticPointerActionParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SyntheticPointerAction::SyntheticPointerAction()
    : gesture_source_type(),
      params() {}

SyntheticPointerAction::SyntheticPointerAction(
    GestureSourceType gesture_source_type_in,
    std::vector<std::vector<SyntheticPointerActionParamsPtr>> params_in)
    : gesture_source_type(std::move(gesture_source_type_in)),
      params(std::move(params_in)) {}

SyntheticPointerAction::~SyntheticPointerAction() = default;

void SyntheticPointerAction::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture_source_type"), this->gesture_source_type, 
      "<value of type GestureSourceType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params, 
      "<value of type std::vector<std::vector<SyntheticPointerActionParamsPtr>>>");
}

bool SyntheticPointerAction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char InputInjector::Name_[] = "content.mojom.InputInjector";

class InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback(
      InputInjector::QueueSyntheticSmoothDragCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  InputInjector::QueueSyntheticSmoothDragCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback);
};

class InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback(
      InputInjector::QueueSyntheticSmoothScrollCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  InputInjector::QueueSyntheticSmoothScrollCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback);
};

class InputInjector_QueueSyntheticPinch_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputInjector_QueueSyntheticPinch_ForwardToCallback(
      InputInjector::QueueSyntheticPinchCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  InputInjector::QueueSyntheticPinchCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(InputInjector_QueueSyntheticPinch_ForwardToCallback);
};

class InputInjector_QueueSyntheticTap_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputInjector_QueueSyntheticTap_ForwardToCallback(
      InputInjector::QueueSyntheticTapCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  InputInjector::QueueSyntheticTapCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(InputInjector_QueueSyntheticTap_ForwardToCallback);
};

class InputInjector_QueueSyntheticPointerAction_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputInjector_QueueSyntheticPointerAction_ForwardToCallback(
      InputInjector::QueueSyntheticPointerActionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  InputInjector::QueueSyntheticPointerActionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(InputInjector_QueueSyntheticPointerAction_ForwardToCallback);
};

InputInjectorProxy::InputInjectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void InputInjectorProxy::QueueSyntheticSmoothDrag(
    const ::content::SyntheticSmoothDragGestureParams& in_drag, QueueSyntheticSmoothDragCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::InputInjector::QueueSyntheticSmoothDrag", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drag"), in_drag, 
                        "<value of type const ::content::SyntheticSmoothDragGestureParams&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInputInjector_QueueSyntheticSmoothDrag_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticSmoothDrag_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->drag)::BaseType> drag_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::SyntheticSmoothDragDataView>(
      in_drag, drag_fragment);
  params->drag.Set(
      drag_fragment.is_null() ? nullptr : drag_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->drag.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null drag in InputInjector.QueueSyntheticSmoothDrag request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticSmoothDrag");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void InputInjectorProxy::QueueSyntheticSmoothScroll(
    const ::content::SyntheticSmoothScrollGestureParams& in_scroll, QueueSyntheticSmoothScrollCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::InputInjector::QueueSyntheticSmoothScroll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scroll"), in_scroll, 
                        "<value of type const ::content::SyntheticSmoothScrollGestureParams&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInputInjector_QueueSyntheticSmoothScroll_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticSmoothScroll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->scroll)::BaseType> scroll_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::SyntheticSmoothScrollDataView>(
      in_scroll, scroll_fragment);
  params->scroll.Set(
      scroll_fragment.is_null() ? nullptr : scroll_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->scroll.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scroll in InputInjector.QueueSyntheticSmoothScroll request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticSmoothScroll");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void InputInjectorProxy::QueueSyntheticPinch(
    const ::content::SyntheticPinchGestureParams& in_pinch, QueueSyntheticPinchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::InputInjector::QueueSyntheticPinch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pinch"), in_pinch, 
                        "<value of type const ::content::SyntheticPinchGestureParams&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInputInjector_QueueSyntheticPinch_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticPinch_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pinch)::BaseType> pinch_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::SyntheticPinchDataView>(
      in_pinch, pinch_fragment);
  params->pinch.Set(
      pinch_fragment.is_null() ? nullptr : pinch_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->pinch.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pinch in InputInjector.QueueSyntheticPinch request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticPinch");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputInjector_QueueSyntheticPinch_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void InputInjectorProxy::QueueSyntheticTap(
    const ::content::SyntheticTapGestureParams& in_tap, QueueSyntheticTapCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::InputInjector::QueueSyntheticTap", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tap"), in_tap, 
                        "<value of type const ::content::SyntheticTapGestureParams&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInputInjector_QueueSyntheticTap_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticTap_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tap)::BaseType> tap_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::SyntheticTapDataView>(
      in_tap, tap_fragment);
  params->tap.Set(
      tap_fragment.is_null() ? nullptr : tap_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->tap.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tap in InputInjector.QueueSyntheticTap request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticTap");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputInjector_QueueSyntheticTap_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void InputInjectorProxy::QueueSyntheticPointerAction(
    const ::content::SyntheticPointerActionListParams& in_pointer_action, QueueSyntheticPointerActionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::InputInjector::QueueSyntheticPointerAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pointer_action"), in_pointer_action, 
                        "<value of type const ::content::SyntheticPointerActionListParams&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInputInjector_QueueSyntheticPointerAction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticPointerAction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pointer_action)::BaseType> pointer_action_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::SyntheticPointerActionDataView>(
      in_pointer_action, pointer_action_fragment);
  params->pointer_action.Set(
      pointer_action_fragment.is_null() ? nullptr : pointer_action_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->pointer_action.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pointer_action in InputInjector.QueueSyntheticPointerAction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticPointerAction");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputInjector_QueueSyntheticPointerAction_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder {
 public:
  static InputInjector::QueueSyntheticSmoothDragCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder> proxy(
        new InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputInjector::QueueSyntheticSmoothDragCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder);
};

bool InputInjector_QueueSyntheticSmoothDrag_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::InputInjector::QueueSyntheticSmoothDragCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  InputInjector_QueueSyntheticSmoothDrag_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputInjector::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)content::mojom::InputInjector::QueueSyntheticSmoothDragCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInputInjector_QueueSyntheticSmoothDrag_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::InputInjector::QueueSyntheticSmoothDragCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticSmoothDrag");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder {
 public:
  static InputInjector::QueueSyntheticSmoothScrollCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder> proxy(
        new InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputInjector::QueueSyntheticSmoothScrollCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder);
};

bool InputInjector_QueueSyntheticSmoothScroll_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::InputInjector::QueueSyntheticSmoothScrollCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  InputInjector_QueueSyntheticSmoothScroll_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputInjector::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)content::mojom::InputInjector::QueueSyntheticSmoothScrollCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInputInjector_QueueSyntheticSmoothScroll_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::InputInjector::QueueSyntheticSmoothScrollCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticSmoothScroll");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class InputInjector_QueueSyntheticPinch_ProxyToResponder {
 public:
  static InputInjector::QueueSyntheticPinchCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<InputInjector_QueueSyntheticPinch_ProxyToResponder> proxy(
        new InputInjector_QueueSyntheticPinch_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&InputInjector_QueueSyntheticPinch_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputInjector_QueueSyntheticPinch_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  InputInjector_QueueSyntheticPinch_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputInjector::QueueSyntheticPinchCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(InputInjector_QueueSyntheticPinch_ProxyToResponder);
};

bool InputInjector_QueueSyntheticPinch_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::InputInjector::QueueSyntheticPinchCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::InputInjector_QueueSyntheticPinch_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputInjector_QueueSyntheticPinch_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  InputInjector_QueueSyntheticPinch_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputInjector::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void InputInjector_QueueSyntheticPinch_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)content::mojom::InputInjector::QueueSyntheticPinchCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInputInjector_QueueSyntheticPinch_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticPinch_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::InputInjector::QueueSyntheticPinchCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticPinch");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class InputInjector_QueueSyntheticTap_ProxyToResponder {
 public:
  static InputInjector::QueueSyntheticTapCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<InputInjector_QueueSyntheticTap_ProxyToResponder> proxy(
        new InputInjector_QueueSyntheticTap_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&InputInjector_QueueSyntheticTap_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputInjector_QueueSyntheticTap_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  InputInjector_QueueSyntheticTap_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputInjector::QueueSyntheticTapCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(InputInjector_QueueSyntheticTap_ProxyToResponder);
};

bool InputInjector_QueueSyntheticTap_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::InputInjector::QueueSyntheticTapCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::InputInjector_QueueSyntheticTap_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputInjector_QueueSyntheticTap_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  InputInjector_QueueSyntheticTap_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputInjector::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void InputInjector_QueueSyntheticTap_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)content::mojom::InputInjector::QueueSyntheticTapCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInputInjector_QueueSyntheticTap_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticTap_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::InputInjector::QueueSyntheticTapCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticTap");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class InputInjector_QueueSyntheticPointerAction_ProxyToResponder {
 public:
  static InputInjector::QueueSyntheticPointerActionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<InputInjector_QueueSyntheticPointerAction_ProxyToResponder> proxy(
        new InputInjector_QueueSyntheticPointerAction_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&InputInjector_QueueSyntheticPointerAction_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputInjector_QueueSyntheticPointerAction_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  InputInjector_QueueSyntheticPointerAction_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputInjector::QueueSyntheticPointerActionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(InputInjector_QueueSyntheticPointerAction_ProxyToResponder);
};

bool InputInjector_QueueSyntheticPointerAction_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::InputInjector::QueueSyntheticPointerActionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::InputInjector_QueueSyntheticPointerAction_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputInjector_QueueSyntheticPointerAction_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  InputInjector_QueueSyntheticPointerAction_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputInjector::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void InputInjector_QueueSyntheticPointerAction_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)content::mojom::InputInjector::QueueSyntheticPointerActionCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kInputInjector_QueueSyntheticPointerAction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::InputInjector_QueueSyntheticPointerAction_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::InputInjector::QueueSyntheticPointerActionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputInjector::Name_);
  message.set_method_name("QueueSyntheticPointerAction");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool InputInjectorStubDispatch::Accept(
    InputInjector* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kInputInjector_QueueSyntheticSmoothDrag_Name: {
      break;
    }
    case internal::kInputInjector_QueueSyntheticSmoothScroll_Name: {
      break;
    }
    case internal::kInputInjector_QueueSyntheticPinch_Name: {
      break;
    }
    case internal::kInputInjector_QueueSyntheticTap_Name: {
      break;
    }
    case internal::kInputInjector_QueueSyntheticPointerAction_Name: {
      break;
    }
  }
  return false;
}

// static
bool InputInjectorStubDispatch::AcceptWithResponder(
    InputInjector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kInputInjector_QueueSyntheticSmoothDrag_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::InputInjector::QueueSyntheticSmoothDrag",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::InputInjector::QueueSyntheticSmoothDrag");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::InputInjector_QueueSyntheticSmoothDrag_Params_Data* params =
          reinterpret_cast<
              internal::InputInjector_QueueSyntheticSmoothDrag_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::content::SyntheticSmoothDragGestureParams p_drag{};
      InputInjector_QueueSyntheticSmoothDrag_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDrag(&p_drag))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputInjector::Name_, 0, false);
        return false;
      }
      InputInjector::QueueSyntheticSmoothDragCallback callback =
          InputInjector_QueueSyntheticSmoothDrag_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueSyntheticSmoothDrag(
std::move(p_drag), std::move(callback));
      return true;
    }
    case internal::kInputInjector_QueueSyntheticSmoothScroll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::InputInjector::QueueSyntheticSmoothScroll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::InputInjector::QueueSyntheticSmoothScroll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::InputInjector_QueueSyntheticSmoothScroll_Params_Data* params =
          reinterpret_cast<
              internal::InputInjector_QueueSyntheticSmoothScroll_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::content::SyntheticSmoothScrollGestureParams p_scroll{};
      InputInjector_QueueSyntheticSmoothScroll_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScroll(&p_scroll))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputInjector::Name_, 1, false);
        return false;
      }
      InputInjector::QueueSyntheticSmoothScrollCallback callback =
          InputInjector_QueueSyntheticSmoothScroll_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueSyntheticSmoothScroll(
std::move(p_scroll), std::move(callback));
      return true;
    }
    case internal::kInputInjector_QueueSyntheticPinch_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::InputInjector::QueueSyntheticPinch",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::InputInjector::QueueSyntheticPinch");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::InputInjector_QueueSyntheticPinch_Params_Data* params =
          reinterpret_cast<
              internal::InputInjector_QueueSyntheticPinch_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::content::SyntheticPinchGestureParams p_pinch{};
      InputInjector_QueueSyntheticPinch_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPinch(&p_pinch))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputInjector::Name_, 2, false);
        return false;
      }
      InputInjector::QueueSyntheticPinchCallback callback =
          InputInjector_QueueSyntheticPinch_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueSyntheticPinch(
std::move(p_pinch), std::move(callback));
      return true;
    }
    case internal::kInputInjector_QueueSyntheticTap_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::InputInjector::QueueSyntheticTap",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::InputInjector::QueueSyntheticTap");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::InputInjector_QueueSyntheticTap_Params_Data* params =
          reinterpret_cast<
              internal::InputInjector_QueueSyntheticTap_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::content::SyntheticTapGestureParams p_tap{};
      InputInjector_QueueSyntheticTap_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTap(&p_tap))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputInjector::Name_, 3, false);
        return false;
      }
      InputInjector::QueueSyntheticTapCallback callback =
          InputInjector_QueueSyntheticTap_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueSyntheticTap(
std::move(p_tap), std::move(callback));
      return true;
    }
    case internal::kInputInjector_QueueSyntheticPointerAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::InputInjector::QueueSyntheticPointerAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::InputInjector::QueueSyntheticPointerAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::InputInjector_QueueSyntheticPointerAction_Params_Data* params =
          reinterpret_cast<
              internal::InputInjector_QueueSyntheticPointerAction_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::content::SyntheticPointerActionListParams p_pointer_action{};
      InputInjector_QueueSyntheticPointerAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPointerAction(&p_pointer_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputInjector::Name_, 4, false);
        return false;
      }
      InputInjector::QueueSyntheticPointerActionCallback callback =
          InputInjector_QueueSyntheticPointerAction_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueSyntheticPointerAction(
std::move(p_pointer_action), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kInputInjectorValidationInfo[] = {
    {internal::kInputInjector_QueueSyntheticSmoothDrag_Name,
     {&internal::InputInjector_QueueSyntheticSmoothDrag_Params_Data::Validate,
      &internal::InputInjector_QueueSyntheticSmoothDrag_ResponseParams_Data::Validate}},
    {internal::kInputInjector_QueueSyntheticSmoothScroll_Name,
     {&internal::InputInjector_QueueSyntheticSmoothScroll_Params_Data::Validate,
      &internal::InputInjector_QueueSyntheticSmoothScroll_ResponseParams_Data::Validate}},
    {internal::kInputInjector_QueueSyntheticPinch_Name,
     {&internal::InputInjector_QueueSyntheticPinch_Params_Data::Validate,
      &internal::InputInjector_QueueSyntheticPinch_ResponseParams_Data::Validate}},
    {internal::kInputInjector_QueueSyntheticTap_Name,
     {&internal::InputInjector_QueueSyntheticTap_Params_Data::Validate,
      &internal::InputInjector_QueueSyntheticTap_ResponseParams_Data::Validate}},
    {internal::kInputInjector_QueueSyntheticPointerAction_Name,
     {&internal::InputInjector_QueueSyntheticPointerAction_Params_Data::Validate,
      &internal::InputInjector_QueueSyntheticPointerAction_ResponseParams_Data::Validate}},
};

bool InputInjectorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::InputInjector::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kInputInjectorValidationInfo);
}

bool InputInjectorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::InputInjector::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kInputInjectorValidationInfo);

}
}  // namespace mojom
}  // namespace content

namespace mojo {


// static
bool StructTraits<::content::mojom::SyntheticSmoothDrag::DataView, ::content::mojom::SyntheticSmoothDragPtr>::Read(
    ::content::mojom::SyntheticSmoothDrag::DataView input,
    ::content::mojom::SyntheticSmoothDragPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticSmoothDragPtr result(::content::mojom::SyntheticSmoothDrag::New());
  
      if (success && !input.ReadGestureSourceType(&result->gesture_source_type))
        success = false;
      if (success && !input.ReadStartPoint(&result->start_point))
        success = false;
      if (success && !input.ReadDistances(&result->distances))
        success = false;
      if (success)
        result->speed_in_pixels_s = input.speed_in_pixels_s();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::SyntheticSmoothScroll::DataView, ::content::mojom::SyntheticSmoothScrollPtr>::Read(
    ::content::mojom::SyntheticSmoothScroll::DataView input,
    ::content::mojom::SyntheticSmoothScrollPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticSmoothScrollPtr result(::content::mojom::SyntheticSmoothScroll::New());
  
      if (success && !input.ReadGestureSourceType(&result->gesture_source_type))
        success = false;
      if (success && !input.ReadAnchor(&result->anchor))
        success = false;
      if (success && !input.ReadDistances(&result->distances))
        success = false;
      if (success)
        result->prevent_fling = input.prevent_fling();
      if (success)
        result->speed_in_pixels_s = input.speed_in_pixels_s();
      if (success)
        result->fling_velocity_x = input.fling_velocity_x();
      if (success)
        result->fling_velocity_y = input.fling_velocity_y();
      if (success && !input.ReadGranularity(&result->granularity))
        success = false;
      if (success)
        result->modifiers = input.modifiers();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::SyntheticPinch::DataView, ::content::mojom::SyntheticPinchPtr>::Read(
    ::content::mojom::SyntheticPinch::DataView input,
    ::content::mojom::SyntheticPinchPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticPinchPtr result(::content::mojom::SyntheticPinch::New());
  
      if (success)
        result->scale_factor = input.scale_factor();
      if (success && !input.ReadAnchor(&result->anchor))
        success = false;
      if (success)
        result->relative_pointer_speed_in_pixels_s = input.relative_pointer_speed_in_pixels_s();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::SyntheticTap::DataView, ::content::mojom::SyntheticTapPtr>::Read(
    ::content::mojom::SyntheticTap::DataView input,
    ::content::mojom::SyntheticTapPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticTapPtr result(::content::mojom::SyntheticTap::New());
  
      if (success && !input.ReadGestureSourceType(&result->gesture_source_type))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success)
        result->duration_ms = input.duration_ms();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::SyntheticPointerActionParams::DataView, ::content::mojom::SyntheticPointerActionParamsPtr>::Read(
    ::content::mojom::SyntheticPointerActionParams::DataView input,
    ::content::mojom::SyntheticPointerActionParamsPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticPointerActionParamsPtr result(::content::mojom::SyntheticPointerActionParams::New());
  
      if (success && !input.ReadPointerActionType(&result->pointer_action_type))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success)
        result->pointer_id = input.pointer_id();
      if (success && !input.ReadButton(&result->button))
        success = false;
      if (success)
        result->key_modifiers = input.key_modifiers();
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
      if (success)
        result->rotation_angle = input.rotation_angle();
      if (success)
        result->force = input.force();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadDuration(&result->duration))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::SyntheticPointerAction::DataView, ::content::mojom::SyntheticPointerActionPtr>::Read(
    ::content::mojom::SyntheticPointerAction::DataView input,
    ::content::mojom::SyntheticPointerActionPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticPointerActionPtr result(::content::mojom::SyntheticPointerAction::New());
  
      if (success && !input.ReadGestureSourceType(&result->gesture_source_type))
        success = false;
      if (success && !input.ReadParams(&result->params))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif