// content/common/navigation_client.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/navigation_client.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/navigation_client.mojom-params-data.h"
namespace content {
namespace mojom {

namespace internal {


// static
bool DidCommitProvisionalLoadParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 200, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DidCommitProvisionalLoadParams_Data* object = static_cast<const DidCommitProvisionalLoadParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->base_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->base_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->virtual_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->virtual_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;


  if (!::content::mojom::internal::PageTransition_Data
        ::Validate(object->transition, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirects, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams redirects_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->redirects, validation_context,
                                         &redirects_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->contents_mime_type, 10, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams contents_mime_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->contents_mime_type, validation_context,
                                         &contents_mime_type_validate_params)) {
    return false;
  }


  if (!::content::mojom::internal::NavigationGesture_Data
        ::Validate(object->gesture, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 15, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_state, 19, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 22, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;


  if (!::network::mojom::internal::WebSandboxFlags_Data
        ::Validate(object->sandbox_flags, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->feature_policy_header, 24, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams feature_policy_header_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->feature_policy_header, validation_context,
                                         &feature_policy_header_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_policy_header, 25, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams document_policy_header_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::DocumentPolicyFeature_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->document_policy_header, validation_context,
                                         &document_policy_header_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::InsecureRequestPolicy_Data
        ::Validate(object->insecure_request_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->insecure_navigations_set, 27, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams insecure_navigations_set_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->insecure_navigations_set, validation_context,
                                         &insecure_navigations_set_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_token, 30, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->navigation_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->embedding_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->unload_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->unload_end, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->commit_navigation_end, validation_context))
    return false;

  return true;
}

DidCommitProvisionalLoadParams_Data::DidCommitProvisionalLoadParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DidCommitSameDocumentNavigationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DidCommitSameDocumentNavigationParams_Data* object = static_cast<const DidCommitSameDocumentNavigationParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DidCommitSameDocumentNavigationParams_Data::DidCommitSameDocumentNavigationParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationClient_CommitNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NavigationClient_CommitNavigation_Params_Data* object = static_cast<const NavigationClient_CommitNavigation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->common_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->common_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_head, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_head, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->response_body,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->url_loader_client_endpoints, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->subresource_loader_factories, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams subresource_overrides_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->subresource_overrides, validation_context,
                                         &subresource_overrides_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->controller_service_worker_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->container_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->prefetch_loader_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_navigation_token, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_navigation_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_container, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->policy_container, validation_context))
    return false;

  return true;
}

NavigationClient_CommitNavigation_Params_Data::NavigationClient_CommitNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationClient_CommitNavigation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NavigationClient_CommitNavigation_ResponseParams_Data* object = static_cast<const NavigationClient_CommitNavigation_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->interface_params, validation_context))
    return false;

  return true;
}

NavigationClient_CommitNavigation_ResponseParams_Data::NavigationClient_CommitNavigation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationClient_CommitFailedNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NavigationClient_CommitFailedNavigation_Params_Data* object = static_cast<const NavigationClient_CommitFailedNavigation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->common_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->common_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resolve_error_info, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resolve_error_info, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams error_page_content_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error_page_content, validation_context,
                                         &error_page_content_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->subresource_loader_factories, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_container, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->policy_container, validation_context))
    return false;

  return true;
}

NavigationClient_CommitFailedNavigation_Params_Data::NavigationClient_CommitFailedNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationClient_CommitFailedNavigation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NavigationClient_CommitFailedNavigation_ResponseParams_Data* object = static_cast<const NavigationClient_CommitFailedNavigation_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->interface_params, validation_context))
    return false;

  return true;
}

NavigationClient_CommitFailedNavigation_ResponseParams_Data::NavigationClient_CommitFailedNavigation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content
