// content/common/pepper_plugin.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/pepper_plugin.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/pepper_plugin.mojom-params-data.h"
#include "content/common/pepper_plugin.mojom-shared-message-ids.h"

#include "content/common/pepper_plugin.mojom-import-headers.h"


#ifndef CONTENT_COMMON_PEPPER_PLUGIN_MOJOM_JUMBO_H_
#define CONTENT_COMMON_PEPPER_PLUGIN_MOJOM_JUMBO_H_
#include "content/public/common/webplugininfo_param_traits.h"
#endif
namespace content {
namespace mojom {
const char PepperHost::Name_[] = "content.mojom.PepperHost";
bool PepperHost::GetPluginInfo(const ::GURL& url, const ::url::Origin& main_frame_origin, const std::string& mime_type, bool* out_found, ::content::WebPluginInfo* out_plugin_info, std::string* out_actual_mime_type) {
  NOTREACHED();
  return false;
}
class PepperHost_GetPluginInfo_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PepperHost_GetPluginInfo_HandleSyncResponse(
      bool* result, bool* out_found, ::content::WebPluginInfo* out_plugin_info, std::string* out_actual_mime_type)
      : result_(result), out_found_(out_found), out_plugin_info_(out_plugin_info), out_actual_mime_type_(out_actual_mime_type) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_found_;
  ::content::WebPluginInfo* out_plugin_info_;
  std::string* out_actual_mime_type_;DISALLOW_COPY_AND_ASSIGN(PepperHost_GetPluginInfo_HandleSyncResponse);
};

class PepperHost_GetPluginInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PepperHost_GetPluginInfo_ForwardToCallback(
      PepperHost::GetPluginInfoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PepperHost::GetPluginInfoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PepperHost_GetPluginInfo_ForwardToCallback);
};

PepperHostProxy::PepperHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PepperHostProxy::InstanceCreated(
    int32_t in_instance_id, ::mojo::PendingAssociatedRemote<PepperPluginInstance> in_instance, ::mojo::PendingAssociatedReceiver<PepperPluginInstanceHost> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::PepperHost::InstanceCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instance_id"), in_instance_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instance"), in_instance, 
                        "<value of type ::mojo::PendingAssociatedRemote<PepperPluginInstance>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host, 
                        "<value of type ::mojo::PendingAssociatedReceiver<PepperPluginInstanceHost>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperHost_InstanceCreated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_InstanceCreated_Params_Data> params(
          message);
  params.Allocate();
  params->instance_id = in_instance_id;
  mojo::internal::Serialize<::content::mojom::PepperPluginInstanceAssociatedPtrInfoDataView>(
      in_instance, &params->instance, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->instance),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid instance in PepperHost.InstanceCreated request");
  mojo::internal::Serialize<::content::mojom::PepperPluginInstanceHostAssociatedRequestDataView>(
      in_host, &params->host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid host in PepperHost.InstanceCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("InstanceCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PepperHostProxy::BindHungDetectorHost(
    ::mojo::PendingReceiver<PepperHungDetectorHost> in_host, int32_t in_plugin_child_id, const ::base::FilePath& in_plugin_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::PepperHost::BindHungDetectorHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host, 
                        "<value of type ::mojo::PendingReceiver<PepperHungDetectorHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_child_id"), in_plugin_child_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_path"), in_plugin_path, 
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperHost_BindHungDetectorHost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_BindHungDetectorHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::content::mojom::PepperHungDetectorHostInterfaceBase>>(
      in_host, &params->host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid host in PepperHost.BindHungDetectorHost request");
  params->plugin_child_id = in_plugin_child_id;
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_path)::BaseType> plugin_path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_plugin_path, plugin_path_fragment);
  params->plugin_path.Set(
      plugin_path_fragment.is_null() ? nullptr : plugin_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_path in PepperHost.BindHungDetectorHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("BindHungDetectorHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool PepperHostProxy::GetPluginInfo(
    const ::GURL& param_url, const ::url::Origin& param_main_frame_origin, const std::string& param_mime_type, bool* out_param_found, ::content::WebPluginInfo* out_param_plugin_info, std::string* out_param_actual_mime_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "content::mojom::PepperHost::GetPluginInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), param_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_frame_origin"), param_main_frame_origin, 
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), param_mime_type, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperHost_GetPluginInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_GetPluginInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PepperHost.GetPluginInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->main_frame_origin)::BaseType> main_frame_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      param_main_frame_origin, main_frame_origin_fragment);
  params->main_frame_origin.Set(
      main_frame_origin_fragment.is_null() ? nullptr : main_frame_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->main_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_frame_origin in PepperHost.GetPluginInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_mime_type, mime_type_fragment);
  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mime_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in PepperHost.GetPluginInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("GetPluginInfo");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PepperHost_GetPluginInfo_HandleSyncResponse(
          &result, out_param_found, out_param_plugin_info, out_param_actual_mime_type));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::PepperHost::GetPluginInfo", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("found"), out_param_found, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_info"), out_param_plugin_info, 
                        "<value of type const ::content::WebPluginInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("actual_mime_type"), out_param_actual_mime_type, 
                        "<value of type const std::string&>");
   });
#endif
  return result;
}

void PepperHostProxy::GetPluginInfo(
    const ::GURL& in_url, const ::url::Origin& in_main_frame_origin, const std::string& in_mime_type, GetPluginInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::PepperHost::GetPluginInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_frame_origin"), in_main_frame_origin, 
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), in_mime_type, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperHost_GetPluginInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_GetPluginInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PepperHost.GetPluginInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->main_frame_origin)::BaseType> main_frame_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_main_frame_origin, main_frame_origin_fragment);
  params->main_frame_origin.Set(
      main_frame_origin_fragment.is_null() ? nullptr : main_frame_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->main_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_frame_origin in PepperHost.GetPluginInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_mime_type, mime_type_fragment);
  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mime_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in PepperHost.GetPluginInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("GetPluginInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PepperHost_GetPluginInfo_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PepperHost_GetPluginInfo_ProxyToResponder {
 public:
  static PepperHost::GetPluginInfoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PepperHost_GetPluginInfo_ProxyToResponder> proxy(
        new PepperHost_GetPluginInfo_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PepperHost_GetPluginInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PepperHost_GetPluginInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PepperHost_GetPluginInfo_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PepperHost::GetPluginInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_found, const ::content::WebPluginInfo& in_plugin_info, const std::string& in_actual_mime_type);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PepperHost_GetPluginInfo_ProxyToResponder);
};

bool PepperHost_GetPluginInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::PepperHost::GetPluginInfoCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PepperHost_GetPluginInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PepperHost_GetPluginInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_found{};
  ::content::WebPluginInfo p_plugin_info{};
  std::string p_actual_mime_type{};
  PepperHost_GetPluginInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_found = input_data_view.found();
  if (success && !input_data_view.ReadPluginInfo(&p_plugin_info))
    success = false;
  if (success && !input_data_view.ReadActualMimeType(&p_actual_mime_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PepperHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_found), 
std::move(p_plugin_info), 
std::move(p_actual_mime_type));
  return true;
}

void PepperHost_GetPluginInfo_ProxyToResponder::Run(
    bool in_found, const ::content::WebPluginInfo& in_plugin_info, const std::string& in_actual_mime_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::PepperHost::GetPluginInfoCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("found"), in_found, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_info"), in_plugin_info, 
                        "<value of type const ::content::WebPluginInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("actual_mime_type"), in_actual_mime_type, 
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperHost_GetPluginInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_GetPluginInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->found = in_found;
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_info)::BaseType> plugin_info_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::WebPluginInfoDataView>(
      in_plugin_info, plugin_info_fragment);
  params->plugin_info.Set(
      plugin_info_fragment.is_null() ? nullptr : plugin_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->actual_mime_type)::BaseType> actual_mime_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_actual_mime_type, actual_mime_type_fragment);
  params->actual_mime_type.Set(
      actual_mime_type_fragment.is_null() ? nullptr : actual_mime_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->actual_mime_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null actual_mime_type in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::PepperHost::GetPluginInfoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("GetPluginInfo");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PepperHost_GetPluginInfo_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::PepperHost_GetPluginInfo_ResponseParams_Data* params =
      reinterpret_cast<internal::PepperHost_GetPluginInfo_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_found{};
  ::content::WebPluginInfo p_plugin_info{};
  std::string p_actual_mime_type{};
  PepperHost_GetPluginInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_found = input_data_view.found();
  if (success && !input_data_view.ReadPluginInfo(&p_plugin_info))
    success = false;
  if (success && !input_data_view.ReadActualMimeType(&p_actual_mime_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PepperHost::Name_, 2, true);
    return false;
  }
  *out_found_ = std::move(p_found);
  *out_plugin_info_ = std::move(p_plugin_info);
  *out_actual_mime_type_ = std::move(p_actual_mime_type);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool PepperHostStubDispatch::Accept(
    PepperHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPepperHost_InstanceCreated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperHost::InstanceCreated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperHost::InstanceCreated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PepperHost_InstanceCreated_Params_Data* params =
          reinterpret_cast<internal::PepperHost_InstanceCreated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_instance_id{};
      ::mojo::PendingAssociatedRemote<PepperPluginInstance> p_instance{};
      ::mojo::PendingAssociatedReceiver<PepperPluginInstanceHost> p_host{};
      PepperHost_InstanceCreated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_instance_id = input_data_view.instance_id();
      if (success) {
        p_instance =
            input_data_view.TakeInstance<decltype(p_instance)>();
      }
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstanceCreated(
std::move(p_instance_id), 
std::move(p_instance), 
std::move(p_host));
      return true;
    }
    case internal::kPepperHost_BindHungDetectorHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperHost::BindHungDetectorHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperHost::BindHungDetectorHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PepperHost_BindHungDetectorHost_Params_Data* params =
          reinterpret_cast<internal::PepperHost_BindHungDetectorHost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<PepperHungDetectorHost> p_host{};
      int32_t p_plugin_child_id{};
      ::base::FilePath p_plugin_path{};
      PepperHost_BindHungDetectorHost_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success)
        p_plugin_child_id = input_data_view.plugin_child_id();
      if (success && !input_data_view.ReadPluginPath(&p_plugin_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindHungDetectorHost(
std::move(p_host), 
std::move(p_plugin_child_id), 
std::move(p_plugin_path));
      return true;
    }
    case internal::kPepperHost_GetPluginInfo_Name: {
      break;
    }
  }
  return false;
}

// static
bool PepperHostStubDispatch::AcceptWithResponder(
    PepperHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPepperHost_InstanceCreated_Name: {
      break;
    }
    case internal::kPepperHost_BindHungDetectorHost_Name: {
      break;
    }
    case internal::kPepperHost_GetPluginInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperHost::GetPluginInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperHost::GetPluginInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PepperHost_GetPluginInfo_Params_Data* params =
          reinterpret_cast<
              internal::PepperHost_GetPluginInfo_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::url::Origin p_main_frame_origin{};
      std::string p_mime_type{};
      PepperHost_GetPluginInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadMainFrameOrigin(&p_main_frame_origin))
        success = false;
      if (success && !input_data_view.ReadMimeType(&p_mime_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHost::Name_, 2, false);
        return false;
      }
      PepperHost::GetPluginInfoCallback callback =
          PepperHost_GetPluginInfo_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPluginInfo(
std::move(p_url), 
std::move(p_main_frame_origin), 
std::move(p_mime_type), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPepperHostValidationInfo[] = {
    {internal::kPepperHost_InstanceCreated_Name,
     {&internal::PepperHost_InstanceCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPepperHost_BindHungDetectorHost_Name,
     {&internal::PepperHost_BindHungDetectorHost_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPepperHost_GetPluginInfo_Name,
     {&internal::PepperHost_GetPluginInfo_Params_Data::Validate,
      &internal::PepperHost_GetPluginInfo_ResponseParams_Data::Validate}},
};

bool PepperHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::PepperHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPepperHostValidationInfo);
}

bool PepperHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::PepperHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPepperHostValidationInfo);

}
const char PepperIOHost::Name_[] = "content.mojom.PepperIOHost";
bool PepperIOHost::DidCreateOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url, bool is_privileged_context) {
  NOTREACHED();
  return false;
}
bool PepperIOHost::OpenChannelToPepperPlugin(const ::url::Origin& embedder_origin, const ::base::FilePath& path, const base::Optional<::url::Origin>& origin_lock, ::mojo::ScopedMessagePipeHandle* out_handle_to_channel, ::base::ProcessId* out_plugin_pid, int32_t* out_plugin_child_id) {
  NOTREACHED();
  return false;
}
class PepperIOHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PepperIOHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(PepperIOHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse);
};

class PepperIOHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PepperIOHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback(
      PepperIOHost::DidCreateOutOfProcessPepperInstanceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PepperIOHost::DidCreateOutOfProcessPepperInstanceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PepperIOHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback);
};
class PepperIOHost_OpenChannelToPepperPlugin_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PepperIOHost_OpenChannelToPepperPlugin_HandleSyncResponse(
      bool* result, ::mojo::ScopedMessagePipeHandle* out_handle_to_channel, ::base::ProcessId* out_plugin_pid, int32_t* out_plugin_child_id)
      : result_(result), out_handle_to_channel_(out_handle_to_channel), out_plugin_pid_(out_plugin_pid), out_plugin_child_id_(out_plugin_child_id) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::mojo::ScopedMessagePipeHandle* out_handle_to_channel_;
  ::base::ProcessId* out_plugin_pid_;
  int32_t* out_plugin_child_id_;DISALLOW_COPY_AND_ASSIGN(PepperIOHost_OpenChannelToPepperPlugin_HandleSyncResponse);
};

class PepperIOHost_OpenChannelToPepperPlugin_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PepperIOHost_OpenChannelToPepperPlugin_ForwardToCallback(
      PepperIOHost::OpenChannelToPepperPluginCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PepperIOHost::OpenChannelToPepperPluginCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PepperIOHost_OpenChannelToPepperPlugin_ForwardToCallback);
};

PepperIOHostProxy::PepperIOHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PepperIOHostProxy::DidCreateInProcessInstance(
    int32_t in_instance_id, int32_t in_frame_routing_id, const ::GURL& in_document_url, const ::GURL& in_plugin_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::PepperIOHost::DidCreateInProcessInstance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instance_id"), in_instance_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_routing_id"), in_frame_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_url"), in_document_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_url"), in_plugin_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperIOHost_DidCreateInProcessInstance_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperIOHost_DidCreateInProcessInstance_Params_Data> params(
          message);
  params.Allocate();
  params->instance_id = in_instance_id;
  params->frame_routing_id = in_frame_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->document_url)::BaseType> document_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_document_url, document_url_fragment);
  params->document_url.Set(
      document_url_fragment.is_null() ? nullptr : document_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->document_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_url in PepperIOHost.DidCreateInProcessInstance request");
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_url)::BaseType> plugin_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_plugin_url, plugin_url_fragment);
  params->plugin_url.Set(
      plugin_url_fragment.is_null() ? nullptr : plugin_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_url in PepperIOHost.DidCreateInProcessInstance request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperIOHost::Name_);
  message.set_method_name("DidCreateInProcessInstance");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PepperIOHostProxy::DidDeleteInProcessInstance(
    int32_t in_instance_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::PepperIOHost::DidDeleteInProcessInstance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instance_id"), in_instance_id, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperIOHost_DidDeleteInProcessInstance_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperIOHost_DidDeleteInProcessInstance_Params_Data> params(
          message);
  params.Allocate();
  params->instance_id = in_instance_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperIOHost::Name_);
  message.set_method_name("DidDeleteInProcessInstance");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool PepperIOHostProxy::DidCreateOutOfProcessPepperInstance(
    int32_t param_plugin_child_id, int32_t param_pp_instance, bool param_is_external, int32_t param_frame_routing_id, const ::GURL& param_document_url, const ::GURL& param_plugin_url, bool param_is_privileged_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "content::mojom::PepperIOHost::DidCreateOutOfProcessPepperInstance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_child_id"), param_plugin_child_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pp_instance"), param_pp_instance, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_external"), param_is_external, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_routing_id"), param_frame_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_url"), param_document_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_url"), param_plugin_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_privileged_context"), param_is_privileged_context, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperIOHost_DidCreateOutOfProcessPepperInstance_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperIOHost_DidCreateOutOfProcessPepperInstance_Params_Data> params(
          message);
  params.Allocate();
  params->plugin_child_id = param_plugin_child_id;
  params->pp_instance = param_pp_instance;
  params->is_external = param_is_external;
  params->frame_routing_id = param_frame_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->document_url)::BaseType> document_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_document_url, document_url_fragment);
  params->document_url.Set(
      document_url_fragment.is_null() ? nullptr : document_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->document_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_url in PepperIOHost.DidCreateOutOfProcessPepperInstance request");
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_url)::BaseType> plugin_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_plugin_url, plugin_url_fragment);
  params->plugin_url.Set(
      plugin_url_fragment.is_null() ? nullptr : plugin_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_url in PepperIOHost.DidCreateOutOfProcessPepperInstance request");
  params->is_privileged_context = param_is_privileged_context;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperIOHost::Name_);
  message.set_method_name("DidCreateOutOfProcessPepperInstance");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PepperIOHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "content::mojom::PepperIOHost::DidCreateOutOfProcessPepperInstance");
#endif
  return result;
}

void PepperIOHostProxy::DidCreateOutOfProcessPepperInstance(
    int32_t in_plugin_child_id, int32_t in_pp_instance, bool in_is_external, int32_t in_frame_routing_id, const ::GURL& in_document_url, const ::GURL& in_plugin_url, bool in_is_privileged_context, DidCreateOutOfProcessPepperInstanceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::PepperIOHost::DidCreateOutOfProcessPepperInstance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_child_id"), in_plugin_child_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pp_instance"), in_pp_instance, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_external"), in_is_external, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_routing_id"), in_frame_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_url"), in_document_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_url"), in_plugin_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_privileged_context"), in_is_privileged_context, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperIOHost_DidCreateOutOfProcessPepperInstance_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperIOHost_DidCreateOutOfProcessPepperInstance_Params_Data> params(
          message);
  params.Allocate();
  params->plugin_child_id = in_plugin_child_id;
  params->pp_instance = in_pp_instance;
  params->is_external = in_is_external;
  params->frame_routing_id = in_frame_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->document_url)::BaseType> document_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_document_url, document_url_fragment);
  params->document_url.Set(
      document_url_fragment.is_null() ? nullptr : document_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->document_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_url in PepperIOHost.DidCreateOutOfProcessPepperInstance request");
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_url)::BaseType> plugin_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_plugin_url, plugin_url_fragment);
  params->plugin_url.Set(
      plugin_url_fragment.is_null() ? nullptr : plugin_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_url in PepperIOHost.DidCreateOutOfProcessPepperInstance request");
  params->is_privileged_context = in_is_privileged_context;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperIOHost::Name_);
  message.set_method_name("DidCreateOutOfProcessPepperInstance");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PepperIOHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PepperIOHostProxy::DidDeleteOutOfProcessPepperInstance(
    int32_t in_plugin_child_id, int32_t in_pp_instance, bool in_is_external) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::PepperIOHost::DidDeleteOutOfProcessPepperInstance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_child_id"), in_plugin_child_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pp_instance"), in_pp_instance, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_external"), in_is_external, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperIOHost_DidDeleteOutOfProcessPepperInstance_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperIOHost_DidDeleteOutOfProcessPepperInstance_Params_Data> params(
          message);
  params.Allocate();
  params->plugin_child_id = in_plugin_child_id;
  params->pp_instance = in_pp_instance;
  params->is_external = in_is_external;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperIOHost::Name_);
  message.set_method_name("DidDeleteOutOfProcessPepperInstance");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool PepperIOHostProxy::OpenChannelToPepperPlugin(
    const ::url::Origin& param_embedder_origin, const ::base::FilePath& param_path, const base::Optional<::url::Origin>& param_origin_lock, ::mojo::ScopedMessagePipeHandle* out_param_handle_to_channel, ::base::ProcessId* out_param_plugin_pid, int32_t* out_param_plugin_child_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "content::mojom::PepperIOHost::OpenChannelToPepperPlugin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedder_origin"), param_embedder_origin, 
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path, 
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_lock"), param_origin_lock, 
                        "<value of type const base::Optional<::url::Origin>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperIOHost_OpenChannelToPepperPlugin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperIOHost_OpenChannelToPepperPlugin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->embedder_origin)::BaseType> embedder_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      param_embedder_origin, embedder_origin_fragment);
  params->embedder_origin.Set(
      embedder_origin_fragment.is_null() ? nullptr : embedder_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->embedder_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null embedder_origin in PepperIOHost.OpenChannelToPepperPlugin request");
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in PepperIOHost.OpenChannelToPepperPlugin request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin_lock)::BaseType> origin_lock_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      param_origin_lock, origin_lock_fragment);
  params->origin_lock.Set(
      origin_lock_fragment.is_null() ? nullptr : origin_lock_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperIOHost::Name_);
  message.set_method_name("OpenChannelToPepperPlugin");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PepperIOHost_OpenChannelToPepperPlugin_HandleSyncResponse(
          &result, out_param_handle_to_channel, out_param_plugin_pid, out_param_plugin_child_id));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::PepperIOHost::OpenChannelToPepperPlugin", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handle_to_channel"), out_param_handle_to_channel, 
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_pid"), out_param_plugin_pid, 
                        "<value of type ::base::ProcessId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_child_id"), out_param_plugin_child_id, 
                        "<value of type int32_t>");
   });
#endif
  return result;
}

void PepperIOHostProxy::OpenChannelToPepperPlugin(
    const ::url::Origin& in_embedder_origin, const ::base::FilePath& in_path, const base::Optional<::url::Origin>& in_origin_lock, OpenChannelToPepperPluginCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::PepperIOHost::OpenChannelToPepperPlugin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedder_origin"), in_embedder_origin, 
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path, 
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_lock"), in_origin_lock, 
                        "<value of type const base::Optional<::url::Origin>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperIOHost_OpenChannelToPepperPlugin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperIOHost_OpenChannelToPepperPlugin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->embedder_origin)::BaseType> embedder_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_embedder_origin, embedder_origin_fragment);
  params->embedder_origin.Set(
      embedder_origin_fragment.is_null() ? nullptr : embedder_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->embedder_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null embedder_origin in PepperIOHost.OpenChannelToPepperPlugin request");
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in PepperIOHost.OpenChannelToPepperPlugin request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin_lock)::BaseType> origin_lock_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin_lock, origin_lock_fragment);
  params->origin_lock.Set(
      origin_lock_fragment.is_null() ? nullptr : origin_lock_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperIOHost::Name_);
  message.set_method_name("OpenChannelToPepperPlugin");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PepperIOHost_OpenChannelToPepperPlugin_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PepperIOHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder {
 public:
  static PepperIOHost::DidCreateOutOfProcessPepperInstanceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PepperIOHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder> proxy(
        new PepperIOHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PepperIOHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PepperIOHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PepperIOHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PepperIOHost::DidCreateOutOfProcessPepperInstanceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PepperIOHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder);
};

bool PepperIOHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::PepperIOHost::DidCreateOutOfProcessPepperInstanceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PepperIOHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PepperIOHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PepperIOHost_DidCreateOutOfProcessPepperInstance_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PepperIOHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PepperIOHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)content::mojom::PepperIOHost::DidCreateOutOfProcessPepperInstanceCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperIOHost_DidCreateOutOfProcessPepperInstance_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperIOHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::PepperIOHost::DidCreateOutOfProcessPepperInstanceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperIOHost::Name_);
  message.set_method_name("DidCreateOutOfProcessPepperInstance");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PepperIOHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::PepperIOHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data* params =
      reinterpret_cast<internal::PepperIOHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  PepperIOHost_DidCreateOutOfProcessPepperInstance_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PepperIOHost::Name_, 2, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class PepperIOHost_OpenChannelToPepperPlugin_ProxyToResponder {
 public:
  static PepperIOHost::OpenChannelToPepperPluginCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PepperIOHost_OpenChannelToPepperPlugin_ProxyToResponder> proxy(
        new PepperIOHost_OpenChannelToPepperPlugin_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PepperIOHost_OpenChannelToPepperPlugin_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PepperIOHost_OpenChannelToPepperPlugin_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PepperIOHost_OpenChannelToPepperPlugin_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PepperIOHost::OpenChannelToPepperPluginCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::ScopedMessagePipeHandle in_handle_to_channel, ::base::ProcessId in_plugin_pid, int32_t in_plugin_child_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PepperIOHost_OpenChannelToPepperPlugin_ProxyToResponder);
};

bool PepperIOHost_OpenChannelToPepperPlugin_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::PepperIOHost::OpenChannelToPepperPluginCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PepperIOHost_OpenChannelToPepperPlugin_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PepperIOHost_OpenChannelToPepperPlugin_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::mojo::ScopedMessagePipeHandle p_handle_to_channel{};
  ::base::ProcessId p_plugin_pid{};
  int32_t p_plugin_child_id{};
  PepperIOHost_OpenChannelToPepperPlugin_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_handle_to_channel = input_data_view.TakeHandleToChannel();
  if (success && !input_data_view.ReadPluginPid(&p_plugin_pid))
    success = false;
  if (success)
    p_plugin_child_id = input_data_view.plugin_child_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PepperIOHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_handle_to_channel), 
std::move(p_plugin_pid), 
std::move(p_plugin_child_id));
  return true;
}

void PepperIOHost_OpenChannelToPepperPlugin_ProxyToResponder::Run(
    ::mojo::ScopedMessagePipeHandle in_handle_to_channel, ::base::ProcessId in_plugin_pid, int32_t in_plugin_child_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::PepperIOHost::OpenChannelToPepperPluginCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handle_to_channel"), in_handle_to_channel, 
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_pid"), in_plugin_pid, 
                        "<value of type ::base::ProcessId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_child_id"), in_plugin_child_id, 
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperIOHost_OpenChannelToPepperPlugin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperIOHost_OpenChannelToPepperPlugin_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
      in_handle_to_channel, &params->handle_to_channel, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_pid)::BaseType> plugin_pid_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
      in_plugin_pid, plugin_pid_fragment);
  params->plugin_pid.Set(
      plugin_pid_fragment.is_null() ? nullptr : plugin_pid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_pid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_pid in ");
  params->plugin_child_id = in_plugin_child_id;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::PepperIOHost::OpenChannelToPepperPluginCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperIOHost::Name_);
  message.set_method_name("OpenChannelToPepperPlugin");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PepperIOHost_OpenChannelToPepperPlugin_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::PepperIOHost_OpenChannelToPepperPlugin_ResponseParams_Data* params =
      reinterpret_cast<internal::PepperIOHost_OpenChannelToPepperPlugin_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::mojo::ScopedMessagePipeHandle p_handle_to_channel{};
  ::base::ProcessId p_plugin_pid{};
  int32_t p_plugin_child_id{};
  PepperIOHost_OpenChannelToPepperPlugin_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_handle_to_channel = input_data_view.TakeHandleToChannel();
  if (success && !input_data_view.ReadPluginPid(&p_plugin_pid))
    success = false;
  if (success)
    p_plugin_child_id = input_data_view.plugin_child_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PepperIOHost::Name_, 4, true);
    return false;
  }
  *out_handle_to_channel_ = std::move(p_handle_to_channel);
  *out_plugin_pid_ = std::move(p_plugin_pid);
  *out_plugin_child_id_ = std::move(p_plugin_child_id);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool PepperIOHostStubDispatch::Accept(
    PepperIOHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPepperIOHost_DidCreateInProcessInstance_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperIOHost::DidCreateInProcessInstance",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperIOHost::DidCreateInProcessInstance");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PepperIOHost_DidCreateInProcessInstance_Params_Data* params =
          reinterpret_cast<internal::PepperIOHost_DidCreateInProcessInstance_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_instance_id{};
      int32_t p_frame_routing_id{};
      ::GURL p_document_url{};
      ::GURL p_plugin_url{};
      PepperIOHost_DidCreateInProcessInstance_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_instance_id = input_data_view.instance_id();
      if (success)
        p_frame_routing_id = input_data_view.frame_routing_id();
      if (success && !input_data_view.ReadDocumentUrl(&p_document_url))
        success = false;
      if (success && !input_data_view.ReadPluginUrl(&p_plugin_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperIOHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCreateInProcessInstance(
std::move(p_instance_id), 
std::move(p_frame_routing_id), 
std::move(p_document_url), 
std::move(p_plugin_url));
      return true;
    }
    case internal::kPepperIOHost_DidDeleteInProcessInstance_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperIOHost::DidDeleteInProcessInstance",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperIOHost::DidDeleteInProcessInstance");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PepperIOHost_DidDeleteInProcessInstance_Params_Data* params =
          reinterpret_cast<internal::PepperIOHost_DidDeleteInProcessInstance_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_instance_id{};
      PepperIOHost_DidDeleteInProcessInstance_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_instance_id = input_data_view.instance_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperIOHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDeleteInProcessInstance(
std::move(p_instance_id));
      return true;
    }
    case internal::kPepperIOHost_DidCreateOutOfProcessPepperInstance_Name: {
      break;
    }
    case internal::kPepperIOHost_DidDeleteOutOfProcessPepperInstance_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperIOHost::DidDeleteOutOfProcessPepperInstance",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperIOHost::DidDeleteOutOfProcessPepperInstance");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PepperIOHost_DidDeleteOutOfProcessPepperInstance_Params_Data* params =
          reinterpret_cast<internal::PepperIOHost_DidDeleteOutOfProcessPepperInstance_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_plugin_child_id{};
      int32_t p_pp_instance{};
      bool p_is_external{};
      PepperIOHost_DidDeleteOutOfProcessPepperInstance_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_plugin_child_id = input_data_view.plugin_child_id();
      if (success)
        p_pp_instance = input_data_view.pp_instance();
      if (success)
        p_is_external = input_data_view.is_external();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperIOHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDeleteOutOfProcessPepperInstance(
std::move(p_plugin_child_id), 
std::move(p_pp_instance), 
std::move(p_is_external));
      return true;
    }
    case internal::kPepperIOHost_OpenChannelToPepperPlugin_Name: {
      break;
    }
  }
  return false;
}

// static
bool PepperIOHostStubDispatch::AcceptWithResponder(
    PepperIOHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPepperIOHost_DidCreateInProcessInstance_Name: {
      break;
    }
    case internal::kPepperIOHost_DidDeleteInProcessInstance_Name: {
      break;
    }
    case internal::kPepperIOHost_DidCreateOutOfProcessPepperInstance_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperIOHost::DidCreateOutOfProcessPepperInstance",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperIOHost::DidCreateOutOfProcessPepperInstance");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PepperIOHost_DidCreateOutOfProcessPepperInstance_Params_Data* params =
          reinterpret_cast<
              internal::PepperIOHost_DidCreateOutOfProcessPepperInstance_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_plugin_child_id{};
      int32_t p_pp_instance{};
      bool p_is_external{};
      int32_t p_frame_routing_id{};
      ::GURL p_document_url{};
      ::GURL p_plugin_url{};
      bool p_is_privileged_context{};
      PepperIOHost_DidCreateOutOfProcessPepperInstance_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_plugin_child_id = input_data_view.plugin_child_id();
      if (success)
        p_pp_instance = input_data_view.pp_instance();
      if (success)
        p_is_external = input_data_view.is_external();
      if (success)
        p_frame_routing_id = input_data_view.frame_routing_id();
      if (success && !input_data_view.ReadDocumentUrl(&p_document_url))
        success = false;
      if (success && !input_data_view.ReadPluginUrl(&p_plugin_url))
        success = false;
      if (success)
        p_is_privileged_context = input_data_view.is_privileged_context();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperIOHost::Name_, 2, false);
        return false;
      }
      PepperIOHost::DidCreateOutOfProcessPepperInstanceCallback callback =
          PepperIOHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCreateOutOfProcessPepperInstance(
std::move(p_plugin_child_id), 
std::move(p_pp_instance), 
std::move(p_is_external), 
std::move(p_frame_routing_id), 
std::move(p_document_url), 
std::move(p_plugin_url), 
std::move(p_is_privileged_context), std::move(callback));
      return true;
    }
    case internal::kPepperIOHost_DidDeleteOutOfProcessPepperInstance_Name: {
      break;
    }
    case internal::kPepperIOHost_OpenChannelToPepperPlugin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperIOHost::OpenChannelToPepperPlugin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperIOHost::OpenChannelToPepperPlugin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PepperIOHost_OpenChannelToPepperPlugin_Params_Data* params =
          reinterpret_cast<
              internal::PepperIOHost_OpenChannelToPepperPlugin_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_embedder_origin{};
      ::base::FilePath p_path{};
      base::Optional<::url::Origin> p_origin_lock{};
      PepperIOHost_OpenChannelToPepperPlugin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEmbedderOrigin(&p_embedder_origin))
        success = false;
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadOriginLock(&p_origin_lock))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperIOHost::Name_, 4, false);
        return false;
      }
      PepperIOHost::OpenChannelToPepperPluginCallback callback =
          PepperIOHost_OpenChannelToPepperPlugin_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChannelToPepperPlugin(
std::move(p_embedder_origin), 
std::move(p_path), 
std::move(p_origin_lock), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPepperIOHostValidationInfo[] = {
    {internal::kPepperIOHost_DidCreateInProcessInstance_Name,
     {&internal::PepperIOHost_DidCreateInProcessInstance_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPepperIOHost_DidDeleteInProcessInstance_Name,
     {&internal::PepperIOHost_DidDeleteInProcessInstance_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPepperIOHost_DidCreateOutOfProcessPepperInstance_Name,
     {&internal::PepperIOHost_DidCreateOutOfProcessPepperInstance_Params_Data::Validate,
      &internal::PepperIOHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data::Validate}},
    {internal::kPepperIOHost_DidDeleteOutOfProcessPepperInstance_Name,
     {&internal::PepperIOHost_DidDeleteOutOfProcessPepperInstance_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPepperIOHost_OpenChannelToPepperPlugin_Name,
     {&internal::PepperIOHost_OpenChannelToPepperPlugin_Params_Data::Validate,
      &internal::PepperIOHost_OpenChannelToPepperPlugin_ResponseParams_Data::Validate}},
};

bool PepperIOHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::PepperIOHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPepperIOHostValidationInfo);
}

bool PepperIOHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::PepperIOHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPepperIOHostValidationInfo);

}
const char PepperHungDetectorHost::Name_[] = "content.mojom.PepperHungDetectorHost";

PepperHungDetectorHostProxy::PepperHungDetectorHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PepperHungDetectorHostProxy::PluginHung(
    bool in_is_hung) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::PepperHungDetectorHost::PluginHung", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_hung"), in_is_hung, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperHungDetectorHost_PluginHung_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHungDetectorHost_PluginHung_Params_Data> params(
          message);
  params.Allocate();
  params->is_hung = in_is_hung;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHungDetectorHost::Name_);
  message.set_method_name("PluginHung");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PepperHungDetectorHostStubDispatch::Accept(
    PepperHungDetectorHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPepperHungDetectorHost_PluginHung_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperHungDetectorHost::PluginHung",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperHungDetectorHost::PluginHung");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PepperHungDetectorHost_PluginHung_Params_Data* params =
          reinterpret_cast<internal::PepperHungDetectorHost_PluginHung_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_hung{};
      PepperHungDetectorHost_PluginHung_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_hung = input_data_view.is_hung();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHungDetectorHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PluginHung(
std::move(p_is_hung));
      return true;
    }
  }
  return false;
}

// static
bool PepperHungDetectorHostStubDispatch::AcceptWithResponder(
    PepperHungDetectorHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPepperHungDetectorHost_PluginHung_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPepperHungDetectorHostValidationInfo[] = {
    {internal::kPepperHungDetectorHost_PluginHung_Name,
     {&internal::PepperHungDetectorHost_PluginHung_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PepperHungDetectorHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::PepperHungDetectorHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPepperHungDetectorHostValidationInfo);
}

const char PepperPluginInstanceHost::Name_[] = "content.mojom.PepperPluginInstanceHost";

PepperPluginInstanceHostProxy::PepperPluginInstanceHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PepperPluginInstanceHostProxy::StartsPlayback(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::PepperPluginInstanceHost::StartsPlayback");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperPluginInstanceHost_StartsPlayback_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperPluginInstanceHost_StartsPlayback_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperPluginInstanceHost::Name_);
  message.set_method_name("StartsPlayback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PepperPluginInstanceHostProxy::StopsPlayback(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::PepperPluginInstanceHost::StopsPlayback");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperPluginInstanceHost_StopsPlayback_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperPluginInstanceHost_StopsPlayback_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperPluginInstanceHost::Name_);
  message.set_method_name("StopsPlayback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PepperPluginInstanceHostProxy::InstanceCrashed(
    const ::base::FilePath& in_plugin_path, ::base::ProcessId in_plugin_pid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::PepperPluginInstanceHost::InstanceCrashed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_path"), in_plugin_path, 
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_pid"), in_plugin_pid, 
                        "<value of type ::base::ProcessId>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperPluginInstanceHost_InstanceCrashed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperPluginInstanceHost_InstanceCrashed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_path)::BaseType> plugin_path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_plugin_path, plugin_path_fragment);
  params->plugin_path.Set(
      plugin_path_fragment.is_null() ? nullptr : plugin_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_path in PepperPluginInstanceHost.InstanceCrashed request");
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_pid)::BaseType> plugin_pid_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
      in_plugin_pid, plugin_pid_fragment);
  params->plugin_pid.Set(
      plugin_pid_fragment.is_null() ? nullptr : plugin_pid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_pid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_pid in PepperPluginInstanceHost.InstanceCrashed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperPluginInstanceHost::Name_);
  message.set_method_name("InstanceCrashed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PepperPluginInstanceHostStubDispatch::Accept(
    PepperPluginInstanceHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPepperPluginInstanceHost_StartsPlayback_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperPluginInstanceHost::StartsPlayback",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperPluginInstanceHost::StartsPlayback");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PepperPluginInstanceHost_StartsPlayback_Params_Data* params =
          reinterpret_cast<internal::PepperPluginInstanceHost_StartsPlayback_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PepperPluginInstanceHost_StartsPlayback_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperPluginInstanceHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartsPlayback();
      return true;
    }
    case internal::kPepperPluginInstanceHost_StopsPlayback_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperPluginInstanceHost::StopsPlayback",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperPluginInstanceHost::StopsPlayback");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PepperPluginInstanceHost_StopsPlayback_Params_Data* params =
          reinterpret_cast<internal::PepperPluginInstanceHost_StopsPlayback_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PepperPluginInstanceHost_StopsPlayback_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperPluginInstanceHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopsPlayback();
      return true;
    }
    case internal::kPepperPluginInstanceHost_InstanceCrashed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperPluginInstanceHost::InstanceCrashed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperPluginInstanceHost::InstanceCrashed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PepperPluginInstanceHost_InstanceCrashed_Params_Data* params =
          reinterpret_cast<internal::PepperPluginInstanceHost_InstanceCrashed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_plugin_path{};
      ::base::ProcessId p_plugin_pid{};
      PepperPluginInstanceHost_InstanceCrashed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPluginPath(&p_plugin_path))
        success = false;
      if (success && !input_data_view.ReadPluginPid(&p_plugin_pid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperPluginInstanceHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstanceCrashed(
std::move(p_plugin_path), 
std::move(p_plugin_pid));
      return true;
    }
  }
  return false;
}

// static
bool PepperPluginInstanceHostStubDispatch::AcceptWithResponder(
    PepperPluginInstanceHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPepperPluginInstanceHost_StartsPlayback_Name: {
      break;
    }
    case internal::kPepperPluginInstanceHost_StopsPlayback_Name: {
      break;
    }
    case internal::kPepperPluginInstanceHost_InstanceCrashed_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPepperPluginInstanceHostValidationInfo[] = {
    {internal::kPepperPluginInstanceHost_StartsPlayback_Name,
     {&internal::PepperPluginInstanceHost_StartsPlayback_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPepperPluginInstanceHost_StopsPlayback_Name,
     {&internal::PepperPluginInstanceHost_StopsPlayback_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPepperPluginInstanceHost_InstanceCrashed_Name,
     {&internal::PepperPluginInstanceHost_InstanceCrashed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PepperPluginInstanceHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::PepperPluginInstanceHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPepperPluginInstanceHostValidationInfo);
}

const char PepperPluginInstance::Name_[] = "content.mojom.PepperPluginInstance";

PepperPluginInstanceProxy::PepperPluginInstanceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PepperPluginInstanceProxy::SetVolume(
    double in_volume) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::PepperPluginInstance::SetVolume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("volume"), in_volume, 
                        "<value of type double>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPepperPluginInstance_SetVolume_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperPluginInstance_SetVolume_Params_Data> params(
          message);
  params.Allocate();
  params->volume = in_volume;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperPluginInstance::Name_);
  message.set_method_name("SetVolume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PepperPluginInstanceStubDispatch::Accept(
    PepperPluginInstance* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPepperPluginInstance_SetVolume_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::PepperPluginInstance::SetVolume",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::PepperPluginInstance::SetVolume");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PepperPluginInstance_SetVolume_Params_Data* params =
          reinterpret_cast<internal::PepperPluginInstance_SetVolume_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      double p_volume{};
      PepperPluginInstance_SetVolume_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_volume = input_data_view.volume();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperPluginInstance::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVolume(
std::move(p_volume));
      return true;
    }
  }
  return false;
}

// static
bool PepperPluginInstanceStubDispatch::AcceptWithResponder(
    PepperPluginInstance* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPepperPluginInstance_SetVolume_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPepperPluginInstanceValidationInfo[] = {
    {internal::kPepperPluginInstance_SetVolume_Name,
     {&internal::PepperPluginInstance_SetVolume_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PepperPluginInstanceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::PepperPluginInstance::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPepperPluginInstanceValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif