// content/common/prefetched_signed_exchange_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/prefetched_signed_exchange_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/prefetched_signed_exchange_info.mojom-params-data.h"
#include "content/common/prefetched_signed_exchange_info.mojom-shared-message-ids.h"

#include "content/common/prefetched_signed_exchange_info.mojom-import-headers.h"


#ifndef CONTENT_COMMON_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_JUMBO_H_
#define CONTENT_COMMON_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_JUMBO_H_
#include "content/common/frame_messages.h"
#endif
namespace content {
namespace mojom {
PrefetchedSignedExchangeInfo::PrefetchedSignedExchangeInfo()
    : outer_url(),
      header_integrity(),
      inner_url(),
      inner_response(),
      loader_factory_handle() {}

PrefetchedSignedExchangeInfo::PrefetchedSignedExchangeInfo(
    const ::GURL& outer_url_in,
    const ::net::SHA256HashValue& header_integrity_in,
    const ::GURL& inner_url_in,
    ::network::mojom::URLResponseHeadPtr inner_response_in,
    ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> loader_factory_handle_in)
    : outer_url(std::move(outer_url_in)),
      header_integrity(std::move(header_integrity_in)),
      inner_url(std::move(inner_url_in)),
      inner_response(std::move(inner_response_in)),
      loader_factory_handle(std::move(loader_factory_handle_in)) {}

PrefetchedSignedExchangeInfo::~PrefetchedSignedExchangeInfo() = default;

void PrefetchedSignedExchangeInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "outer_url"), this->outer_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header_integrity"), this->header_integrity, 
      "<value of type const ::net::SHA256HashValue&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inner_url"), this->inner_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inner_response"), this->inner_response, 
      "<value of type ::network::mojom::URLResponseHeadPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "loader_factory_handle"), this->loader_factory_handle, 
      "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderFactory>>");
}

bool PrefetchedSignedExchangeInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace content

namespace mojo {


// static
bool StructTraits<::content::mojom::PrefetchedSignedExchangeInfo::DataView, ::content::mojom::PrefetchedSignedExchangeInfoPtr>::Read(
    ::content::mojom::PrefetchedSignedExchangeInfo::DataView input,
    ::content::mojom::PrefetchedSignedExchangeInfoPtr* output) {
  bool success = true;
  ::content::mojom::PrefetchedSignedExchangeInfoPtr result(::content::mojom::PrefetchedSignedExchangeInfo::New());
  
      if (success && !input.ReadOuterUrl(&result->outer_url))
        success = false;
      if (success && !input.ReadHeaderIntegrity(&result->header_integrity))
        success = false;
      if (success && !input.ReadInnerUrl(&result->inner_url))
        success = false;
      if (success && !input.ReadInnerResponse(&result->inner_response))
        success = false;
      if (success) {
        result->loader_factory_handle =
            input.TakeLoaderFactoryHandle<decltype(result->loader_factory_handle)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif