// content/common/render_accessibility.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "content/common/render_accessibility.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "ui/accessibility/ax_enums.mojom.h"
#include "ui/accessibility/mojom/ax_action_data.mojom.h"
#include "ui/accessibility/mojom/ax_event.mojom.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"


#ifndef CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_JUMBO_H_
#define CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_JUMBO_H_
#endif


namespace content {
namespace mojom {


void RenderAccessibilityHostInterceptorForTesting::HandleAXEvents(const std::vector<::ui::AXTreeUpdate>& updates, const std::vector<::ui::AXEvent>& events, int32_t reset_token, HandleAXEventsCallback callback) {
  GetForwardingInterface()->HandleAXEvents(std::move(updates), std::move(events), std::move(reset_token), std::move(callback));
}
void RenderAccessibilityHostInterceptorForTesting::HandleAXLocationChanges(std::vector<LocationChangesPtr> changes) {
  GetForwardingInterface()->HandleAXLocationChanges(std::move(changes));
}
RenderAccessibilityHostAsyncWaiter::RenderAccessibilityHostAsyncWaiter(
    RenderAccessibilityHost* proxy) : proxy_(proxy) {}

RenderAccessibilityHostAsyncWaiter::~RenderAccessibilityHostAsyncWaiter() = default;

void RenderAccessibilityHostAsyncWaiter::HandleAXEvents(
    const std::vector<::ui::AXTreeUpdate>& updates, const std::vector<::ui::AXEvent>& events, int32_t reset_token) {
  base::RunLoop loop;
  proxy_->HandleAXEvents(std::move(updates),std::move(events),std::move(reset_token),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void RenderAccessibilityInterceptorForTesting::SetMode(uint32_t ax_mode) {
  GetForwardingInterface()->SetMode(std::move(ax_mode));
}
void RenderAccessibilityInterceptorForTesting::FatalError() {
  GetForwardingInterface()->FatalError();
}
void RenderAccessibilityInterceptorForTesting::HitTest(const ::gfx::Point& point, ::ax::mojom::Event event_to_fire, int32_t request_id, HitTestCallback callback) {
  GetForwardingInterface()->HitTest(std::move(point), std::move(event_to_fire), std::move(request_id), std::move(callback));
}
void RenderAccessibilityInterceptorForTesting::PerformAction(const ::ui::AXActionData& action_data) {
  GetForwardingInterface()->PerformAction(std::move(action_data));
}
void RenderAccessibilityInterceptorForTesting::Reset(int32_t reset_token) {
  GetForwardingInterface()->Reset(std::move(reset_token));
}
RenderAccessibilityAsyncWaiter::RenderAccessibilityAsyncWaiter(
    RenderAccessibility* proxy) : proxy_(proxy) {}

RenderAccessibilityAsyncWaiter::~RenderAccessibilityAsyncWaiter() = default;

void RenderAccessibilityAsyncWaiter::HitTest(
    const ::gfx::Point& point, ::ax::mojom::Event event_to_fire, int32_t request_id, HitTestResponsePtr* out_hit_test_response) {
  base::RunLoop loop;
  proxy_->HitTest(std::move(point),std::move(event_to_fire),std::move(request_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             HitTestResponsePtr* out_hit_test_response
,
             HitTestResponsePtr hit_test_response) {*out_hit_test_response = std::move(hit_test_response);
            loop->Quit();
          },
          &loop,
          out_hit_test_response));
  loop.Run();
}





}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif