// content/common/render_message_filter.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "content/common/render_message_filter.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/thread_priority.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"


#ifndef CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_JUMBO_H_
#define CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_JUMBO_H_
#endif


namespace content {
namespace mojom {


void RenderMessageFilterInterceptorForTesting::GenerateRoutingID(GenerateRoutingIDCallback callback) {
  GetForwardingInterface()->GenerateRoutingID(std::move(callback));
}
void RenderMessageFilterInterceptorForTesting::GenerateFrameRoutingID(GenerateFrameRoutingIDCallback callback) {
  GetForwardingInterface()->GenerateFrameRoutingID(std::move(callback));
}
void RenderMessageFilterInterceptorForTesting::HasGpuProcess(HasGpuProcessCallback callback) {
  GetForwardingInterface()->HasGpuProcess(std::move(callback));
}
void RenderMessageFilterInterceptorForTesting::SetThreadPriority(int32_t platform_thread_id, ::base::ThreadPriority thread_priority) {
  GetForwardingInterface()->SetThreadPriority(std::move(platform_thread_id), std::move(thread_priority));
}
RenderMessageFilterAsyncWaiter::RenderMessageFilterAsyncWaiter(
    RenderMessageFilter* proxy) : proxy_(proxy) {}

RenderMessageFilterAsyncWaiter::~RenderMessageFilterAsyncWaiter() = default;

void RenderMessageFilterAsyncWaiter::GenerateRoutingID(
    int32_t* out_routing_id) {
  base::RunLoop loop;
  proxy_->GenerateRoutingID(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_routing_id
,
             int32_t routing_id) {*out_routing_id = std::move(routing_id);
            loop->Quit();
          },
          &loop,
          out_routing_id));
  loop.Run();
}
void RenderMessageFilterAsyncWaiter::GenerateFrameRoutingID(
    int32_t* out_routing_id, ::blink::LocalFrameToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token) {
  base::RunLoop loop;
  proxy_->GenerateFrameRoutingID(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_routing_id
,
             ::blink::LocalFrameToken* out_frame_token
,
             ::base::UnguessableToken* out_devtools_frame_token
,
             int32_t routing_id,
             const ::blink::LocalFrameToken& frame_token,
             const ::base::UnguessableToken& devtools_frame_token) {*out_routing_id = std::move(routing_id);*out_frame_token = std::move(frame_token);*out_devtools_frame_token = std::move(devtools_frame_token);
            loop->Quit();
          },
          &loop,
          out_routing_id,
          out_frame_token,
          out_devtools_frame_token));
  loop.Run();
}
void RenderMessageFilterAsyncWaiter::HasGpuProcess(
    bool* out_has_gpu_process) {
  base::RunLoop loop;
  proxy_->HasGpuProcess(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_gpu_process
,
             bool has_gpu_process) {*out_has_gpu_process = std::move(has_gpu_process);
            loop->Quit();
          },
          &loop,
          out_has_gpu_process));
  loop.Run();
}





}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif