// content/common/renderer.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "content/common/renderer.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "content/common/agent_scheduling_group.mojom.h"
#include "content/common/native_types.mojom.h"
#include "ipc/ipc.mojom.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/network_types.mojom.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"


#ifndef CONTENT_COMMON_RENDERER_MOJOM_JUMBO_H_
#define CONTENT_COMMON_RENDERER_MOJOM_JUMBO_H_
#include "content/common/frame_messages.h"
#include "content/public/common/common_param_traits.h"
#include "services/network/public/cpp/p2p_param_traits.h"
#endif


namespace content {
namespace mojom {


void RendererInterceptorForTesting::CreateAgentSchedulingGroup(::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap> bootstrap, ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> broker_remote) {
  GetForwardingInterface()->CreateAgentSchedulingGroup(std::move(bootstrap), std::move(broker_remote));
}
void RendererInterceptorForTesting::CreateAssociatedAgentSchedulingGroup(::mojo::PendingAssociatedReceiver<::content::mojom::AgentSchedulingGroup> agent_scheduling_group, ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> broker_remote) {
  GetForwardingInterface()->CreateAssociatedAgentSchedulingGroup(std::move(agent_scheduling_group), std::move(broker_remote));
}
void RendererInterceptorForTesting::OnNetworkConnectionChanged(::net::NetworkChangeNotifier::ConnectionType connection_type, double max_bandwidth_mbps) {
  GetForwardingInterface()->OnNetworkConnectionChanged(std::move(connection_type), std::move(max_bandwidth_mbps));
}
void RendererInterceptorForTesting::OnNetworkQualityChanged(::net::EffectiveConnectionType effective_connection_type, ::base::TimeDelta http_rtt, ::base::TimeDelta transport_rtt, double bandwidth_kbps) {
  GetForwardingInterface()->OnNetworkQualityChanged(std::move(effective_connection_type), std::move(http_rtt), std::move(transport_rtt), std::move(bandwidth_kbps));
}
void RendererInterceptorForTesting::SetWebKitSharedTimersSuspended(bool suspend) {
  GetForwardingInterface()->SetWebKitSharedTimersSuspended(std::move(suspend));
}
void RendererInterceptorForTesting::SetUserAgent(const std::string& user_agent) {
  GetForwardingInterface()->SetUserAgent(std::move(user_agent));
}
void RendererInterceptorForTesting::SetUserAgentMetadata(const ::blink::UserAgentMetadata& metadata) {
  GetForwardingInterface()->SetUserAgentMetadata(std::move(metadata));
}
void RendererInterceptorForTesting::SetCorsExemptHeaderList(const std::vector<std::string>& list) {
  GetForwardingInterface()->SetCorsExemptHeaderList(std::move(list));
}
void RendererInterceptorForTesting::UpdateScrollbarTheme(UpdateScrollbarThemeParamsPtr params) {
  GetForwardingInterface()->UpdateScrollbarTheme(std::move(params));
}
void RendererInterceptorForTesting::OnSystemColorsChanged(int32_t aqua_color_variant, const std::string& highlight_text_color, const std::string& highlight_color) {
  GetForwardingInterface()->OnSystemColorsChanged(std::move(aqua_color_variant), std::move(highlight_text_color), std::move(highlight_color));
}
void RendererInterceptorForTesting::UpdateSystemColorInfo(UpdateSystemColorInfoParamsPtr params) {
  GetForwardingInterface()->UpdateSystemColorInfo(std::move(params));
}
void RendererInterceptorForTesting::PurgePluginListCache(bool reload_pages) {
  GetForwardingInterface()->PurgePluginListCache(std::move(reload_pages));
}
void RendererInterceptorForTesting::SetProcessState(RenderProcessBackgroundState background_state, RenderProcessVisibleState visible_state) {
  GetForwardingInterface()->SetProcessState(std::move(background_state), std::move(visible_state));
}
void RendererInterceptorForTesting::SetSchedulerKeepActive(bool keep_active) {
  GetForwardingInterface()->SetSchedulerKeepActive(std::move(keep_active));
}
void RendererInterceptorForTesting::SetIsLockedToSite() {
  GetForwardingInterface()->SetIsLockedToSite();
}
void RendererInterceptorForTesting::SetIsCrossOriginIsolated(bool value) {
  GetForwardingInterface()->SetIsCrossOriginIsolated(std::move(value));
}
RendererAsyncWaiter::RendererAsyncWaiter(
    Renderer* proxy) : proxy_(proxy) {}

RendererAsyncWaiter::~RendererAsyncWaiter() = default;






}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif