// content/common/renderer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/renderer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/renderer.mojom-params-data.h"
#include "content/common/renderer.mojom-shared-message-ids.h"

#include "content/common/renderer.mojom-import-headers.h"


#ifndef CONTENT_COMMON_RENDERER_MOJOM_JUMBO_H_
#define CONTENT_COMMON_RENDERER_MOJOM_JUMBO_H_
#include "content/common/frame_messages.h"
#include "content/public/common/common_param_traits.h"
#include "services/network/public/cpp/p2p_param_traits.h"
#endif
namespace content {
namespace mojom {
UpdateScrollbarThemeParams::UpdateScrollbarThemeParams()
    : has_initial_button_delay(),
      initial_button_delay(),
      has_autoscroll_button_delay(),
      autoscroll_button_delay(),
      jump_on_track_click(),
      preferred_scroller_style(),
      redraw(),
      scroll_view_rubber_banding() {}

UpdateScrollbarThemeParams::UpdateScrollbarThemeParams(
    bool has_initial_button_delay_in,
    float initial_button_delay_in,
    bool has_autoscroll_button_delay_in,
    float autoscroll_button_delay_in,
    bool jump_on_track_click_in,
    ::content::mojom::ScrollerStyle preferred_scroller_style_in,
    bool redraw_in,
    bool scroll_view_rubber_banding_in)
    : has_initial_button_delay(std::move(has_initial_button_delay_in)),
      initial_button_delay(std::move(initial_button_delay_in)),
      has_autoscroll_button_delay(std::move(has_autoscroll_button_delay_in)),
      autoscroll_button_delay(std::move(autoscroll_button_delay_in)),
      jump_on_track_click(std::move(jump_on_track_click_in)),
      preferred_scroller_style(std::move(preferred_scroller_style_in)),
      redraw(std::move(redraw_in)),
      scroll_view_rubber_banding(std::move(scroll_view_rubber_banding_in)) {}

UpdateScrollbarThemeParams::~UpdateScrollbarThemeParams() = default;
size_t UpdateScrollbarThemeParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->has_initial_button_delay);
  seed = mojo::internal::Hash(seed, this->initial_button_delay);
  seed = mojo::internal::Hash(seed, this->has_autoscroll_button_delay);
  seed = mojo::internal::Hash(seed, this->autoscroll_button_delay);
  seed = mojo::internal::Hash(seed, this->jump_on_track_click);
  seed = mojo::internal::Hash(seed, this->preferred_scroller_style);
  seed = mojo::internal::Hash(seed, this->redraw);
  seed = mojo::internal::Hash(seed, this->scroll_view_rubber_banding);
  return seed;
}

void UpdateScrollbarThemeParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_initial_button_delay"), this->has_initial_button_delay, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_button_delay"), this->initial_button_delay, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_autoscroll_button_delay"), this->has_autoscroll_button_delay, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "autoscroll_button_delay"), this->autoscroll_button_delay, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "jump_on_track_click"), this->jump_on_track_click, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preferred_scroller_style"), this->preferred_scroller_style, 
      "<value of type ::content::mojom::ScrollerStyle>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redraw"), this->redraw, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_view_rubber_banding"), this->scroll_view_rubber_banding, 
      "<value of type bool>");
}

bool UpdateScrollbarThemeParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UpdateSystemColorInfoParams::UpdateSystemColorInfoParams()
    : is_dark_mode(),
      forced_colors(),
      colors() {}

UpdateSystemColorInfoParams::UpdateSystemColorInfoParams(
    bool is_dark_mode_in,
    bool forced_colors_in,
    const base::flat_map<::ui::NativeTheme::SystemThemeColor, uint32_t>& colors_in)
    : is_dark_mode(std::move(is_dark_mode_in)),
      forced_colors(std::move(forced_colors_in)),
      colors(std::move(colors_in)) {}

UpdateSystemColorInfoParams::~UpdateSystemColorInfoParams() = default;

void UpdateSystemColorInfoParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_dark_mode"), this->is_dark_mode, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "forced_colors"), this->forced_colors, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "colors"), this->colors, 
      "<value of type const base::flat_map<::ui::NativeTheme::SystemThemeColor, uint32_t>&>");
}

bool UpdateSystemColorInfoParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char Renderer::Name_[] = "content.mojom.Renderer";

RendererProxy::RendererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererProxy::CreateAgentSchedulingGroup(
    ::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap> in_bootstrap, ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> in_broker_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::CreateAgentSchedulingGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bootstrap"), in_bootstrap, 
                        "<value of type ::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("broker_remote"), in_broker_remote, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_CreateAgentSchedulingGroup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_CreateAgentSchedulingGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::IPC::mojom::ChannelBootstrapInterfaceBase>>(
      in_bootstrap, &params->bootstrap, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->bootstrap),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid bootstrap in Renderer.CreateAgentSchedulingGroup request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
      in_broker_remote, &params->broker_remote, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->broker_remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid broker_remote in Renderer.CreateAgentSchedulingGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("CreateAgentSchedulingGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::CreateAssociatedAgentSchedulingGroup(
    ::mojo::PendingAssociatedReceiver<::content::mojom::AgentSchedulingGroup> in_agent_scheduling_group, ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> in_broker_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::CreateAssociatedAgentSchedulingGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent_scheduling_group"), in_agent_scheduling_group, 
                        "<value of type ::mojo::PendingAssociatedReceiver<::content::mojom::AgentSchedulingGroup>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("broker_remote"), in_broker_remote, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_CreateAssociatedAgentSchedulingGroup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::content::mojom::AgentSchedulingGroupAssociatedRequestDataView>(
      in_agent_scheduling_group, &params->agent_scheduling_group, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent_scheduling_group),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid agent_scheduling_group in Renderer.CreateAssociatedAgentSchedulingGroup request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
      in_broker_remote, &params->broker_remote, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->broker_remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid broker_remote in Renderer.CreateAssociatedAgentSchedulingGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("CreateAssociatedAgentSchedulingGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::OnNetworkConnectionChanged(
    ::net::NetworkChangeNotifier::ConnectionType in_connection_type, double in_max_bandwidth_mbps) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::OnNetworkConnectionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection_type"), in_connection_type, 
                        "<value of type ::net::NetworkChangeNotifier::ConnectionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_bandwidth_mbps"), in_max_bandwidth_mbps, 
                        "<value of type double>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_OnNetworkConnectionChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_OnNetworkConnectionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::content::mojom::NetworkConnectionType>(
      in_connection_type, &params->connection_type);
  params->max_bandwidth_mbps = in_max_bandwidth_mbps;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("OnNetworkConnectionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::OnNetworkQualityChanged(
    ::net::EffectiveConnectionType in_effective_connection_type, ::base::TimeDelta in_http_rtt, ::base::TimeDelta in_transport_rtt, double in_bandwidth_kbps) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::OnNetworkQualityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("effective_connection_type"), in_effective_connection_type, 
                        "<value of type ::net::EffectiveConnectionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_rtt"), in_http_rtt, 
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transport_rtt"), in_transport_rtt, 
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bandwidth_kbps"), in_bandwidth_kbps, 
                        "<value of type double>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_OnNetworkQualityChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_OnNetworkQualityChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::EffectiveConnectionType>(
      in_effective_connection_type, &params->effective_connection_type);
  mojo::internal::MessageFragment<
      typename decltype(params->http_rtt)::BaseType> http_rtt_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_http_rtt, http_rtt_fragment);
  params->http_rtt.Set(
      http_rtt_fragment.is_null() ? nullptr : http_rtt_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->http_rtt.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null http_rtt in Renderer.OnNetworkQualityChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->transport_rtt)::BaseType> transport_rtt_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_transport_rtt, transport_rtt_fragment);
  params->transport_rtt.Set(
      transport_rtt_fragment.is_null() ? nullptr : transport_rtt_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->transport_rtt.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transport_rtt in Renderer.OnNetworkQualityChanged request");
  params->bandwidth_kbps = in_bandwidth_kbps;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("OnNetworkQualityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetWebKitSharedTimersSuspended(
    bool in_suspend) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::SetWebKitSharedTimersSuspended", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suspend"), in_suspend, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetWebKitSharedTimersSuspended_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetWebKitSharedTimersSuspended_Params_Data> params(
          message);
  params.Allocate();
  params->suspend = in_suspend;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetWebKitSharedTimersSuspended");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetUserAgent(
    const std::string& in_user_agent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::SetUserAgent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_agent"), in_user_agent, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetUserAgent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetUserAgent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->user_agent)::BaseType> user_agent_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_user_agent, user_agent_fragment);
  params->user_agent.Set(
      user_agent_fragment.is_null() ? nullptr : user_agent_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->user_agent.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_agent in Renderer.SetUserAgent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetUserAgent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetUserAgentMetadata(
    const ::blink::UserAgentMetadata& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::SetUserAgentMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata, 
                        "<value of type const ::blink::UserAgentMetadata&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetUserAgentMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetUserAgentMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::UserAgentMetadataDataView>(
      in_metadata, metadata_fragment);
  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in Renderer.SetUserAgentMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetUserAgentMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetCorsExemptHeaderList(
    const std::vector<std::string>& in_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::SetCorsExemptHeaderList", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("list"), in_list, 
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetCorsExemptHeaderList_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetCorsExemptHeaderList_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->list)::BaseType>
      list_fragment(params.message());
  const mojo::internal::ContainerValidateParams list_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_list, list_fragment, &list_validate_params);
  params->list.Set(
      list_fragment.is_null() ? nullptr : list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null list in Renderer.SetCorsExemptHeaderList request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetCorsExemptHeaderList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::UpdateScrollbarTheme(
    UpdateScrollbarThemeParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::UpdateScrollbarTheme", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type UpdateScrollbarThemeParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_UpdateScrollbarTheme_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_UpdateScrollbarTheme_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::UpdateScrollbarThemeParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in Renderer.UpdateScrollbarTheme request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateScrollbarTheme");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::OnSystemColorsChanged(
    int32_t in_aqua_color_variant, const std::string& in_highlight_text_color, const std::string& in_highlight_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::OnSystemColorsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("aqua_color_variant"), in_aqua_color_variant, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("highlight_text_color"), in_highlight_text_color, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("highlight_color"), in_highlight_color, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_OnSystemColorsChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_OnSystemColorsChanged_Params_Data> params(
          message);
  params.Allocate();
  params->aqua_color_variant = in_aqua_color_variant;
  mojo::internal::MessageFragment<
      typename decltype(params->highlight_text_color)::BaseType> highlight_text_color_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_highlight_text_color, highlight_text_color_fragment);
  params->highlight_text_color.Set(
      highlight_text_color_fragment.is_null() ? nullptr : highlight_text_color_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->highlight_text_color.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null highlight_text_color in Renderer.OnSystemColorsChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->highlight_color)::BaseType> highlight_color_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_highlight_color, highlight_color_fragment);
  params->highlight_color.Set(
      highlight_color_fragment.is_null() ? nullptr : highlight_color_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->highlight_color.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null highlight_color in Renderer.OnSystemColorsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("OnSystemColorsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::UpdateSystemColorInfo(
    UpdateSystemColorInfoParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::UpdateSystemColorInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type UpdateSystemColorInfoParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_UpdateSystemColorInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_UpdateSystemColorInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::UpdateSystemColorInfoParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in Renderer.UpdateSystemColorInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateSystemColorInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::PurgePluginListCache(
    bool in_reload_pages) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::PurgePluginListCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reload_pages"), in_reload_pages, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_PurgePluginListCache_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_PurgePluginListCache_Params_Data> params(
          message);
  params.Allocate();
  params->reload_pages = in_reload_pages;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("PurgePluginListCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetProcessState(
    RenderProcessBackgroundState in_background_state, RenderProcessVisibleState in_visible_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::SetProcessState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("background_state"), in_background_state, 
                        "<value of type RenderProcessBackgroundState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible_state"), in_visible_state, 
                        "<value of type RenderProcessVisibleState>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetProcessState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetProcessState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::content::mojom::RenderProcessBackgroundState>(
      in_background_state, &params->background_state);
  mojo::internal::Serialize<::content::mojom::RenderProcessVisibleState>(
      in_visible_state, &params->visible_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetProcessState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetSchedulerKeepActive(
    bool in_keep_active) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::SetSchedulerKeepActive", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keep_active"), in_keep_active, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetSchedulerKeepActive_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetSchedulerKeepActive_Params_Data> params(
          message);
  params.Allocate();
  params->keep_active = in_keep_active;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetSchedulerKeepActive");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetIsLockedToSite(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::Renderer::SetIsLockedToSite");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetIsLockedToSite_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetIsLockedToSite_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetIsLockedToSite");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetIsCrossOriginIsolated(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::Renderer::SetIsCrossOriginIsolated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetIsCrossOriginIsolated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::Renderer_SetIsCrossOriginIsolated_Params_Data> params(
          message);
  params.Allocate();
  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetIsCrossOriginIsolated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RendererStubDispatch::Accept(
    Renderer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRenderer_CreateAgentSchedulingGroup_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::CreateAgentSchedulingGroup",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::CreateAgentSchedulingGroup");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_CreateAgentSchedulingGroup_Params_Data* params =
          reinterpret_cast<internal::Renderer_CreateAgentSchedulingGroup_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::IPC::mojom::ChannelBootstrap> p_bootstrap{};
      ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> p_broker_remote{};
      Renderer_CreateAgentSchedulingGroup_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_bootstrap =
            input_data_view.TakeBootstrap<decltype(p_bootstrap)>();
      }
      if (success) {
        p_broker_remote =
            input_data_view.TakeBrokerRemote<decltype(p_broker_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAgentSchedulingGroup(
std::move(p_bootstrap), 
std::move(p_broker_remote));
      return true;
    }
    case internal::kRenderer_CreateAssociatedAgentSchedulingGroup_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::CreateAssociatedAgentSchedulingGroup",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::CreateAssociatedAgentSchedulingGroup");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data* params =
          reinterpret_cast<internal::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::content::mojom::AgentSchedulingGroup> p_agent_scheduling_group{};
      ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> p_broker_remote{};
      Renderer_CreateAssociatedAgentSchedulingGroup_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent_scheduling_group =
            input_data_view.TakeAgentSchedulingGroup<decltype(p_agent_scheduling_group)>();
      }
      if (success) {
        p_broker_remote =
            input_data_view.TakeBrokerRemote<decltype(p_broker_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAssociatedAgentSchedulingGroup(
std::move(p_agent_scheduling_group), 
std::move(p_broker_remote));
      return true;
    }
    case internal::kRenderer_OnNetworkConnectionChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::OnNetworkConnectionChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::OnNetworkConnectionChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_OnNetworkConnectionChanged_Params_Data* params =
          reinterpret_cast<internal::Renderer_OnNetworkConnectionChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::NetworkChangeNotifier::ConnectionType p_connection_type{};
      double p_max_bandwidth_mbps{};
      Renderer_OnNetworkConnectionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConnectionType(&p_connection_type))
        success = false;
      if (success)
        p_max_bandwidth_mbps = input_data_view.max_bandwidth_mbps();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkConnectionChanged(
std::move(p_connection_type), 
std::move(p_max_bandwidth_mbps));
      return true;
    }
    case internal::kRenderer_OnNetworkQualityChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::OnNetworkQualityChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::OnNetworkQualityChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_OnNetworkQualityChanged_Params_Data* params =
          reinterpret_cast<internal::Renderer_OnNetworkQualityChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::EffectiveConnectionType p_effective_connection_type{};
      ::base::TimeDelta p_http_rtt{};
      ::base::TimeDelta p_transport_rtt{};
      double p_bandwidth_kbps{};
      Renderer_OnNetworkQualityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEffectiveConnectionType(&p_effective_connection_type))
        success = false;
      if (success && !input_data_view.ReadHttpRtt(&p_http_rtt))
        success = false;
      if (success && !input_data_view.ReadTransportRtt(&p_transport_rtt))
        success = false;
      if (success)
        p_bandwidth_kbps = input_data_view.bandwidth_kbps();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkQualityChanged(
std::move(p_effective_connection_type), 
std::move(p_http_rtt), 
std::move(p_transport_rtt), 
std::move(p_bandwidth_kbps));
      return true;
    }
    case internal::kRenderer_SetWebKitSharedTimersSuspended_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::SetWebKitSharedTimersSuspended",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::SetWebKitSharedTimersSuspended");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetWebKitSharedTimersSuspended_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetWebKitSharedTimersSuspended_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_suspend{};
      Renderer_SetWebKitSharedTimersSuspended_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_suspend = input_data_view.suspend();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWebKitSharedTimersSuspended(
std::move(p_suspend));
      return true;
    }
    case internal::kRenderer_SetUserAgent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::SetUserAgent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::SetUserAgent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetUserAgent_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetUserAgent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_user_agent{};
      Renderer_SetUserAgent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUserAgent(&p_user_agent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserAgent(
std::move(p_user_agent));
      return true;
    }
    case internal::kRenderer_SetUserAgentMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::SetUserAgentMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::SetUserAgentMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetUserAgentMetadata_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetUserAgentMetadata_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::UserAgentMetadata p_metadata{};
      Renderer_SetUserAgentMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserAgentMetadata(
std::move(p_metadata));
      return true;
    }
    case internal::kRenderer_SetCorsExemptHeaderList_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::SetCorsExemptHeaderList",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::SetCorsExemptHeaderList");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetCorsExemptHeaderList_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetCorsExemptHeaderList_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<std::string> p_list{};
      Renderer_SetCorsExemptHeaderList_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadList(&p_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCorsExemptHeaderList(
std::move(p_list));
      return true;
    }
    case internal::kRenderer_UpdateScrollbarTheme_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::UpdateScrollbarTheme",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::UpdateScrollbarTheme");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_UpdateScrollbarTheme_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateScrollbarTheme_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      UpdateScrollbarThemeParamsPtr p_params{};
      Renderer_UpdateScrollbarTheme_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateScrollbarTheme(
std::move(p_params));
      return true;
    }
    case internal::kRenderer_OnSystemColorsChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::OnSystemColorsChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::OnSystemColorsChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_OnSystemColorsChanged_Params_Data* params =
          reinterpret_cast<internal::Renderer_OnSystemColorsChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_aqua_color_variant{};
      std::string p_highlight_text_color{};
      std::string p_highlight_color{};
      Renderer_OnSystemColorsChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_aqua_color_variant = input_data_view.aqua_color_variant();
      if (success && !input_data_view.ReadHighlightTextColor(&p_highlight_text_color))
        success = false;
      if (success && !input_data_view.ReadHighlightColor(&p_highlight_color))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSystemColorsChanged(
std::move(p_aqua_color_variant), 
std::move(p_highlight_text_color), 
std::move(p_highlight_color));
      return true;
    }
    case internal::kRenderer_UpdateSystemColorInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::UpdateSystemColorInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::UpdateSystemColorInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_UpdateSystemColorInfo_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateSystemColorInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      UpdateSystemColorInfoParamsPtr p_params{};
      Renderer_UpdateSystemColorInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSystemColorInfo(
std::move(p_params));
      return true;
    }
    case internal::kRenderer_PurgePluginListCache_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::PurgePluginListCache",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::PurgePluginListCache");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_PurgePluginListCache_Params_Data* params =
          reinterpret_cast<internal::Renderer_PurgePluginListCache_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_reload_pages{};
      Renderer_PurgePluginListCache_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reload_pages = input_data_view.reload_pages();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PurgePluginListCache(
std::move(p_reload_pages));
      return true;
    }
    case internal::kRenderer_SetProcessState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::SetProcessState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::SetProcessState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetProcessState_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetProcessState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RenderProcessBackgroundState p_background_state{};
      RenderProcessVisibleState p_visible_state{};
      Renderer_SetProcessState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBackgroundState(&p_background_state))
        success = false;
      if (success && !input_data_view.ReadVisibleState(&p_visible_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetProcessState(
std::move(p_background_state), 
std::move(p_visible_state));
      return true;
    }
    case internal::kRenderer_SetSchedulerKeepActive_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::SetSchedulerKeepActive",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::SetSchedulerKeepActive");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetSchedulerKeepActive_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetSchedulerKeepActive_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_keep_active{};
      Renderer_SetSchedulerKeepActive_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_keep_active = input_data_view.keep_active();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSchedulerKeepActive(
std::move(p_keep_active));
      return true;
    }
    case internal::kRenderer_SetIsLockedToSite_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::SetIsLockedToSite",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::SetIsLockedToSite");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetIsLockedToSite_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetIsLockedToSite_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Renderer_SetIsLockedToSite_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsLockedToSite();
      return true;
    }
    case internal::kRenderer_SetIsCrossOriginIsolated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::Renderer::SetIsCrossOriginIsolated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::Renderer::SetIsCrossOriginIsolated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetIsCrossOriginIsolated_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetIsCrossOriginIsolated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_value{};
      Renderer_SetIsCrossOriginIsolated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsCrossOriginIsolated(
std::move(p_value));
      return true;
    }
  }
  return false;
}

// static
bool RendererStubDispatch::AcceptWithResponder(
    Renderer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderer_CreateAgentSchedulingGroup_Name: {
      break;
    }
    case internal::kRenderer_CreateAssociatedAgentSchedulingGroup_Name: {
      break;
    }
    case internal::kRenderer_OnNetworkConnectionChanged_Name: {
      break;
    }
    case internal::kRenderer_OnNetworkQualityChanged_Name: {
      break;
    }
    case internal::kRenderer_SetWebKitSharedTimersSuspended_Name: {
      break;
    }
    case internal::kRenderer_SetUserAgent_Name: {
      break;
    }
    case internal::kRenderer_SetUserAgentMetadata_Name: {
      break;
    }
    case internal::kRenderer_SetCorsExemptHeaderList_Name: {
      break;
    }
    case internal::kRenderer_UpdateScrollbarTheme_Name: {
      break;
    }
    case internal::kRenderer_OnSystemColorsChanged_Name: {
      break;
    }
    case internal::kRenderer_UpdateSystemColorInfo_Name: {
      break;
    }
    case internal::kRenderer_PurgePluginListCache_Name: {
      break;
    }
    case internal::kRenderer_SetProcessState_Name: {
      break;
    }
    case internal::kRenderer_SetSchedulerKeepActive_Name: {
      break;
    }
    case internal::kRenderer_SetIsLockedToSite_Name: {
      break;
    }
    case internal::kRenderer_SetIsCrossOriginIsolated_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererValidationInfo[] = {
    {internal::kRenderer_CreateAgentSchedulingGroup_Name,
     {&internal::Renderer_CreateAgentSchedulingGroup_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_CreateAssociatedAgentSchedulingGroup_Name,
     {&internal::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_OnNetworkConnectionChanged_Name,
     {&internal::Renderer_OnNetworkConnectionChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_OnNetworkQualityChanged_Name,
     {&internal::Renderer_OnNetworkQualityChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetWebKitSharedTimersSuspended_Name,
     {&internal::Renderer_SetWebKitSharedTimersSuspended_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetUserAgent_Name,
     {&internal::Renderer_SetUserAgent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetUserAgentMetadata_Name,
     {&internal::Renderer_SetUserAgentMetadata_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetCorsExemptHeaderList_Name,
     {&internal::Renderer_SetCorsExemptHeaderList_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_UpdateScrollbarTheme_Name,
     {&internal::Renderer_UpdateScrollbarTheme_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_OnSystemColorsChanged_Name,
     {&internal::Renderer_OnSystemColorsChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_UpdateSystemColorInfo_Name,
     {&internal::Renderer_UpdateSystemColorInfo_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_PurgePluginListCache_Name,
     {&internal::Renderer_PurgePluginListCache_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetProcessState_Name,
     {&internal::Renderer_SetProcessState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetSchedulerKeepActive_Name,
     {&internal::Renderer_SetSchedulerKeepActive_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetIsLockedToSite_Name,
     {&internal::Renderer_SetIsLockedToSite_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetIsCrossOriginIsolated_Name,
     {&internal::Renderer_SetIsCrossOriginIsolated_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RendererRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::Renderer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRendererValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {


// static
bool StructTraits<::content::mojom::UpdateScrollbarThemeParams::DataView, ::content::mojom::UpdateScrollbarThemeParamsPtr>::Read(
    ::content::mojom::UpdateScrollbarThemeParams::DataView input,
    ::content::mojom::UpdateScrollbarThemeParamsPtr* output) {
  bool success = true;
  ::content::mojom::UpdateScrollbarThemeParamsPtr result(::content::mojom::UpdateScrollbarThemeParams::New());
  
      if (success)
        result->has_initial_button_delay = input.has_initial_button_delay();
      if (success)
        result->initial_button_delay = input.initial_button_delay();
      if (success)
        result->has_autoscroll_button_delay = input.has_autoscroll_button_delay();
      if (success)
        result->autoscroll_button_delay = input.autoscroll_button_delay();
      if (success)
        result->jump_on_track_click = input.jump_on_track_click();
      if (success && !input.ReadPreferredScrollerStyle(&result->preferred_scroller_style))
        success = false;
      if (success)
        result->redraw = input.redraw();
      if (success)
        result->scroll_view_rubber_banding = input.scroll_view_rubber_banding();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::UpdateSystemColorInfoParams::DataView, ::content::mojom::UpdateSystemColorInfoParamsPtr>::Read(
    ::content::mojom::UpdateSystemColorInfoParams::DataView input,
    ::content::mojom::UpdateSystemColorInfoParamsPtr* output) {
  bool success = true;
  ::content::mojom::UpdateSystemColorInfoParamsPtr result(::content::mojom::UpdateSystemColorInfoParams::New());
  
      if (success)
        result->is_dark_mode = input.is_dark_mode();
      if (success)
        result->forced_colors = input.forced_colors();
      if (success && !input.ReadColors(&result->colors))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif