// content/common/renderer_variations_configuration.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/renderer_variations_configuration.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/renderer_variations_configuration.mojom-params-data.h"
#include "content/common/renderer_variations_configuration.mojom-shared-message-ids.h"

#include "content/common/renderer_variations_configuration.mojom-import-headers.h"


#ifndef CONTENT_COMMON_RENDERER_VARIATIONS_CONFIGURATION_MOJOM_JUMBO_H_
#define CONTENT_COMMON_RENDERER_VARIATIONS_CONFIGURATION_MOJOM_JUMBO_H_
#endif
namespace content {
namespace mojom {
const char RendererVariationsConfiguration::Name_[] = "content.mojom.RendererVariationsConfiguration";

RendererVariationsConfigurationProxy::RendererVariationsConfigurationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererVariationsConfigurationProxy::SetVariationsHeaders(
    ::variations::mojom::VariationsHeadersPtr in_variations_headers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RendererVariationsConfiguration::SetVariationsHeaders", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("variations_headers"), in_variations_headers, 
                        "<value of type ::variations::mojom::VariationsHeadersPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererVariationsConfiguration_SetVariationsHeaders_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererVariationsConfiguration_SetVariationsHeaders_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->variations_headers)::BaseType> variations_headers_fragment(
          params.message());
  mojo::internal::Serialize<::variations::mojom::VariationsHeadersDataView>(
      in_variations_headers, variations_headers_fragment);
  params->variations_headers.Set(
      variations_headers_fragment.is_null() ? nullptr : variations_headers_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererVariationsConfiguration::Name_);
  message.set_method_name("SetVariationsHeaders");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererVariationsConfigurationProxy::SetFieldTrialGroup(
    const std::string& in_trial_name, const std::string& in_group_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RendererVariationsConfiguration::SetFieldTrialGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trial_name"), in_trial_name, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_name"), in_group_name, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererVariationsConfiguration_SetFieldTrialGroup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererVariationsConfiguration_SetFieldTrialGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->trial_name)::BaseType> trial_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_trial_name, trial_name_fragment);
  params->trial_name.Set(
      trial_name_fragment.is_null() ? nullptr : trial_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->trial_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trial_name in RendererVariationsConfiguration.SetFieldTrialGroup request");
  mojo::internal::MessageFragment<
      typename decltype(params->group_name)::BaseType> group_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_group_name, group_name_fragment);
  params->group_name.Set(
      group_name_fragment.is_null() ? nullptr : group_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_name in RendererVariationsConfiguration.SetFieldTrialGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererVariationsConfiguration::Name_);
  message.set_method_name("SetFieldTrialGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RendererVariationsConfigurationStubDispatch::Accept(
    RendererVariationsConfiguration* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRendererVariationsConfiguration_SetVariationsHeaders_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RendererVariationsConfiguration::SetVariationsHeaders",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RendererVariationsConfiguration::SetVariationsHeaders");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererVariationsConfiguration_SetVariationsHeaders_Params_Data* params =
          reinterpret_cast<internal::RendererVariationsConfiguration_SetVariationsHeaders_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::variations::mojom::VariationsHeadersPtr p_variations_headers{};
      RendererVariationsConfiguration_SetVariationsHeaders_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVariationsHeaders(&p_variations_headers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererVariationsConfiguration::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVariationsHeaders(
std::move(p_variations_headers));
      return true;
    }
    case internal::kRendererVariationsConfiguration_SetFieldTrialGroup_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RendererVariationsConfiguration::SetFieldTrialGroup",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RendererVariationsConfiguration::SetFieldTrialGroup");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererVariationsConfiguration_SetFieldTrialGroup_Params_Data* params =
          reinterpret_cast<internal::RendererVariationsConfiguration_SetFieldTrialGroup_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_trial_name{};
      std::string p_group_name{};
      RendererVariationsConfiguration_SetFieldTrialGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTrialName(&p_trial_name))
        success = false;
      if (success && !input_data_view.ReadGroupName(&p_group_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererVariationsConfiguration::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFieldTrialGroup(
std::move(p_trial_name), 
std::move(p_group_name));
      return true;
    }
  }
  return false;
}

// static
bool RendererVariationsConfigurationStubDispatch::AcceptWithResponder(
    RendererVariationsConfiguration* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRendererVariationsConfiguration_SetVariationsHeaders_Name: {
      break;
    }
    case internal::kRendererVariationsConfiguration_SetFieldTrialGroup_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererVariationsConfigurationValidationInfo[] = {
    {internal::kRendererVariationsConfiguration_SetVariationsHeaders_Name,
     {&internal::RendererVariationsConfiguration_SetVariationsHeaders_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRendererVariationsConfiguration_SetFieldTrialGroup_Name,
     {&internal::RendererVariationsConfiguration_SetFieldTrialGroup_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RendererVariationsConfigurationRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RendererVariationsConfiguration::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRendererVariationsConfigurationValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif