// content/public/common/media_playback_renderer_type.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/public/common/media_playback_renderer_type.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/public/common/media_playback_renderer_type.mojom-params-data.h"
namespace content {
namespace mojom {

std::string RendererTypeToString(RendererType value) {
  switch(value) {
    case RendererType::DEFAULT_RENDERER:
      return "RendererType::DEFAULT_RENDERER";
    case RendererType::MOJO_RENDERER:
      return "RendererType::MOJO_RENDERER";
    case RendererType::REMOTING_RENDERER:
      return "RendererType::REMOTING_RENDERER";
    default:
      return base::StringPrintf("Unknown RendererType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, RendererType value) {
  return os << RendererTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace content

namespace perfetto {

// static
void TraceFormatTraits<::content::mojom::RendererType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::content::mojom::RendererType value) {
  return std::move(context).WriteString(::content::mojom::RendererTypeToString(value));
}

} // namespace perfetto
