// content/public/common/resource_usage_reporter.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/public/common/resource_usage_reporter.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/public/common/resource_usage_reporter.mojom-params-data.h"
namespace content {
namespace mojom {

namespace internal {


// static
bool ResourceTypeStat_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResourceTypeStat_Data* object = static_cast<const ResourceTypeStat_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ResourceTypeStat_Data::ResourceTypeStat_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResourceTypeStats_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResourceTypeStats_Data* object = static_cast<const ResourceTypeStats_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->images, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->images, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->css_style_sheets, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->css_style_sheets, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scripts, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scripts, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->xsl_style_sheets, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->xsl_style_sheets, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fonts, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->fonts, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->other, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->other, validation_context))
    return false;

  return true;
}

ResourceTypeStats_Data::ResourceTypeStats_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResourceUsageData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResourceUsageData_Data* object = static_cast<const ResourceUsageData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->web_cache_stats, validation_context))
    return false;

  return true;
}

ResourceUsageData_Data::ResourceUsageData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResourceUsageReporter_GetUsageData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResourceUsageReporter_GetUsageData_Params_Data* object = static_cast<const ResourceUsageReporter_GetUsageData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ResourceUsageReporter_GetUsageData_Params_Data::ResourceUsageReporter_GetUsageData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResourceUsageReporter_GetUsageData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResourceUsageReporter_GetUsageData_ResponseParams_Data* object = static_cast<const ResourceUsageReporter_GetUsageData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

ResourceUsageReporter_GetUsageData_ResponseParams_Data::ResourceUsageReporter_GetUsageData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content
