// content/public/common/trust_tokens.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/public/common/trust_tokens.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/public/common/trust_tokens.mojom-params-data.h"
#include "content/public/common/trust_tokens.mojom-shared-message-ids.h"

#include "content/public/common/trust_tokens.mojom-import-headers.h"


#ifndef CONTENT_PUBLIC_COMMON_TRUST_TOKENS_MOJOM_JUMBO_H_
#define CONTENT_PUBLIC_COMMON_TRUST_TOKENS_MOJOM_JUMBO_H_
#endif
namespace content {
namespace mojom {
const char LocalTrustTokenFulfiller::Name_[] = "content.mojom.LocalTrustTokenFulfiller";

class LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ForwardToCallback(
      LocalTrustTokenFulfiller::FulfillTrustTokenIssuanceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalTrustTokenFulfiller::FulfillTrustTokenIssuanceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ForwardToCallback);
};

LocalTrustTokenFulfillerProxy::LocalTrustTokenFulfillerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalTrustTokenFulfillerProxy::FulfillTrustTokenIssuance(
    ::network::mojom::FulfillTrustTokenIssuanceRequestPtr in_request, FulfillTrustTokenIssuanceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::LocalTrustTokenFulfiller::FulfillTrustTokenIssuance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request, 
                        "<value of type ::network::mojom::FulfillTrustTokenIssuanceRequestPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalTrustTokenFulfiller_FulfillTrustTokenIssuance_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::FulfillTrustTokenIssuanceRequestDataView>(
      in_request, request_fragment);
  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in LocalTrustTokenFulfiller.FulfillTrustTokenIssuance request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalTrustTokenFulfiller::Name_);
  message.set_method_name("FulfillTrustTokenIssuance");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ProxyToResponder {
 public:
  static LocalTrustTokenFulfiller::FulfillTrustTokenIssuanceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ProxyToResponder> proxy(
        new LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalTrustTokenFulfiller::FulfillTrustTokenIssuanceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr in_answer);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ProxyToResponder);
};

bool LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::LocalTrustTokenFulfiller::FulfillTrustTokenIssuanceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr p_answer{};
  LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAnswer(&p_answer))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalTrustTokenFulfiller::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_answer));
  return true;
}

void LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ProxyToResponder::Run(
    ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr in_answer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::LocalTrustTokenFulfiller::FulfillTrustTokenIssuanceCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("answer"), in_answer, 
                        "<value of type ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalTrustTokenFulfiller_FulfillTrustTokenIssuance_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->answer)::BaseType> answer_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::FulfillTrustTokenIssuanceAnswerDataView>(
      in_answer, answer_fragment);
  params->answer.Set(
      answer_fragment.is_null() ? nullptr : answer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->answer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null answer in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::LocalTrustTokenFulfiller::FulfillTrustTokenIssuanceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalTrustTokenFulfiller::Name_);
  message.set_method_name("FulfillTrustTokenIssuance");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalTrustTokenFulfillerStubDispatch::Accept(
    LocalTrustTokenFulfiller* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLocalTrustTokenFulfiller_FulfillTrustTokenIssuance_Name: {
      break;
    }
  }
  return false;
}

// static
bool LocalTrustTokenFulfillerStubDispatch::AcceptWithResponder(
    LocalTrustTokenFulfiller* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalTrustTokenFulfiller_FulfillTrustTokenIssuance_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::LocalTrustTokenFulfiller::FulfillTrustTokenIssuance",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::LocalTrustTokenFulfiller::FulfillTrustTokenIssuance");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_Params_Data* params =
          reinterpret_cast<
              internal::LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::network::mojom::FulfillTrustTokenIssuanceRequestPtr p_request{};
      LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalTrustTokenFulfiller::Name_, 0, false);
        return false;
      }
      LocalTrustTokenFulfiller::FulfillTrustTokenIssuanceCallback callback =
          LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FulfillTrustTokenIssuance(
std::move(p_request), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalTrustTokenFulfillerValidationInfo[] = {
    {internal::kLocalTrustTokenFulfiller_FulfillTrustTokenIssuance_Name,
     {&internal::LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_Params_Data::Validate,
      &internal::LocalTrustTokenFulfiller_FulfillTrustTokenIssuance_ResponseParams_Data::Validate}},
};

bool LocalTrustTokenFulfillerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::LocalTrustTokenFulfiller::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalTrustTokenFulfillerValidationInfo);
}

bool LocalTrustTokenFulfillerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::LocalTrustTokenFulfiller::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLocalTrustTokenFulfillerValidationInfo);

}
}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif